// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

#ifndef INCLUDED_pose_rna_fragments_classes
#define INCLUDED_pose_rna_fragments_classes

// Rosetta Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/StaticIndexRange.hh>

// C++ Headers
#include <string>
#include <map>
#include <vector>



/////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////
// Goal: to make a fragment object that can choose fragments
// "on the fly" for RNA ab inito folding.
//
// After reading in a set of torsions from, e.g., the ribosome crystal structure,
//  should be able to generate fragments of size 1, 2, or 3, with
//  exact sequence matches, partial Y/R matches, or ignoring sequence.
//
namespace rna_fragments_class{

	enum { MATCH_ALL /* 0 */, MATCH_YR /* 1 */, MATCH_EXACT /* 2 */};


	/////////////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////////////
	class TorsionSet {
	public:
		TorsionSet & operator =( TorsionSet const & src );
		TorsionSet( int const size );

		//make this private?
		FArray2D_float  torsions;  // dimensions: (NUM_RNA_TORSIONS, SRange(0, size) );
		FArray1D_string torsion_source_name;  // dimensions: ( SRange(0, size) );

		void
		flip_chi_purines( std::string const sequence );

		inline
		int get_size() const { return size_; }


	private:
		int size_;

	};

	/////////////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////////////
	class FragmentLibrary {
	public:

		//constructor!
		//FragmentLibrary();

		//destructor -- necessary?
		//~FragmentLibrary();

		float get_fragment_torsion(
           int const num_torsion,
					 int const which_frag,
					 int const offset );

		TorsionSet const get_fragment_torsion_set( int const which_frag );

		void  add_torsion( TorsionSet const torsion_set );

		void  add_torsion(
					FArray2D_float & source_array,
					int const position,
					int const size,
					FArray1D_string & source_name
					);

		void  add_torsion(
					FArray2D_float & source_array,
					int const position,
					int const size,
					bool flip_chi_purines,
					std::string const RNA_sequence,
					FArray1D_string & source_name
		 );

		int get_align_depth();

	private:
		std::vector< TorsionSet > align_torsions_;

	};


	typedef std::map< std::string, FragmentLibrary * >  FragmentLibraryPointerMap;

	/////////////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////////////
	class RNA_Fragments {
	public:
		//Constructor -- needs vall_torsions_file to get started.
		// RNA_Fragments();
		// RNA_Fragments( std::string const filename );

		//We need an explicit destructor, I think, because each
		// of the fragment libraries is "new".
		~RNA_Fragments(){
			FragmentLibraryPointerMap::iterator it;
			for (it = fragment_library_pointer_map.begin();
					 it != fragment_library_pointer_map.end();
					 it++ ){
				delete it->second;
			}
		}

		void read_vall_torsions( std::string const filename );

		void
		pick_random_fragment(
					TorsionSet & torsion_set,
					std::string const RNA_string,
					int const type = MATCH_YR );

		//Probably the only thing that will actually get called publicly:
		void
		pick_random_fragment(
					TorsionSet & torsion_set,
          pose_ns::Pose & pose,
					int const position,
					int const size,
					int const type = MATCH_YR );

		//random helper functions. Not very elegant, actually lots of copied code.

	void
	get_fragment(
			 TorsionSet & torsion_set,
			 std::string const RNA_string,
			 int const type,
			 int const which_frag );

	void
	get_fragment(
			 TorsionSet & torsion_set,
			 pose_ns::Pose & pose,
			 int const position,
			 int const size,
			 int const type,
       int const which_frag );

	int
	get_align_depth(
			 std::string const RNA_string,
			 int const type );

	int
	get_align_depth(
			 pose_ns::Pose & pose,
			 int const position,
			 int const size,
			 int const type );


	private:

		// Probably should make following "vall" stuff a different object
		// and, come on, these could be a vector to save memory!
		FArray2D_float vall_torsions_;
		FArray1D_char  vall_sequence_;
		FArray1D_bool  vall_is_chainbreak_;
		FArray2D_bool  vall_edge_is_base_pairing_;
		FArray1D_string  vall_name_;
		int vall_size_;

		// Need to hold on to some fragment libraries. These
		// will be picked on the fly when the code requires them.
		//   Indexed by sequence, e.g., AAA, AGA, GUA ... or even RYR ...  or even NNN (totally generic!)
		FragmentLibraryPointerMap fragment_library_pointer_map;

		void pick_fragment_library( std::string const RNA_string );

		void pick_random_fragment( FArray1D_float & RNA_torsions, std::string const RNA_string );

	};




	/////////////////////////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////////////////////////

	std::string const convert_based_on_match_type( std::string const RNA_string, int const type );

	bool	compare_RNA_char( char const char1, char const char2 );


}

#endif
