// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 1.1.2.1 $
//  $Date: 2005/11/07 21:05:35 $
//  $Author: pbradley $

#ifndef INCLUDED_pose_rna_jumping
#define INCLUDED_pose_rna_jumping

// Rosetta Headers
#include "pose_fwd.h"

// C++ Headers
#include <string>
#include <vector>

namespace pairing_RNA_ns {
	class Pairing_RNA {
	public:
		int pos1;
		int pos2;
		int cutpoint;
		char edge1; //W,H,S
		char edge2; //W,H,S
		char orientation; //A,P
	};
	typedef std::vector<Pairing_RNA> Pairing_list_RNA;
}

void
make_rna_basepair_database();

bool
is_canonical( int const res1, int const res2 );

void
read_jump_templates_RNA();

void
pose_from_random_base_pairings( pose_ns::Pose & pose );

void
random_jump_trial( pose_ns::Pose & pose, pose_ns::Monte_carlo & mc, std::string const trial_type );

void
clear_barcode_pairing_list_RNA();

void
add_to_barcode_pairing_list_RNA( int const res1, int const res2, int const cutpoint,
																 char const edge1, char const edge2, char const orientation );


char get_edge_from_num( int const num );

char get_orientation_from_num( int const num );

void
prepare_cut_weight_for_pose(
														pose_ns::Pose & pose,
														pose_ns::Score_weight_map & rna_weight_map );

void
prepare_cut_weight_for_pose_from_user_pairings(
														pose_ns::Pose & pose,
														pose_ns::Score_weight_map & rna_weight_map );


#endif
