// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17963 $
//  $Date: 2007-10-23 18:40:23 -0400 (Tue, 23 Oct 2007) $
//  $Author: csmith $

#ifndef INCLUDED_pose_rotamer_controller
#define INCLUDED_pose_rotamer_controller

// Rosetta Headers
#include "PackerTask.h"
#include "pose.h"
#include "RotamerSet.h"

// Utility Headers
#include <utility/vector1.hh>

namespace pose_ns {

class Rotamer_controller {

private:

	pose_ns::Pose *pose_;
	PackerTask *packer_task_;
	RotamerSet rotamer_set_;
	utility::vector1<int> indexpos_;
	utility::vector1<int> nrotpos_;
	utility::vector1<utility::vector1<int> > indexposaa_;
	utility::vector1<utility::vector1<int> > nrotposaa_;

	void
	init_packer_task();

	void
	index_rotamers();

public:

	Rotamer_controller();

	Rotamer_controller(
		pose_ns::Pose * pose
	);

	~Rotamer_controller();

	void set_include_current(
		bool include_current
	);

	bool
	include_current();

	void
	init(
		pose_ns::Pose * pose
	);

	void
	init_rotamers();

	void
	print(
	 	bool chi = true
	);

	void
	print(
		int pos,
	 	bool chi = true
	);

	void
	print(
		int pos,
		int aa,
	 	bool chi = true
	);

	utility::vector1<int>
	closest_rotamer(
		pose_ns::Pose & pose
	);

	int
	nrotamers();

	utility::vector1<int>
	nrotpos();

	int
	nrotpos(
		int const pos
	);

	int
	res(
		int const pos,
		int const rotnum
	);

	void
	set_rotamer(
		int const pos,
		int const rotnum
	);

	void
	set_rotamer(
		pose_ns::Pose & pose,
		int const pos,
		int const rotnum
	);

	void
	set_rotamer(
		FArray3D_float & full_coord,
		int const aa_old,
		int const aav_old,
		int const pos,
		int const rotnum
	);

	int
	random_rotnum(
		int const pos
	);
	
	void
	pack(
		pose_ns::Pose & pose
	);
	
	inline
	PackerTask &
	packer_task()
	{
		assert(packer_task_);
		return *packer_task_;
	}
};

} // end pose_ns namespace

#endif
