// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-

#ifndef INCLUDED_rb_relax
#define INCLUDED_rb_relax

#include "pose.h"
#include "pose_fwd.h"

//Forward Declarations
namespace pose_ns { class RbSegments; }
namespace pose_ns { class Loops; }

bool
rb_relax();

void
segment_rb_move(
								pose_ns::Pose & pose,
								pose_ns::RbSegments & rb_segments,
								bool const fullatom
								);


void
perturb_one_segment_and_close_loops(
													pose_ns::Pose & pose,
													pose_ns::RbSegments & tmp_segment,
													bool const fullatom
													);

void
random_gaussian_perturbation(
														 pose_ns::Pose & pose
														 );

void
perturb_segment(
								pose_ns::Pose & pose,
								int & seg_begin,
								int & seg_end,
								bool const fullatom
								);

void
select_repack_regions(
											pose_ns::Pose & pose,
											int & seg_begin,
											int & seg_end,
											FArray1D_bool & allow_repack
											);


void
refine_segment(
							 pose_ns::Pose & pose,
							 int & start_pos,
							 int & end_pos
							 );

bool
get_fullatom_rb_flag();

void
refine_segment_allow_move_map(
															pose_ns::Pose & pose,
															int const & start,
															int const & stop
															);

#endif
