// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12046 $
//  $Date: 2007-01-15 16:41:53 -0500 (Mon, 15 Jan 2007) $
//  $Author: snoeyink $

#ifndef INCLUDED_read_aaproperties
#define INCLUDED_read_aaproperties


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <string>


// read_aaproperties Function Declarations


void
atom_num_from_atom_name(
	std::string const & name,
	int aa,
	int aav,
	int & num
);


void
atom_name_from_atom_num(
	int num,
	int aa,
	int aav,
	std::string & name
);


std::string
atom_type_char_from_id(
	int const atmno,
	int const aa,
	int const aav
);

int
LookupByName(
						 int const aa,
						 int const aav,
						 std::string const & atom_name
						 );


void
initialize_aaproperties();


int
create_new_variant(
	int const aa,
	int const starting_variant,
	int const aav_type
);


void
read_residue_paircutoffs();


void
assert_total_charge(
	int const aa,
	int const aav,
	float const total_q
);


void
make_room_for_atom(
	int const aa,
	int const aav,
	int const insert
);


void
remove_atom(
	int const aa,
	int const aav,
	int const insert
);


void
get_angles_from_bonds(
	int const aa,
	int const aav
);


#endif
