// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $


// Rosetta Headers
#include "read_vall.h"
#include "vall_data.h" // class defns

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>

// C++ Headers
#include <iostream>
#include <fstream>


// returns true on success
bool
read_vall( const std::string & filename, Vall::Vall_data & vall_data ) {

	std::ifstream data ( filename.c_str() );
	if ( !data ) {
		std::cout << "cant open file: " << filename << std::endl;
		return false;
	}

	char line[250];
	float phi,psi,omega;
	char seq,ss;
	while ( data ) {
		data.getline( line, 250 );
		if ( data.eof() ) break;

		std::sscanf( line+6 , "%1c", &seq);
		std::sscanf( line+8 , "%1c", &ss);

		std::sscanf( line+52, "%9f", &phi);
		std::sscanf( line+61, "%9f", &psi);
		std::sscanf( line+70, "%9f", &omega);

		if ( !vall_data.add_line( seq, ss, phi, psi, omega ) ) {
			// out of space
			break;
		}
	}
	data.close();
	return true;
}
