// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14662 $
//  $Date: 2007-05-01 08:40:56 -0400 (Tue, 01 May 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_refold
#define INCLUDED_refold


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// refold Function Declarations


bool
use_new_refold();


void
refold_set_direction( int dir_x );


void
refold_get_dir( int & dir_x );


void
refold(
	int begin_res,
	int end_res
);


void
refold_set_orient_flag( bool const yes_no );


bool
refold_get_orient_flag();


void
refold_select_dir(
	int const seg_num,
	int const fold_begin,
	int const fold_end,
	int & dir
);


void
refold_set_segments(
	int const first_seg,
	int const last_seg,
	FArray1Da_int begin,
	FArray1Da_int end,
	FArray1Da_int dir
);


void
refold_adjust_segment_ends(
	int const first_seg,
	int const last_seg,
	FArray1Da_int begin,
	FArray1Da_int end,
	FArray1Da_int dir
);


int
identify_segment(
	int const residue
);


void
retrieve_segment_ends(
	int const seg_num,
	int & begin,
	int & end
);


void
refold_set_orient_position(
	int const total_residue,
	FArray3Da_float orient_position
);


void
refold_get_orient_position(
	FArray3Da_float orient_position /* native backbone */
);


bool
use_st_bond();


void
refold_update_coords(
	int dir,
	int begin_frag,
	int end_frag,
	int end_region,
	int seg_begin,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega,
	FArray1Da_int res, // residue types
	FArray1Da_int resv, // residue variants
	FArray1Da_bool N_term, // Nterm
	FArray1Da_bool C_term, // Cterm
	FArray3Da_float Ebest_position,
	FArray3Da_float Eposition,
	FArray2Da_float best_centroid,
	FArray2Da_float centroid,
	bool fullatom,
	FArray3Da_float best_full_coord,
	FArray3Da_float full_coord
);

void
refold_update_coords(
	int dir,
	int begin_frag,
	int end_frag,
	int end_region,
	int seg_begin,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega,
	FArray1Da_int res, // residue types
	FArray1Da_int resv, // residue variants
	FArray1Da_bool N_term, // Nterm
	FArray1Da_bool C_term, // Cterm
	FArray3Da_float Ebest_position,
	FArray3Da_float Eposition,
	FArray2Da_float best_centroid,
	FArray2Da_float centroid,
	bool fullatom,
	FArray3Da_float best_full_coord,
	FArray3Da_float full_coord,
	FArray3Da_float centroid_parm_eachres
);


void
build_backbone(
	int dir,
	FArray1Da_float c1_xyz,
	FArray1Da_float n1_xyz,
	FArray1Da_float ca1_xyz,
	int end_frag,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega,
	FArray1Da_int res,
	FArray3Da_float Eposition,
	FArray2Da_float centroid,
	FArray1Da_float c2_xyz,
	FArray1Da_float n2_xyz,
	FArray1Da_float ca2_xyz,
	int const begin_offset
);

void
build_backbone(
	int dir,
	FArray1Da_float c1_xyz,
	FArray1Da_float n1_xyz,
	FArray1Da_float ca1_xyz,
	int end_frag,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega,
	FArray1Da_int res,
	FArray3Da_float Eposition,
	FArray2Da_float centroid,
	FArray1Da_float c2_xyz,
	FArray1Da_float n2_xyz,
	FArray1Da_float ca2_xyz,
	int const begin_offset,
	FArray3Da_float centroid_parm_eachres
);


void
build_residue_n2c(
	FArray2Da_float X,
	FArray3Da_float Eposition, // coords of res i, i+1
	FArray1Da_float centroid, // centroid of res i
	FArray1Da_float cT_1,
	FArray1Da_float cT_2,
	FArray1Da_float sT_1,
	FArray1Da_float sT_2,
	FArray1Da_float D_1,
	FArray1Da_float D_2,
	float const cb_phi_offset,
	float const ox_psi_offset,
	FArray1Da_float centroid_parm,
	float const phi,
	float const psi,
	float const omega
);


void
build_residue_c2n(
	FArray2Da_float X,
	FArray3Da_float Eposition, // coords of res i-1,i
	FArray1Da_float centroid, // centroid of res i
	FArray1Da_float cT_1,
	FArray1Da_float cT_0,
	FArray1Da_float sT_1,
	FArray1Da_float sT_0,
	FArray1Da_float D_1,
	FArray1Da_float D_0,
	float const cb_phi_offset,
	float const ox_psi_offset,
	FArray1Da_float centroid_parm,
	float const phi,
	float const psi,
	float const omega
);


void
GL_rotate(
	int last,
	int stride,
	FArray2Da_float Mgl,
	FArray2Da_float V,
	FArray2Da_float V_out
);


void
GL_rot(
	FArray2Da_float Mgl,
	FArray1Da_float V,
	FArray1Da_float X
);


void
GL_rot_in_place(
	FArray2Da_float Mgl,
	FArray1Da_float X
);


void
build_atom(
	FArray2Da_float M,
	FArray1Da_float ori,
	float const cT,
	float const sT,
	float const P,
	float const D,
	FArray1Da_float Xo,
	FArray1Da_float N
);


void
refold_coord_sys(
	FArray1Da_float B,
	FArray1Da_float X0,
	FArray1Da_float X,
	FArray1Da_float Y,
	FArray1Da_float Z
);


void
get_GL_matrix(
	FArray1Da_float P1,
	FArray1Da_float P2,
	FArray1Da_float P3,
	FArray1Da_float Q1,
	FArray1Da_float Q2,
	FArray1Da_float Q3,
	FArray2Da_float Mgl
);


void
refold_default_template_stub(
	FArray1Da_float c_xyz,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz
);


void
refold_default_stub(
	FArray1Da_float c_xyz,
	FArray1Da_float n_xyz,
	FArray1Da_float ca_xyz,
	int const dir // n2c or c2n
);


void
init_fold();


void
initialize_start_bond_info(
	bool const coord_fail, // true if there is no coordinates read in
	int const total_residue,
	FArray1Da_int res,
	FArray3Da_float Eposition,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega
);


void
calculate_start_bond_info(
	int const total_residue,
	FArray3DB_float const & Eposition,
	FArray1DB_float const & phi,
	FArray1DB_float const & psi,
	FArray1DB_float const & omega
);

void
init_start_fold();


void
init_start_fold_angles();


void
backbone_fold(
	int const nres,
	FArray1Da_float phi,
	FArray1Da_float psi,
	FArray1Da_float omega,
	FArray3Da_float xyz
);

void
get_centroid_parm_eachres_default( FArray3Da_float centroid_parm_eachres, FArray1Da_int res);

void
get_centroid_parm_eachres_fromnative( FArray3Da_float centroid_parm_eachres);


bool
get_use_native_centroid_flag();

FArray3Da_float
compute_centroid_parm_eachres(
	 FArray1Da_int res,
	 FArray1Da_int res_variant,
	 FArray3Da_float full_coord );


void
build_actual_centroid(int const aa,
											FArray2Da_float full_coord,
											FArray1Da_float centroid);

#endif

