// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10137 $
//  $Date: 2006-09-01 16:49:23 -0400 (Fri, 01 Sep 2006) $
//  $Author: yiliu $


// Rosetta Headers
#include "refold_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>


namespace refold_ns {


int const n = { 1 };
int const ca = { 2 };
int const cb = { 3 };
int const c = { 4 };
int const ox = { 5 };
int const cen = { 6 };

int const ph = { 1 };
int const ps = { 2 };
int const om = { 3 };

int const n2c = { 1 };
int const c2n = { -1 };


namespace refold_param {


	void
	cb_phi_offset_initializer( FArray1D_float & cb_phi_offset )
	{
		cb_phi_offset(n2c) = -123.00;
		cb_phi_offset(c2n) = 123.00;
	}


	void
	ox_psi_offset_initializer( FArray1D_float & ox_psi_offset )
	{
		ox_psi_offset(n2c) = 180.00;
		ox_psi_offset(c2n) = -180.00;
	}


	void
	D_initializer( FArray2D_float & D )
	{
		D(n,n2c) = 1.32868493; // c-n
		D(ca,n2c) = 1.45800149; // n-ca
		D(cb,n2c) = 1.52083504; // ca-cb
		D(c,n2c) = 1.52325821; // ca-c
		D(ox,n2c) = 1.23101556; // c-ox
		D(c,c2n) = 1.32868493; // c-n
		D(n,c2n) = 1.45800149; // n-ca
		D(cb,c2n) = 1.52083504; // ca-cb
		D(ca,c2n) = 1.52325821; // ca-c
		D(ox,c2n) = 1.23101556; // c-ox
	}


	void
	angle_initializer( FArray2D_float & angle )
	{
		angle(n,n2c) = 116.2; // ca-c-n
		angle(ca,n2c) = 121.7; // c-n-ca
		angle(cb,n2c) = 110.4; // n-ca-cb
		angle(c,n2c) = 111.2; // n-ca-c
		angle(ox,n2c) = 120.8; // ca-c-o
		angle(ca,c2n) = 116.2; // ca-c-n
		angle(c,c2n) = 121.7; // c-n-ca
		angle(cb,c2n) = 110.5; // c-ca-cb
		angle(n,c2n) = 111.2; // n-ca-c
		angle(ox,c2n) = 123.0; // n-c-o
	}


	void
	centroid_parm_initializer( FArray3D_float & centroid_parm )
	{
		{ // n2c
			FArray1Da_float centroid_parm_1d( centroid_parm.a( 1, 1, n2c ) ); // 1D view
			int i = 0;
			centroid_parm_1d( ++i ) = 1.52078068;
			centroid_parm_1d( ++i ) = -2.14698720;
			centroid_parm_1d( ++i ) = 0.34840003;
			centroid_parm_1d( ++i ) = 0.93734592;
			centroid_parm_1d( ++i ) = 1.21493268;
			centroid_parm_1d( ++i ) = 2.32452989;
			centroid_parm_1d( ++i ) = -2.40994549;
			centroid_parm_1d( ++i ) = 0.31520718;
			centroid_parm_1d( ++i ) = 0.94902289;
			centroid_parm_1d( ++i ) = 1.25012136;
			centroid_parm_1d( ++i ) = 2.40449333;
			centroid_parm_1d( ++i ) = -2.43199468;
			centroid_parm_1d( ++i ) = 0.37118587;
			centroid_parm_1d( ++i ) = 0.92855859;
			centroid_parm_1d( ++i ) = 1.19051051;
			centroid_parm_1d( ++i ) = 3.12483096;
			centroid_parm_1d( ++i ) = -2.43366456;
			centroid_parm_1d( ++i ) = 0.37695175;
			centroid_parm_1d( ++i ) = 0.92623287;
			centroid_parm_1d( ++i ) = 1.18429327;
			centroid_parm_1d( ++i ) = 2.91614914;
			centroid_parm_1d( ++i ) = -2.53572178;
			centroid_parm_1d( ++i ) = 0.37545523;
			centroid_parm_1d( ++i ) = 0.92684054;
			centroid_parm_1d( ++i ) = 1.18590844;
			centroid_parm_1d( ++i ) = 0.00052975;
			centroid_parm_1d( ++i ) = 0.84912473;
			centroid_parm_1d( ++i ) = 0.51631129;
			centroid_parm_1d( ++i ) = 0.85640097;
			centroid_parm_1d( ++i ) = 1.02825820;
			centroid_parm_1d( ++i ) = 2.76337719;
			centroid_parm_1d( ++i ) = -2.51447344;
			centroid_parm_1d( ++i ) = 0.36275643;
			centroid_parm_1d( ++i ) = 0.93188399;
			centroid_parm_1d( ++i ) = 1.19957221;
			centroid_parm_1d( ++i ) = 2.51137257;
			centroid_parm_1d( ++i ) = -2.39756799;
			centroid_parm_1d( ++i ) = 0.33815348;
			centroid_parm_1d( ++i ) = 0.94109100;
			centroid_parm_1d( ++i ) = 1.22584224;
			centroid_parm_1d( ++i ) = 3.51447439;
			centroid_parm_1d( ++i ) = -2.47674322;
			centroid_parm_1d( ++i ) = 0.40300778;
			centroid_parm_1d( ++i ) = 0.91519654;
			centroid_parm_1d( ++i ) = 1.15599537;
			centroid_parm_1d( ++i ) = 2.81658983;
			centroid_parm_1d( ++i ) = -2.58276582;
			centroid_parm_1d( ++i ) = 0.40834156;
			centroid_parm_1d( ++i ) = 0.91282922;
			centroid_parm_1d( ++i ) = 1.15015984;
			centroid_parm_1d( ++i ) = 3.10966110;
			centroid_parm_1d( ++i ) = -2.50547338;
			centroid_parm_1d( ++i ) = 0.43134743;
			centroid_parm_1d( ++i ) = 0.90218592;
			centroid_parm_1d( ++i ) = 1.12481058;
			centroid_parm_1d( ++i ) = 2.40384126;
			centroid_parm_1d( ++i ) = -2.47138309;
			centroid_parm_1d( ++i ) = 0.36183378;
			centroid_parm_1d( ++i ) = 0.93224263;
			centroid_parm_1d( ++i ) = 1.20056212;
			centroid_parm_1d( ++i ) = 2.22823262;
			centroid_parm_1d( ++i ) = -2.07012248;
			centroid_parm_1d( ++i ) = -0.62391335;
			centroid_parm_1d( ++i ) = 0.78149348;
			centroid_parm_1d( ++i ) = 2.24453664;
			centroid_parm_1d( ++i ) = 3.12066936;
			centroid_parm_1d( ++i ) = -2.48532963;
			centroid_parm_1d( ++i ) = 0.38623190;
			centroid_parm_1d( ++i ) = 0.92240173;
			centroid_parm_1d( ++i ) = 1.17425334;
			centroid_parm_1d( ++i ) = 3.94853449;
			centroid_parm_1d( ++i ) = -2.41812086;
			centroid_parm_1d( ++i ) = 0.38897488;
			centroid_parm_1d( ++i ) = 0.92124838;
			centroid_parm_1d( ++i ) = 1.17127776;
			centroid_parm_1d( ++i ) = 2.03359127;
			centroid_parm_1d( ++i ) = -2.08460999;
			centroid_parm_1d( ++i ) = 0.26911235;
			centroid_parm_1d( ++i ) = 0.96310878;
			centroid_parm_1d( ++i ) = 1.29832506;
			centroid_parm_1d( ++i ) = 2.07255626;
			centroid_parm_1d( ++i ) = -2.25062275;
			centroid_parm_1d( ++i ) = 0.30043134;
			centroid_parm_1d( ++i ) = 0.95380342;
			centroid_parm_1d( ++i ) = 1.26565146;
			centroid_parm_1d( ++i ) = 2.13426304;
			centroid_parm_1d( ++i ) = -2.33004522;
			centroid_parm_1d( ++i ) = 0.41847429;
			centroid_parm_1d( ++i ) = 0.90822864;
			centroid_parm_1d( ++i ) = 1.13903153;
			centroid_parm_1d( ++i ) = 3.10705566;
			centroid_parm_1d( ++i ) = -2.49406767;
			centroid_parm_1d( ++i ) = 0.47588727;
			centroid_parm_1d( ++i ) = 0.87950629;
			centroid_parm_1d( ++i ) = 1.07482374;
			centroid_parm_1d( ++i ) = 3.08834434;
			centroid_parm_1d( ++i ) = -2.53498769;
			centroid_parm_1d( ++i ) = 0.38536251;
			centroid_parm_1d( ++i ) = 0.92276525;
			centroid_parm_1d( ++i ) = 1.17519569;
		}
		{ // c2n
			FArray1Da_float centroid_parm_1d( centroid_parm.a( 1, 1, c2n ) ); // 1D view
			int i = 0;
			centroid_parm_1d( ++i ) = 1.52078068;
			centroid_parm_1d( ++i ) = 2.14590907;
			centroid_parm_1d( ++i ) = 0.35014793;
			centroid_parm_1d( ++i ) = 0.93669438;
			centroid_parm_1d( ++i ) = 1.21306729;
			centroid_parm_1d( ++i ) = 2.32452989;
			centroid_parm_1d( ++i ) = 2.28464031;
			centroid_parm_1d( ++i ) = 0.54437017;
			centroid_parm_1d( ++i ) = 0.83884507;
			centroid_parm_1d( ++i ) = 0.99515820;
			centroid_parm_1d( ++i ) = 2.40449333;
			centroid_parm_1d( ++i ) = 2.35272121;
			centroid_parm_1d( ++i ) = 0.52252555;
			centroid_parm_1d( ++i ) = 0.85262364;
			centroid_parm_1d( ++i ) = 1.02098596;
			centroid_parm_1d( ++i ) = 3.12483096;
			centroid_parm_1d( ++i ) = 2.35917664;
			centroid_parm_1d( ++i ) = 0.51973414;
			centroid_parm_1d( ++i ) = 0.85432804;
			centroid_parm_1d( ++i ) = 1.02425659;
			centroid_parm_1d( ++i ) = 2.91614914;
			centroid_parm_1d( ++i ) = 2.44072938;
			centroid_parm_1d( ++i ) = 0.57453620;
			centroid_parm_1d( ++i ) = 0.81847918;
			centroid_parm_1d( ++i ) = 0.95875895;
			centroid_parm_1d( ++i ) = 0.00052975;
			centroid_parm_1d( ++i ) = -1.97732937;
			centroid_parm_1d( ++i ) = -0.71419662;
			centroid_parm_1d( ++i ) = 0.69994515;
			centroid_parm_1d( ++i ) = 2.36627197;
			centroid_parm_1d( ++i ) = 2.76337719;
			centroid_parm_1d( ++i ) = 2.41160369;
			centroid_parm_1d( ++i ) = 0.57232004;
			centroid_parm_1d( ++i ) = 0.82003033;
			centroid_parm_1d( ++i ) = 0.96146405;
			centroid_parm_1d( ++i ) = 2.51137257;
			centroid_parm_1d( ++i ) = 2.29665875;
			centroid_parm_1d( ++i ) = 0.52326441;
			centroid_parm_1d( ++i ) = 0.85217041;
			centroid_parm_1d( ++i ) = 1.02011919;
			centroid_parm_1d( ++i ) = 3.51447439;
			centroid_parm_1d( ++i ) = 2.41572499;
			centroid_parm_1d( ++i ) = 0.52578765;
			centroid_parm_1d( ++i ) = 0.85061586;
			centroid_parm_1d( ++i ) = 1.01715553;
			centroid_parm_1d( ++i ) = 2.81658983;
			centroid_parm_1d( ++i ) = 2.50928974;
			centroid_parm_1d( ++i ) = 0.57392347;
			centroid_parm_1d( ++i ) = 0.81890893;
			centroid_parm_1d( ++i ) = 0.95950741;
			centroid_parm_1d( ++i ) = 3.10966110;
			centroid_parm_1d( ++i ) = 2.46291852;
			centroid_parm_1d( ++i ) = 0.52062625;
			centroid_parm_1d( ++i ) = 0.85378474;
			centroid_parm_1d( ++i ) = 1.02321208;
			centroid_parm_1d( ++i ) = 2.40384126;
			centroid_parm_1d( ++i ) = 2.37522864;
			centroid_parm_1d( ++i ) = 0.55030078;
			centroid_parm_1d( ++i ) = 0.83496648;
			centroid_parm_1d( ++i ) = 0.98807192;
			centroid_parm_1d( ++i ) = 2.22823262;
			centroid_parm_1d( ++i ) = 0.99398440;
			centroid_parm_1d( ++i ) = 0.57450551;
			centroid_parm_1d( ++i ) = 0.81850070;
			centroid_parm_1d( ++i ) = 0.95879644;
			centroid_parm_1d( ++i ) = 3.12066936;
			centroid_parm_1d( ++i ) = 2.40799069;
			centroid_parm_1d( ++i ) = 0.54167145;
			centroid_parm_1d( ++i ) = 0.84059030;
			centroid_parm_1d( ++i ) = 0.99837208;
			centroid_parm_1d( ++i ) = 3.94853449;
			centroid_parm_1d( ++i ) = 2.35822392;
			centroid_parm_1d( ++i ) = 0.50309587;
			centroid_parm_1d( ++i ) = 0.86423063;
			centroid_parm_1d( ++i ) = 1.04361904;
			centroid_parm_1d( ++i ) = 2.03359127;
			centroid_parm_1d( ++i ) = 2.03701520;
			centroid_parm_1d( ++i ) = 0.34401906;
			centroid_parm_1d( ++i ) = 0.93896270;
			centroid_parm_1d( ++i ) = 1.21960247;
			centroid_parm_1d( ++i ) = 2.07255626;
			centroid_parm_1d( ++i ) = 2.16105723;
			centroid_parm_1d( ++i ) = 0.45039546;
			centroid_parm_1d( ++i ) = 0.89282918;
			centroid_parm_1d( ++i ) = 1.10358810;
			centroid_parm_1d( ++i ) = 2.13426304;
			centroid_parm_1d( ++i ) = 2.32283235;
			centroid_parm_1d( ++i ) = 0.43156338;
			centroid_parm_1d( ++i ) = 0.90208262;
			centroid_parm_1d( ++i ) = 1.12457120;
			centroid_parm_1d( ++i ) = 3.10705566;
			centroid_parm_1d( ++i ) = 2.49122143;
			centroid_parm_1d( ++i ) = 0.48191175;
			centroid_parm_1d( ++i ) = 0.87621975;
			centroid_parm_1d( ++i ) = 1.06796110;
			centroid_parm_1d( ++i ) = 3.08834434;
			centroid_parm_1d( ++i ) = 2.44854283;
			centroid_parm_1d( ++i ) = 0.56747061;
			centroid_parm_1d( ++i ) = 0.82339364;
			centroid_parm_1d( ++i ) = 0.96736562;
		}
	}


	FArray1D_float const cb_phi_offset( DRange( -1, 1 ), cb_phi_offset_initializer );
	FArray1D_float const ox_psi_offset( DRange( -1, 1 ), ox_psi_offset_initializer );
	FArray2D_float const D( 5, DRange( -1, 1 ), D_initializer );
	FArray2D_float const angle( 5, DRange( -1, 1 ), angle_initializer );
	FArray2D_float cT( 5, DRange( -1, 1 ) );
	FArray2D_float sT( 5, DRange( -1, 1 ) );
	FArray3D_float const centroid_parm( 5, param::MAX_AA(), DRange( -1, 1 ), centroid_parm_initializer );
}


namespace huber {


	void
	default_template_initializer( FArray2D_float & default_template )
	{
		// Inactive DATA initializer from original Fortran
		//$$$      data default_template
		//$$$     #     /-0.69821947,-1.1305144  ,0.0, // c
		//$$$     #     0.0,       0.0     ,   0.0, // n
		//$$$     #     1.4578786 , 0.0     ,0.0/ // ca

		//car orientation for old refold
		FArray1Da_float default_template_1d( default_template );
		int i = 0;
		default_template_1d( ++i ) = 1.304528f; // c
		default_template_1d( ++i ) = 1.645746f;
		default_template_1d( ++i ) = -1.233196f;
		default_template_1d( ++i ) = 1.039787f; // n
		default_template_1d( ++i ) = 0.3743024f;
		default_template_1d( ++i ) = -0.9522739f;
		default_template_1d( ++i ) = 0.0f; // ca
		default_template_1d( ++i ) = 0.0f;
		default_template_1d( ++i ) = 0.0f;
	}


	FArray2D_float default_template( 3, 3, default_template_initializer );
}


// this particular orientation of the stub gives an indentity matrix coord_sys matrix.

//     X   -0.50331366, 0.08584201,-0.02342459, // c 4
//     X   -0.06336936, 1.26154232,-0.45902890, // N+1 6
//     X   -0.63328403, 2.51655889, 0.01588227, // cA+1 7
//     X   -1.74543917, 2.26859903, 1.02942538/ // c+1  8

namespace refold_mat {
	int refold_dir;
	int force_refold_dir = { 0 };
}

using namespace param;
namespace refold_segments {
	FArray1D_int seg_begin( DRange( 0, MAX_SEGMENTS ) );
	FArray1D_int seg_end( DRange( 0, MAX_SEGMENTS ) );
	FArray1D_int seg_dir( DRange( 0, MAX_SEGMENTS ) );
	FArray1D_int seg_map( MAX_RES() );
	int first_segment = { 1 };
	int last_segment = { 1 };
}

namespace orient_flag_bool {
	bool refold_orient_flag = { false };
}

namespace refold_orient_pos {
	int orient_total_residue;
	FArray3D_float refold_orient_position( 3, MAX_POS, MAX_RES() );
}

namespace st_bond_switch {
	bool st_bond = { false };
}

namespace refold_switch {
	bool new_refold = { false };
}


}

