// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 17863 $
//  $Date: 2007-10-18 12:31:54 -0400 (Thu, 18 Oct 2007) $
//  $Author: sraman $


// Rosetta Headers
#include "relax_structure.h"
#include "assemble_domains.h"
#include "after_opts.h"
#include "constraints.h"
#include "counters.h"
#include "crankshaft.h"
#include "design.h"
#include "diagnostics_rosetta.h"
#include "filters.h"
#include "force_barcode.h"
#include "fragments.h"
#include "fullatom.h"
#include "fullatom_setup.h"
#include "initialize.h"
#include "jumping_util.h" //score_filter
#include "loop_relax.h"
#include "make_pdb.h"
#include "maps.h"
#include "maps_ns.h"
#include "minimize.h"
#include "misc.h"
#include "monte_carlo.h"
#include "nblist.h"
#include "orient_rms.h"
#include "output_decoy.h"
#include "pack_fwd.h"
#include "param.h"
#include "param_pack.h"
#include "pose_relax.h"
#include "ramachandran.h"
#include "random_numbers.h"
#include "rb_relax.h"
#include "recover.h"
#include "relax.h"
#include "RotamerOptions.h"
#include "rotamer_trials.h"
#include "runlevel.h"
#include "score.h"
#include "score_ns.h"
#include "start.h"
#include "smallmove.h"
#include "tether_ns.h"
#include "tether.h"
#include "torsion_bbmove_trials.h"
#include "trajectory.h"
#include "taboo_search.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>
#include <ObjexxFCL/Fmath.hh>
#include <ObjexxFCL/formatted.o.hh>
#include <ObjexxFCL/string.functions.hh>

// BOINC
#ifdef BOINC
#ifdef _WIN32
#include "boinc_win.h"
#endif
#include "boinc_api.h"
#include "boinc_rosetta_util.h"
#endif

// C++ Headers
#include <cmath>
#include <iostream>
#include <ctime>

// Namespaces

namespace score_variant_storage {
	std::string score_variant;
}

namespace score_filter_save {
	bool auto_relax_score_filter = { false };
	float relax_score_filter_save1 = 0.0;
	float relax_score_filter_save2 = 0.0;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin relax_structure
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool
relax_structure()
{
	using namespace relax_options;

	save_rms_before_relax();

	bool rb_relax_success = true;
	bool loop_relax_success = true;

	if( relax_options::rb_rlx ) rb_relax_success = rb_relax();
	if( !rb_relax_success ) {
		std::cout << "WARNING:: rb_relax failed. returning ... " << std::endl;
		return false;
	}

	if ( relax_options::looprlx ) loop_relax_success = loop_relax();
	if ( !loop_relax_success ) {
		std::cout << "WARNING:: looprlx failed. returning..." << std::endl;
		return false;
	}

	if ( cenrlx ) centroid_relax();
	if ( farlx ) fullatom_relax();

	return true;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin centroid_relax
///
/// @brief
///db  quick relaxation of centroid structures using
///db  Kira's increased atom radii and Tanja's hydrogen bonding
///
/// @detailed
///car assumes all arrays are initialized, position, best, low, low_sc
///car alreay occupied.
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
centroid_relax()
{

	using namespace misc;
	using namespace runlevel_ns;
	using namespace start;

//car local
	int j, jk;
	float lj_rep_phase;

//car parameters
	int cycles,nloop;

	float const temperature = { 0.8 };
	float const helix = { 2.0 };
	float const strand = { 2.0 };
	float const loop = { 3.0 };
	float const noe_weight = { 2.0 };
	float const rdc_weight = { 10.0 };
	float const cutoff = { 60.0 }; // msd cutoff for chuck moves
	float rms_threshold;
	int const fe_cycles = { 200 }; //vats number of cycles for forced expander loop
	float rms_to_start;
	nloop = 6;
	std::string protein_sstype = get_protein_sstype();
	if ( protein_sstype == "a" ) {
		cycles = total_residue / 3; // centroid score is useless for alpha proteins
	} else {
		cycles = total_residue; // can clean up the beta sheets
	}

	if ( benchmark ) {
		nloop = 2;
		cycles = 5;
	}
//------------------------------------------------
	std::cout << "Starting centroid relax ..." << std::endl;
	clear_trajectory();
//car setup.....
	monte_carlo_set_simannealing(true);
	set_fullatom_flag(false);
	classical_constraints::BOUNDARY::set_max_seqSep(total_residue);
	choose_frag_set_top_N_frags(200);
	minimize_exclude_sstype(true,false);
	score_set_cst_weight(noe_weight);
	score_set_dpl_weight(rdc_weight);
	score_set_cst_mode(3);
	score_set_lj_weight(1.0);
	int local_min_window = get_local_min_window(); //default 5
	if (get_minimize_set_local_min()) {
		minimize_set_local_min(true,local_min_window);
	}	else {
		minimize_set_local_min(false,local_min_window);
	}
	monte_carlo_set_temp(temperature);
	set_smallmove_size(helix,strand,loop);
	set_use_nblist(true);

//car begin relaxing...
	recover_LOW(score6);
	cenrlx_log_output(0);
	reset_trial_counters();


//vats command line flag '-force_expand'. Ensures that the structure moves
//vats away from the starting structure by atleast the rms_threshold value.

	if ( relax_options::force_expand ) {
		rms_threshold = (1.5*ran3())+0.3;
		for ( j = 1; j <= fe_cycles; ++j ) {
			main_feature_small_min_trial(5,score6,j,"dfpmin");
			fast_rms_x(position,start_position,rms_to_start);
			if ( get_monte_carlo_accept() > 1 ) {
				if (rms_to_start>=rms_threshold) {
					std::cout << "rms_threshold exceeded " << std::endl;
					goto L555;
				}
			}
		}
	}

L555:

	for ( jk = 1; jk <= nloop; ++jk ) {

		lj_rep_phase = jk;
		score_set_lj_weight(lj_rep_phase);
		std::cout << "dfpmin moves...  lj_rep=" << SS(lj_rep_phase) << std::endl;
		recover_LOW(score6);
		cenrlx_log_output(jk);

		main_minimize_trial(score6,"dfpmin");
		cenrlx_log_output(jk);


		for ( j = 1; j <= cycles; ++j ) {
			main_small_min_trial(5,score6,j*jk,"dfpmin");
			main_shear_min_trial(10,score6,j*jk,"dfpmin");

			if ( ! get_assemble_flag() & ! get_skip_fragment_moves() ) {
				main_crank_min_trial(1,cutoff,score6,j,1,2,"dfpmin");
				main_small_wobble_min_trial(1,score6,j,7,0,"dfpmin");
				main_wobble_min_trial(1,cutoff,score6,j,1,2,"dfpmin");
			}
		}
	}                     // jk
	recover_LOW(score6);
	cenrlx_log_output(jk);

	output_trial_counters( std::cout );

//car cleanup...
	score_set_lj_weight(1.0);

}


////////////////////////////////////////////////////////////////////////////////
/// @begin cenrlx_log_output
///
/// @brief
///
/// @detailed
///
/// @param  jk - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
cenrlx_log_output( int jk )
{
	using namespace counters;
	using namespace misc;
	using namespace scores;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	if ( jk <= 0 ) {
		std::cout << "jk nlowacc   score    low_sc low_rms rms_min vdw local  rama";
		if (classical_constraints::BOUNDARY::get_constraints_exist() ) std::cout << " pc_score ";
		std::cout << std::endl;
	}
	std::cout << I( 2, jk ) << ' ' <<
	 I( 5, n_low_accept ) << ' ' << ' ' <<
	 F( 9, 2, scorefxn() ) << ' '; // Sequence point
	std::cout <<
	 F( 9, 2, low_score ) << ' ' <<
	 F( 5, 2, low_rms ) << ' ' <<
	 F( 5, 2, rms_min ) << ' ' <<
	 F( 7, 2, vdw_score ) << ' ' <<
	 F( 7, 2, ramachandran_score );
	if (classical_constraints::BOUNDARY::get_constraints_exist() ) std::cout << SS(pc_score);
	std::cout << std::endl;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin fullatom_relax
///
/// @brief
///car this is a simplified version of the relax protocol derived from
///car Jerry Tsai's original protocol.
///
/// @detailed
///car Jerry's protocol can be found in the cvs repository v1.30.
///car You can retrieve it with:
///car 'cvs checkout -r jwtsai_fullatom_relax rosetta' OR
///car 'cvs checkout -r 1.30 rosetta
///car note that when Jerry's protocol was in use, rotamer trials was used
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fullatom_relax(
)
{
	using namespace misc;
	using namespace param;
	using namespace param_pack;
	using namespace protein_maps;
	using namespace relax_options;
	using namespace runlevel_ns;
	using namespace score_filter_save;

	using namespace mc_global_track::diagnose; // yab: misc removal
	using namespace mc_global_track::mc_score; // yab: misc removal

#ifdef BOINC
	std::string const checkpoint_decoy_name( "farlxcheck" );
	int attempted_decoys(0);
	int num_decoys(0);
	int farlx_stage(0);
	int set_stage(0);
	time_t stage0_time, stage1_time, stage2_time;
	double time_diff(0.0);
	restoreDecoyInfo( attempted_decoys, num_decoys, farlx_stage );
#endif

//car constants
	int lj_ramp_cycles = 8;
	if ( benchmark ) lj_ramp_cycles = 3;
	int numtrials = 10;
	if (get_assemble_flag()) {
		lj_ramp_cycles = 3;
		numtrials = 5;
	}

	get_lj_ramp_cycles( lj_ramp_cycles );
	float const stage2_lj_rep_weight = get_stage2_lj_rep_weight();
	float const starting_lj_rep_weight = get_starting_lj_rep_weight();
	float const lj_increment = ( lj_ramp_cycles == 0 ) ? 0.0 :
		( stage2_lj_rep_weight - starting_lj_rep_weight ) / lj_ramp_cycles;
	int const cycles_per_residue = { 1 };
	const std::string min_type = use_abs_tolerance() ? "dfpmin_atol" : "dfpmin";

	float cutoff;
	int cycles;
	float temperature;

	int stage2_cycles,nwobble1_crank, nwobble2_crank, nwobble_wobble, crank_size, wobble_size;
	int stage2_repack_period;

	bool const minimize_exclude_helix  = get_minimize_exclude_helix(); //default false
	bool const minimize_exclude_strand = get_minimize_exclude_strand(); // default false

//car OPTIONS ------------------------------------------------------------------
//car set options in case of loop mode or constraints
//	score_set_loop_weight(20.0);
	classical_constraints::BOUNDARY::set_max_seqSep(total_residue);
	score_set_cst_weight(1.0);
	score_set_cst_mode(3);
	score_set_dpl_weight(5.0);

//car these options set to the default values, but just make sure they
//car  have not been inadvertantly changed
	score_set_lj_weight( 1.0 );
	choose_frag_set_top_N_frags( MAX_NEIGH() );
	select_rotamer_set( "large" );
	rot_limit_surface = 24; // large set has 45 rots for surface--overkill?
	set_taboo_active( true );

	clear_trajectory();

//car these options may need to be changed to optimize the protocol
//car they control underlying rosetta behavior (ie minimization, move size, etc)
	int local_min_window = get_local_min_window(); //default 5
	int local_min_window_fragment_moves = get_local_min_window_fragment_moves(); //default 5
	if (get_minimize_set_local_min()) {
		minimize_set_local_min(true, local_min_window);
	}	else {
		minimize_set_local_min(false, local_min_window);
	}
	set_use_nblist(true);

	if( !disable_rotamer_trials_in_farlx() )score_set_try_rotamers(true); // (11/05/04)

//db 4-5-06 changed default relax behavior to vary omega and minimize within helix
	set_smallmove_size(2.0,2.0,3.); // helix,strand,other
	if( score_get_vary_omega() ){
		setup_omega_tether();
		minimize_set_vary_omega(true);
	}
	minimize_exclude_sstype( minimize_exclude_helix, minimize_exclude_strand);

//car options to control the relax protocol
	temperature = 0.8;
	monte_carlo_set_temp(temperature);
	monte_carlo_set_simannealing(true); // constant temp, but mc shouldn't change temp
	//	minimize_set_tolerance(.001);
	if (stringent_relax()) {
		minimize_set_tolerance(.00025);
	} else {
		minimize_set_tolerance(.001);
	}
	if ( get_assemble_flag() ) {
		std::cout << "[DEBUG] total_insert=" << SS( total_insert ) << std::endl;
		cycles = 2 * total_insert;
	} else {
		cycles = static_cast<int> ( cycles_per_residue * total_residue * get_farlx_cycle_ratio() );
	}

	std::cout << "CYCLES::number is " << SS( cycles_per_residue ) <<
	 " x total_residue:" << SS( cycles ) << std::endl;
	cutoff = 60.; // msd cutoff for wobble/crank
	if ( benchmark ) cycles = 8;

	// Halved number of final cycles (stage 3), in favor of
	// more stringent minimization in earlier, more important stage (stage 2).
	// (DB,RD 1-10-07)
	int final_cycles=cycles/2;
	if (more_relax_cycles()) {
		final_cycles=2*cycles;
	}

	static bool const relax_rtmin = truefalseoption("relax_rtmin");
//car MINIMIZATION -------------------------------------------------------------

	reset_trial_counters();
	set_fullatom_flag(true);

#ifdef BOINC
	time( &stage0_time );
	if( get_do_checkpointing() && farlx_stage < 10 ){
		set_stage = 10;
		boinc_begin_critical_section();
		checkpoint_decoys(attempted_decoys, num_decoys, set_stage);
		recover_LOW(score12);
		dump_fullatom_pdb( checkpoint_decoy_name );
		boinc_end_critical_section();
	}

	if( farlx_stage == 10 ){
		read_checkpoint_decoy( checkpoint_decoy_name, true /*fullatom*/ );
		initialize_random_numbers();
		if( score_get_vary_omega() )
			setup_omega_tether();
	}else if( farlx_stage > 10 ) goto STAGE1;

#endif

	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	// PART I
	// lj-ramp cycles
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	recover_LOW(score12);

	if ( relax_options::use_pose_relax ) {
		// pose relax
		pose_relax_wrapper( lj_ramp_cycles, cycles,
												relax_options::vary_sidechain_bond_angles );
		return;
	}

	if ( relax_options::minimize ) {
		if ( sc_only ) {
			minimize_set_vary_chi(true);
			minimize_set_vary_phipsi(false);
			minimize_set_vary_omega(false);
		} else if ( bb_only ) {
			minimize_set_vary_chi(false);
			minimize_set_vary_phipsi(true);
		} else {
			minimize_set_vary_chi(true);
			minimize_set_vary_phipsi(true);
		}

		minimize_set_tolerance(0.000001);

		for ( int k = 0; k <= lj_ramp_cycles; ++k ) {
			score_set_lj_rep_weight(starting_lj_rep_weight+k*lj_increment);
			recover_LOW(score12);
			main_minimize_trial(score12,min_type);
		}
		std::cout << "starting score" << SS( score ) << " rms" << SS( rms_err );
		if ( classical_constraints::BOUNDARY::get_constraints_exist() ) std::cout << " pc_score" << SS(scores::current_scores::pc_score);
		std::cout << std::endl;


		return;
	}

	if (get_vary_chi_before_stage1()) minimize_set_vary_chi(true);

	main_repack_trial(score12,0,relax_rtmin);
	std::cout << "starting score" << SS( score ) << " rms" << SS( rms_err );
	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) std::cout << " pc_score" << SS(scores::current_scores::pc_score);
	std::cout << std::endl;

	if ( runlevel > standard ) write_rama_score_all(phi,psi,res,secstruct,
	 total_residue);

	std::cout << "starting full atom minimization" << std::endl;

	for ( int k = 0; k <= lj_ramp_cycles; ++k ) {
		score_set_lj_rep_weight(starting_lj_rep_weight+k*lj_increment);
		recover_LOW(score12);

		should_detect_interface(true);
		main_repack_trial(score12,0);
		should_detect_interface(false); // shouldn't be too necessary
		main_minimize_trial(score12,min_type);
		should_detect_interface(true);
		for ( int j = 1; j <= numtrials; ++j ) {
			main_small_min_trial(5,score12,j,"linmin"); // 5 small moves
		}
	}

#ifdef BOINC
// checkpoint stage 11
	time(&stage1_time);
	time_diff = difftime( stage1_time, stage0_time );
	if ( time_diff > get_checkpoint_interval() && get_do_checkpointing() && farlx_stage < 11 ){
		set_stage = 11;
		boinc_begin_critical_section();
		checkpoint_decoys(attempted_decoys, num_decoys, set_stage);
		recover_LOW(score12);
		dump_fullatom_pdb( checkpoint_decoy_name );
		boinc_end_critical_section();
	}

STAGE1:
// recover from stage11
	if( farlx_stage == 11 ){
		read_checkpoint_decoy( checkpoint_decoy_name, true /*fullatom*/ );
		initialize_random_numbers();
		if( score_get_vary_omega() )
			setup_omega_tether();
	}
	else if( farlx_stage > 11 ) goto STAGE2;

#endif

	recover_LOW(score12);
	main_repack_trial(score12,0,relax_rtmin);

	std::cout << "---------------------------------------------------" << std::endl;
	output_trial_counters( std::cout );
	std::cout << "stage1 score:" << SS( score ) << std::endl;
	std::cout << "---------------------------------------------------" << std::endl;
	reset_trial_counters();

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// PART II
	// small/shear moves, no vary chi
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// scorefilter1
	relax_score_filter_save1 = score;
	relax_score_filter_save2 = score;
	if ( !relax_score_filter( score, 1 ) ) goto L99;

	if ( sim_aneal ) {
		fullatom_relax_sim_aneal();
		return;
	}

	// Stringent relax before stage2 on by default (DB,RD 1-10-07)
	if (get_stringentrelax_before_stage2()){
		if (stringent_relax()) {
			minimize_set_tolerance(.000025);
		} else {
			minimize_set_tolerance(.0001);
		}
	}

	// Vary chi angles before stage 2 on by default (DB,RD 1-10-07)
	if (get_vary_chi_before_stage2()) minimize_set_vary_chi(true);

	stage2_cycles = cycles;
	get_stage2_cycles( stage2_cycles );
	nwobble1_crank = get_nwobble1_crank(); //default 3
	nwobble2_crank = get_nwobble2_crank(); //default 2
	nwobble_wobble = get_nwobble_wobble(); //default 2 (DB,RD 1-10-07)
	crank_size  = get_crank_size(); //default 3
	wobble_size = get_wobble_size();//default 3
	stage2_repack_period = get_stage2_repack_period(); //default 25
	for ( int j = 1; j <= stage2_cycles; ++j ) {
// 		if ( barcode_exist() ) {
// 			main_feature_small_min_trial(5, score12, j, min_type); // 5 small moves at feature residues
// 		} else {
// 			main_small_min_trial(5,score12,j,min_type); // 5 small moves
// 		}
		main_small_wobble_min_trial(1,score12,j,7,0,min_type);
		main_small_min_trial(5,score12,j,min_type); // 5 small moves
		if ( ! get_assemble_flag() && ! get_skip_fragment_moves() ) {
			if (get_minimize_set_local_min()) 		minimize_set_local_min(true, local_min_window_fragment_moves);
			main_crank_min_trial(crank_size,cutoff,score12,j,nwobble1_crank,nwobble2_crank,min_type);
			main_wobble_min_trial(wobble_size,cutoff,score12,j,nwobble_wobble,0,min_type);
			if (get_minimize_set_local_min()) 		minimize_set_local_min(true, local_min_window);
		}
		if ( mod(j, stage2_repack_period) == 0 ){
			main_repack_trial(score12,j);
		}
	}

#ifdef BOINC
	time(&stage2_time);
	time_diff = difftime( stage2_time, stage1_time );
	if ( time_diff > get_checkpoint_interval() && get_do_checkpointing() && farlx_stage < 12 ){
		set_stage = 12;
		boinc_begin_critical_section();
		checkpoint_decoys(attempted_decoys, num_decoys, set_stage);
		recover_LOW(score12);
		dump_fullatom_pdb( checkpoint_decoy_name );
		boinc_end_critical_section();
	}

STAGE2:
	if( farlx_stage == 12 ){
		read_checkpoint_decoy( checkpoint_decoy_name, true /*fullatom*/ );
		initialize_random_numbers();
		if( score_get_vary_omega() )
			setup_omega_tether();
	}else if( farlx_stage > 12 ) goto L99;

#endif

	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	// PART III
	// small/shear moves, vary chi
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	/////////////////////////////////////////////////////////////////////////////
	score_set_lj_rep_weight( 1.0 ); //by default, stage2 used lj_rep_weight = 1.0, but user could change it.
	recover_LOW(score12);
	set_taboo_active( false );
	main_repack_trial(score12,0,relax_rtmin);

	//scorefilter2
	relax_score_filter_save2 = score;
	if ( !relax_score_filter( score, 2) ) goto L99;
	minimize_set_vary_chi(true);

	if (stringent_relax()) {
		minimize_set_tolerance(.000025);
	} else {
		minimize_set_tolerance(.0001);
	}

	// PBHACK: may want to add new trial
	//main_minimize_trial( score12, min_type );

	get_final_cycles( final_cycles );
	for ( int j = 1; j <= final_cycles; ++j ) {
		main_small_min_trial(5,score12,j,min_type); // 5 small moves
		main_shear_min_trial(10,score12,j,min_type); // 5 shear moves
		if ( mod(j,25) == 0 ) {
			main_repack_trial(score12,0);
		}
	}

	recover_LOW(score12);

	main_repack_trial(score12,0,relax_rtmin);
	if (stringent_relax()) {
		minimize_set_tolerance(.000005);
	} else {
		minimize_set_tolerance(.00005);
	}
	main_minimize_trial(score12,min_type);


	// jump here if scorefilter-fail
 L99:

	minimize_set_tolerance(.001);
	minimize_set_vary_chi(false);
	set_taboo_active( true );

	std::cout << "---------------------------------------------------" << std::endl;
	output_trial_counters( std::cout );
	std::cout << "final score:" << SS( score );
	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) std::cout << " pc_score" << SS(scores::current_scores::pc_score);
	std::cout << std::endl;
	std::cout << "---------------------------------------------------" << std::endl;

#ifdef BOINC
	set_stage = 0; // reset checkpointing stage
	boinc_begin_critical_section();
	checkpoint_decoys(attempted_decoys, num_decoys, set_stage);
	boinc_end_critical_section();
#endif

}

////////////////////////////////////////////////////////////////////////////////
/// @begin fullatom_relax_sim_aneal
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
fullatom_relax_sim_aneal()
{
	using namespace misc;
	using namespace param_pack;
	using namespace runlevel_ns;
	using namespace score_filter_save;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

//car constants
	int const cycles_per_residue = { 1 };

//car these options may need to be changed to optimize the protocol
//car they control underlying rosetta behavior (ie minimization, move size, etc)
//  	minimize_set_local_min(true,5);
// 	set_use_nblist(true);
// 	score_set_try_rotamers(true); // (11/05/04)
// 	minimize_exclude_sstype(true,false); // exclude H from minimiz.
// 	set_smallmove_size(4.0,4.0,6.); // helix,strand,other

//car options to control the relax protocol
	int cycles = cycles_per_residue * total_residue;
	if  (more_relax_cycles()) cycles=cycles*3;
	std::cout << "CYCLES::number is " << SS( cycles_per_residue ) <<
	 " x total_residue:" << SS( cycles ) << std::endl;
	float cutoff = 300.0; // msd cutoff for wobble/crank

	float const init_temp = 3.0;
	float const final_temp = 0.4;
	float const gamma =
	 std::pow( ( final_temp / init_temp ), ( 1.0f / ( cycles * 2 ) ) );
	float temperature = init_temp;
	monte_carlo_set_temp(temperature);
	monte_carlo_set_simannealing(true);

//db following call increases non local Lennard Jones by 3x and downweights
//db solvation energy. set_score_variant can also be used to change weights
//db on terms during run
//	set_score_variant("loc_lj");
//car MINIMIZATION ---------------------------------------------------

	std::cout << "starting score" << SS( score ) << " rms" << SS( rms_err );
	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) std::cout << " pc_score" << SS(scores::current_scores::pc_score);
	std::cout << std::endl;

	if ( runlevel > standard )
	 write_rama_score_all(phi,psi,res,secstruct,total_residue);

	std::cout << "starting full atom simulated anealing" << std::endl;

// 	no_extra_chi();
// 	rot_limit_surface = 9;
// 	rot_limit_buried = 36;
// 	set_energycut(0.4);

//db  minimization is cheap, so include sidechains to make up for no extra chi
	minimize_set_vary_chi(true);
	set_smallmove_size(4.0,4.0,8.); //helix,strand,other
	minimize_set_tolerance(.001);

	for ( int j = 1; j <= cycles; ++j ) {
		temperature *= gamma;
		monte_carlo_set_temp(temperature);
		main_small_min_trial(5,score12,j,"dfpmin"); // 5 small moves
		main_crank_min_trial(1,cutoff,score12,j,4,2,"dfpmin");
		main_wobble_min_trial(1,cutoff,score12,j,6,0,"dfpmin");
		main_small_wobble_min_trial(1,score12,j,7,0,"dfpmin");
		if ( mod(j,25) == 0 ) main_repack_trial(score12,j);
	}

	recover_LOW(score12);
	relax_score_filter_save2 = score;
	if ( relax_score_filter( score, 2) ) {

	set_smallmove_size(2.0,2.0,3.0); //helix,strand,other
	cutoff = 120.0;
	main_repack_trial(score12,0);
	minimize_exclude_sstype(false,false); //exclude H from minimiz.

// 	rot_limit_surface=20;
// 	rot_limit_buried=100;
	for ( int j = 1; j <= cycles; ++j ) {
		main_small_wobble_min_trial(1,score12,j,7,0,"dfpmin");
		main_small_min_trial(5,score12,j,"dfpmin"); // 5 small moves
		main_shear_min_trial(10,score12,j,"dfpmin"); // 5 shear moves
		if ( mod(j,25) == 0 ) main_repack_trial(score12,0);
	}


		for ( int j = 1; j <= cycles; ++j ) {
			temperature *= gamma;
			monte_carlo_set_temp(temperature);
			main_small_wobble_min_trial(1,score12,j,7,0,"dfpmin");
			main_small_min_trial(5,score12,j,"dfpmin"); // 3 small moves
			main_shear_min_trial(10,score12,j,"dfpmin"); // 5 shear moves
			if ( mod(j,25) == 0 ) main_repack_trial(score12,0);
		}
// 	}

	recover_LOW(score12);
	main_repack_trial(score12,0);
	minimize_set_tolerance(.00005);
	temperature = 0.005;
	monte_carlo_set_temp(temperature);
	//	set_energycut(.01);
	for ( int j = 1; j <= 20; ++j ) {
		main_small_min_trial(3,score12,j,"dfpmin"); // 3 small moves
		main_shear_min_trial(7,score12,j,"dfpmin"); // 5 shear moves
	}
	minimize_set_tolerance(.000005);
	main_minimize_trial(score12,"dfpmin");

	}  // 2nd score_filter_loop
	minimize_set_tolerance(.005);
	minimize_set_vary_chi(false);

	std::cout << "---------------------------------------------------" << std::endl;
	output_trial_counters( std::cout );
	std::cout << "final score:" << SS( score );
	if ( classical_constraints::BOUNDARY::get_constraints_exist() ) std::cout << " pc_score" << SS(scores::current_scores::pc_score);
	std::cout << std::endl;
	std::cout << "---------------------------------------------------" << std::endl;

}

//////////////////////////////////////////////////////////////////////////////
/// @begin set_score_variant
///
/// @brief
///
/// @detailed
///
/// @param  type - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
void
set_score_variant( std::string const & type )
{
	score_variant_storage::score_variant = type;
}

//////////////////////////////////////////////////////////////////////////////
/// @begin get_score_variant
///
/// @brief
///
/// @detailed
///
/// @param
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
////////////////////////////////////////////////////////////////////////////////
std::string const &
get_score_variant()
{
	return score_variant_storage::score_variant;
}


///////////////////////////////////////////////////////////////////////////////
// returns PASSED -- ie TRUE if score passed filters

bool
relax_score_filter(
	float const score,
	int const round
)
{
	// static data
	static bool init( false );
	static bool use_filter( false );
	static bool auto_filter( false );
	static float filter1( 0.0 );
	static float filter2( 0.0 );
	static float acceptance_rate( 0.5 );

	if ( !init ) {
		init = true;
		// setup filters
		if ( truefalseoption("relax_score_filter") ) {
			use_filter = true;
			if ( truefalseoption("filter1" ) ) {
				auto_filter = false;
				filter1 = realafteroption("filter1");
				filter2 = realafteroption("filter2");
			} else {
				auto_filter = true;
				realafteroption( "acceptance_rate", acceptance_rate, acceptance_rate );
			}
		}
	}

	score_filter_save::auto_relax_score_filter = auto_filter;

	if ( !use_filter ) {
		return true; // passed
	} else if ( auto_filter ) {
		return score_filter( score, "relax_score_filter"+string_of(round),
												 acceptance_rate );
	} else {
		return ( round == 1 && score <= filter1 ||
						 round == 2 && score <= filter2 );
	}
}

////////////////////////////////////////////////////////////////
//Maybe all the following variable should go into a namespace
////////////////////////////////////////////////////////////////

bool
stringent_relax()
{
	static bool stringent_relax = { false };
	static bool init = { false };

	if ( !init ) {
		stringent_relax = truefalseoption("stringent_relax");
		init = true;
	}
	return stringent_relax;
}

void
setup_omega_tether()
{
	using namespace tether;
	using namespace misc;
	for ( int i = 1; i <= total_residue; ++i ) {
		tether_angle_res_weight(i) = 1.0;
		if ( abs(omega(i)) > 90.){
			omega_tether(i) = 180.;
		} else {
			omega_tether(i) = 0.0;
		}
	}
}

bool
more_relax_cycles()
{
	static bool more_relax_cycles = { false };
	static bool init = { false };

	if ( !init ) {
		more_relax_cycles = truefalseoption("more_relax_cycles");
		init = true;
	}
	return more_relax_cycles;
}

bool
get_ss_independent_hb_wt()    // shouldn't be here
{
	static bool ss_hb_wt = { false };
	static bool init = { false };

	if ( !init ) {
		ss_hb_wt = truefalseoption("ss_independent_hb_wt");
		init = true;
	}
	return ss_hb_wt;
}

float
get_input_lrhb_weight()
{
	static float input_lr_weight( 0.0 );
  static bool init = {false};

	if ( !init ) {
     if ( truefalseoption("long_range_hb_weight" ) ) {
				input_lr_weight = realafteroption("long_range_hb_weight");
		 }
		 init = true;
	}
	return input_lr_weight;
}

float
get_input_srhb_weight()
{
	static float input_sr_weight( 0.0 );
  static bool init = {false};

	if ( !init ) {
		 if ( truefalseoption("short_range_hb_weight" ) ) {
				input_sr_weight = realafteroption("short_range_hb_weight");
		 }
		 init = true;
	}
	return input_sr_weight;
}


float
get_farlx_cycle_ratio()
{
	static float farlx_cycle_ratio( 1.0 );
  static bool init = {false};

	if ( !init ) {
		realafteroption( "farlx_cycle_ratio", 1.0, farlx_cycle_ratio );
		init = true;
	}
	return farlx_cycle_ratio;
}


bool
use_abrelax_filters()
{
	static bool apply_filters( false );
	static bool init( false );

	if ( !init ) {
		apply_filters = truefalseoption("abrelax_filters");
		init = true;
	}
	return apply_filters;
}

bool
disable_rotamer_trials_in_farlx()
{
	static bool disable_rotamer_trials( false );
	static bool init( false );

	if ( !init ) {
		disable_rotamer_trials = truefalseoption("no_farlx_rot_trials");
		init = true;
	}
	return disable_rotamer_trials;
}

bool
enable_rotamer_trials_in_farlx()
{
	static bool enable_rotamer_trials( false );
	static bool init( false );

	if ( !init ) {
		enable_rotamer_trials = truefalseoption("farlx_rot_trials");
		init = true;
	}
	return enable_rotamer_trials;
}

bool
get_skip_fragment_moves()
{
	static bool skip_fragment_moves( false );
	static bool init( false );

	if ( !init ) {
		skip_fragment_moves = truefalseoption("skip_fragment_moves");
		init = true;
	}
	return skip_fragment_moves;
}

bool
get_auto_relax_score_filter()
{
	using namespace score_filter_save;
	return auto_relax_score_filter;
}

float
get_relax_score_filter1()
{
	using namespace score_filter_save;
	return relax_score_filter_save1;
}

float
get_relax_score_filter2()
{
	using namespace score_filter_save;
	return relax_score_filter_save2;
}

void
save_rms_before_relax()
{
	using namespace relax_options;
	rms_before_relax = mc_global_track::diagnose::low_rms;
}

void
get_lj_ramp_cycles( int & lj_ramp_cycles)
{
	static bool init( false );
	static int new_lj_ramp_cycles = lj_ramp_cycles;

	if ( !init ) {
		intafteroption("lj_ramp_cycles", lj_ramp_cycles, new_lj_ramp_cycles);
		init = true;
	}
	lj_ramp_cycles = new_lj_ramp_cycles;
	return;
}

void
get_stage2_cycles( int & stage2_cycles)
{
	static bool init( false );
	static int new_stage2_cycles = stage2_cycles;

	if ( !init ) {
		intafteroption("stage2_cycles", stage2_cycles, new_stage2_cycles);
		init = true;
	}
	stage2_cycles = new_stage2_cycles;
	return;
}

void
get_final_cycles( int & final_cycles)
{
	static bool init( false );
	static int new_final_cycles = final_cycles;

	if ( !init ) {
		intafteroption("final_cycles", final_cycles, new_final_cycles);
		init = true;
	}
	final_cycles = new_final_cycles;
	return;
}

bool
get_minimize_exclude_helix()
{
	static bool minimize_exclude_helix( false );
	static bool init( false );

	if ( !init ) {
		minimize_exclude_helix = truefalseoption("minimize_exclude_helix");
		init = true;
	}
	return minimize_exclude_helix;
}

bool
get_minimize_exclude_strand()
{
	static bool minimize_exclude_strand( false );
	static bool init( false );

	if ( !init ) {
		minimize_exclude_strand = truefalseoption("minimize_exclude_strand");
		init = true;
	}
	return minimize_exclude_strand;
}

bool
get_vary_chi_before_stage1()
{
	static bool vary_chi_before_stage1( false );
	static bool init( false );

	if ( !init ) {
		vary_chi_before_stage1 = truefalseoption("vary_chi_before_stage1");
		init = true;
	}
	return vary_chi_before_stage1;
}

bool
get_vary_chi_before_stage2()
{
	static bool vary_chi_before_stage2( false );
	static bool init( false );

	if ( !init ) {
		//		vary_chi_before_stage2 = truefalseoption("vary_chi_before_stage2");
	// Vary chi angles  before stage 2 on by default (DB,RD 1-10-07)
		vary_chi_before_stage2 = !truefalseoption("no_vary_chi_before_stage2");
		init = true;
	}
	return vary_chi_before_stage2;
}

bool
get_stringentrelax_before_stage2()
{
	static bool stringentrelax_before_stage2( false );
	static bool init( false );

	if ( !init ) {
		//		stringentrelax_before_stage2 = ( truefalseoption("stringentrelax_before_stage2") ||
		//																		 truefalseoption("stringent_relax_before_stage2"));
			// Stringent relax before stage2 on by default (DB,RD 1-10-07):
		stringentrelax_before_stage2 = !( truefalseoption("no_stringentrelax_before_stage2") ||
																		 truefalseoption("no_stringent_relax_before_stage2"));
		init = true;
	}
	return stringentrelax_before_stage2;
}


int
get_nwobble1_crank()
{
	static int nwobble1_crank( false );
	static bool init( false );

	if ( !init ) {
		intafteroption("nwobble1_crank", 3, nwobble1_crank);
		init = true;
	}
	return nwobble1_crank;
}

int
get_nwobble2_crank()
{
	static int nwobble2_crank( false );
	static bool init( false );

	if ( !init ) {
		intafteroption("nwobble2_crank", 2, nwobble2_crank);
		init = true;
	}
	return nwobble2_crank;
}

int
get_nwobble_wobble()
{
	static int nwobble_wobble( false );
	static bool init( false );

	if ( !init ) {
		//		intafteroption("nwobble_wobble", 1, nwobble_wobble);
		intafteroption("nwobble_wobble", 2, nwobble_wobble); //(DB,RD 1-10-07)
		init = true;
	}
	return nwobble_wobble;
}

int
get_crank_size()
{
	static int crank_size( false );
	static bool init( false );

	if ( !init ) {
		intafteroption("crank_size", 3, crank_size);
		init = true;
	}
	return crank_size;
}

int
get_wobble_size()
{
	static int wobble_size( false );
	static bool init( false );

	if ( !init ) {
		intafteroption("wobble_size", 3, wobble_size);
		init = true;
	}
	return wobble_size;
}

int
get_local_min_window()
{
	static int local_min_window( false );
	static bool init( false );

	if ( !init ) {
		intafteroption("local_min_window", 5, local_min_window);
		init = true;
	}
	return local_min_window;
}

int
get_local_min_window_fragment_moves()
{
	static int local_min_window_fragment_moves( false );
	static bool init( false );

	if ( !init ) {
		intafteroption("local_min_window_fragment_moves", 5, local_min_window_fragment_moves);
		init = true;
	}
	return local_min_window_fragment_moves;
}

float
get_starting_lj_rep_weight()
{
	static float starting_lj_rep_weight( false );
	static bool init( false );

	if ( !init ) {
		realafteroption("starting_lj_rep_weight", 0.02, starting_lj_rep_weight);
		init = true;
	}
	return starting_lj_rep_weight;
}

float
get_stage2_lj_rep_weight()
{
	static float stage2_lj_rep_weight( false );
	static bool init( false );

	if ( !init ) {
		realafteroption("stage2_lj_rep_weight", 1.0, stage2_lj_rep_weight);
		init = true;
	}
	return stage2_lj_rep_weight;
}

int
get_stage2_repack_period()
{
	static int stage2_repack_period( false );
	static bool init( false );

	if ( !init ) {
		intafteroption("stage2_repack_period", 25, stage2_repack_period);
		init = true;
	}
	return stage2_repack_period;
}

bool
use_abs_tolerance()
{
	static bool use_abs_tolerance( false );
	static bool init( false );

	if ( !init ) {
		use_abs_tolerance = truefalseoption("use_abs_tolerance");
		init = true;
	}
	return use_abs_tolerance;
}
