// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 12014 $
//  $Date: 2007-01-11 20:23:23 -0500 (Thu, 11 Jan 2007) $
//  $Author: chu $

#ifndef INCLUDED_relax_structure
#define INCLUDED_relax_structure


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// relax_structure Function Declarations


bool
get_relax_flag();


bool
relax_structure();


void
centroid_relax();


void
cenrlx_log_output( int jk );


void
fullatom_relax();


void
fullatom_relax_sim_aneal();


void
set_score_variant( std::string const & type );


std::string const &
get_score_variant();


bool
relax_score_filter(
	float const score,
	int const round
);


bool
stringent_relax();

bool
more_relax_cycles();

void
setup_omega_tether();

bool
get_ss_independent_hb_wt();

float
get_input_lrhb_weight();


float
get_input_srhb_weight();


float
get_farlx_cycle_ratio(
);


bool
use_abrelax_filters();

bool
disable_rotamer_trials_in_farlx();

bool
enable_rotamer_trials_in_farlx();

bool
get_skip_fragment_moves();

bool
get_auto_relax_score_filter();

float
get_relax_score_filter1();

float
get_relax_score_filter2();

void
save_rms_before_relax();

void
get_lj_ramp_cycles( int & lj_ramp_cycles);

void
get_stage2_cycles( int & stage2_cycles);

void
get_final_cycles( int & final_cycles);

bool
get_minimize_exclude_helix();

bool
get_minimize_exclude_strand();

bool
get_vary_chi_before_stage1();

bool
get_vary_chi_before_stage2();

bool
get_stringentrelax_before_stage2();

int
get_nwobble1_crank();

int
get_nwobble2_crank();

int
get_nwobble_wobble();

int
get_crank_size();

int
get_wobble_size();

int
get_local_min_window();

int
get_local_min_window_fragment_moves();

float
get_starting_lj_rep_weight();

float
get_stage2_lj_rep_weight();

int
get_stage2_repack_period();

bool
use_abs_tolerance();

#endif
