// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13011 $
//  $Date: 2007-02-21 17:17:13 -0800 (Wed, 21 Feb 2007) $
//  $Author: possu $

// Rosetta Headers
#include "loop_relax.h"
#include "aa_name_conversion.h"
#include "after_opts.h"
#include "atom_tree_routines.h"
#include "chuck.h"
#include "constraints.h"
#include "cst_descriptor.h"
#include "design.h"
#include "disulfides.h"
#include "dssp.h"
#include "enzyme.h"
#include "files_paths.h"
#include "fragments.h"
#include "fragments_pose.h"
#include "fragments_ns.h"
#include "fold_loops.h"
#include "force_barcode.h"
#include "fullatom.h"
#include "fullatom_setup.h"
#include "idealize.h"
#include "initialize.h"
#include "jumping_ns.h"
#include "jumping_pairings.h"
#include "jumping_refold.h"
#include "jumping_util.h"
#include "jumping_loops.h"
#include "jumping_diagnostics.h"
#include "kin_util.h"
#include "loops_ns.h"
#include "loop_class.h"
#include "maps.h"
#include "make_pdb.h"
#include "minimize.h"
#include "misc.h" // damn
#include "monte_carlo.h"
#include "nblist.h"
#include "output_decoy.h"
#include "packing_measures.h"
#include "param.h" // MAX_POS
#include "pdb.h"
#include "pose.h"
#include "pose_backrub_controller.h"
#include "pose_io.h"
#include "pose_loops.h"
#include "pose_fwd.h"
#include "pose_design.h"
#include "pose_docking.h"
#include "pose_idealize.h"
#include "pose_ligand.h"
#include "pose_rms.h"
#include "pose_relax.h" //test
#include "pose_vdw.h"
#include "ramachandran.h"
#include "random_numbers.h"
#include "relax.h"
#include "relax_structure.h" // test
#include "remodel_functions.hh"
#include "runlevel.h"
//#include "relax_structure.h"
#include "score.h"
#include "score_ns.h"
#include "silent_input.h" //psh add this for silent pdb
#include "smallmove.h"
#include "ssblocks.h" // charlie's heap stuff
#include "torsion_bbmove_trials.h"
#include "trajectory.h"
#include "util_basic.h"
#include "util_vector.h"

//yab headers
#include "AtomPoint.hh"
#include "BoundingBox.hh"
#include "epigraft_functions.hh"
#include "Octree.hh"
#include "rootstock_types.hh"
#include "ccd_functions.hh"


// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>
#include <ObjexxFCL/FArray4D.hh>
#include <ObjexxFCL/FArray5D.hh>
#include <ObjexxFCL/formatted.io.hh>
#include <ObjexxFCL/string.functions.hh>


// C++ Headers
#include <algorithm>
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <fstream>
#include <vector>
#include <string>
#include <list>
#include <map>


// Utility Headers
#include <utility/basic_sys_util.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>
#include <utility/io/ocstream.hh>
#include <utility/file/file_sys_util.hh>
#include <utility/vector1.hh>

namespace remodel_ns {

				class LineObject
				{
				public:
					int index;
					int original_index;
					std::string resname;
					std::string sstype;
					std::string design_type;
					bool isDesignable;
					std::vector<int> aminoAcidList;
				};

				class CommandLineFlags
				{
				public:
					int num_trajectory;
					int num_report ;
					int num_frag_moves;
					bool nojumps;
					bool automatic;
					bool use_bp_seq; // use blueprint sequence for fragment picking
					bool has_ligand;
					bool no_repack;
					bool fast_build;
					bool backrub;
					bool help;
					bool checkpoint;
					bool rigid_min;
					bool no_design;
					bool no_frags;
					bool matchingFrags;
					bool use_ccd_refine;
					bool pose_relax;
					bool pose_frag_moves;
					bool dsspSS;
					bool inserting_pdb;
					bool neighbor_design;
					bool rank_by_bsasa;
					bool neighbor_repack;

					// added by Nobu
					bool silent;
					bool output_fragfiles;
					bool read_fragfiles;

					std::string cstfile;
					std::string insert_pdb;
					CommandLineFlags(){
						intafteroption("try", 1, num_trajectory);
						intafteroption("save_top", 1, num_report);
						intafteroption("num_frag_moves", 10, num_frag_moves);
						nojumps = truefalseoption("no_jumps");
						use_bp_seq = truefalseoption("use_blueprint_sequence");
						has_ligand = truefalseoption("enable_ligand_aa");
						no_repack = truefalseoption("no_repack");
						fast_build = truefalseoption("quick_and_dirty");
						backrub = truefalseoption("backrub");
						help = truefalseoption("help");
						checkpoint = truefalseoption("checkpoint");
						rigid_min = truefalseoption("keep_jumps_in_minimizer");
						no_design = truefalseoption("no_design");
						stringafteroption("cstfile","",cstfile);
						no_frags = truefalseoption("bypass_fragments");
						matchingFrags = truefalseoption("match_fragment_size");
						use_ccd_refine = truefalseoption("use_ccd_refine");
						pose_relax = truefalseoption("use_pose_relax");
						pose_frag_moves = truefalseoption("pose_relax_fragment_moves");
						dsspSS = truefalseoption("use_dssp_assignment");
						stringafteroption("insert_segment_from_pdb", "", insert_pdb);
						inserting_pdb = truefalseoption("insert_segment_from_pdb");
						neighbor_design = truefalseoption("design_neighbors");
						rank_by_bsasa = truefalseoption("rank_by_bsasa");
						silent = truefalseoption("silent");
						output_fragfiles = truefalseoption("output_fragfiles");
						read_fragfiles = truefalseoption("read_fragfiles");
						neighbor_repack = truefalseoption("neighbor_repack");
					};
					~CommandLineFlags(){
					};
					void getAutoMode(){
						if (truefalseoption("auto")){
							automatic = true;
							num_trajectory = 100;
							num_report = 5;
							num_frag_moves = 10;
							if (!this->fast_build){
								this->checkpoint = true; //if not quick_and_dirty, always use checkpointing
							}
						}
					}
				};


				class RemodelData   // this class stores information in the blueprint file
				{
				public:
						pose_ns::Loops loops_to_build;
						std::string sequence;
						std::string ss; // need this for "." switch to find remodel regions
						std::string dssp_updated_ss; // merge the dssp assignment with ss string, exclude ".", gets the final dssp_updated_ss for fragment pick
						int design_mode; // 1 is fully auto, 2 is semi-auto (only design rebuilt and no neighbors, 3 is manual which require resfile like assignments
						std::vector<remodel_ns::LineObject> blueprint;
//					std::map< int, float > coord_cst;
//					bool coord_cst_exist(false);
//					float loop_skip_rate(0.0);
//					float loop_combine_rate(0.0);
//					bool loop_model_exist(false);
						pose_ns::Pose insertPose;
						int insertionSize;
						std::string insertionSS;
						float total_chain_break_score;
//					std::vector< float > chain_breaks;
						void getLoopsToBuildFromFile(remodel_ns::CommandLineFlags const & flags);
						void splitString(std::string str, std::string delim, std::vector<std::string> & results);
						void updateWithDsspAssigment(FArray1Da_char dsspSS);
						void collectInsertionPose();
				};


/*
				class RemodelData   // this class stores information in the blueprint file
				{
				public:
						pose_ns::Loops loops_to_build;
						std::string sequence;
						std::string ss; // need this for "." switch to find remodel regions
						std::string dssp_updated_ss; // merge the dssp assignment with ss string, exclude ".", gets the final dssp_updated_ss for fragment pick
						int design_mode; // 1 is fully auto, 2 is semi-auto (only design rebuilt and no neighbors, 3 is manual which require resfile like assignments
						std::vector<remodel_ns::LineObject> blueprint;
//					std::map< int, float > coord_cst;
//					bool coord_cst_exist(false);
//					float loop_skip_rate(0.0);
//					float loop_combine_rate(0.0);
//					bool loop_model_exist(false);
						pose_ns::Pose insertPose;
						int insertionSize;
						std::string insertionSS;
						float total_chain_break_score;
//					std::vector< float > chain_breaks;
						void getLoopsToBuildFromFile(remodel_ns::CommandLineFlags const & flags);
						void splitString(std::string str, std::string delim, std::vector<std::string> & results);
						void updateWithDsspAssigment(FArray1Da_char dsspSS);
						void collectInsertionPose();
				};
				*/
				class WorkingRemodelSet // this class holds all the info for the model_pose
				{
				// in the future a new variable might be added to delete a certain jump
				// to create domain assembly type of fold-tree
				public:
				  pose_ns::Loops loops;
					std::string sequence;
					std::string ss;
					std::map<int,int> translate_index;
					std::vector<int> begin;
					std::vector<int> end;
					std::vector<int> copy_begin;
					std::vector<int> copy_end;
					std::vector<int> src_begin;
					std::vector<int> src_end;
					bool hasInsertion;
					int insertionStartIndex;
					int insertionEndIndex;
					FArray2D_bool design_matrix;
					void workingSetGen( pose_ns::Pose const & input_pose, pose_ns::Pose & extended_pose, remodel_ns::RemodelData const & data, remodel_ns::CommandLineFlags const & flags);
					void design_matrix_from_blueprint( std::vector<remodel_ns::LineObject>  blueprint); //manual
					void setup_auto_design_matrix(pose_ns::Pose const & model_pose, std::vector<remodel_ns::LineObject> const & blueprint, bool const core, bool const boundary, bool surface);

					void setup_repack_residues(pose_ns::Pose & model_pose, std::vector<remodel_ns::LineObject> const & blueprint);
			};
				class ScoreWeight
				{
				public:
				 float vdw;
				 float env;
				 float pair;
				 float rama;
				 float cb;
				 float rg;
				 float co;
				 float sheet;
				 float sspair;
				 float rsigma;
				 float hb_lrbb;
				 float hb_srbb;
				 float barcode;
				 float barcode_energy;
				 float chainbreak;
				 float chainbreak_overlap;
				 float cst_score;

					ScoreWeight(){
					static bool init = false;
					if (!init){
						vdw = 0;
						env=0;
						pair=0;
						rama=0;
						cb=0;
						rg=0;
						co=0;
						sheet=0;
						sspair=0;
						rsigma=0;
						hb_lrbb=0;
						hb_srbb=0;
						barcode=0;
						barcode_energy=0;
						chainbreak=0;
						chainbreak_overlap=0;
						cst_score=0;
						/*
						if (truefalseoption("find_disulf") || truefalseoption("fix_disulf")){
							scorefxns::disulf_cendist_weight = 5.0;
							scorefxns::disulf_bb_dih_weight = 3.0;
							scorefxns::disulf_cbdist_weight = 5.0;
							scorefxns::disulf_cacbcb_weight = 1.0;
							scorefxns::disulf_cacbcbca_weight = 3.0;
						}
						*/
						init=true;
					 }
					};
					void get_score_function_weights();
				};


				class Segment
				{
				public:
					std::vector<int> residues;
				};

}
//forward declaration
bool
remodel_build_random_loops(
	pose_ns::Pose & pose,
	std::vector<int> const & loops_begin,
	std::vector<int> const & loops_end,
	pose_ns::Loops & output_loops,
	int const & num_frag_moves,
	remodel_ns::ScoreWeight weights,
	remodel_ns::WorkingRemodelSet working_model,
	remodel_ns::CommandLineFlags const & flags
);

void
evaluatePackingScores(pose_ns::Pose & pose);

void remodel_build_loop_with_ccd_move
(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end,
	int & cutpoint,
	int const & num_frag_moves,
	remodel_ns::ScoreWeight weights,
	remodel_ns::WorkingRemodelSet working_model,
	remodel_ns::CommandLineFlags const & flags
);
void apply_score_function_to_weight_map(remodel_ns::ScoreWeight weights, pose_ns::Score_weight_map & weight_map);
void
randomize_segment(
  pose_ns::Pose & pose,
  const int begin,
  const int size
);
void design_top_pdbs(
	std::map<float,Pose*> & sorted_results,
	remodel_ns::WorkingRemodelSet & working_model,
	remodel_ns::RemodelData const & data
);

void dump_top_pdbs(
	std::map<float,Pose*> &sorted_results
);
void build_1mer_from_3mer(pose_ns::Pose const & pose);
void keep_top_pose(
	std::map<float, Pose*> & sorted_results,
	int num_to_keep
);
/*
void setup_design_matrix(
	remodel_ns::WorkingRemodelSet &  working_model,
	pose_ns::Pose const & pose,
	bool const core,
	bool const boundary,
	bool const surface
); */
void
remodel_fa_relax(
	pose_ns::Pose & pose,
	std::vector<int> const & loop_begin,
	std::vector<int> const & loop_end,
	remodel_ns::CommandLineFlags const & flags
);
//test
void analyze_neighbors(
	pose_ns::Pose const & pose,
	std::set<int> & near_residues
);
void
fill_non_loop_cst_set(
	cst_set_ns::Cst_set & cst_set,
	pose_ns::Pose const & pose,
	std::vector<int> const & loop_begin,
	std::vector<int> const & loop_end,
	bool const & just_use_bb_heavy_atoms
);
void remodel_help();
/*
initalize_start(){
	std::string loops_filename;
	std::string filename;
	static float rmsd_tol = { 10000.0 };
	static float chain_break_tol = { 0.2 };
	static bool random_loop_exist = { false };
	static float score_filter_cutoff = { 1.0 };
	static float looprlx_cycle_ratio( 1.0 );
	static bool random_cut = { false };
	static bool use_rg = { false };
	static bool use_hb = { false };
	static bool use_sspair = { false };
	static bool use_rsigma = { false };
	static int use_9mer_frag = { 16 };
// 	static std::vector< std::string > alter_seqs;

//value or string options

	stringafteroption( "loopout_file", "", loops_filename);
	stringafteroption( "loop_file", "", filename);
//	realafteroption( "rmsd_tol", 10000.0, rmsd_tol);
//	realafteroption( "loop_combine_rate", 0.0, loop_combine_rate);
	realafteroption( "chain_break_tol", 0.2, chain_break_tol);
	stringafteroption( "coordcst", "", filename);
	stringafteroption( "alter_seqs", "junk.out", filename);
	realafteroption( "score_filter_cutoff", 1.0, score_filter_cutoff);
//	realafteroption( "loop_skip_rate", 0.0, loop_skip_rate);
//	intafteroption("num_desired_loops", 1, desired_loop );
	realafteroption( "looprlx_cycle_ratio", 1.0, looprlx_cycle_ratio );
	intafteroption("9mer_frag_cutoff", 16, use_9mer_frag );

// true false options

      	random_loop_exist = truefalseoption("random_loop");
		 		idealize = truefalseoption("looprlx_idealization");
        if ( truefalseoption ("coordcst") )
//				if (truefalseoption ("alter_seqs") ){
        loop_model_exist =  truefalseoption( "loop_model" );
				if( truefalseoption("loop_farlx") )     loop_farlx = true;
				if( truefalseoption("loop_farlx_only") ) rebuild_loop = false;
				if( truefalseoption("fullatom_loop") )  fullatom_loop = true;
				if( truefalseoption("pose_idlz") ) pose_idlz = true;
				if( truefalseoption("obligate_loops") ) obligate_loop_exist = true;
				if( truefalseoption("loops_subset") ) desired_loop_exist = true;
				if( truefalseoption("ccd_closure") ) ccd_closure_exist = true;
				if( truefalseoption("fast_loop_farlx") ) fast_refine_exist = true;
				if( truefalseoption("looprlx_fix_natsc") ) fix_natsc_exist = true;
				if( truefalseoption("shorten_long_terminal_loop") ) short_loop = true;
				if( truefalseoption("output_loops_built") ) out_loop = true;
//				if( truefalseoption("no_combine_if_fail") ) combine_loop = false;
				if( truefalseoption("loop_farlx_random_cut") ) random_cut = true;
				if( truefalseoption("use_rg") ) use_rg = true;
				if( truefalseoption("use_hb") ) use_hb = true;
				if( truefalseoption("use_sspair") ) use_sspair = true;
				if( truefalseoption("use_rsigma") ) use_rsigma = true;
//}

}


////////////////////////////////////////////////////////////////////////////////
/// @begin loop_relax
///
/// @brief called from relax_structure to relax loops defined by loop_file
///
/// @detailed this routine will use build_random_loops to rebuild loop regions
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
*/
void remodel(){
	using namespace pose_ns;
  using namespace silent_io;

	std::cout << "REMODEL MODE" << std::endl;
	//initialization
	remodel_ns::CommandLineFlags flags;
	if (flags.help){
		remodel_help();
		return;
	}
	remodel_ns::RemodelData remodel_data;
		// set default design mode to be automatic
	remodel_data.design_mode = 1;
		// unless the no_repack flag is given to overwrite automatic design
	if (flags.no_repack){
		remodel_data.design_mode = 2;
	}

	if (flags.inserting_pdb){ //this has to come before loop definition so we can update SS
		remodel_data.collectInsertionPose();
	}
		//read everything from blueprint file and put it in remodel_data object
		//design_mode 4 is initialized here.  fully manual(mode3) and semi-automatic (mode4) should overwrite 1(auto) and 2(norepack)
	remodel_data.getLoopsToBuildFromFile(flags);

	remodel_ns::WorkingRemodelSet working_model;
	remodel_ns::ScoreWeight weights;
	weights.get_score_function_weights();
	flags.getAutoMode(); // check to see if auto is on, if it is then use auto mode run control values;
	if (flags.cstfile != ""){
		std::cout << "using cstfile, turning cst_score weight to 1.0: be careful -- this overwrites manual cst_score setting" << std::endl;
		weights.cst_score = 1.0;
	}

//	bool include_neighbors=true;
	FArray1D_bool allow_repack(false);
	Pose input_pose;
	bool const fullatom( true ), ideal_pose( false ), read_all_chains( true );

	pose_from_pdb( input_pose, stringafteroption("s"), fullatom, ideal_pose, read_all_chains  );

//get DSSP assignment
	pose_to_misc(input_pose);
	dssp_ns::DSSP dssp;
	dssp.compute();
	FArray1D_char dsspSS(input_pose.total_residue());
	dssp.dssp_reduced(dsspSS);
	//std::cout << "dssp: ";
	//for (int i = 1; i<= input_pose.total_residue(); i++){
	//std::cout << dsspSS(i);
//	}
//	std::cout << std::endl;
	remodel_data.updateWithDsspAssigment(dsspSS);

//this is only if one ever wants to attach ligand to input pose
/*
	if (false){ // test only
		cst_descriptor_ns::cst_set_descriptor csts;

		bool attach_by_jump = false;
		int lig_root_atomno;
		int anchor_atomno;
		int anchor_rsd;
			csts.get_ligand_anchor_atoms( input_pose, param_aa::ligand_aa_vector[1],enable_ligaa_ns::get_ligaa_icoord( param_aa::ligand_aa_vector[1] ),
																anchor_atomno, anchor_rsd, lig_root_atomno, attach_by_jump );
			//lin add ligand to the pose
	 attach_by_jump = false;
//			input_pose.attach_ligand( param_aa::ligand_aa_vector[1], 1 // aav
													, anchor_atomno, input_pose.total_residue()-1,
//												lig_root_atomno, enable_ligaa_ns::get_ligaa_icoord( param_aa::ligand_aa_vector[1] ), attach_by_jump );
//			input_pose.dump_pdb("test_ligand");
	}
*/

	std::set<int> test_neighbors;
//	analyze_neighbors( input_pose, test_neighbors);

	Pose model_pose;  // length will be set in the workingSetGen function

		Pdb_info pdb_info;
		pdb_info.pdb_info_from_global();
		model_pose.set_pdb_information(pdb_info);


	Pose ligand_pose;
	Pose saved_fullatom_pose;
	Pose saved_centroid_pose;
	working_model.workingSetGen(input_pose, model_pose, remodel_data,flags); // after this we get fullatom model_pose

	pose_to_misc(model_pose);

	// handle classic constraints
	classical_constraints::BOUNDARY::init_module();
  classical_constraints::BOUNDARY::reset_cst_res_wt();
	classical_constraints::BOUNDARY::load_constraints_from_file(flags.cstfile); // distance constraints

	saved_fullatom_pose = model_pose; // save all the info in model_pose to be recovered later
	saved_centroid_pose = model_pose;
	model_pose.set_fullatom_flag(false, false); // switch model_pose back to centroid for building

	pose_update_MAX_RES(model_pose);
	if (flags.has_ligand){  // has to set this before picking fragment otherwise will lose it after attaching ligand
		param::MAX_RES_assign_res( model_pose.total_residue()+1);
	}

	float seq_weight(0.0); // sequence unbiased
	float const ss_weight(1.0);
	float const bb_weight(0.0);
	//int num_type_frags = 2; // use 1mer and 3mer
	std::string seq_string(model_pose.total_residue(),'.');
	std::string bb_string(model_pose.total_residue(), '.');

	if (flags.use_bp_seq){
		seq_weight = 1.0; // turns on sequence weight for fragment picking
		seq_string = remodel_data.sequence;
	}

	if (flags.matchingFrags){
		for (int window=0; window<(int)working_model.begin.size(); window++){   // pick matching size frag
			int windowSize = working_model.end[window] - working_model.begin[window];
			//read 9mer fragments
			get_vall_frags( seq_string, remodel_data.dssp_updated_ss,bb_string,
											seq_weight, ss_weight, bb_weight,
											working_model.begin[window], working_model.end[window], windowSize, 200,
											true /*excl-gly*/, true /*excl-pro*/, true/*excl-cyspep*/, 4);
		}
	}

	if (!flags.no_frags || flags.pose_frag_moves){ //if pose_relax then just use the entire dssp assignment, otherwise has to use remodel_data info
		std::string ss_string;
		if (flags.dsspSS){
			for (int i = 0; i < (int)seq_string.size(); i++){
					ss_string.append(1, dsspSS(i+1)); // mixing 0 and 1 based arrays.. be careful here
			}
		}
		else {
			if (flags.inserting_pdb){
				std::cout << "Processing insertion SS info..." << std::endl;
				int insertStartIndex =  remodel_data.dssp_updated_ss.find_first_of("I");
				int insertEndIndex = remodel_data.dssp_updated_ss.find_last_of("I");
				//std::cout << "first of I " << remodel_data.dssp_updated_ss.find_first_of("I") << "and last of I " << remodel_data.dssp_updated_ss.find_last_of("I")<< std::endl;
				/*
				if ( (insertEndIndex - insertStartIndex +1) != remodel_data.insertionSize){
					std::cout << "insertion assignment does not match inserting PDB length" << std::endl;
					utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
				}*/
				//process ss_string
				std::string beforeInsert = remodel_data.dssp_updated_ss.substr(0, insertStartIndex);
				std::string afterInsert = remodel_data.dssp_updated_ss.substr(insertEndIndex+1);
				ss_string = beforeInsert + remodel_data.insertionSS + afterInsert;
				std::cout << ss_string << std::endl;
				//temporary
				for (int i = insertStartIndex +1 /*convert to 1 based*/; i <= insertEndIndex +1; i++){
					model_pose.set_allow_bb_move(i, false);
					model_pose.set_allow_chi_move(i, false);
				}


			}
			else {
				ss_string = remodel_data.dssp_updated_ss;
			}
		}
		if(!flags.read_fragfiles){
 //	std::string ss_debug(model_pose.total_residue(),'E');
			for (int window=0; window<(int)working_model.begin.size(); window++){   // pick only the fragments we need
			//read 9mer fragments
				get_vall_frags( seq_string, ss_string, bb_string,
												seq_weight, ss_weight, bb_weight,
												working_model.begin[window], working_model.end[window], 9, 200,
												true /*excl-gly*/, true /*excl-pro*/, true/*excl-cyspep*/, 3);
			}
			for (int window=0; window<(int)working_model.begin.size(); window++){   // pick only the fragments we need
				//read 3mer fragments
				get_vall_frags( seq_string, ss_string, bb_string,
												seq_weight, ss_weight, bb_weight,
												working_model.begin[window], working_model.end[window], 3, 200,
											true /*excl-gly*/, true /*excl-pro*/, true/*excl-cyspep*/, 2);
			}
			build_1mer_from_3mer(model_pose);
		}else{
			read_fragments(model_pose.total_residue());
		}

	}

	if(flags.output_fragfiles){
		std::stringstream fragfile3,fragfile9;
		std::string fragfile;
		stringafteroption( "output_fragfiles", "", fragfile);

		fragfile3 << fragfile << "_03_05.200_v1_3";
		fragfile9 << fragfile << "_09_05.200_v1_3";

		for (int window=0; window<(int)working_model.begin.size(); window++){
			dump_fragments( fragfile3.str(), 3,
												working_model.begin[window], working_model.end[window],
											model_pose.total_residue());
		}

		for (int window=0; window<(int)working_model.begin.size(); window++){
			dump_fragments( fragfile9.str(), 9,
											working_model.begin[window], working_model.end[window],
											model_pose.total_residue());
		}
		exit(0);
	}
	score_set_vary_omega(false);

	std::map<float, Pose *> sorted_results;

	for (int i = 0; i < flags.num_trajectory; i ++){
		Pose * pose_ptr( new Pose); // make the pose storage for the sorted results
		Loops output_loops;
		int frag_move_count = flags.num_frag_moves;
		bool loopBuilt=false;

		if (!flags.no_frags){
			loopBuilt = remodel_build_random_loops( model_pose, working_model.begin, working_model.end, output_loops, frag_move_count, weights, working_model, flags);
			//model_pose.dump_pdb("check_this.pdb");
		} else {
			std::cout << "*** bypass fragment steps; refinement design only ***" << std::endl;
			loopBuilt = true;
		}

		if (flags.has_ligand){

			// after backbone modeling, the loop region has to be corrected at the
			// fullatom level.  first copy the old sidechains back and then repack
			// just the loops -- they are just ALA's at the moment
			model_pose.set_fullatom_flag( true, false );
			model_pose.recover_sidechain( saved_fullatom_pose );
			repack_loops( output_loops , model_pose); // rearrange the atoms in the rebuilt region
			saved_fullatom_pose = model_pose;

			cst_descriptor_ns::cst_set_descriptor csts;

	//studpid pdb info stuff to avoid crash

			Pdb_info pdb_info;
			pdb_info.pdb_info_from_global();
			model_pose.set_pdb_information(pdb_info);

			bool attach_by_jump = false;
			int lig_root_atomno;
			int anchor_atomno;
			int anchor_rsd;
	// the following mess is to make a pose with ligand by itself and a messed up
	// ALA as the anchor atom -- pose doesn't allow having one residue just by
	// itself.  Can be refactored into a function later
			ligand_pose.simple_fold_tree(2);
			ligand_pose.set_fullatom_flag(true,false); // has to be set before loading coords because it wipes out coords
			ligand_pose.set_res(1, param_aa::aa_ala);
			ligand_pose.set_res_variant(1,1);
			ligand_pose.set_res( 2 , param_aa::ligand_aa_vector[1] );
			ligand_pose.set_res_variant( 2, 1 );

			FArray3D_float fullcoord_out_in_the_universe(3,param::MAX_ATOM(),2);
			FArray3D_float Epos_out_in_the_universe(3, 5, 2);

			// make virtual ala coords
			for (int i = 1; i<= aaproperties_pack::natoms(param_aa::aa_ala, 1); ++i){
				for (int j=1; j<=3; ++j){
					float random_offset_for_atoms= ran3(); // need this because atom-tree doesn't allow overlapping atoms
					if (i <=5){
						Epos_out_in_the_universe(j,i,1) = 1000.0+random_offset_for_atoms;
					}
					fullcoord_out_in_the_universe(j,i,1) = 1000.0+random_offset_for_atoms;
				}
			}
			// load ligand coords
			for ( int i=1; i<= aaproperties_pack::natoms(param_aa::ligand_aa_vector[1],1); ++i ) {
				for ( int k=1; k<= 3; ++k ) {
					fullcoord_out_in_the_universe(k,i,2) = enable_ligaa_ns::lig_icoord(k,i,1);
				}
			}

			insert_init_frag(ligand_pose, 1,1); // this takes care of torsioin so refold won't complain
			csts.get_ligand_anchor_atoms( model_pose, param_aa::ligand_aa_vector[1],enable_ligaa_ns::get_ligaa_icoord( param_aa::ligand_aa_vector[1] ),
																	anchor_atomno, anchor_rsd, lig_root_atomno, attach_by_jump ); // main goal is to pick atomno
			set_default_root_atomno(param_aa::ligand_aa_vector[1], lig_root_atomno);  // probably redundant
			ligand_pose.set_coords(false, Epos_out_in_the_universe, fullcoord_out_in_the_universe); //finally put everything into the pose

			Pdb_info ligand_pdb_info; // the object that holds all the pdb info for writing out pdb files

			ligand_pdb_info.dimension(2); // only two residues

			// manual setup to make "TER" after the virtual residue and the HETATOM ligand
			FArray1D_int part_begin(2);
			FArray1D_int part_end(2);
			part_begin(1) = 1;
			part_end(1)=1;
			part_begin(2) = 2;
			part_end(2)=2;

			for (int nres = 1; nres<= ligand_pose.total_residue(); nres++){
				ligand_pdb_info.set_pdb_res( nres, nres );
				ligand_pdb_info.set_pdb_chain( nres, ' ' );
				ligand_pdb_info.set_pdb_insert_let( nres, ' ' );
			}
			ligand_pdb_info.set_multi_chain_info( false, 2, part_begin, part_end); // make it understand where to put TER
			ligand_pose.set_pdb_information(ligand_pdb_info); // load info into the pose
			ligand_pose.setup_atom_tree_preserving_allow_move();
			//	ligand_pose.dump_pdb("ligand_self.pdb");  // holy moly, it works!
			// end of ligand pose generation

			// this part attach the ligand to the model_pose, incase we are going to design
			// with the ligand present
			model_pose.set_fullatom_flag(true,false); // very important to set this up first
			csts.get_ligand_anchor_atoms( model_pose, param_aa::ligand_aa_vector[1],enable_ligaa_ns::get_ligaa_icoord( param_aa::ligand_aa_vector[1] ),
																anchor_atomno, anchor_rsd, lig_root_atomno, attach_by_jump );
			// add ligand to the pose
			attach_by_jump = true;
			model_pose.attach_ligand( param_aa::ligand_aa_vector[1], 1  /*aav*/ , anchor_atomno, model_pose.total_residue()-1,
												lig_root_atomno, enable_ligaa_ns::get_ligaa_icoord( param_aa::ligand_aa_vector[1] ), attach_by_jump );
			// model_pose.dump_pdb("test_ligand.pdb"); // this also works!

			// the following section scores ligand against the "saved_fullatom_pose"
			// because we don't want to use the pose that already has the ligand
			// attached
			float DIST_CUTOFF = 5.5;
			//define bounding box with pose
			rootstock::BoundingBox bb = epigraft::backbone_bounding_box( saved_fullatom_pose );
			//build Octree
			rootstock::Octree< epigraft::AtomPoint > octree( DIST_CUTOFF, bb.lower_corner(), bb.upper_corner() );
			//fill Octree
			epigraft::fill_backbone_octree( octree, saved_fullatom_pose );

			std::cout << "inter_rep " << octree_inter_rep_with_ligand(octree, saved_fullatom_pose, ligand_pose) << std::endl;

			if (octree_inter_rep_with_ligand(octree, saved_fullatom_pose, ligand_pose) > 0){
				loopBuilt = false;
			}
		}

		if (loopBuilt){
			if (flags.no_design){
				// written by Nobu
				std::stringstream SS;
				if(flags.silent){
					SS << "nd" << i ;
					std::string outfile( stringafteroption("silent" ) );
					Silent_out out( outfile );
					out.write( SS.str(), model_pose );
				}else{
					SS << "nd" << i << ".pdb" ;
					model_pose.dump_pdb(SS.str());
				}
				continue;
			}

			if (!flags.has_ligand) { // only do it once from above if has ligand
				// after backbone modeling, the loop region has to be corrected at the
				// fullatom level.  first copy the old sidechains back and then repack
				// just the loops -- they are just ALA's at the moment
				model_pose.set_fullatom_flag( true, false );
				model_pose.recover_sidechain( saved_fullatom_pose );
				repack_loops( output_loops , model_pose); // rearrange the atoms in the rebuilt region
				saved_fullatom_pose = model_pose; //sync the two poses
			}

			std::cout << "design_mode " << remodel_data.design_mode << std::endl;
			if (remodel_data.design_mode == 1) { // fully automated
				// find neighbors for the newly built region, but only setup core
				// and boundary residues for optimized contact
				//setup_design_matrix(working_model, model_pose, true, true, false);
				working_model.setup_auto_design_matrix(model_pose, remodel_data.blueprint, true, true, false);
			}
			else if (remodel_data.design_mode == 4) {
				std::cout << "assigning design_matrix from blueprint with auto neighbors" << std::endl;
				working_model.setup_auto_design_matrix(model_pose, remodel_data.blueprint, true, true, true); // NOTE!!
				std::cout << "assigning nataa  from blueprint" << std::endl;
				working_model.design_matrix_from_blueprint(remodel_data.blueprint);
			}

			else if (remodel_data.design_mode == 5) {
				std::cout << "assigning repack residues  from blueprint with auto neighbors" << std::endl;
				working_model.setup_repack_residues(model_pose, remodel_data.blueprint);
				std::cout << "assigning nataa/natro from blueprint" << std::endl;
				working_model.design_matrix_from_blueprint(remodel_data.blueprint);
			}

			model_pose.set_fullatom_flag(true,!flags.no_repack); // set fullatom and honor repack flag
			design_using_design_matrix(model_pose,working_model.design_matrix);
			saved_fullatom_pose = model_pose;
			model_pose.score(score12);
			//model_pose.show_scores( std::cout ); std::cout<< "<= before min" <<  std::endl;
			//model_pose.dump_pdb("beforeMin.pdb");

			if (!flags.fast_build){
				for (int desMinLoop = 1; desMinLoop <= 5 ; desMinLoop++) { // try five rounds of bbmin with design
					std::cout << "minimize step:" << desMinLoop << std::endl;

					if (flags.has_ligand){
						set_use_nblist(false);
					} else {
						set_use_nblist(true);
					}
	//test
					if (flags.use_ccd_refine){
						std::cout << "##### CCD refinement #####" << std::endl;
						const int total_loops( working_model.begin.size() );
						const int nres( model_pose.total_residue() );
						std::vector<int> num_loop;
						for (int kk = 0; kk < total_loops; ++kk){
							num_loop.push_back(kk);
						}

						for (int i = 1 ; i <= nres  ; i ++) { // set everything to false first
							model_pose.set_allow_bb_move(i , false);
						}

						for (int jj = 0; jj < total_loops; ++jj) {
							for ( int i=1; i<= nres; ++i ) {
							//////////////////
							// reset allow move to only allow move in the loop region:
								if ( i >= working_model.begin[num_loop[jj]] && i <= working_model.end[num_loop[jj]] ) {
									//std::cout << i << std::endl;
									model_pose.set_allow_bb_move( i, true ); // second pass move backbone
									model_pose.set_allow_chi_move( i, true );
								}
							}
						}


						Score_weight_map weight_map;
						setup_score_weight_map( weight_map, score12 );

						Pose trim_pose;
						Loops trim_loops;
						FArray1D_bool trim_res( model_pose.total_residue(), false );
				// trim
						std::cout << "trim" << std::endl;
						pose_update_cendist( model_pose ); // this is required for trim
						pose_loops_select_trim_residues( model_pose, working_model.loops, trim_res );
						pose_loops_trim_template( model_pose, working_model.loops, trim_res, trim_pose, trim_loops );
						loops_ns::loop_int::num_loop = 0; // set this so no classical splicerms score
						trim_pose.set_allow_jump_move( false );
						pose_loops_set_allow_bb_move( trim_pose, trim_loops );

						for (int refTries = 1; refTries <= 20; refTries++){
							weight_map.set_weight( CHAINBREAK, 1.0 );
							weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );
							weight_map.set_weight( CST_SCORE, 1.0 );
							trim_pose.score(weight_map);
							pose_refine_loops_with_ccd( trim_pose, weight_map, trim_loops );
							float loop_chain_break = trim_pose.get_0D_score( pose_ns::CHAINBREAK );
							std::cout << "refinement stage " << refTries << " chainbreak score: " << loop_chain_break << std::endl;
						//	std::stringstream SS;
						//	SS << "stage" << refTries << ".pdb" ;
						//	trim_pose.dump_pdb(SS.str());
							if (loop_chain_break < 0.01) {
								std::cout << "loop closed in refinement: Continue with design" << std::endl;
								break;
							}
							if (refTries == 20){
								std::cout << "unable to close loop during refinement in 20 tries" << std::endl;
								utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
							}
						}
						pose_loops_trim_template_reset(model_pose, working_model.loops, trim_res, trim_pose, trim_loops);
						loops_ns::loop_int::num_loop = 0; // set this so no classical splicerms score
						if (flags.checkpoint){
							std::stringstream SN;
							SN << "trimRecover" << desMinLoop << ".pdb";
							model_pose.dump_pdb(SN.str());
						}
						model_pose.update_backbone_bonds_and_torsions();
					} // use ccd refine
				//float cbreak =  score_given_chainbreak_in_pose_linear(model_pose, cutpoint);
//end test
	/*
				model_pose.dump_pdb("beforeRELAX.pdb");
				pose_to_misc(model_pose);
				pose_update_cendist(model_pose);
				*/
					if (!flags.use_ccd_refine){
								remodel_fa_relax(model_pose, working_model.begin, working_model.end, flags);
					}
/*
		Score_weight_map weight_map( score12 );
// total test
	cst_set_ns::Cst_set cst_set; //here for scope reasons
		// turning on the scores in weights
		weight_map.set_weight( ATOMPAIR_CST, 5.0);
		weight_map.set_weight( COORD_CST, 5.0);

		bool just_use_bb_heavy_atoms = true;
		fill_non_loop_cst_set(cst_set, model_pose, working_model.begin, working_model.end, just_use_bb_heavy_atoms); // trying to freeze everything except for loop
		model_pose.set_constraints( cst_set );
// total test
	model_pose.score( weight_map );


     int lj_ramp_cycles = intafteroption("lj_ramp_cycles",8) ;
      int const cycles_per_residue = { 1 };
      int cycles = static_cast<int> ( cycles_per_residue * model_pose.total_residue() * get_farlx_cycle_ratio() );
      bool const vary_sidechain_bond_angles = truefalseoption("vary_sidechain_bond_angles");

fast_relax_pose(model_pose, weight_map, lj_ramp_cycles, cycles, "tmp", 1.0, vary_sidechain_bond_angles);

		model_pose.dump_scored_pdb("a.pdb", weight_map);
*/
					std::cout << "post_min design" << std::endl;
					design_using_design_matrix(model_pose,working_model.design_matrix);
					saved_fullatom_pose = model_pose;
					std::cout << model_pose.sequence() << std::endl;
					model_pose.score(score12);
			//model_pose.dump_pdb("afterMin.pdb");
				//	std::cout << "score: " << model_pose.get_0D_score(SCORE) << std::endl;
					//model_pose.show_scores( std::cout ); std::cout<< "<= before min" <<  std::endl;
				}
			} //if not fast build
			//model_pose.dump_pdb("afterMin.pdb");

			if (flags.backrub) {

				model_pose.simple_fold_tree(model_pose.total_residue());
				const int total_loops( working_model.begin.size() );
				const int nres( model_pose.total_residue() );
				std::vector<int> num_loop;
				for (int kk = 0; kk < total_loops; ++kk){
					num_loop.push_back(kk);
				}

				for (int i = 1 ; i <= nres  ; i ++) { // set everything to false first
					model_pose.set_allow_bb_move(i , false);
				}

				for (int jj = 0; jj < total_loops; ++jj) {
					for ( int i=1; i<= nres; ++i ) {
					//////////////////
					// reset allow move to only allow move in the loop region:
						if ( i >= working_model.begin[num_loop[jj]] && i <= working_model.end[num_loop[jj]] ) {
							//std::cout << i << std::endl;
							model_pose.set_allow_bb_move( i, true ); // second pass move backbone
							model_pose.set_allow_chi_move( i, true );
						}
					}
				}

				model_pose.score(score12);
				pose_ns::Backrub_controller backcontrol;
				Score_weight_map weight_map;
				setup_score_weight_map(weight_map,score12);
				backcontrol.set_pose(&model_pose);
				float mc_temp=0.6;
				pose_ns::Monte_carlo mc(model_pose, weight_map, mc_temp);
				float bond_angle_weight = 1.0;
				weight_map.set_weight(pose_ns::BOND_ANGLE, bond_angle_weight);
				backcontrol.init_with_args_no_resfile();
				//replace_cbha_pose(pose);
				//backcontrol.trial(model_pose, mc);
				for (int t = 1; t<=5; t++){
					int ntrials = 2000;
					backcontrol.mc_loop(model_pose, mc, ntrials);
					design_using_design_matrix(model_pose,working_model.design_matrix);
					saved_fullatom_pose = model_pose;
					mc.boltzmann(model_pose);
					model_pose = mc.low_pose();
					std::cout << model_pose.show_scores() << std::endl;
					//std::stringstream SS;
					//SS << "bc" << t << ".pdb" ;
					model_pose.score(score12); // switch back to score12 for fullatom score
					float model_pose_score = model_pose.get_0D_score(SCORE);
					std::cout << "model_pose score = " << model_pose_score << std::endl;
				//	model_pose.dump_pdb(SS.str());
				}
			}

			model_pose.score(score12); // switch back to score12 for fullatom score
			evaluatePackingScores(model_pose);
			float model_pose_score = model_pose.get_0D_score(SCORE);
			float bsasaScore = model_pose.get_extra_score("bsasaWLN");
			std::cout << "model_pose score = " << model_pose_score << std::endl;
			std::cout << "bsasaWLN score = " << bsasaScore << std::endl;
			*pose_ptr = model_pose; // attach pointer to model_pose
			if (flags.rank_by_bsasa){
					sorted_results[bsasaScore] = pose_ptr;
			}
			else {
					sorted_results[model_pose_score] = pose_ptr;
			}
			keep_top_pose(sorted_results, flags.num_report);
			if (flags.checkpoint){
				dump_top_pdbs(sorted_results);
			}
		}
		if ( flags.has_ligand ) { // need to remove the ligand and switch back to centroid level before continuing
			model_pose = saved_centroid_pose;
			model_pose.set_fullatom_flag(false, false);
			//model_pose.clear_atom_tree();
			//model_pose.update_backbone_bonds_and_torsions();
		}
	} // for num_trajectories
	if (sorted_results.size() == 0 && !flags.no_design){
		std::cout << "WARNING: remodel unsuccessful" << std::endl;
		return;
	}

	// fill in the surface residues by redesigning the entire remodeled area
	if (remodel_data.design_mode==1){ // fully automated
		design_top_pdbs(sorted_results, working_model, remodel_data);
	}

	dump_top_pdbs(sorted_results);
  //model_pose.dump_pdb("test.pdb");

	return;
}

void
evaluatePackingScores(pose_ns::Pose & pose){
	using namespace packing_ns;
	pose_to_misc(pose);
	ProteinSasa ps;
	ps.compute_atom_bsasa_score();
	float bsasa_score = ps.bsasa_score_weighted_log();
	pose.set_extra_score("bsasaWLN", bsasa_score);
	std::cout << "bsasa score " << pose.get_extra_score("bsasaWLN") << std::endl;
	return;
}


void
fill_non_loop_cst_set(
	cst_set_ns::Cst_set & cst_set,
	pose_ns::Pose const & pose,
	std::vector<int> const & loop_begin,
	std::vector<int> const & loop_end,
	bool const & just_use_bb_heavy_atoms
)
{
  using namespace cst_set_ns;

  int const cutoff_atm( 2 ); // c-alpha
  float const dist2_threshold( 144.0 );

  bool const fullatom( pose.fullatom() );
  if ( !fullatom && !just_use_bb_heavy_atoms ) {
    std::cout << "just for fullatom!!" << std::endl;
    utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
  }

  int const nres( pose.total_residue() );
  FArray1D_int const & res( pose.res() );
  FArray1D_int const & res_variant( pose.res_variant() );
  FArray3D_float const & full_coord( pose.full_coord() );
	FArray1D_bool loop_definition(nres,false);

	//compile a lookup table for loop regions
	for (int loop_count = 0, end = loop_begin.size(); loop_count < end; loop_count++){ // which loop
		for (int residue = loop_begin[loop_count]; residue <= loop_end[loop_count]; residue++){ // iterate the range
			loop_definition(residue) = true;  // flag as loop region
		}
	}
//debug
/*
	for (int i = 1; i <= nres ; i++){
		std::cout<< loop_definition(i) ;
	}
	std::cout << std::endl;
*/
  int count(0);
  int natm1;
  int natm2;
  for ( int i=1; i<= nres; ++i ) {
    int const aa1( res(i) );
    int const aav1( res_variant(i) );
    if ( just_use_bb_heavy_atoms ) {
      natm1 = 4;
    } else {
      natm1 = aaproperties_pack::nheavyatoms(aa1,aav1);
    }
    for ( int j=i+1; j<= nres; ++j ) {
      int const aa2( res(j) );
      int const aav2( res_variant(j) );
      if ( just_use_bb_heavy_atoms ) {
        natm2 = 4;
      } else {
        natm2 = aaproperties_pack::nheavyatoms(aa2,aav2);
      }
			// break out of the loop if falls within loop_definition
			if (loop_definition(i) || loop_definition(j)) {
		//		std::cout << "no atompair constraints for pair " << i << " " << j << std::endl;
				continue;
			}
		//	std::cout << "setup atompair constraints for pair " << i << " " << j << std::endl;
      if ( vec_dist2( full_coord( 1, cutoff_atm, i ),
                      full_coord( 1, cutoff_atm, j ) ) < dist2_threshold ) {
        for ( int ii=1; ii<= natm1; ++ii ) {
          kin::Atom_id atom1(ii,i);
          for ( int jj=1; jj<= natm2; ++jj ) {
            kin::Atom_id atom2(jj,j);
            float const r ( std::sqrt( vec_dist2( full_coord( 1, ii, i ),
                                                  full_coord( 1, jj, j ) ) ) );
            Cst cst(r);
            cst_set.add_atompair_constraint( atom1, atom2, cst );
            ++count;
          }
        }
      }
    }
  }
  std::cout << "total atompair constraints: " << count << std::endl;

  // now do the torsions
  for ( int i=1; i<= nres; ++i ) {
		if (loop_definition(i)) {
		//		std::cout << "no torsion constraint for residue " << i <<  std::endl;
				continue;
		}
    int const aa(res(i));
    int const aav(res_variant(i));
    int const nchi( fullatom ? aaproperties_pack::nchi(aa,aav) : 0 );
    for ( int tor=1; tor<= param_torsion::total_bb_torsion + nchi; ++tor ) {
      cst_set.add_rosetta_torsion_constraint( i, tor,
        pose.get_torsion_by_number( i, tor ) );
    }
  }

  // now do the coordinate tether
  if ( fullatom ) {
    for ( int i=1; i<= nres; ++i ) {
			if (loop_definition(i)) {
			//		std::cout << "no coordinate constraint for residue " << i <<  std::endl;
					continue;
			}
      int const aa(res(i));
      int const aav(res_variant(i));
      int const natoms( aaproperties_pack::natoms(aa,aav) );
      for ( int j=1; j<= natoms; ++j ) {
        kin::Atom_id  atom(j,i);
        cst_set.add_coordinate_constraint( atom,
          numeric::xyzVector_float( &full_coord(1,j,i) ) );
      }
    }
  }
}


// trying new refinement tricks that relies only on repack/redesign and
// minimization
void
remodel_fa_relax(
	pose_ns::Pose & pose,
	std::vector<int> const & loop_begin,
	std::vector<int> const & loop_end,
	remodel_ns::CommandLineFlags const & flags
)
{
	using namespace pose_ns;
	using namespace files_paths;

	pose.set_fullatom_flag( true, true );
  const int total_loops( loop_begin.size() );
	assert ( total_loops == int(loop_end.size()) );
	//int const inner_cycles( 12 );
	int const outer_cycles( 5 );
	float const mc_temp( 1.2 );
	const int nres( pose.total_residue() );

	std::vector<int> num_loop;
	//pose_setup_packer();

	if (!flags.rigid_min){  // take out jumps if not running "keep_jumps_during_minimizer"
		pose.simple_fold_tree(pose.total_residue());
	}

	// minimizer params:
	minimize_exclude_sstype( false, false );
	minimize_set_vary_phipsi( true );
	minimize_set_vary_chi( true );
	minimize_set_vary_omega( false ); // NOT omega, but everything else
	minimize_set_vary_rb_angle( true );
	minimize_set_vary_rb_trans( true );
	minimize_set_tolerance( 0.001 );
	minimize_set_local_min( false, 0 ); // all non-move-list rsds minimized

	// miscellaneous
	score_set_try_rotamers( false ); // may be turned on inside moves
//	set_use_nblist(true);  <= set outside this function for ligand detection
	//set_smallmove_size( 2.0, 2.0, 3.0 );
	//bool const try_rotamers( true );
	//float const energycut = 0.001;
	Score_weight_map weight_map;
	//	setup_score12_weight_map( weight_map );
	setup_score_weight_map( weight_map, score12 );
	if (flags.rigid_min){ //if keep jumps in minimizer, need to keep chainbreak score, too
		weight_map.set_weight( CHAINBREAK, 1.0 );
		weight_map.set_weight( CHAINBREAK_OVERLAP, 1.0 );
	}
	//weight_map.set_weight(FA_ATR, 1.0);
	//weight_map.set_weight(FA_REP,1.0);

	cst_set_ns::Cst_set cst_set; //here for scope reasons
	if (!flags.rigid_min){
		// turning on the scores in weights
		weight_map.set_weight( ATOMPAIR_CST, 5.0);
		weight_map.set_weight( COORD_CST, 5.0);

		bool just_use_bb_heavy_atoms = true;
		fill_non_loop_cst_set(cst_set, pose, loop_begin, loop_end, just_use_bb_heavy_atoms); // trying to freeze everything except for loop
		pose.set_constraints( cst_set );
	}

	pose.score( weight_map );

	pose.show_scores( std::cout ); std::cout<< "<= initial Energy" << std::endl;
	// assert unbroken chain?

	// pose_relax the entire structure
	if (flags.pose_relax){
		std::cout << "===POSE RELAX===" << std::endl;
		//pose.set_allow_bb_move(true);
		//pose.set_allow_chi_move(true);

		//psh include disulfide constraints  -- only for pose_relax for now.
		bool const disulf_flag = disulfides::BOUNDARY::get_disulf_flag();
		if (disulf_flag){
			std::cout << "include disulfide constraint" << std::endl;
			add_disulf_pose_constraints( pose );
			//turn on the weight_map terms that correspond to disulf_constraints
			weight_map.set_weight( KIN_3D_CST, 1.0 )  ; // the torsion/bond/angle tether
			weight_map.set_weight( ATOMPAIR_CST, 1.0 ); // the ring constraint tether
		}
		//psh score weight_map to get the terms calculated
		pose.score(weight_map);

		int lj_ramp_cycles = intafteroption("lj_ramp_cycles",8) ;
		int const cycles_per_residue = { 1 };
		int cycles = static_cast<int> ( cycles_per_residue * pose.total_residue() * get_farlx_cycle_ratio() );
		bool const vary_sidechain_bond_angles = truefalseoption("vary_sidechain_bond_angles");
		fast_relax_pose(pose, weight_map, lj_ramp_cycles, cycles, "tmp", 1.0, vary_sidechain_bond_angles);
		return;
	}


	for (int kk = 0; kk < total_loops; ++kk){
		num_loop.push_back(kk);
	}
/*
	if ( fold_tree.get_num_jump() > 0 ) {
		std::cout << "currently only supports unbroken chains but " <<
			" that would be easy to change" << std::endl;
		utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
	}
*/
  random_shuffle( num_loop.begin(), num_loop.end() );

	std::cout << "bb-MOVE" << std::endl;
	FArray1D_bool loop_residue(nres,false);


	if (!flags.rigid_min) {
		for (int i = 1; i <= nres; ++i){
			pose.set_allow_bb_move(i, true); // NOTE!!
			pose.set_allow_chi_move(i, false);
		}
	}
	else {
		for (int i = 1; i <= nres; ++i){
			pose.set_allow_bb_move(i, false); // NOTE!!
			pose.set_allow_chi_move(i, false);
		}
	}

	for (int jj = 0; jj < total_loops; ++jj) {

//		int loop_size = loop_end[num_loop[jj]] - loop_begin[num_loop[jj]] + 1;

//		int n_small_moves ( std::min(5,loop_size/2) );

//		int cutpoint( choose_cutpoint( pose,
//								loop_begin[num_loop[jj]], loop_end[num_loop[jj]] ) );


		//////////////////
		// set allow move:
		for ( int i=1; i<= nres; ++i ) {
			if ( i >= loop_begin[num_loop[jj]] && i <= loop_end[num_loop[jj]] ) {
				pose.set_allow_bb_move( i, true ); // second pass move backbone
				pose.set_allow_chi_move( i, true );
				loop_residue( i ) = true;
//			} else {
//				pose.set_allow_bb_move( i, true );
//				pose.set_allow_chi_move( i, false ); // NOTE!!
			}
		}
	}
		pose.score( weight_map );

		Monte_carlo mc( pose, weight_map, mc_temp );
	//	mc.reset( pose );
		for ( int i=1; i<= outer_cycles; ++i ) {

		//	float const chainbreak_weight( i ); // CHANGE ME
		//	weight_map.set_weight( CHAINBREAK, chainbreak_weight );
			mc.set_weight_map( weight_map );

			pose = mc.low_pose();

			// repack the loop positions
			pose.repack( loop_residue, true );
			pose.score( weight_map );
			mc.boltzmann( pose );
			// minimize
			pose.main_minimize( weight_map, "dfpmin" );
			mc.boltzmann( pose );
/*
			for ( int j = 1; j <= inner_cycles; ++j ) {
				// small moves, min
				// std::cout << "Inner cycles " << j << std::endl;
				pose_small_min_trial( pose, mc, weight_map, "dfpmin",
															n_small_moves,try_rotamers, energycut );
}
				// ccd trial:
				if ( loop_begin[num_loop[jj]] != 1 && loop_end[num_loop[jj]] != nres )
					pose_ccd_min_trial( pose, mc, weight_map, "dfpmin",
															loop_begin[num_loop[jj]], loop_end[num_loop[jj]],
															cutpoint, 100, try_rotamers, energycut );
			}
*/
				// try dunbrack closing at the end

		//	pose.main_minimize( weight_map, "dfpmin");
			pose.score( weight_map);
			pose.show_scores( std::cout ); std::cout<< std::endl;
	//		mc.boltzmann( pose );
		}
		pose = mc.low_pose();
		pose.update_backbone_bonds_and_torsions();
		//pose.simple_fold_tree( nres );
//	} orignal jj loop end
//  pose = mc.low_pose();

		//////////////////
		// reset allow move to only allow move in the loop region:
	for (int i = 1; i <= nres; ++i){
		pose.set_allow_bb_move(i, false); // NOTE!!
		pose.set_allow_chi_move(i, false);
	}
	for (int jj = 0; jj < total_loops; ++jj) {
		for ( int i=1; i<= nres; ++i ) {
			if ( i >= loop_begin[num_loop[jj]] && i <= loop_end[num_loop[jj]] ) {
				pose.set_allow_bb_move( i, true ); // second pass move backbone
				pose.set_allow_chi_move( i, true );
	//		} else {
	//			pose.set_allow_bb_move( i, false );
	//			pose.set_allow_chi_move( i, false ); // NOTE!!
			}
		}
	}

	pose.set_fullatom_flag( true, false );
	pose.reset_constraints();
	//output_decoy_pose(pose);
}



void find_neighbors(
	remodel_ns::WorkingRemodelSet const & working_model,
	pose_ns::Pose const & pose,
	std::map<int, std::set<int> > & neighbor_per_residue
)
{
  using namespace epigraft;

	float DIST_CUTOFF = 6.0;

	//define bounding box with pose
	rootstock::BoundingBox bb = backbone_bounding_box( pose );
  //build Octree
	rootstock::Octree< AtomPoint > octree( DIST_CUTOFF, bb.lower_corner(), bb.upper_corner() );
	//fill Octree
	fill_backbone_octree( octree, pose );


	FArray3D_float const & coord = pose.full_coord(); // load the array for coordinate access

	// find neighbors for remodeling range
	for (int i = 0; i < (int)working_model.begin.size() ; i++){  // for each of the remodeling segments
		//find out how many residues to update
		int update_residues = (working_model.end[i] - working_model.begin[i] + 1);
		std::set<int> neighbors;
		for (int j = 0 ; j < update_residues ; j++){
			int res = working_model.begin[i]+j;
		//	int const aa(pose.res( res ));
	//		int const aav(pose.res_variant( res ));
			neighbors.clear();
			for (int atom = 1 ; atom <= 4; ++atom){
				//find_near_residues( octree, coord(1,atom,res), coord(2,atom,res), coord(3,atom,res), DIST_CUTOFF, near_residues);
				find_near_residues( octree, coord(1,atom,res), coord(2,atom,res), coord(3,atom,res), DIST_CUTOFF, neighbors);
			}
			std::cout << "number of near neighbor residues =  " << neighbors.size() << std::endl;
			neighbor_per_residue[res] = neighbors;
		}
	}
	//		std::cout << "number of near neighbor residues =  " << near_residues.size() << std::endl;
}

void analyze_neighbors(
	pose_ns::Pose const & pose,
	std::set<int> & near_residues
)
{
std::cout << "analyze neighbors " << std::endl;
  using namespace epigraft;

	float DIST_CUTOFF = 6.0;

	//define bounding box with pose
	rootstock::BoundingBox bb = backbone_bounding_box( pose );
  //build Octree
	rootstock::Octree< AtomPoint > octree( DIST_CUTOFF, bb.lower_corner(), bb.upper_corner() );
	//fill Octree
	fill_backbone_octree( octree, pose );

	FArray3D_float const & coord = pose.full_coord(); // load the array for coordinate access

	// find neighbors for remodeling range
	for (int i = 1; i <= pose.total_residue() ; i++){  // for each of the remodeling segments
		//find out how many residues to update
			int res = i;
			//int const aa(pose.res( res ));
			//int const aav(pose.res_variant( res ));

	near_residues.clear();
			std::cout << "res " << i ;
	//		std::cout << "SCARLET: finding near neighbors for residue " << res << std::endl;
			for (int atom = 1 ; atom <= 4; ++atom){
	//		std::cout << "                                              " << coord(1,atom,res) << " " << coord(2,atom,res) << " " << coord(3,atom,res) << std::endl;
				find_near_residues( octree, coord(1,atom,res), coord(2,atom,res), coord(3,atom,res), DIST_CUTOFF, near_residues);
			}
			std::cout << "number of near neighbor residues =  " << near_residues.size() << std::endl;
	}
}

int resclass(
	pose_ns::Pose const & pose,
	int const residue
)
{
  using namespace epigraft;
	//std::cout << "classify residue " << std::endl;
	std::set<int> near_residues;

	float DIST_CUTOFF = 6.0;
	int CORE_CUTOFF = 15;
	int BOUNDARY_CUTOFF = 10;

	//define bounding box with pose
	rootstock::BoundingBox bb = backbone_bounding_box( pose );
  //build Octree
	rootstock::Octree< AtomPoint > octree( DIST_CUTOFF, bb.lower_corner(), bb.upper_corner() );
	//fill Octree
	fill_backbone_octree( octree, pose );
	FArray3D_float const & coord = pose.full_coord(); // load the array for coordinate access

	int res = residue;
//	int const aa(pose.res( res ));
//	int const aav(pose.res_variant( res ));

	//std::cout << "res " << residue ;
	for (int atom = 1 ; atom <= 4; ++atom){
		find_near_residues( octree, coord(1,atom,res), coord(2,atom,res), coord(3,atom,res), DIST_CUTOFF, near_residues);
	}
	//std::cout << "number of near neighbor residues =  " << near_residues.size() << std::endl;
	if ((int)near_residues.size() >= CORE_CUTOFF){
		//std::cout << "core" << std::endl;
		return 1; // core
	}
	else if ( (int)near_residues.size() >= BOUNDARY_CUTOFF && (int)near_residues.size() < CORE_CUTOFF){
		//std::cout << "boundary" << std::endl;
		return 2; // boundary
	}
	else {
		//std::cout << "surface" << std::endl;
		return 3; // surface
	}
}

void designResidueAsCore( remodel_ns::WorkingRemodelSet & working_model, int const residue){ // apolar
	using namespace param;
	using namespace param_aa;
	for (int aa = 1; aa <= MAX_AUTH_AA ; aa++) {
		if (aa != param_aa::aa_cys){
			if (aa_is_nonpolar(aa)){
				working_model.design_matrix(aa, residue) = true;
			}
		}
	}
}
void designResidueAsBoundary( remodel_ns::WorkingRemodelSet & working_model, int const residue){ // all aa
	using namespace param;
	using namespace param_aa;
	for (int aa = 1; aa <= MAX_AUTH_AA ; aa++) {
		if (aa != param_aa::aa_cys){
			//std::cout << "bon" << std::endl;
				working_model.design_matrix(aa, residue) = true;
		}
	}
}

void designResidueAsSurface( remodel_ns::WorkingRemodelSet & working_model, int const residue){ // polar
	using namespace param;
	using namespace param_aa;
	for (int aa = 1; aa <= MAX_AUTH_AA ; aa++) {
		if (aa != param_aa::aa_cys){
			if (aa_is_polar(aa)){
				working_model.design_matrix(aa, residue) = true;
			}
		}
	}
}

void designResidueAsAla( remodel_ns::WorkingRemodelSet & working_model, int const residue){ // polar
	working_model.design_matrix(1, residue) = true;
}

void repack_residue_matrix( remodel_ns::WorkingRemodelSet & working_model, int const residue, int const nat_res){
	using namespace param;
	using namespace param_aa;
	if (nat_res != param_aa::aa_cys && nat_res != param_aa::aa_pro ){

		working_model.design_matrix(nat_res , residue) = true;

	}

}

/*
void setup_design_matrix(
	remodel_ns::WorkingRemodelSet & working_model,
	pose_ns::Pose const & pose,
	bool const core, // use real core? or ALA for core?
	bool const boundary, // use real boundary? or ALA for boundary?
	bool const surface // use real surface? or ALA for bounday?
)
{
	std::map< int, std::set<int> > neighbor_per_residue;
	std::set< int > residues_to_design; // use set to store unique residues
	find_neighbors(working_model, pose, neighbor_per_residue);

	//iterate over all positions and load unique info into the residues_to_design set
	for (std::map<int,std::set<int> >::iterator itr = neighbor_per_residue.begin(); itr != neighbor_per_residue.end(); itr++) {
		std::set<int>::iterator iter;
		for (iter = (*itr).second.begin(); iter != (*itr).second.end(); iter++){
			if (working_model.hasInsertion){
				if (working_model.insertionStartIndex <= *iter && *iter <= working_model.insertionEndIndex){
					std::cout << "insertion position " << *iter << " skipped in design" << std::endl;
					continue;
				}
			}
			residues_to_design.insert((*iter));
		}
	}

	std::cout << "designing: " ;
	for (std::set<int>::iterator itr = residues_to_design.begin(); itr != residues_to_design.end(); itr++){
		std::cout << *itr << ",";
		int resclassification;
		resclassification = resclass(pose, *itr);
		switch (resclassification) {
			case 1:
				if (core) {
					designResidueAsCore(working_model, *itr);
				} else {
					designResidueAsAla(working_model, *itr);
				}
				break;
			case 2:
				if (boundary) {
					designResidueAsBoundary(working_model, *itr);
				} else {
					designResidueAsAla(working_model, *itr);
				}
				break;
			case 3:
				if (surface) {
					designResidueAsSurface(working_model, *itr);
				} else {
					designResidueAsAla(working_model, *itr);
				}
				break;
		}
	}
	std::cout << std::endl;
}
*/

void remodel_ns::WorkingRemodelSet::setup_auto_design_matrix(
	pose_ns::Pose const & pose,
	std::vector<remodel_ns::LineObject> const & blueprint,
	bool const core, // use real core? or ALA for core?
	bool const boundary, // use real boundary? or ALA for boundary?
	bool const surface // use real surface? or ALA for bounday?
)
{
	std::map< int, std::set<int> > neighbor_per_residue;
	std::set< int > residues_to_design; // use set to store unique residues
	find_neighbors(*this, pose, neighbor_per_residue);

	//iterate over all positions and load unique info into the residues_to_design set
	for (std::map<int,std::set<int> >::iterator itr = neighbor_per_residue.begin(); itr != neighbor_per_residue.end(); itr++) {
		std::set<int>::iterator iter;
		for (iter = (*itr).second.begin(); iter != (*itr).second.end(); iter++){
			residues_to_design.insert((*iter));
		}
	}

	std::cout << "designing: " ;
	for (std::set<int>::iterator itr = residues_to_design.begin(); itr != residues_to_design.end(); itr++){
		if (blueprint[*itr-1].isDesignable){ // convert from residue number to array 0 based index
	//		std::cout << "manual design postion " << *itr << " skipping from auto setup\n";
			continue;
		}
		std::cout << *itr << ",";
		int resclassification;
		resclassification = resclass(pose, *itr);
		switch (resclassification) {
			case 1:
				if (core) {
					designResidueAsCore(*this, *itr);
				} else {
					designResidueAsAla(*this, *itr);
				}
				break;
			case 2:
				if (boundary) {
					designResidueAsBoundary(*this, *itr);
				} else {
					designResidueAsAla(*this, *itr);
				}
				break;
			case 3:
				if (surface) {
					designResidueAsSurface(*this, *itr);
				} else {
					designResidueAsAla(*this, *itr);
				}
				break;
		}
	}
	std::cout << std::endl;
}

// Repack

void remodel_ns::WorkingRemodelSet::setup_repack_residues(
	pose_ns::Pose & pose,
	std::vector<remodel_ns::LineObject> const & blueprint
)
{
	using namespace pose_ns;
	using namespace param;
	using namespace param_aa;

	std::map< int, std::set<int> > neighbor_per_residue;
	std::set< int > residues_to_repack; // use set to store unique residues
	find_neighbors(*this, pose, neighbor_per_residue);
	FArray1D_bool allow_repack_neighbor(pose.total_residue(), false);

	for (std::map<int,std::set<int> >::iterator itr = neighbor_per_residue.begin(); itr != neighbor_per_residue.end(); itr++) {
		std::set<int>::iterator iter;
		for (iter = (*itr).second.begin(); iter != (*itr).second.end(); iter++){
		residues_to_repack.insert((*iter));
			}
		}

	std::cout << "repacking: " ;
	for (std::set<int>::iterator itr = residues_to_repack.begin(); itr != residues_to_repack.end(); itr++){
		if (blueprint[*itr-1].isDesignable){ // convert from residue number to array 0 based index
			  //    std::cout << "manual design postion " << *itr << " skipping from
				//    auto setup\n";
			continue;
			}
		std::cout << *itr << ",";
		//bc

		int const aa= pose.res(*itr);
		repack_residue_matrix(*this,*itr,aa);
	}
}


void design_top_pdbs(
	std::map<float,Pose*> & sorted_results,
	remodel_ns::WorkingRemodelSet & working_model,
	remodel_ns::RemodelData const & data
)
{
	std::map<float, Pose*>::iterator itr;
	for (itr = sorted_results.begin() ; itr != sorted_results.end(); itr++){
		working_model.setup_auto_design_matrix(*(itr->second), data.blueprint, true, true, true);  // use all resclass types
		(*(*itr).second).set_fullatom_flag(true, true);
		design_using_design_matrix(*(itr->second), working_model.design_matrix);
		(*(*itr).second).score(score12);
	}
}

void dump_top_pdbs(
	std::map<float,Pose*> & sorted_results
)
{
	std::cout << "sorted size in dumping: " << sorted_results.size() << std::endl;
	std::map<float, Pose*>::iterator itr;

//setup a standard weightmap
	pose_ns::Score_weight_map weight_map;
	setup_score_weight_map( weight_map, score12 );

	int i;
	for (itr = sorted_results.begin(), i=1; itr != sorted_results.end(); itr++, i++){
		std::string number(lead_zero_string_of(i, 3));
		std::string filename = number + ".pdb";
		std::cout << filename << std::endl;
		(*itr).second->simple_fold_tree((*itr).second->total_residue()); // make sure chainbreak free for rama score
		(*itr).second->dump_scored_pdb(filename, weight_map);
	}
}

void keep_top_pose(
	std::map<float, Pose*> & sorted_results,
	int num_to_keep
)
{
	std::cout << "sorted size " << sorted_results.size() << std::endl;
	if ((int)sorted_results.size() > num_to_keep)  {
		std::map<float, Pose*>::iterator worst_structure = --sorted_results.end();
		delete (*worst_structure).second; // deletes Pose allocated on heap
		sorted_results.erase( worst_structure );
		std::cout << "sorted size " << sorted_results.size() << std::endl;
	}
}
void
remodel_ns::RemodelData::splitString(std::string str, std::string delim, std::vector<std::string> & results) {
	int cutAt;
	while((cutAt = str.find_first_of(delim)) != int(str.npos) ) {
		if(cutAt > 0) {
			results.push_back(str.substr(0,cutAt));
		}
		str = str.substr(cutAt+1);
	}
	if(str.length() > 0) {
		results.push_back(str);
	}
}

void
remodel_ns::RemodelData::getLoopsToBuildFromFile(remodel_ns::CommandLineFlags const & flags)
{

// read blueprint file and load everything into the maps
	std::string filename;
	stringafteroption("blueprint", "", filename);
	if (filename == ""){
		std::cout << "can't find blueprint file for remodel!" << std::endl;
	}
	utility::io::izstream data(filename.c_str());
	if (!data) {
		std::cout << "Can't open blueprint file " << filename << std::endl;
		utility::exit(EXIT_FAILURE, __FILE__, __LINE__);
	}
	std::string line;

	//extension management
	std::string ext_ss_buffer;
	//int ext_buffer=-1;
	//int ext_count_buffer=0;

	int index = 1;
	while (getline( data, line)){
		std::istringstream line_stream(line);
		remodel_ns::LineObject line;
		line.isDesignable = false; // initialize design default to false
	//	std::cout << "index: " << index << std::endl;
		line.index = index;
/*
		line_stream >> line.original_index >> line.resname >> line.sstype >> skip;
		this->blueprint.push_back(line);
*/
		index++;
		// could have initialized blueprint after the split, oh well...
		std::vector<std::string> split_info;
		this->splitString(line_stream.str(), " ", split_info);
		std::istringstream(split_info[0]) >> line.original_index;
		//std::istringstream(split_info[1]) >> line.resname;  doesn't work !!
		//std::istringstream(split_info[2]) >> line.sstype;  doesn't work !!
		line.resname = split_info[1];
		line.sstype = split_info[2];
		if (split_info.size() > 3){ // has design info
			std::cout << "manual design overwrite" << std::endl;
			this->design_mode = 3; //default manual mode
			if (flags.neighbor_design){
				this->design_mode = 4; // fully manual design mode automatically switched on when you assign residues by hand
			}
			if (flags.neighbor_repack){
				this->design_mode = 5; // bc repack neigbors
			}
			line.isDesignable = true;
			//std::istringstream(split_info[3]) >> line.design_type; doesn't work!!
			line.design_type = split_info[3];
			if (split_info.size() > 4 && split_info[3] == "PIKAA") { // has manual amino acid assignment
				for ( int i = 4 ; i < (int)split_info.size(); i++) {
					char one_letter_name;
					int aa;
					//std::istringstream(split_info[i]) >> one_letter_name; doesn't work
					one_letter_name = split_info[i].c_str()[0];
					num_from_res1(one_letter_name, aa);
					std::cout << "design position to " << one_letter_name << " " << aa << std::endl;
					line.aminoAcidList.push_back(aa);
				}
			}
		}
		this->blueprint.push_back(line);
	}

	//process blueprint to initialize all the needed strings/vectors
	std::vector<remodel_ns::LineObject>::iterator iter;
	for ( iter = this->blueprint.begin(); iter != this->blueprint.end(); iter++) {
		this->sequence.append(iter->resname);
		this->ss.append(iter->sstype);
	}
	std::cout<< "sequence: " << std::endl << this->sequence << std::endl;
	std::cout<< "sstype  : " << std::endl << this->ss << std::endl;
}

void
remodel_ns::WorkingRemodelSet::design_matrix_from_blueprint( std::vector<remodel_ns::LineObject> blueprint)
{
	for (int i = 0, ie=blueprint.size(); i < ie ; i++){
		if (blueprint[i].isDesignable){
			std::cout << "designable position " << blueprint[i].index << std::endl;
			if (blueprint[i].design_type == "ALLAA"){
				designResidueAsBoundary( *this, blueprint[i].index);
			}
			else if (blueprint[i].design_type == "POLAR"){
				designResidueAsSurface( *this, blueprint[i].index);
			}
			else if (blueprint[i].design_type == "APOLA"){
				designResidueAsCore( *this, blueprint[i].index);
			}
			else if (blueprint[i].design_type == "PIKAA"){
				for (std::vector<int>::iterator iter = blueprint[i].aminoAcidList.begin(), end = blueprint[i].aminoAcidList.end(); iter < end; iter++){
					this->design_matrix((*iter), blueprint[i].index) = true;
				}
			}
			else if (blueprint[i].design_type == "NATRO"){
				//this->design_matrix(*this, blueprint[i].index) = false;
				continue;
			}
		}
	}
}

void
remodel_ns::WorkingRemodelSet::workingSetGen(
	pose_ns::Pose const & input_pose,
	pose_ns::Pose & model_pose,
	remodel_ns::RemodelData const & data,
	remodel_ns::CommandLineFlags const & flags

)
{
	//find rebuilding segments
	int model_length = data.sequence.size();
	bool NtermExt = false;
	bool CtermExt = false;
	bool truncation = false;

	//find N term extension, if any
	std::string Xs = "xX";
	int first_ext;
	first_ext = this->sequence.find_first_of(Xs);
	if (first_ext == 0){
		NtermExt = true;
		std::cout << "N-terminal is extended" << std::endl;
	}
	//find C term extension, if any
	int last_ext;
	last_ext = this->sequence.find_last_of(Xs);
	if (last_ext == model_length -1) {
		std::cout << "C-terminal is extended" << std::endl;
		CtermExt = true;
	}
	//any truncation?  check the last orignal_index vs index to see if they match
	// this is wrong, but not being used anyway...
	if (data.blueprint[model_length-1].index != data.blueprint[model_length-1].original_index) {
		truncation = true;
		std::cout << "truncation found" << std::endl;
	}


// find all the indices.
	//identify truncation
	// for all the positions that are not extensions "x" or "X", put them in the
	// temp_for_truncation vector -- this corresponds to all the regions need to
	// be copied from the original pdb with deletions included.  fragment_pdb
	// requires a boolean vector that correspond to the length of the original
	// pdb, so initializes a "keep" vector of that size and set values to false.
	// As we iterate over the template_for_truncation, all the positions seen by
	// this iterative step are kept.  Because the truncated_pose is renumbered, we
	// also initializes a translate_index map to link the truncated index to the
	// original index.
	std::vector<remodel_ns::LineObject> temp_for_truncation; // collection of positions to copy from  original pdb
	//std::cout << input_pose.total_residue() << std::endl;
	utility::vector1<bool> keep(input_pose.total_residue(),false);
	for (int i = 0, ie=data.blueprint.size(); i < ie ; i++){  // loop to extract positions to keep
		if (data.blueprint[i].resname != "x" && data.blueprint[i].resname != "X"){
			temp_for_truncation.push_back(data.blueprint[i]);
	//	std::cout << data.blueprint[i].resname << data.blueprint[i].original_index << std::endl;
		}
	}
	//std::map<int,int> translate_index; // moved to object data
	for (int i = 0, ie = temp_for_truncation.size(); i < ie; i++){ // loop to update keep vector according to what's found
		keep[temp_for_truncation[i].original_index] = true;
	//	std::cout << temp_for_truncation[i].original_index << std::endl;
		if (temp_for_truncation[i].original_index != 0){ // correct for the use of "0" in marking extensions, original index should start from 1
			translate_index[temp_for_truncation[i].original_index] = i+1; // one based translation
		}
	}

	std::vector<remodel_ns::LineObject> temp_for_copy;
	std::vector<remodel_ns::LineObject> temp;
	std::vector<remodel_ns::Segment> segmentStorageVector;
	std::vector<remodel_ns::Segment> segment_to_copyVector;
	std::vector<remodel_ns::Segment> segment_to_copyNewIndex;
	for (int i = 0, ie = data.blueprint.size(); i < ie; i++){
		if (data.blueprint[i].sstype != ".") { // first find the segments to be remodeled
			temp.push_back(data.blueprint[i]);
		}
		else if (data.blueprint[i].sstype == "."){ // parts to be copied
			temp_for_copy.push_back(data.blueprint[i]);
		}
		else {
			std::cout << "assignment error" << std::endl;
		}
	}

	//break up temp into small segments
	remodel_ns::Segment segment;
	for (int i = 0, ie = temp.size()-1;  i < ie ; i++) { // compare the (i)-th and (i+1)-th element to find contiguous segments
		remodel_ns::LineObject first = temp[i];
		remodel_ns::LineObject next  = temp[i+1];
		if (next.index == (first.index+1)) {
			segment.residues.push_back(first.index);
	//		std::cout << first.index ;
			if (i+1 == (int)temp.size()-1){ // if reaching the end of the last segment
	//			std::cout << "next:" << next.index << std::endl;
				segment.residues.push_back(next.index);
				segmentStorageVector.push_back(segment);
				segment.residues.clear();
			}
		}
		else {
			segment.residues.push_back(first.index);
			if (i+1 == (int)temp.size()-1){ // if reaching the end of the last segment
				segment.residues.push_back(next.index);
				segmentStorageVector.push_back(segment);
				segment.residues.clear();
			}
	//		std::cout << first.index << std::endl;
			segmentStorageVector.push_back(segment);
			segment.residues.clear();
		}
	}
	// find the begin and end index
	for (int i = 0, ie = segmentStorageVector.size(); i < ie ; i++){
		this->begin.push_back(segmentStorageVector[i].residues.front());
		this->end.push_back(segmentStorageVector[i].residues.back());
		this->loops.add_loop(segmentStorageVector[i].residues.front(), segmentStorageVector[i].residues.back(), segmentStorageVector[i].residues.front()+1, 0, 0);
	}

	//break up temp_for_copy into small segments
	remodel_ns::Segment segment_to_copy;
	remodel_ns::Segment seg_to_copy_new_idx;
	for (int i = 0, ie = temp_for_copy.size()-1;  i < ie ; i++) { // compare the (i)-th and (i+1)-th element to find contiguous segments
		remodel_ns::LineObject first = temp_for_copy[i];
		remodel_ns::LineObject next  = temp_for_copy[i+1];
		if (next.original_index == (first.original_index+1)) {
			segment_to_copy.residues.push_back(first.original_index);
		//std::cout << first.index << " " << first.original_index << " " << translate_index[first.original_index]<< std::endl;
			seg_to_copy_new_idx.residues.push_back(first.index);
			if (i+1 == (int)temp_for_copy.size()-1){ // if reach the end of the last segment
				segment_to_copy.residues.push_back(next.original_index);
				seg_to_copy_new_idx.residues.push_back(next.index);
				segment_to_copyVector.push_back(segment_to_copy);
				segment_to_copyNewIndex.push_back(seg_to_copy_new_idx);
				segment_to_copy.residues.clear();
				seg_to_copy_new_idx.residues.clear();

			}
		}
		else {
			segment_to_copy.residues.push_back(first.original_index);
			seg_to_copy_new_idx.residues.push_back(first.index);
			if (i+1 == (int)temp_for_copy.size()-1){ // if reach the end of the last segment
				segment_to_copy.residues.push_back(next.original_index);
				seg_to_copy_new_idx.residues.push_back(next.index);
				segment_to_copyVector.push_back(segment_to_copy);
				segment_to_copyNewIndex.push_back(seg_to_copy_new_idx);
				segment_to_copy.residues.clear();
				seg_to_copy_new_idx.residues.clear();

			}
			//std::cout << first.index << " " << first.original_index << translate_index[first.original_index]<< std::endl;
			segment_to_copyVector.push_back(segment_to_copy);
			segment_to_copyNewIndex.push_back(seg_to_copy_new_idx);
			segment_to_copy.residues.clear();
			seg_to_copy_new_idx.residues.clear();
		}
	}
	// find the begin and end index
	for (int i = 0, ie = segment_to_copyVector.size(); i < ie ; i++){
	//std::cout << "segtocopy: " << segment_to_copyVector[i].residues.front() << std::endl;
	//std::cout << "segtocopynewid: " << segment_to_copyNewIndex[i].residues.front() << std::endl;
	//std::cout << "map: " << translate_index[segment_to_copyVector[i].residues.front()] << std::endl;
		this->src_begin.push_back(translate_index[segment_to_copyVector[i].residues.front()]);
		this->src_end.push_back(translate_index[segment_to_copyVector[i].residues.back()]);
		this->copy_begin.push_back(segment_to_copyNewIndex[i].residues.front());
		this->copy_end.push_back(segment_to_copyNewIndex[i].residues.back());
	}

// truncate the input pose first
	pose_ns::Pose truncated_input_pose;
	fragment_Pose(input_pose, keep, truncated_input_pose, true); // this renumbers the new pose too
	//truncated_input_pose.dump_pdb("truncated_input_pose.pdb");

// build model_pose
	int new_length = model_length;
	pose_ns::Fold_tree foldtree;
	pose_loops_build_fold_tree(new_length, this->loops, foldtree);
	model_pose.set_fold_tree(foldtree);
	std::cout<< "tree_built: " << model_pose.fold_tree() << std::endl;

	// build design_matrix for the model_pose
	//FArray2D_bool desMat(param::MAX_AA(), model_pose.total_residue(), false);
	if (flags.has_ligand){
		this->design_matrix.dimension(param::MAX_AA(), model_pose.total_residue()+1, false); // ligand exists as an extra residue
	} else {
		this->design_matrix.dimension(param::MAX_AA(), model_pose.total_residue(), false);
	}
	if (data.design_mode == 3) { // manual design overwrite
		std::cout << "assigning design_matrix from blueprint" << std::endl;
		design_matrix_from_blueprint(data.blueprint);
	}
	/*
	if (data.design_mode == 4) { // manual design overwrite
		std::cout << "assigning design_matrix from blueprint with auto neighbors" << std::endl;
		setup_auto_design_matrix(model_pose, true, true, false);
		std::cout << "assigning nataa  from blueprint" << std::endl;
		design_matrix_from_blueprint(data.blueprint);
	}
	*/


	bool update_jumps = true;
	model_pose.set_fullatom_flag(true,false); // need to set fullatom "on" otherwise full_coord is not copied
// copy segment
	for (int i = 0, ie = this->src_begin.size(); i < ie ; i++){
		int size_to_copy = (this->src_end[i] - this->src_begin[i]+1);
	//	std::cout << "size to copy " << size_to_copy << std::endl;
//		std::cout << "begin" << this->src_begin[i] << std::endl;
//		std::cout << "copybegin" << this->copy_begin[i] << std::endl;
		model_pose.copy_segment(size_to_copy, truncated_input_pose, this->copy_begin[i] , this->src_begin[i], update_jumps);
	}

// set info for remodeling range
	for (int i = 0; i < (int)this->begin.size() ; i++){  // for each of the remodeling segments
		//find out how many residues to update
		int update_residues = (this->end[i] - this->begin[i] + 1);
		for (int j = 0 ; j < update_residues ; j++){
			model_pose.set_res(this->begin[i]+j, 1); // set identity to ala
	//		std::cout << this->begin[i]+j << std::endl;
			model_pose.set_res_variant(this->begin[i]+j, 1); // set variant to 1
			if (data.design_mode == 2) {	 // if only the rebuilt region is going to be redesigned and nothing else
				for ( int aa = 1; aa <= 20 ; aa++) {	// setup the design_matrix (ALLAA) for each position
					if (aa != param_aa::aa_cys){    // exclude cys
					 this->design_matrix( aa, this->begin[i]+j) = true;
					}
				}
			}
		}
		model_pose.insert_ideal_bonds(this->begin[i], this->end[i]);
		insert_init_frag(model_pose, this->begin[i], update_residues); // fill in the gap in torsion so refold doesn't complain

		//randomize_segment(model_pose, this->begin[i], update_residues); // fill in the gap in torsion so refold doesn't complain
	}
	// take care of NATRO assignments
	for (int i = 0, ie=data.blueprint.size(); i < ie ; i++){
		if (data.blueprint[i].design_type == "NATRO"){
			std::cout << "found NATRO assignment, update sidechain" << std::endl;
			int aa;
			char  aa_name = data.blueprint[i].resname[0];
			std::cout << "position " << data.blueprint[i].index << " has " << aa_name << std::endl;
			num_from_res1(aa_name, aa);
			model_pose.copy_sidechain(data.blueprint[i].index, aa, 1 /*aav*/, input_pose.full_coord()(1,1,data.blueprint[i].original_index), true /*keep bb*/, true /*align bb*/ );
		}
	}

	if (flags.inserting_pdb){
		// process insertion Pose
		model_pose.copy_segment(data.insertionSize, data.insertPose, data.dssp_updated_ss.find_first_of("I")+1 /*convert to 1 based array*/, 1 /*copy from start*/, false /*don't update jumps as it's already setup correctly*/);
		model_pose.dump_pdb("test_insert.pdb");
		this->hasInsertion = true;
		this->insertionStartIndex =  data.dssp_updated_ss.find_first_of("I");
		this->insertionEndIndex = data.dssp_updated_ss.find_last_of("I");
		for (int i = insertionStartIndex +1 /*convert to 1 based*/; i <= insertionEndIndex +1; i++){
			model_pose.set_allow_bb_move(i, false);
			model_pose.set_allow_chi_move(i, false);
		}
	}


	//this->design_matrix = desMat;

/*
for (int i = 20 ; i<=38;i++){
std::cout << i << std::endl;
std::cout << model_pose.phi(translate_index[i]) << " " << model_pose.psi(translate_index[i])<< std::endl;
std::cout << truncated_input_pose.phi(i) << " " << truncated_input_pose.psi(i)<< std::endl;
}
*/

/*
	for (int i=1; i<= model_pose.total_residue(); i++) {
		std::cout << model_pose.phi(i) << std::endl;
		}
*/
//	model_pose.set_fullatom_flag(true,false);
//	model_pose.dump_pdb("intermediate_full.pdb");
//	model_pose.set_fullatom_flag(false,false); // switch back to centroid only
//	model_pose.set_fullatom_flag(true,false); // switch back to centroid only
//	model_pose.dump_pdb("intermediate_second_switch.pdb");
//	model_pose.set_fullatom_flag(false,false); // switch back to centroid only

	if (flags.no_frags){
		std::cout << "*** use no fragment building: clone input_pose into model_pose ***" << std::endl;
		if (model_pose.total_residue() == input_pose.total_residue()){
			pose_ns::Fold_tree foldtree;
			foldtree = model_pose.fold_tree();
			model_pose = input_pose;
			model_pose.set_fold_tree(foldtree);
		}
		else {
			std::cout << "chain length modified in blueprint: abort" << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
	}

	return;
}
void
randomize_segment(
  pose_ns::Pose & pose,
  const int begin,
  const int size
)
{
  for ( int i=begin; i<begin+size; ++i ) {
    pose.set_phi       ( i, (ran3() * 360.0) );
    pose.set_psi       ( i, (ran3() * 360.0) );
    pose.set_omega     ( i, param::init_omega );
    pose.set_secstruct ( i, 'L' );
  }
}

float
score_given_chainbreak_in_pose_quadratic( pose_ns::Pose const & pose, int const cutpoint){
	using namespace param_aa;
  float msd = 0.0;
	float chainbreak_score;
  float tmp;
	int num_fold_tree_cutpoint;
//initialize
	pose.fold_tree().get_fold_tree_cutpoint( num_fold_tree_cutpoint ) ;
	FArray1D_float cut_weight( num_fold_tree_cutpoint, 1.0);
  FArray4D_float const & jmp_overlap_Eposition
    ( pose.get_overlap_Eposition( jumping::jmp_chainbreak_overlap ));

  if ( cut_weight.size1() == scorefxns::cut_weight.size1() )
   cut_weight = scorefxns::cut_weight;

	if ( !pose.is_protein( cutpoint ) || !pose.is_protein( cutpoint+1 ) )
		return 10000;

	int istart = std::max( 1-jumping::jmp_chainbreak_overlap, 1-cutpoint );
	int istop  = std::min(   jumping::jmp_chainbreak_overlap, misc::total_residue-cutpoint );
	int ncut = 0;
//find cutpoint number in Eposition
	for (int whichCut = 1; whichCut <= num_fold_tree_cutpoint; whichCut++){
		if (cutpoint == pose.fold_tree().cutpoint_by_jump(whichCut)){
			ncut = whichCut;
		}
	}
	std::cout << "ncut" << ncut << std::endl;
// compute score
	for ( int i = istart; i <= istop; ++i ) {
		int seqpos = cutpoint + i;
		for ( int j = 1; j <= 5; ++j ) {
			if ( j != 3 || misc::res(seqpos) != aa_gly ) { // no gly c-beta
				for ( int k = 1; k <= 3; ++k ) {
					tmp = ( misc::Eposition(k,j,seqpos) - jmp_overlap_Eposition(k,j,i,ncut) );
					msd += tmp*tmp*cut_weight(ncut);
				//	std::cout << "add" << tmp*tmp*cut_weight(ncut) << std::endl;
				}         // k
			}            // no gly c-beta
		}               // j
	}                  // i
	chainbreak_score = msd; // note: not really Msd, no dividing by natoms
	std::cout << "chainbr" << chainbreak_score << std::endl;

	return chainbreak_score;
}

float
score_given_chainbreak_in_pose_linear( pose_ns::Pose const & pose, int const cutpoint){
	using namespace param_aa;
	float chainbreak_score = 0.0;
	int num_fold_tree_cutpoint;
//initialize
	pose.fold_tree().get_fold_tree_cutpoint( num_fold_tree_cutpoint ) ;
	FArray1D_float cut_weight( num_fold_tree_cutpoint, 1.0);
  FArray4D_float const & jmp_overlap_Eposition
    ( pose.get_overlap_Eposition( jumping::jmp_chainbreak_overlap ));

  if ( cut_weight.size1() == scorefxns::cut_weight.size1() )
   cut_weight = scorefxns::cut_weight;

	if ( !pose.is_protein( cutpoint ) || !pose.is_protein( cutpoint+1 ) )
		return 10000;

	int istart = std::max( 1-jumping::jmp_chainbreak_overlap, 1-cutpoint );
	int istop  = std::min(   jumping::jmp_chainbreak_overlap, misc::total_residue-cutpoint );
	int ncut = 0;
//find cutpoint number in Eposition
	for (int whichCut = 1; whichCut <= num_fold_tree_cutpoint; whichCut++){
		if (cutpoint == pose.fold_tree().cutpoint_by_jump(whichCut)){
			ncut = whichCut;
		//	chainbreak_score =0;
		}
	}
	std::cout << "ncut" << ncut << std::endl;
// compute score
	for ( int i = istart; i <= istop; ++i ) {
		int seqpos = cutpoint + i;
		for ( int j = 1; j <= 5; ++j ) {
			if ( j != 3 || misc::res(seqpos) != aa_gly ) { // no gly c-beta
				chainbreak_score += cut_weight(ncut) *
					std::sqrt( square( misc::Eposition(1,j,seqpos) - jmp_overlap_Eposition(1,j,i,ncut) ) +
										 square( misc::Eposition(2,j,seqpos) - jmp_overlap_Eposition(2,j,i,ncut) ) +
										 square( misc::Eposition(3,j,seqpos) - jmp_overlap_Eposition(3,j,i,ncut) ) );
			}            // no gly c-beta
		}               // j
	}                  // i
	chainbreak_score /= 20.0; // some magical number.... no idea why
	std::cout << "chainbr" << chainbreak_score << std::endl;
//} // debug
	//std::cout << "chainbr" << chainbreak_score << std::endl;
	return chainbreak_score;
}



////////////////////////////////////////////////////////////////////////////////
/// @begin remodel_build_random_loops
///
/// @brief randomly choosing loop stems based on loop_file, then build loops
///  from the chosen stems using make_one_loop -- modified from bin's
//loop_relax version
///
/// @detailed
///
/// @param
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
bool
remodel_build_random_loops (
	pose_ns::Pose & pose,
	std::vector<int> const & loops_begin,
	std::vector<int> const & loops_end,
	pose_ns::Loops & output_loops,
	int const & num_frag_moves,
	remodel_ns::ScoreWeight weights,
	remodel_ns::WorkingRemodelSet working_model,
	remodel_ns::CommandLineFlags const & flags
)
{

	using namespace pose_ns;

	remodel_ns::RemodelData rdata; // need the chain_break_score

	// link to native pose if exists
	if ( get_native_exists() )
		pose.set_native_pose();

	int const nres( pose.total_residue() );

	// save the input pose for rmsd calculations
	Pose init_pose;
	init_pose = pose;

	classical_constraints::BOUNDARY::set_max_seqSep(nres);
	set_use_nblist( false );
	// minimizer params:
	minimize_exclude_sstype( false, false );
	if( get_ccd_closure_exist() )
		monte_carlo_set_simannealing(true);
	else monte_carlo_set_simannealing(false);

//fragment picking parameters
	if ( get_random_frag_state() ){
		pick_random_frags( 200, 100, 75, 25 );
		// randomly pick 100 of the top 200 3mers and 25 of the top 75 9mers.
		// different choice for each trajectory to spread out sampling
	}
	if ( get_ssblock_state() ) {
		decide_block_state();
		choose_frag_set_top_N_frags( 200 );
	} else {
		choose_frag_set_top_N_frags( 200 );
	}
	//pose.clear_atom_tree();
	pose.set_fullatom_flag( false, false );

	int const num_loop = static_cast <int>( loops_begin.size() );
	std::vector< int > free_res; // stores residue numbers in real loops
	for ( int ll = 0; ll < num_loop; ++ll ){
		for ( int k = loops_begin.at( ll );	k <= loops_end.at( ll ); ++k )
				free_res.push_back(k);
	}

	std::vector<int> inter_res; // residues in-between loop_file defined loops

	// now go through all the loop regions
	Pose stage_pose; // stores a pose at certain stage
	std::vector< int > folded_loops; // loops folded
	int num_desired_loops ( get_desired_loops_exist()? std::min( desired_loops(), num_loop) :num_loop );
	bool  is_chain_break( true ); // take this out as the final test for function returns

	for ( int loop_counter = 0; loop_counter < num_desired_loops; ++loop_counter ){

		// save the original pose at this stage
		stage_pose = pose;

		// randomly select one loop from the loop regions
		inter_res.clear();
		int selected_loop, def_loop_begin, def_loop_end, combine_number;
		bool loops_combined( false );
		bool use_selected_loop =
				select_one_loop( nres, selected_loop, loops_begin, loops_end, folded_loops,
												 inter_res, def_loop_begin, def_loop_end, loops_combined,
												 combine_number, loop_counter );

		if ( ! use_selected_loop ) continue; // skip this loop

		// params record the behaviors of individual loop modeling process
		int   nfail( 0 );
	//	int   n_chain_break_fail( 1 );
	  is_chain_break = true ;
		bool  rmsd_acceptable( false );
		int   barcst_extend_begin( 0 );
		int   barcst_extend_end( 0 );
		int total_combine( 0 );
		if ( loops_combined ) total_combine = combine_number;
	//	int backward_combine( 0 );
		//int const allowed_failure_before_extend(15);
	//	int const allowed_failure_before_stop( get_random_loop_exist()? 20:5);
		int const allowed_failure_before_stop = 100;

		// select further random stems which will be constrainted by barcode cst
		if ( get_random_loop_exist() ){
			barcst_extend_begin = static_cast <int> ( ran3() * 2 );
			barcst_extend_end = static_cast <int> ( ran3() * 2 );
		}

		Loop loop_built;
		float loop_chain_break(0);
		// start the loop building cycle
		while ( is_chain_break || !rmsd_acceptable )
		{

			if( nfail > allowed_failure_before_stop ) {
			// die right here since one of the loop can't seem to be closed
				std::cout << "failed to close a loop: DIE FOR SAFETY REASONS: TRY CHANGING RESIDUE NUMBER OR LOOP RANGE!!" << std::endl;
				utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
			}

			nfail++;
			// refresh pose
			pose = stage_pose;
/*
			// combine next loop if this loop can't be closed after 20 iterations
			if ( get_random_loop_exist() && get_combine_if_fail_exist() ){
				if ( n_chain_break_fail % allowed_failure_before_extend == 0 ){
					if ( selected_loop + total_combine + 1 < num_loop ){
						def_loop_end = loops_end.at( selected_loop + total_combine + 1 );
						if( !get_loop_modeling_exist() ) folded_loops.push_back( selected_loop + total_combine + 1);
						total_combine++; // one more combined loop
					} else if ( selected_loop - backward_combine > 0 ){
						def_loop_begin   = loops_begin.at( selected_loop - backward_combine - 1 );
						if( !get_loop_modeling_exist() ) folded_loops.push_back( selected_loop - backward_combine - 1 );
						backward_combine++;
					}
					else break;// return false; // give up if no loop to combine
					if( !get_loop_modeling_exist() ) loop_counter++;
					barcst_extend_begin = static_cast <int> ( ran3() * 2 );
					barcst_extend_end = static_cast <int> ( ran3() * 2 );
				}
			}
*/
			// further extend loop regions, and add barcode constraints on these
			// extended regions
			int loop_begin = def_loop_begin, loop_end=def_loop_end;
			/*barcode_extend_stems( barcst_extend_begin, barcst_extend_end, loop_begin, loop_end,
														def_loop_begin, def_loop_end, free_res,
														nres, selected_loop, total_combine,
														backward_combine, loops_begin, loops_end );
*/
			// Now really make a loop
			int cutpoint(0);

			//update occ info
			for (int jj = loop_begin; jj <= loop_end; ++jj ){
				pose.pdb_info().set_pdb_occ( jj, 1.0 );
			}

			remodel_build_loop_with_ccd_move( pose, loop_begin, loop_end, cutpoint, num_frag_moves, weights, working_model, flags);
			loop_built.set_start( loop_begin );
			loop_built.set_stop ( loop_end );
			loop_built.set_cut( cutpoint );
			//pose.dump_pdb("step.pdb");
			rmsd_acceptable = true; // don't care about RMSD to starting pose

//			rmsd_acceptable = acceptable_rmsd_change( stage_pose, pose );
/*
			// extend more barcode regions
			extend_barcode_regions_if_chain_break( pose, loop_begin, loop_end,
						n_chain_break_fail, is_chain_break, barcst_extend_begin, barcst_extend_end );
*/
			restore_seq( pose, stage_pose, loop_begin, loop_end );

			if ( (loop_begin != 1 && loop_end != nres) && !flags.nojumps  ){
			//std::cout << "update chain break" << std::endl;
			//	loop_chain_break = pose.get_0D_score( pose_ns::CHAINBREAK );
				loop_chain_break = score_given_chainbreak_in_pose_linear(pose, cutpoint);
			}
			std::cout << "loop_chain_break " <<  loop_chain_break << "is_chain_break " << is_chain_break << std::endl;
		//	std::cout << "loop_chain_break2 " <<  score_given_chainbreak_in_pose_linear(pose, cutpoint) << std::endl;
			//if (loop_chain_break <  get_chain_break_tolerance() ){ // tolerance is 0.2
			if (loop_chain_break <  0.05 ){ // really try hard to close the loop
				is_chain_break = false; // this exits the building loop. no more chain break is GOOD
			}

		//	show_decoy_status(pose);

		} // accepted this loop

		rdata.total_chain_break_score += loop_chain_break;

		//remodel_ns::total_chain_break_score += loop_chain_break;

		pose.update_backbone_bonds_and_torsions();
		//pose.simple_fold_tree( nres );
		output_loops.add_overlap_loop( loop_built );

	//	show_decoy_status(pose);

	}// all loops folded

	for ( int i = 0 ; i < static_cast<int>(folded_loops.size()); ++i ) {
		std::cout << "folded loops at vector position: " << folded_loops.at(i) << std::endl;
	}
	if ( is_chain_break ){
		pose= init_pose;
		return false;
	}
	return true;
}



////////////////////////////////////////////////////////////////////////////////
/// @begin remodel_build_loop_with_ccd_move
///
/// @brief ab-initio model of a loop using the pose mode, where we can grow
///  from both end of the loops and try to close at the cutpoint.  This is
//modified from bin's loop_relax version
///
/// @detailed
///
/// @param  tolerance - [in/out]? -
/// @param  size - [in/out]? -
/// @param  frag_begin - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors bqian
///
/// @last_modified 10/20/2005
/////////////////////////////////////////////////////////////////////////////////
void remodel_build_loop_with_ccd_move
(
	pose_ns::Pose & pose,
	int const & loop_begin,
	int const & loop_end,
	int & cutpoint,
	int const & num_frag_moves,
	remodel_ns::ScoreWeight weights,
	remodel_ns::WorkingRemodelSet working_model,
	remodel_ns::CommandLineFlags const & flags
)
{

	using namespace pose_ns;

	int const nres( pose.total_residue() );

	set_looprlx_allow_move_map( pose, loop_begin, loop_end );
	if (flags.inserting_pdb){
		for (int i = working_model.insertionStartIndex+2  /*convert to 1 based and off set 1*/; i <= working_model.insertionEndIndex /* off set 1 to include the last position*/; i++){
	//		std::cout << "not_allow move " << i << std::endl;
			pose.set_allow_bb_move(i, false);
			pose.set_allow_chi_move(i, false);
		}
	}
	cutpoint = choose_cutpoint( pose, loop_begin, loop_end );
	if (flags.inserting_pdb){
		int cut1 = choose_cutpoint(pose, loop_begin, working_model.insertionStartIndex +1	/*convert to 1 base*/);
		int cut2 = choose_cutpoint(pose, working_model.insertionEndIndex +1, loop_end);
		int pick = static_cast<int>(ran3() * 2);
		std::cout << "pick " << pick << std::endl;
		if (pick == 1) {
			cutpoint = cut1;
		} else {
			cutpoint = cut2;
		}
	}
	std::cout << "cutpoint: " << cutpoint << std::endl;

	int const loop_size( loop_end - loop_begin + 1 );
	int cycles2( num_frag_moves );
	//int const cycles2( 3 );
//	int const cycles3( 10* loop_size );
	float const cycle_ratio( std::max( 0.5f, get_looprlx_cycle_ratio() ) );
	int cycles3( std::max( 50, static_cast<int>( 10*loop_size*cycle_ratio)));
	if (flags.inserting_pdb){
		int insertSize = working_model.insertionEndIndex - working_model.insertionStartIndex + 1;
		cycles3  = std::max( 50, static_cast<int>( 10*(loop_size - insertSize)*cycle_ratio));
	}
	FArray1D_bool allow_repack( nres, false );
	for ( int i = loop_begin; i <= loop_end; ++i )
		allow_repack( i ) = true;
	// repack loop residues

	// make fold trees for loops
	if ( loop_begin == 1 || loop_end == nres || flags.nojumps)
		pose.simple_fold_tree( nres );
	else{
		pose_ns::Loops current_loops;
		pose_ns::Loops::const_iterator it;
		for (it = working_model.loops.begin(); it != working_model.loops.end(); it++){
			if ( it->start() == loop_begin && it->stop() == loop_end){
				current_loops.add_loop(it->start(), it->stop(), cutpoint, 0,0);
			}
			else {
				current_loops.add_loop(it->start(), it->stop(), it->start()+1, 0, 0);
			}
		}
		pose_ns::Fold_tree foldtree;
		pose_loops_build_fold_tree(pose.total_residue(), current_loops, foldtree);
		pose.set_fold_tree(foldtree);
	//	pose.one_jump_tree( nres, loop_begin-1, loop_end+1, cutpoint );
		pose.set_allow_jump_move( false );
	}
	if (flags.inserting_pdb){
		std::cout << "process insertion: inserting ideal bonds between "<< loop_begin << " " << working_model.insertionStartIndex+1;
		std::cout << " and " << working_model.insertionEndIndex+1 << " " << loop_end << std::endl;
		pose.insert_ideal_bonds(loop_begin, working_model.insertionStartIndex+1); //first half before insertion
		pose.insert_ideal_bonds(working_model.insertionEndIndex+1, loop_end);
	}
	else{
		pose.insert_ideal_bonds( loop_begin, loop_end );  // this is TOTALLY ESSENTIAL!!!
	}
	Score_weight_map weight_map;
	apply_score_function_to_weight_map(weights, weight_map);

	score_set_cst_mode(3);

	// perturb the initial loop conformation
	int begin;
	if ( get_loop_modeling_exist() ){
		insert_random_frags( 3, pose, loop_begin, loop_end, 0 );
		// size=3, frag_offset=0
	}else{
		for ( int i = 0; i < loop_size; ++i ){
			if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
				one_loop_choose_fragment_cst_pose( pose, 1.5, 1, begin, cutpoint );
			else
				one_loop_choose_fragment_coord_pose( pose, 1.2, 1, begin, cutpoint );
		}
	}

	//pose.dump_pdb("perturbed_init.pdb");
	// setup monte_carlo object
	pose.score( weight_map );
	Monte_carlo mc( pose, weight_map, 2 );
	std::cout << "starting loop pose" << std::endl;
	show_decoy_status( pose );

	// std::cout << "OK" << std::endl;
	float final_weight = 5.0;
	float const delta_weight ( final_weight / cycles2 );
	bool do_ccd_moves( false );
	if ( (loop_begin != 1 && loop_end != nres) && !flags.nojumps )
		do_ccd_moves = true;

	for ( int c2 = 1, overlap; c2 <= cycles2; ++c2 ) { // 10 cycles of chainbreak ramping
		// statistics
		int frag_accepts( 0 ),
				frag_trials ( 0 ),
				ccd_accepts ( 0 ),
				ccd_trials  ( 0 );
/*
		int const cutoff9 = get_use_9mer_frag_cutoff();
		int const cutoff3 = { 6 };
		int const cutoff1 = { 3 };
*/
//		int const cutoff9 = { 8 };
//		int const cutoff3 = { 2 };
//		int const cutoff1 = { 0 };


		pose = mc.low_pose();
		overlap = 0;

		if ( (loop_begin != 1 && loop_end != nres ) && !flags.nojumps){
			weight_map.set_weight( CHAINBREAK, c2 * delta_weight );
			//std::cout << "cbreak weight: " << c2*delta_weight << std::endl;
			if ( c2 > cycles2/2 ) overlap = 1; // total conjecture
			weight_map.set_weight( CHAINBREAK_OVERLAP, overlap );
		}

		pose.score( weight_map );
		mc.set_weight_map( weight_map );
		mc.reset( pose );
//		show_decoy_status( pose );
	//	append_trajectory( pose.get_0D_score(SCORE), pose.get_0D_score(RMSD) );

		for ( int c3 = 1, size, begin; c3 <= cycles3; ++c3 ) { // 30 cycles of fragment insertion
			if ( !do_ccd_moves ||
						overlap == 0 ||
						ran3() * cycles2 > c2 )
			{
			/*
				if( flags.matchingFrags ){
					size = loop_size;
					//std::cout << "insert 9 mer" << std::endl;
					if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
						one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
					else
						one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
					mc.set_weight_map( weight_map );
				//	pose.score(weight_map);
				//	if (pose.get_0D_score(CHAINBREAK) < 0.2) { // only consider mc if chainbreak is low enough -- first layer of filter
						bool const accepted ( mc.boltzmann( pose ) );
						if ( accepted )	++frag_accepts;
						++frag_trials;
				//	}
				}
*/
		//		if( loop_size > cutoff9 ){
					size = 9;
					//std::cout << "insert 9 mer" << std::endl;
					if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
						one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
					else
						one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
					mc.set_weight_map( weight_map );
				//	pose.score(weight_map);
				//	if (pose.get_0D_score(CHAINBREAK) < 0.2) { // only consider mc if chainbreak is low enough -- first layer of filter
						bool accepted ( mc.boltzmann( pose ) );
						if ( accepted )	++frag_accepts;
						++frag_trials;
				//	}
		//		} //if loop_size 9
		//		if( loop_size > cutoff3 ){
					size = 3;
					//std::cout << "insert 3 mer" << std::endl;
					if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
						one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
					else
						one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
					mc.set_weight_map( weight_map );
				//	pose.score(weight_map);
				//	if (pose.get_0D_score(CHAINBREAK) < 0.2) {
						accepted =  mc.boltzmann( pose );
						if ( accepted )	++frag_accepts;
						++frag_trials;
				//	}
		//		} //if loop_size 3
		//		if( loop_size > cutoff1 ){
					size = 1;
					//std::cout << "insert 1 mer" << std::endl;
					if ( classical_constraints::BOUNDARY::get_constraints_exist() || !get_coord_cst_exist() )
						one_loop_choose_fragment_cst_pose( pose, 2.0, size, begin, cutpoint );
					else
						one_loop_choose_fragment_coord_pose( pose, 1.2, size, begin, cutpoint );
					mc.set_weight_map( weight_map );
				//	pose.score(weight_map);
				//	if (pose.get_0D_score(CHAINBREAK) < 0.2) {
						accepted  =  mc.boltzmann( pose ) ;
						if ( accepted )	++frag_accepts;
						++frag_trials;
				//	}
				//} //if loop_size 1
			} else {
				pose_to_misc( pose );
				//std::cout << "ccdmove" << std::endl;
				epigraft::design::ccd_moves_obeying_nonideality( 10, pose, loop_begin, loop_end, cutpoint );
				mc.set_weight_map( weight_map );
			//	pose.score(weight_map);
			//	if (pose.get_0D_score(CHAINBREAK) < 0.2) {
					bool const accepted ( mc.boltzmann( pose ) );
					if ( accepted )	++ccd_accepts;
					++ccd_trials;
			//	}
			}
		}

		if ( ccd_trials == 0 ) ++ccd_trials;
		if ( frag_trials == 0 ) ++frag_trials;
		std::cout     << "accepts: frag,ccd " << c2  << ' ' <<
			frag_trials << ' ' << ccd_trials    << ' ' <<
			float( 100.0*frag_accepts ) /frag_trials   << ' ' <<
			float( 100.0*ccd_accepts  ) /ccd_trials    << std::endl;

		//show_decoy_status( pose );
		if ( (loop_begin != 1 && loop_end != nres) && !flags.nojumps ){
			if (c2 == cycles2){
				pose_to_misc( pose ); // make sure things are in sync because score_given_chainbreak function needs misc Eposition array
				//float cbreak = pose.get_0D_score(CHAINBREAK);
				float cbreak =  score_given_chainbreak_in_pose_linear(pose, cutpoint);
				//pose.dump_pdb("afterCBreakScore.pdb");
			//	std::cout << "cbreak: " << cbreak << std::endl;
			//	std::cout << "cbreak2: " << score_given_chainbreak_in_pose_linear(pose, cutpoint) << std::endl;
				if (cbreak < 0.5 && cbreak > 0.01) {
					std::cout << "boost closure cycle" << std::endl;
					if (cycles2 <= 100){
						cycles2 += 5;
					}
					else {
						std::cout << "boost cycle exceed 100, end now"<< std::endl;
						break;
					}
				}
			}
		}
	}

	// recover low, rescore with overlap = 1 for compatibility with ccd closure
	if ( (loop_begin != 1 && loop_end != nres) && !flags.nojumps )
	weight_map.set_weight(CHAINBREAK_OVERLAP, 1.0 );
pose.score(weight_map);
	//pose.dump_scored_pdb("testDumpScore.pdb", weight_map);
	//		float cbreak = pose.get_0D_score(CHAINBREAK);
	//		std::cout << "cbreak: " << cbreak << std::endl;
	pose = mc.low_pose();
	//		cbreak = pose.get_0D_score(CHAINBREAK);
	//		std::cout << "cbreak: " << cbreak << std::endl;
}

void
remodel_ns::ScoreWeight::get_score_function_weights(){
	static bool init = false;
	if (!init){
		realafteroption("vdw", 1.0, vdw);
		realafteroption("env", 0.0, env);
		realafteroption("pair", 0.0, pair);
		realafteroption("rama", 0.01, rama);
		realafteroption("cb", 0.0, cb);
		realafteroption("rg", 1.0, rg);
		realafteroption("co", 0.0, co);
		realafteroption("sheet", 0.0, sheet);
		realafteroption("sspair", 0.0, sspair);
		realafteroption("rsigma", 0.0, rsigma);
		realafteroption("hb_lrbb", 0.0, hb_lrbb);
		realafteroption("hb_srbb", 0.0, hb_srbb);
		realafteroption("barcode", 0.0, barcode);
		realafteroption("barcode_energy", 0.0, barcode_energy);
		realafteroption("chainbreak", 0.0, chainbreak);
		realafteroption("chainbreak_overlap", 0.0, chainbreak_overlap);
		realafteroption("cst_score", 0.0, cst_score);
		init = true;
	}
}

void
apply_score_function_to_weight_map(
	remodel_ns::ScoreWeight weights,
	pose_ns::Score_weight_map & weight_map
)
{   // explicitly turning on/off some terms
	using namespace pose_ns;

	//remodel_ns::ScoreWeight weights;
	//weights.get_score_function_weights();

	// centroid level only
	if (weights.vdw  > 1e-8) weight_map.set_weight(VDW, weights.vdw);
	// turn off seq specific weights
	if (weights.env > 1e-8) weight_map.set_weight(ENV, weights.env);
	if (weights.pair > 1e-8) weight_map.set_weight(PAIR, weights.pair);
	if (weights.rama > 1e-8) weight_map.set_weight(RAMACHANDRAN, weights.rama);
	// other features
	if (weights.cb > 1e-8) weight_map.set_weight( CB , weights.cb); // cb density
	if (weights.rg > 1e-8) weight_map.set_weight( RG , weights.rg); // radius of gyration
	if (weights.co > 1e-8) weight_map.set_weight( CO , weights.co); // contact order
	if (weights.sheet > 1e-8) weight_map.set_weight( SHEET , weights.sheet); //sheet organization
	if (weights.sspair > 1e-8) weight_map.set_weight( SSPAIR, weights.sspair);
	if (weights.rsigma > 1e-8) weight_map.set_weight( RSIGMA, weights.rsigma);
	if (weights.hb_lrbb > 1e-8) weight_map.set_weight( HB_LRBB, weights.hb_lrbb);
	if (weights.hb_srbb > 1e-8) weight_map.set_weight( HB_SRBB, weights.hb_srbb);
	// loopmode specific weights
	if (weights.barcode > 1e-8) weight_map.set_weight( BARCODE, weights.barcode);
	if (weights.barcode_energy > 1e-8) weight_map.set_weight( BARCODE_ENERGY, weights.barcode_energy);
	if (weights.chainbreak > 1e-8) weight_map.set_weight( CHAINBREAK, weights.chainbreak);
	if (weights.chainbreak_overlap > 1e-8) weight_map.set_weight( CHAINBREAK_OVERLAP, weights.chainbreak_overlap);
	if (weights.cst_score > 1e-8) weight_map.set_weight( CST_SCORE, weights.cst_score);
}

void
build_1mer_from_3mer(pose_ns::Pose const & pose){
	using namespace fragments;
	using namespace param;
	using namespace files_paths;
// check to see if the globals are set already
/*
  if ( !param::MAX_LEN().initialized() ) {
    param::MAX_LEN() = frag_size;
  }

  if ( !param::n_frag_sizes().initialized() ) {
    param::n_frag_sizes() = size_bin;
  }
*/
  // See if 3mer library present
  int bin3 = 0;
  for ( int i = 1, ie = n_frag_files(); i <= ie; ++i ) {
    if ( frag_sizes(i) == 3 ) bin3 = i;
  }

// Generate 1mer library from 3mer library if present
  if ( bin3 > 0 ) { // 3mer library present
    std::cout << "generating 1mer library from 3mer library" << std::endl;
   // int const bin1 = n_frag_sizes();
	  int const bin1 = 1;
    frag_sizes( bin1 ) = 1;
    for ( int i = 1; i <= pose.total_residue(); ++i ) {

      int pos3 = 1; // keep central res of 3mer
      int begin3 = i - 1;
      if ( i == 1 ) {
        begin3 = i; // first res of first frag
        pos3 = 0;
      } else if ( i == pose.total_residue() ) {
        begin3 = i - 2; // last res of last frag
        pos3 = 2;
      }
      align_depth( i, bin1 ) = align_depth( begin3, bin3 );
      for ( int j = 1, je = align_depth( i, bin1 ); j <= je; ++j ) {
        align_phi(i,j,0,bin1) = align_phi( begin3, j, pos3, bin3 );
        align_psi(i,j,0,bin1) = align_psi( begin3, j, pos3, bin3 );
        align_omega(i,j,0,bin1) = align_omega( begin3, j, pos3, bin3 );
        ss_type(i,j,0,bin1) = ss_type( begin3, j, pos3, bin3 );
        align_name(i,j,bin1) = align_name( begin3, j, bin3 );
      }
    }
  }
}

void
remodel_ns::RemodelData::updateWithDsspAssigment(FArray1Da_char dsspSS){
	for (int i = 0; i < (int)ss.size(); i++){
		int idx = this->blueprint[i].original_index;
		char const * ss_chars = ss.c_str();
		if (ss_chars[i] != '.'){
			dssp_updated_ss.append(1, ss_chars[i]);
		}
		else {
			dssp_updated_ss.append(1, dsspSS(idx));
		}
	}
	std::cout << "dssp_updated_ss" << std::endl << dssp_updated_ss << std::endl;
}

void
remodel_ns::RemodelData::collectInsertionPose(){
	pose_from_pdb( insertPose, stringafteroption("insert_segment_from_pdb"), true /*fullatom*/, false /*ideal*/, true /*read_all_chains*/);
	insertionSize = insertPose.total_residue();
	pose_to_misc(insertPose);
	dssp_ns::DSSP dssp;
	dssp.compute();
	FArray1D_char dsspSS(insertPose.total_residue());
	dssp.dssp_reduced(dsspSS);
	for (int i = 1; i <= (int)dsspSS.size(); i++){
		insertionSS.push_back(dsspSS(i));
	}
	std::cout << "insertion SS: " << insertionSS << std::endl;
}

void
remodel_help(){
//format: one tab for if line, two tabs for flag line
	std::cout << std::endl << std::endl << "REMODEL MODE HELP" << std::endl;
	std::cout << "	require these flags:" << std::endl;
	std::cout << "		-s <input pdb>" << std::endl;
	std::cout << "		-blueprint <blueprint file>" << std::endl << std::endl;
	std::cout << "LOOP BUILDING FLAGS" << std::endl;
	std::cout << "	if simply wants to run multiple trajectories use:" << std::endl;
	std::cout << "		-auto <= equivalent to \"-try 100 -save_top 5 -num_frag_moves 10\"" << std::endl<< std::endl;
	std::cout << "	if setting trajectories by hand:" << std::endl;
	std::cout << "		-try [number] <= sets up the number of monte carlo objects used in centroid building stage" << std::endl;
	std::cout << "		-save_top [number] <= the number of final low scoring pdbs to keep" << std::endl;
	std::cout << "		-num_frag_moves [number] <= number of fragment moves to try in the centroid stage" << std::endl << std::endl;
	std::cout << "	if only want minimization and design cycles:" << std::endl;
	std::cout << "		-bypass_fragments <= only works on input PDB, so no extensions or deletions are honored in the blueprint.  Blueprint (H,L,E,D) becomes allow_move definitions"<< std::endl<<std::endl;
	std::cout << "	if running with ligand:" << std::endl;
	std::cout << "		-enable_ligand_aa <= handles ligand attachment and clash check after centroid build" << std::endl<< std::endl;
	std::cout << "	if running domain assembly type runs:" << std::endl;
	std::cout << "		-no_jumps <= will setup simple foldtree and fold through it during centroid build" << std::endl<< std::endl;
	std::cout << "	if using backrub moves:" << std::endl;
	std::cout << "		-backrub <= run backrub MC trajectory after every completed loop building attempt" << std::endl<< std::endl;
	std::cout << "	if wants to use native sequence in picking fragments:" << std::endl;
	std::cout << "		-use_blueprint_sequence <= picks fragments based on both secondary structure and the second column (sequence) in blueprint file" << std::endl << std::endl;
	std::cout << "	if don't want to run minimize routine: (default is on -- 5 cycles of minimization with design)" << std::endl;
	std::cout << "		-quick_and_dirty <= only do fragment insertion" << std::endl << std::endl;
	std::cout << "	if checkpointing is desired: (turns on automatially if not using -quick_and_dirty)" << std::endl;
	std::cout << "		-checkpoint <= this writes out the best pdbs collected so far after each design step." << std::endl << std::endl;
	std::cout << "	if trying pose_refine_loop_with_ccd() instead of just design-minimize: "<< std::endl;
	std::cout << "		-use_ccd_refine <= maintain a default chainbreak position (loop start+1) and try using CCD for refinement.  try 20 times for 5 closed loops." << std::endl << std::endl;
	std::cout << "	if refining the entire structure with pose_relax. One may define regions in blueprint file for constraint setup."<< std::endl;
	std::cout << "	This flag is incompatible with -use_ccd_refine (bypassed by -use_ccd_refine). Most likely used with -bypass_fragments for final refine-design step." << std::endl;
	std::cout << "		-use_pose_relax <= an alternative to the default minimization step, but use constraints in a similar way." << std::endl<<std::endl;
	std::cout << "	if forceing fragments to use DSSP assignments (most likely used with -use_pose_relax, since no user defined sec struct is assigned:" << std::endl;
	std::cout << "		-use_dssp_assignment"<< std::endl << std::endl;
	std::cout << "	if trying an alternative minimization setup were jumps are set instead of constraints to ensure no movement in certain regions:" << std::endl;
	std::cout << "		-keep_jumps_in_minimizer <= no constraint is setup for minimization, only rebuilt regions allow bbmove." << std::endl << std::endl << "==================" << std::endl;
	std::cout << "	if trying to dump fragment files of 3mer and 9mer, which prepared by reading vall " << std::endl;
	std::cout << "		-output_fragfiles [filename ,e.g. aafr01] " << std::endl;
	std::cout << "	if trying to get fragment information from fragment files not from vall" << std::endl;
	std::cout << "		-read_fragfile  " << std::endl;
	std::cout << "DOMAIN/EPITOPE FUSION FLAGS" << std::endl;
	std::cout << "	if inserting a pdb carrying an epitope or domain (called insert) into a structure to be changed (called host):" << std::endl;
	std::cout << "		-insert_segment_from_pdb [insert pdb file name]" << std::endl;
	std::cout << "		This mode enables a blueprint file designation of \"I\", for insertion. The host PDB still has to be processed normally (single chain, renumbered), but the insert"<< std::endl;
	std::cout << "		can be of any PDB truncated to only the region of interest. Number of \"I\" entries in blueprint file has to agree with the chain lengh of the insert PDB." << std::endl;
	std::cout << "		Inserted region will not be touched. allow_bb_move is false, and allow_chi_move is also false." << std::endl << std::endl <<"==================" << std::endl;
	std::cout << "DESIGN RELATED FLAGS" << std::endl;
	std::cout << "  Design modes are switched on and off implictly according to information provided by the following flags and blueprint file." << std::endl;
	std::cout << "	if trying to do very fast backbone only build:" << std::endl;
	std::cout << "		-no_design <= skips all design steps. WARNING: will only output centroid level structures and dump all fragment tries." << std::endl << std::endl;
	std::cout << "	if trying to dump structures by silent-mode during no_design protocol:" << std::endl;
	std::cout << "		-silent [filename] <= dumps all structures by silent-mode WARNING: will work only during no_design protocol (see -no_design)." << std::endl << std::endl;
	std::cout << "	if only wants to design the remodeled region: (activate design_mode 2, see info on the design mode)" << std::endl;
	std::cout << "		-no_repack" << std::endl<< std::endl;
	std::cout << "	if manual design and want rosetta to get neighbors for you: (activate design_mode 4, see info on the design mode)" << std::endl;
	std::cout << "		-design_neighbors" << std::endl << std::endl;
	std::cout << "    -neighbor_repack " << std::endl;
	std::cout << "	if accumulating structures according to bsasaWLN instead of SCORE" << std::endl;
	std::cout << "		-rank_by_bsasa" << std::endl<< std::endl << "=================="<< std::endl;
	std::cout << "	There are 4 different conceptual design modes:" << std::endl;
	std::cout << "	mode 1: fully automated, designs remodel region and all of its neighbors (6 angstrom)" << std::endl;
	std::cout << "	mode 2: no repack mode only designs remodel region" << std::endl;
	std::cout << "	mode 3: manual overwrite. by specifying PIKAA,ALLAA,APOLA,POLAR as the forth column in the blueprint file turns on manual overwrite" << std::endl;
	std::cout << "	        regions not defined are assigned as ALAs. NOTE: PIKAA selections has to have space in between the single letter codes" << std::endl;
	std::cout << "	mode 4: manual overwrite, similar to mode 3 but auto pick neighbors as in mode 1" << std::endl;
	std::cout << "  mode 5: manual overwrite, similar to mode 3 and 4 but auto pick neighbors as in mode 1 and repacks those neighbors"<< std::endl;
	std::cout << "REMODEL HELP END" << std::endl;
}


