// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 8949 $
//  $Date: 2006-06-27 21:05:26 -0400 (Tue, 27 Jun 2006) $
//  $Author: mtyka $

#ifndef INCLUDED_rms
#define INCLUDED_rms


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>


// rms Function Declarations


void
rms_setup(
	int & n,
	FArray2Da_double xe,
	FArray2Da_double xp,
	FArray3Da_double xm,
	FArray1Da_double xre,
	FArray1Da_double xrp,
	FArray2Da_double xse,
	FArray2Da_double xsp
);

float
rms_FArray(
	FArray2D_float &vector_list_1,
  FArray2D_float &vector_list_2
);


float
rms_FArray(
	FArray2D_double &vector_list_1,
  FArray2D_double &vector_list_2
);


double
rms2_fast2(
	int & ii,
	int & jj,
	FArray3Da_double xm, // note zero origin
	FArray1Da_double xre,
	FArray1Da_double xrp,
	FArray2Da_double xse,
	FArray2Da_double xsp,
	FArray1Da_double ev
);


double
rms2_fast3(
	int & n,
	FArray2Da_double xmi, // note zero origin
	double & xrei,
	double & xrpi,
	FArray1Da_double xsei,
	FArray1Da_double xspi,
	FArray2Da_double xmj, // note zero origin
	double & xrej,
	double & xrpj,
	FArray1Da_double xsej,
	FArray1Da_double xspj
);


double
rms2_fast(
	int & ii,
	int & jj,
	FArray3Da_double xm, // note zero origin
	FArray1Da_double xre,
	FArray1Da_double xrp,
	FArray2Da_double xse,
	FArray2Da_double xsp,
	double & det,
	FArray1Da_double ev
);


void
prepare_cross_moments(
	int & nover,
	FArray2Da_double xe,
	FArray2Da_double xp,
	FArray3Da_double xm // note zero origin
);


void
prepare_radii(
	int & n,
	FArray2Da_double xu,
	FArray1Da_double xr
);


void
prepare_rsums(
	int & n,
	FArray2Da_double xu,
	FArray2Da_double xs
);


void
clear_rms();


void
add_rms(
	int i,
	FArray2Da_double xp,
	FArray2Da_double xe
);


void
rmsfitca3(
	int npoints,
	FArray2Da_double xx0,
	FArray2Da_double xx,
	FArray2Da_double yy0,
	FArray2Da_double yy,
	double & esq
);


void
rmsfitca2(
	int npoints,
	FArray2Da_double xx,
	FArray2Da_double yy,
	FArray1Da_double ww,
	int & natsel,
	double & esq
);


void
rsym_rotation(
	FArray2Da_double mm,
	FArray2Da_double m,
	FArray1Da_double ev,
	FArray2Da_double rot
);


double
det3( FArray2Da_double m );


void
rsym_eigenval(
	FArray2Da_double m,
	FArray1Da_double ev
);


void
rsym_evector(
	FArray2Da_double m,
	FArray1Da_double ev,
	FArray2Da_double mvec
);


#endif
