// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   rootstock_types.hh
/// @brief  Type definitions for rootstock package.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef FAUX_TYPES_HH_
#define FAUX_TYPES_HH_

// Numeric headers
#include <numeric/xyzTriple.hh>

// C++ headers
#include <sys/types.h> // ssize_t
#include <cstddef> // std::size_t


//namespace rootstock_types {

// integer types
typedef int Integer; // Rosetta uses 'int' right now... should be 'ssize_t'
typedef unsigned int UInteger; // Rosetta uses 'unsigned int' right now... should be 'std::size_t'
typedef int SSize; // Rosett uses 'int' right now... should be 'ssize_t'
typedef unsigned int Size; // Rosetta uses 'unsigned int' right now... should be 'std::size_t'

// scalar types
typedef float Real; // Rosetta uses 'float' right now... should be 'double'
typedef Real Length;
typedef Real Distance;
typedef Real DistanceSquared;
typedef Real Angle;

// point types
typedef numeric::xyzTriple< Real > PointPosition;


//} // namespace rootstock

#endif /*FAUX_TYPES_HH_*/
