#!/usr/bin/perl -w
# -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
# vi: set ts=2 noet:
#  CVS information:
#  $Revision: 13641 $
#  $Date: 2007-03-19 18:29:17 -0500 (Mon, 19 Mar 2007) $
#  $Author: rhiju $
use strict;

## Adds new source and header files in rosetta++.vcproj
## This script will try to add new source and header files used in the makefile
## IT IS ASSUMED THAT ALL SOURCE AND HEADER FILE NAMES ARE UNIQUE
## THE BOINC BUILD DOES NOT GET UPDATED WITH THIS SCRIPT

## CONFIGURE ##################################################################
our $VCPROJ       = "rosetta++.vcproj";  ## vcproj for rosetta++
our $MAKEFILE     = "makefile"; ## makefile for rosetta++
our $VERSION_CSH	= ""; #"./version.csh";
our $VERSION_ROSETTA_CC = "version_rosetta.cc";
our @SRCSUFFIX    = qw( C c cc cpp cxx ); ## source filename extensions
our @HEADERSUFFIX = qw( h hh hpp hxx ii ipp ); ## header filename extensions
our @SRCPATHS     = qw( . src src/ObjexxFCL src/ObjexxFCL/internal src/numeric src/numeric/random src/utility src/utility/file src/utility/io src/utility/options src/utility/options/keys src/utility/pointer src/utility/boinc ); ## source paths (SRC_PATH in makefile)
our @INCLUDEPATHS	= qw( . src external/include src/platform/windows/xp/32 ); ## include paths (INCLUDE_DIRS in makefile)
our $VERBOSE			= 1;
###############################################################################

our ($PWD, %HEADERFILES, %SRCFILES);

my (@vcheaderfilenames, @vcsrcfilenames);
my ($n, $origfilestr, $newvcprojstr, %inc);
our $srcsuffixregex = join("|", @SRCSUFFIX);
our $headersuffixregex = join("|", @HEADERSUFFIX);

# get current directory
#$PWD = `pwd`;
#chomp $PWD;
use Cwd;
$PWD = getcwd;
print "Current directory: $PWD\n" if $VERBOSE;

if ($VERSION_CSH) {
	print "Updating = $VERSION_ROSETTA_CC\n";
	(system($VERSION_CSH) == 0) or die "ERROR!! cannot $VERSION_CSH execution failed\n";
}

## Get header files and source files for this project
print "Getting list of all source and header files\n" if $VERBOSE;
open(MFILE, $MAKEFILE) or die "ERROR!! cannot open $MAKEFILE ($!)\n";
while (my $line = <MFILE>) {
	if ($line =~ /^\s*include\s+(\S+\.src)[\s#]+/ && !$inc{$1}) {
		my $sf = $1;
		$inc{$sf} = 1;
		open(SRC, $sf) or die "ERROR!! cannot open $sf ($!)\n";
		while (my $sline = <SRC>) {
			if ($sline =~ /^\s*(\S+\.($srcsuffixregex))[\\\s#]*$/) {
				my $srcfile = $1;
				my $srcfilename = &getFileName( $srcfile );
				my ($relpath, $exists);
				INNER: foreach my $path (@SRCPATHS) {
					$relpath = "$path/$srcfilename";
					$relpath =~ s/\\/\//gs;
					if (-s $relpath) {
						$exists = 1;
						&getHeadersFromSourceFile( $relpath );
						if (exists $SRCFILES{$srcfilename}) {
							warn "WARNING!! $srcfilename already exists\n";
						}
						$SRCFILES{$srcfilename} = $relpath;
						last INNER;
					}
				}
				if (!$exists) { warn "WARNING!! cannot find source file $srcfilename\n";}
			}
		}
		close(SRC);
	}
}
close(MFILE);

## Read old vcproj
$n = $/;
undef $/;
open(FILE, "$VCPROJ") or die "ERROR!! cannot open $VCPROJ ($!)\n";
$origfilestr = <FILE>;
close(FILE);
$/ = $n;
$newvcprojstr = $origfilestr;

## Get old vcproj source files
if ($origfilestr =~ /<Filter\s*Name="Source\s+Files"[^>]*>(.+?)<\/Filter>/gs) {
	my $srcfiles = $1;
	my @vcsrcfiles = &getVCFiles( $srcfiles );
	@vcsrcfilenames = map { $_->{filename} } @vcsrcfiles;
}

## Get old vcproj header files
if ($origfilestr =~ /<Filter\s*Name="Header\s+Files"[^>]*>(.+?)<\/Filter>/gs) {
	my $headerfiles = $1;
	my @vcheaderfilestmp = &getVCFiles( $headerfiles );
	my @vcheaderfiles;
	foreach my $ref (@vcheaderfilestmp) {
		if ($ref->{filename} =~ /\.($headersuffixregex)\s*$/) {
			push(@vcheaderfiles, $ref);
		}
	}
	@vcheaderfilenames = map { $_->{filename} } @vcheaderfiles;
}

## add new source files to vcproj file
foreach my $filename (sort keys %SRCFILES) {
	my $tmpsrcname = $filename;
	$tmpsrcname =~ s/(\W)/\\$1/gs; # escape
	if (! grep { /^$tmpsrcname$/} @vcsrcfilenames ) {
		$newvcprojstr = &addFileToVCProj(
			filetype					=> "Source",
			filename					=> $filename,
			relunixpath				=> $SRCFILES{$filename},
			vcprojstr					=> $newvcprojstr,
			vcfiles_array_ref	=> \@vcsrcfilenames );
	}
}

## add new header files to vcproj file
foreach my $filename (sort keys %HEADERFILES) {
	my $tmpheader = $filename;
	$tmpheader =~ s/(\W)/\\$1/gs; # escape
	if (! grep { /^$tmpheader$/ } @vcheaderfilenames ) {
		$newvcprojstr = &addFileToVCProj(
			filetype  				=> "Header",
			filename  				=> $filename,
			relunixpath				=> $HEADERFILES{$filename},
			vcprojstr 				=> $newvcprojstr,
			vcfiles_array_ref => \@vcheaderfilenames );
	}
}

## remove non-existing rosetta source files
if ($newvcprojstr =~ /<Filter\s*Name="Source\s+Files"[^>]*>(.+?)<\/Filter>/gs) {
	my $srcfiles = $1;
	while ($srcfiles =~ /<File\s+RelativePath=["']([^"']+)["']\s*>\s*<\/File>/gs) {
		my $winfileref = $1;
		my $filename = &getFileName( $winfileref );
		if ($filename ne $VERSION_ROSETTA_CC && !exists $SRCFILES{$filename}) {
			warn "WARNING! $winfileref does not exist: removing from vcproj file\n";
			$winfileref =~ s/(\W)/\\$1/gs; # escape
			$newvcprojstr =~ s/<File\s+RelativePath=["']$winfileref["']\s*>\s*<\/File>//gs;
		}
	}
}

$newvcprojstr =~ s/([\cJ\cM\cZ]+)/\n/gs;

if ($origfilestr ne $newvcprojstr) {
	## make copy of previous vcproj file
	#(system("cp $VCPROJ $VCPROJ~") == 0) or
	#	die "ERROR!! cannot 'cp $VCPROJ $VCPROJ~': execution failed\n";
	open(BACKUP, ">$VCPROJ~") or die "ERROR!! cannot open file $VCPROJ~ ($!)\n";
	print BACKUP $origfilestr;
	close(BACKUP);


	## replace old with new
	open(FILE, ">$VCPROJ") or die "ERROR!! cannot open file $VCPROJ ($!)\n";
	print FILE $newvcprojstr;
	close(FILE);
}

## FINISHED


## SUBS ###########################

sub getHeadersFromSourceFile {
	my $file = shift;
	my %incfiles;
	open(SRCFILE, $file) or die "ERROR!! cannot open file $file ($!)\n";
	while (<SRCFILE>) {
		if (/^\s*#include\s+[<"']([^"']+)["'>]/) {
			my $incfile = $1;
			next if (exists $incfiles{$incfile} || $incfile !~ /\.($headersuffixregex)/);
			$incfiles{$incfile} = 1;
			my @headers;
			foreach my $dir (@INCLUDEPATHS) {
				my $relpath = "$dir/$incfile";
				$relpath =~ s/\\/\//gs;
				if (-s $relpath) {
					push( @headers, { filename => &getFileName( $relpath ), relpath => $relpath } );
				}
			}
			if (scalar@headers == 1) {
				$HEADERFILES{$headers[0]->{filename}} = $headers[0]->{relpath};
			} elsif (!scalar@headers) {
				warn "WARNING!! cannot find header file $incfile\n";
			} elsif (scalar@headers > 1) {
				die "ERROR!! ambiguous header file $incfile\n";
			}
		}
	}
	close(SRCFILE);
}

sub addFileToVCProj {
	my %params = ( @_ );
	my $filetype		= $params{filetype};
	my $filename		= $params{filename};
	my $relunixpath	= $params{relunixpath};
	my $vcprojstr		= $params{vcprojstr};
	my $vcfiles_array_ref = $params{vcfiles_array_ref};

	my ($relpathwin, $newlines, $prevname);
	$relpathwin = &convertToRelWinPath( $relunixpath );

	## new file lines for vcproj file
	$newlines = "\t\t\t<File\n\t\t\t\tRelativePath=\"$relpathwin\">\n\t\t\t</File>\n";

	## get file name alphabetically listed before new one
	$prevname = &getSortedPrevName( $filename, @{$vcfiles_array_ref} );

	## adding new file entries
	print "Adding $relpathwin\n" if $VERBOSE;
	if ($prevname) {
		## add file after $prevname
		$vcprojstr =~ s/(<File\s+RelativePath="[^>]*?\\$prevname".+?<\/File>\s*\n)/$1$newlines/gs;
	} else {
		## add file as first entry
		$vcprojstr =~ s/(<Filter\s+Name="$filetype Files"[^>]+?>\s*\n)/$1$newlines/gsi;
	}
	return $vcprojstr;
}

sub getVCFiles {
	my $list = shift;
	my @files;
	while ($list =~ /(\s+<File\s+RelativePath="([^"]+)".+?<\/File>)/gs) {
		my $fullstr = $1;
		my $relpath = $2;
		my $path = $relpath;
		$path = "$PWD/$path";
		$path =~ s/\\/\//gs;
		$path =~ s/\/+/\//gs;
		$fullstr =~ s/\n[ \t]*$/\n/gs;
		my $fname = &getFileName( $path );
		push( @files, { relwinpath => $relpath, fullunixpath => $path, lines => $fullstr, filename => $fname } );
	}
	return @files;
}

sub convertToRelWinPath {
	my $path = shift;
	$path =~ s/\//\\/gs;
	$path = ".\\$path" if ($path !~ /^(\.\\|\\)/);
	return $path;
}

sub getFileName {
	my $fpath = shift;
	$fpath =~ s/^.*[\/\\]([^\/\\]+)$/$1/;
	return $fpath;
}

sub getSortedPrevName {
	my @names = @_;
	my $n = $names[0];
	my $sortedprevname;
	@names = sort @names;
	unless ($names[0] eq $n) {
		for (my $i = 0; $i <= $#names; $i++) {
			if ($names[$i] eq $n) {
				$sortedprevname = $names[$i-1];
				last;
			}
		}
	}
	return $sortedprevname;
}

