// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13687 $
//  $Date: 2007-03-23 09:22:54 -0500 (Fri, 23 Mar 2007) $
//  $Author: yiliu $

#ifndef INCLUDED_rotamer_trials
#define INCLUDED_rotamer_trials

//Rosetta++ Headers
#include "pose_fwd.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

//C++ Headers
#include <iosfwd>
#include <vector>

// forward declarations
class DesignMap;
class RotamerSet;
class rotamer_trie;

typedef  float (*Scoring_Function)();

void
rotamer_trials();


void
set_allow_rotamer_trials(
	FArray1Da_bool setting,
	int & total_residue
);


void
retrieve_allow_rottrial(
	DesignMap & design_map,
	int & total_residue
);


bool
get_minimize_rot_flag();


void
score_set_minimize_rot( bool const setting );


void
set_energycut( float const cutoff );


float
get_energycut();


void
fullatom_rotamer_trials(
	FArray3Da_float xyz_out,
	FArray1Da_int aa_variant_out,
	DesignMap const & design_map,
	std::string const & seq_opt
);

void
fullatom_rotamer_trials_trie(
	FArray3Da_float xyz_out,
	FArray1Da_int aa_variant_out,
	DesignMap const & design_map,
	std::string const & seq_opt
);

void
trie_trials_energies(
	rotamer_trie * rt,
	int seqpos,
	int seqpos_aa,
	int seqpos_aav,
	std::vector< rotamer_trie* > & bg_tries,
	RotamerSet const & rotamer_set
);

void
set_best_rotamer_trie_trials(
	int seqpos,
	int best_rotamer,
	int rot_aa,
	int rot_aav,
	std::vector< rotamer_trie* > & bg_tries,
	FArray3D_float & trie_trials_componentE,
	FArray2Da_float rotcoord,
	FArray1Da_float rotactcoord,
	FArray1Da_float rotchi,
	FArray1Da_int rotid
);


void
get_trial_energies(
	float const rperc,
	FArray2Da_float rotcoord,
	FArray1Da_float rot_born_radius,
	int const seqpos1,
	int const aa1,
	int const aav1,
	FArray1Da_float rotactcoord,
	int total_residue,
	FArray1D_int const & res,
	FArray1D_int  const & res_variant,
	FArray3D_float const & full_coord,
	bool const symm_rottrial = false
);


void
reset_energy_coord_from_trial(
	int total_residue,
	FArray1D_int & res,
	FArray1D_int & res_variant,
	FArray3D_float & full_coord,
	FArray2Da_float rotcoord,
	FArray1Da_float rotchi,
	FArray1Da_int rotid,
	int seqpos,
	FArray1Da_float rotactcoord,
	FArray1Da_float rot_born_radius,
	int rot_aav,
	int rot_aa,
	bool const symm_rottrial = false
);


void
random_order(
	FArray1Da_int list,
	int const npos
);


void
write_rot_energies(
	int const seqpos,
	int const aa,
	int const rot,
	int const aanat,
	int const nb
);


void
minimize_trial_energies(
	FArray1Da_float chi,
	FArray1Da_int rotid,
	int const seqpos,
	int const aa,
	int const aav,
	FArray2Da_float rotcoord,
	FArray1Da_float rot_born_radius,
	FArray1Da_float rotactcoord,
	float func_tol,
	std::string const & min_type,
	int total_residue,
	FArray1D_int const & res,
	FArray1D_int const & res_variant,
	FArray3D_float const & full_coord
);


float
func_scvdw(
	FArray1Da_float min_chi,
	bool & gfrag
);


void
dfunc_scvdw(
	FArray1Da_float min_chi,
	FArray1Da_float dE_dchi,
	int nfree
);


void
get_hbond_deriv(
	FArray2DB_float & f1_hbond_deriv,
	FArray2DB_float & f2_hbond_deriv
);


void
get_LJ_solv_deriv(
	int & chi,
	FArray1DB_float & f1,
	FArray1DB_float & f2
);


void
accumulate_nb_f1_f2(
	int iatom,
	int iaa,
	int iaav,
	int iseqpos,
	FArray2DB_float & icoord,
	int jaa,
	int jaav,
	int jseqpos,
	FArray1DB_float & f1,
	FArray1DB_float & f2
);


void
pairderiv_h_to_all(
	int const hatom1,
	int const atom1,
	int const aa1,
	int const aav1,
	int const res1,
	FArray2DB_float & coord1,
	int const atom2,
	int const aa2,
	int const aav2,
	int const res2,
	FArray2DB_float & coord2,
	FArray1DB_float & f1,
	FArray1DB_float & f2
);


void
pairderiv_heavyatom_to_h(
	int const atom1,
	int const aa1,
	int const aav1,
	int const res1,
	FArray2DB_float & coord1,
	int const atom2,
	int const aa2,
	int const aav2,
	int const res2,
	FArray2DB_float & coord2,
	FArray1DB_float & f1,
	FArray1DB_float & f2
);


void
do_f1_f2_formula(
	FArray1Da_float ixyz,
	FArray1Da_float jxyz,
	float dE_dr,
	FArray1DB_float & f1,
	FArray1DB_float & f2
);


void
pairderiv_hydrogens(
	FArray1Da_float atom1,
	FArray1Da_float atom2,
	int const attype1,
	int const attype2,
	float & repulse,
	float const cp_weight
);


void
get_rotcoord_from_fullcoord(
	int seqpos,
	FArray2DB_float & coord
);


void
get_atom_from_sc_rotcoord(
	int const atom,
	FArray1DB_float & coord
);


void
make_chi_unit_vector(
	int const torsion,
	FArray1DB_float & vec,
	int & end_atom,
	FArray2DB_float & rotcoord
);


void
pack_min_chi( FArray1DB_float & min_chi );


void
unpack_min_chi( FArray1Da_float min_chi );


void
sum_trial_energy(
	float & atr_E,
	float & rep_E,
	float & solv_E,
	float & hbond_E
);


void
write_rot_energies_ctsa(
	int const seqpos,
	int const aa,
	int const rot,
	int const aanat,
	int const nb
);


void
write_rot_energies_dna(
	int const seqpos,
	int const aa,
	int const rot,
	int const aanat,
	int const nb
);


void
write_rot_energies_lig(
	int const seqpos,
	int const aa,
	int const rot,
	int const aanat,
	int const nb
);


void
set_dummy_seq_array(
	FArray2Da_bool dummy_seq_select,
	int max_aa,
	int max_res
);


void
update_repack_list(
	FArray1D_int & repack_list,
	int & numpositions,
	int const nres,
	FArray1D_bool const & new_rotamer,
	FArray1D_bool const & allow_move,
	FArray2D_bool const & neighborlist
);


void
create_symmetric_rotamers(
	int const seqpos,
	int const aa,
	int const aav,
	FArray2Da_float rotcoord,
	FArray1Da_float rotactcoord,
	FArray3D_float const & full_coord
);


void
debug_rotamer_trials(
	pose_ns::Pose & pose,
	Scoring_Function score_fxn
);


#endif
