// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14003 $
//  $Date: 2007-04-06 14:24:40 -0400 (Fri, 06 Apr 2007) $
//  $Author: snoeyink $

#ifndef INCLUDED_ROTAMER_TRIE_CALC_ENERGIES_H_
#define INCLUDED_ROTAMER_TRIE_CALC_ENERGIES_H_


// Rosetta Headers
#include "atom_descriptor.h"
#include "rotamer_descriptor.h"
#include "InteractionGraphFWD.h"

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// STL Headers
#include <string>

namespace pack {
  extern bool read_interaction_graph_file;
  extern bool write_interaction_graph_file;
  extern std::string ig_file_name;
}


// forward declarations
class PackerTask;
class RotamerSet;

void
rotamer_trie_calc_energies(
	RotamerSet & rotamer_set,
	PackerTask const & Task,
	FArray1D_float & ligenergies,
	FArray2DB_short & neighbor_indexno,
	pack::PrecomputedPairEnergiesInteractionGraph & ig
);

void
get_trie_2body_energies(
	RotamerSet & rotamer_set,
	short const ij_neighbor_indexno,
	pack::PrecomputedPairEnergiesInteractionGraph & ig,
	PackerTask const & Task,
  int const ii,
  int const iiresid,
	int const ii_num_states,
	int const iirotindexoffset,
	rotamer_trie* & ii_rt,
  int const jj,
  int const jjresid,
	int const jj_num_states,
	int const jjrotindexoffset,
	rotamer_trie* & jj_rt
);

float
get_sc_scE_trie(
	int aa_rot1,
	int aa_rot2,
	rotamer_trie const & rot1,
	rotamer_trie const & rot2,
	FArray1DB_float & rotactcoord1,
	FArray1DB_float & rotactcoord2
);

char
read_pair_energy_file(
	pack::PDInteractionGraph* ig,
	RotamerSet & rotamer_set,
	PackerTask const & Task,
	FArray2DB_short & neighbor_indexno,
	FArray1D_float & ligenergy1b
);


void
write_pair_energy_file(
	pack::PDInteractionGraph* ig,
	RotamerSet & rotamer_set,
	char energy_calculation_function
);


void
calculate_remaining_graph_energies(
	pack::PDInteractionGraph & ig,
	RotamerSet & rotamer_set,
	char energy_calculation_function,
	PackerTask const & Task,
	FArray2DB_short & neighbor_indexno,
	FArray1D_float & ligenergy1b
);

void
create_rotamer_descriptor (
	int resid,
	rotamer_descriptor & rot_descr,
	int aa,
	int aav,
	FArray2Da_float rot_coords,
	int rotid
);


int
get_variant_according_to_trie(
	int aa,
	int aav
);

void
create_rotamer_trie(
	RotamerSet & rotamer_set,
	int resid,
	rotamer_trie* & rt
);


void
create_rotamer_trie(
	RotamerSet & rotamer_set,
	int first_rotamer_index,
	int const num_rotamers,
	int resid,
	rotamer_trie * & rt
);

void
create_background_rotamer_trie(
	int  resid,
	rotamer_trie * & rt
);

void
add_res_res_E_mat_to_energy2b(
	int resid1,  // assert(resid1 < resid2);
	int resid2,
	int numrotamers1,
	int numrotamers2,
	int rotamer_offset1, // last rotamer for res (resid1 - 1)
	int rotamer_offset2, // last rotamer for res (resid2 - 1)
	FArray2Da_float oversized_res_res_mat,
	ChunkVector_float & energy2b,
	FArray1D_int & e2b_startindex,
	FArray4D_short & e2b_offsetindex,
	FArray2D_short & neighbor_indexno,
	RotamerSet & rotamer_set
);



void compare_e2b_start(
	FArray1D_int & e2b_startindex,
	FArray1D_int & e2b_startindex_test
);


void copare_e2b_offsetindex(
	FArray4D_short & e2b_offsetindex,
	FArray4D_short & e2b_offsetindex_test
);


void save_weights(
	float & copy_Watr,
	float & copy_Wrep,
	float & copy_Wsol,
	float & copy_Whbond_bb,
	float & copy_Whbond_bb_sc,
	float & copy_Whbond_sc
);


void set_weights_to_scaled_values(
	float copy_Watr,
	float copy_Wsol,
	float copy_Whbond_bb,
	float copy_Whbond_bb_sc,
	float copy_Whbond_sc
);


void set_weights_to_unscaled_values(
	float copy_Watr,
	float copy_Wsol,
	float copy_Whbond_bb,
	float copy_Whbond_bb_sc,
	float copy_Whbond_sc
);


void
set_rep_weight_to_scaled_value( float copy_Wrep );


void
set_rep_weight_to_unscaled_value( float copy_Wrep );


#endif
