// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//	CVS information:
//	$Revision: 20540 $
//	$Date: 2008-02-22 14:53:44 -0500 (Fri, 22 Feb 2008) $
//	$Author: sid $


// Rosetta Headers
#include "score.h"
#include "barcode_stats.h"
#include "homolog_distances.h"
#include "antibody_modeling.h"
#include "assemble_domains.h"
#include "namespace_assemble_options.h"
#include "after_opts.h"
#include "constraints.h"
#include "current_pose.h"
#include "dipolar.h"
#include "disulfides.h"
#include "dna_motifs.h"
#include "dock_ensemble.h"
#include "docking_movement.h"
#include "docking_ns.h"
#include "docking_score.h"
#include "docking_scoring.h"
#include "domins_score.h"
#include "dummy_model.h"
#include "electron_density.h"
#include "enzyme.h"
#include "fibril.h"
#include "files_paths.h"
#include "filters.h"
#include "fold_loops.h"
#include "force_barcode.h"
#include "fullatom.h"
#include "fullatom_energy.h"
#include "fullatom_sasa.h"
#include "gl_graphics.h"
#include "hbonds.h"
#include "jumping_loops.h"
#include "jumping_ns.h"
#include "jumping_refold.h"
#include "kin_util.h"
#include "loops.h"
#include "maps.h"
#include "maps_ns.h"
#include "misc.h"
#include "monte_carlo.h" // yab: misc removal
#include "nblist.h"
#include "orient_rms.h"
#include "param.h"
#include "param_pack.h"
#include "param_torsion.h"
#include "pH_main.h"
#include "pose.h"
#include "pose_constraints.h"
#include "pose_dna.h"
#include "pose_rms.h"
#include "pose_rna.h"
#include "prof.h"
#include "ramachandran.h"
#include "relax_structure.h"
#include "rotamer_trials.h"
#include "saxs_model.h"
#include "sidechain_bond_angles.h"
#include "score_ns.h"
#include "structure.h"
#include "taboo_search.h"
#include "tether.h"
#include "trajectory.h"
#include "vdw.h"
#include "void.h"
#include "water.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3Dp.hh>
#include <ObjexxFCL/formatted.o.hh>

// Utility Headers
#include <utility/basic_sys_util.hh>

// C++ Headers
#include <cstdlib>
#include <iostream>


// for consistency scoring functions should
// 1) return a float value
// 2) not use any calling args
//
// scorefxn() is a generic scoring function which can evaluate all terms
// other scoring functions can utilize this function after ensuring
// weights and parameters in score_ns.h are properly set
// the reason to use scorefxn is that this generic function can be
// used elsewhere without having to pass the scoring function
// (ie func_minimize where the scoring function _can't_ be passed)
//
// methods for setting weights and parameters outside of scoring functions
// are at end of this file: loop_weight,lj_weight,cst_weight


////////////////////////////////////////////////////////////////////////////////
/// @begin scorefxn
///
/// @brief
///car generic scoring function which can evaluate all terms
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
scorefxn()
{
	using namespace misc;
	using namespace assemble_options;
	using namespace files_paths;
	using namespace param;
	using namespace param_pack;
	using namespace param_torsion;
	using namespace scorefxns;
	using namespace scores;

	using namespace mc_global_track::mc_score; // yab: misc removal
	using namespace mc_global_track::diagnose; // yab: misc removal

	PROF_START( prof::SCOREFXN );

	//car ALL CENTROID-BASED TERMS
	if ( no_evaluation ) {
		no_evaluation = false;
		return score; // return previous value
	}

	pose_ns::Pose * const score_pose
		( score_check_current_pose() ? &(score_get_current_pose()) : 0 );

	float domain_score;
	float antibody_linker_contact_score;
	float disulf_cent_score,disulf_fa_score;
	float score_val = 0.0;

	FArray2D_float torsion_tether_deriv( total_bb_torsion, total_residue );

	bool const fullatom = get_fullatom_flag();
	if ( !fullatom ) {
		if ( fa_scorefxn ) {
			std::cout << "WARNING:: fullatom scorefxn terms requested" << std::endl;
			std::cout << "but fullatom flag is false" << std::endl;
			std::cout << "fullatom terms will not be evaluated" << std::endl;
		}
	}

	//lin	 set the water flags
	if ( fullatom ) set_water_rotamer_for_score();

	//car	 must call before vdw_compute & evaluate_envpair
	//car	 count_pair and pair_log behave differently for paired cysteines
	disulfides::BOUNDARY::evaluate_disulfides_centroid();
	disulfides::BOUNDARY::disulf_get_tot_wtd_cent_score(disulf_cent_score);
	score_val += disulf_cent_score;

	if ( evaluate_all_terms ) {
		vdw_compute(vdw_score);
		structure::BOUNDARY::evaluate_envpair(env_score,pair_score,cb_score,centroid_pack_score);
		if( use_homolog_env_stats ) structure::BOUNDARY::evaluate_homolog_env( homolog_env_score );
		if( use_homolog_pair_stats ) structure::BOUNDARY::evaluate_homolog_pair( homolog_pair_score );
		if( use_homolog_cendist_stats ) misc_homolog_score( homolog_cendist_score );
		structure::BOUNDARY::evaluate_ss(ss_lowstrand,ss_cutoff,hs_score,ss_score,rsigma_score,
																		 sheet_score);
		structure::functions::radius_gyration(rg, total_residue);
    contact_order(co, res, total_residue);
    contact_prediction = score_contact_prediction(Eposition, total_residue);
		ramachandran_score =
			eval_rama_score_all(phi,psi,res,secstruct,total_residue);
		classical_constraints::BOUNDARY::eval_pairConstraint(-2,pc_viol);
		eval_dipolar(Eposition,1,total_residue,res,dipolar_score);
		eval_projection(projection_score, Eposition);
		eval_saxs_model_score( saxs_model_score );
		eval_dummy_model_score( dummy_model_score, nsd );

		//functions that will otherwise evaluated by fullatom_energy
		if ( !fullatom ) {
			classical_constraints::BOUNDARY::eval_pairConstraint(pc_mode,pc_score);
			evaluate_hbenergy(hbonds::hbderiv_NONE,hb_srbb_score,hb_lrbb_score); // JSS these hb scores are used
		}
	} else {

		//car only evaluate terms with non-zero weights
		//car some weights are checked inside called functions


		//car pair,env,cb,vdw & ss terms all require the cenlist to be updated
		//car cenlist is updated by the following functions:
		//car	 evaluate_envpair,vdw_compute_insert,evaluate_envpair_novdw()
		if ( vdw_weight != 0.0 ) {
			vdw_compute(vdw_score);
		} else if ( pair_weight != 0.0 || env_weight != 0.0 || cb_weight != 0.0 ||
								sheet_weight != 0.0 || hs_weight != 0.0 || ss_weight != 0.0 ||
								rsigma_weight != 0.0 ) {
			update_cendist(total_residue,centroid);
		}

		if ( pair_weight != 0.0 || env_weight != 0.0 || cb_weight != 0.0 ){
			structure::BOUNDARY::evaluate_envpair(env_score,pair_score,cb_score,centroid_pack_score);
			if( use_homolog_env_stats ) structure::BOUNDARY::evaluate_homolog_env( homolog_env_score );
			if( use_homolog_pair_stats ) structure::BOUNDARY::evaluate_homolog_pair( homolog_pair_score );
			if( use_homolog_cendist_stats ) misc_homolog_score( homolog_cendist_score );
		}

		if ( sheet_weight != 0.0 || hs_weight != 0.0 || ss_weight != 0.0 ||
				 rsigma_weight != 0.0 ) structure::BOUNDARY::evaluate_ss(ss_lowstrand,ss_cutoff,hs_score,
																																 ss_score,rsigma_score,sheet_score);

		if ( dipolar_weight != 0.0 )
			eval_dipolar(Eposition,1,total_residue,res,dipolar_score);

		if ( projection_weight != 0.0 ) eval_projection(projection_score, Eposition);

		if ( ramachandran_weight != 0.0 ) ramachandran_score =
																				eval_rama_score_all(phi,psi,res,secstruct,total_residue);

    if ( contact_prediction_weight != 0.0) contact_prediction = score_contact_prediction(Eposition, total_residue); //mj

    if ( rg_weight != 0.0 ) structure::functions::radius_gyration(rg, total_residue);

    if ( co_weight != 0.0 ) contact_order(co, res, total_residue);

		if (rms_weight != 0.0) calc_rms();

		if (saxs_model_weight != 0.0)	 eval_saxs_model_score( saxs_model_score );
		if (dummy_model_weight != 0.0) eval_dummy_model_score( dummy_model_score, nsd );
		//functions that will otherwise be evaluated by fullatom_energy
		if ( ! fullatom ) {
			if ( pack_wts.hbond_bbwts_nonzero() )
				evaluate_hbenergy(hbonds::hbderiv_NONE,hb_srbb_score,hb_lrbb_score); // JSS these hb scores are used
			if ( pc_weight != 0.0 ) classical_constraints::BOUNDARY::eval_pairConstraint(pc_mode,pc_score);
		}

	}

	//	std::cout << "scorefxn total energy (score12) - 1: " << score_val << std::endl;

	score_val += vdw_weight*vdw_score +
		env_weight*env_score +
		pair_weight*pair_score +
		cb_weight*cb_score +
		sheet_weight*sheet_score +
		ss_weight*ss_score +
		hs_weight*hs_score +
		rsigma_weight*rsigma_score +
		rg_weight*rg +
		co_weight*co +
		ramachandran_weight*ramachandran_score +
		contact_prediction_weight * contact_prediction +
		dipolar_weight*dipolar_score +
		projection_weight*projection_score +
		pair_weight*homolog_pair_score+
		homolog_cendist_score;

	//SJF
	if (get_ssweight_for_homolog()) { score_val += ss_weight*homolog_env_score; }
	else { score_val += env_weight*homolog_env_score; }

	//	std::cout << "scorefxn total energy (score12) - 1b: " << score_val << std::endl;

	if ( barcode_weight != 0.0 && barcode_exist() ) {
		// "Traditional" barcodes, which are applied in mysterious ways.
		barscore = barcode_weight * barcode_score( total_residue, phi, psi,
																							 omega, secstruct );
		score_val += barscore;
	}

	if ( barcode_energy_weight != 0.0 ) {
		// Newer barcode energy -- just apply a user-defined bonus if the feature is present.
		// Note difference: weighting is not applied to bar_energy_score until
		// its added into the score. Useful if we want to know the score but
		// not apply it (set barcode_energy_reweight = 0.000001 );
		bar_energy_score = barcode_energy_score();
		score_val += barcode_energy_weight * bar_energy_score;
	}

	if ( score_pose && sidechain_bond_angle_weight != 0.0 ) {
		float const bond_score( eval_bond_angle_score( *score_pose ) );
		score_val += sidechain_bond_angle_weight * bond_score;
		score_pose->set_0D_score( pose_ns::SIDECHAIN_BOND_ANGLE, bond_score );
	}

	if ( structure::BOUNDARY::get_separate_centroidpackscore_flag() ) {
		//User asked centroidpackscore to not get added to cb_score
		score_val += cb_weight*centroid_pack_score;
	}

	if (rms_weight != 0.0) {
		score_val += rms_weight * (-100/(rms_err+0.00001 + 5));
	}

	if (saxs_model_weight != 0.0){
		score_val += saxs_model_weight * saxs_model_score;
	}

	if (dummy_model_weight != 0.0 && get_dummy_model_score_flag()){
		score_val += dummy_model_weight * dummy_model_score;
		if (score_check_current_pose()) {
			pose_ns::Pose & pose( score_get_current_pose() );
			pose.set_0D_score( pose_ns::DUMMY_MODEL, dummy_model_score );
			pose.set_0D_score( pose_ns::NSD, nsd );
		}
	}

	if ( get_taboo_mode_exist() && taboo_weight != 0.0) {
		taboo_score = taboo_weight * taboo_bonus();
		taboo_best = taboo_weight * taboo_b();
	}

	if ( !fullatom ) score_val +=
										 pack_wts.Whb_srbb() * hb_srbb_score +
										 pack_wts.Whb_lrbb() * hb_lrbb_score +
										 pc_weight*pc_score; //JSS hbscore

	//car tether scores (evaluated only if non-zero weight!!)
	if ( tether_weight != 0.0 ) {
		calculate_tether_score(tether_score);
		score_val += tether_score*tether_weight;
		if (score_check_current_pose()) {
			pose_ns::Pose & pose( score_get_current_pose() );
			pose.set_0D_score( pose_ns::TETHER, tether_score );
		}
	}
	if ( phipsi_weight != 0.0 ) {
		calculate_phipsi_torsion_tether_score(phipsi_score,
																					torsion_tether_deriv);
		score_val += phipsi_weight*phipsi_score;
	}
	if ( omega_weight != 0.0 ) {
		calculate_omega_torsion_tether_score(omega_score,
																				 torsion_tether_deriv);
		score_val += omega_weight*omega_score;
		if (score_check_current_pose()) {
			pose_ns::Pose & pose( score_get_current_pose() );
			pose.set_0D_score( pose_ns::OMEGA, omega_score );
		}
	}

	// DNA
	if ( dna_bp_weight != 0.0 || dna_bs_weight != 0.0 ) {
		pose_ns::Pose & pose( score_get_current_pose() );
		float const dna_bp_score( eval_dna_bp_score( pose ) );
		float const dna_bs_score( eval_new_dna_bs_score( pose ) );
		pose.set_0D_score( pose_ns::DNA_BP, dna_bp_score );
		pose.set_0D_score( pose_ns::DNA_BS, dna_bs_score );
		score_val += dna_bp_weight * dna_bp_score + dna_bs_weight * dna_bs_score;
	}

	// RNA
	if ( rna_bs_weight != 0.0	 || rna_bp_w_weight != 0.0 ||
			 rna_bp_h_weight != 0.0 || rna_bp_s_weight != 0.0 ||
			 rna_axis_weight != 0.0 ||	rna_stagger_weight != 0.0 ||
			 rna_nonbasebase_weight != 0.0 ||
			 rna_o2star_weight != 0.0 ) {

		assert( pose_flag() );
		pose_ns::Pose & pose( score_get_current_pose() );

		eval_rna_score( pose, rna_bs_score, rna_bp_w_score,
										rna_bp_h_score, rna_bp_s_score,
										rna_axis_score, rna_stagger_score, rna_bulge_score,
										rna_contact_score, rna_long_range_contact_score
										);
		eval_rna_nonbasebase_score( pose, rna_nonbasebase_score );
		eval_rna_o2star_score( pose, rna_o2star_score );
		eval_rna_phosphate_score( pose, rna_phosphate_score );

		score_val +=
			rna_bs_weight * rna_bs_score +
			rna_bp_w_weight * rna_bp_w_score +
			rna_bp_h_weight * rna_bp_h_score +
			rna_bp_s_weight * rna_bp_s_score +
			rna_axis_weight * rna_axis_score +
			rna_stagger_weight * rna_stagger_score +
			rna_bulge_weight * rna_bulge_score +
			rna_nonbasebase_weight * rna_nonbasebase_score +
			rna_o2star_weight * rna_o2star_score +
			rna_phosphate_weight * rna_phosphate_score +
			rna_contact_weight * rna_contact_score +
			rna_long_range_contact_weight * rna_long_range_contact_score;

		if (rna_sasa_weight != 0.0) eval_rna_sasa_score( pose, rna_sasa_score);
		score_val +=	rna_sasa_weight * rna_sasa_score;

		store_rna_scores( pose );
	}



	//car docking	 (terms summed and weighted inside function)
	//chu fullatom-dependent docking specific scores calculated after rottrial
	if ( dock_scorefxn ) {
		float docking_score( 0.0 );
		docking_evaluate_all_scores(docking_score);
		score_val += docking_score;
		if ( try_rotamers ) docking_set_allow_rottrial();
	}

	//Monica Berrondo domain insertion score function
	if ( domain_scorefxn ) {
		evaluate_contact_scores(domain_score);
		score_val += domain_score;
	}

	//aroop loop building score with contact score
	if( loop_scorefxn) {
		antibody_modeling_contact_score(antibody_linker_contact_score);
		score_val += antibody_linker_contact_score;
	}

//Sid adjusts score based on unbound reference energy
	if( docking_ensemble_scorefxn && !fullatom) {
			float unbound_score(0.0);
			set_cen_unbound_score( unbound_score );
			score_val -= unbound_score;
	}

	// caz in assemble mode, after having entered relax,
	// caz only rotamer trial at the (moving) interface between
	// caz residues

	if (get_assemble_flag()) {
		assemble_detect_interf_res();
		assemble_set_allow_rottrial();
	}

	//pb jumping chain breaks:
	if ( score_pose && jmp_chainbreak_weight != 0.0 ) {
		float const tmp( jmp_chainbreak_score() );
		score_pose->set_0D_score( pose_ns::CHAINBREAK, tmp );
		score_val += jmp_chainbreak_weight * tmp;
		chainbreak_score = tmp;
	}

	if ( score_pose && extra_weight != 0.0 ) {
		float const tmp( eval_extra_score( *score_pose ));
		score_pose->set_0D_score( pose_ns::EXTRA, tmp );
		score_val += extra_weight * tmp;
	}

	if ( score_pose && get_electron_density_file_flag()) {
		float ed_score = eval_electron_density_score(*score_pose);
		score_pose->set_0D_score( pose_ns::EDENSITY, ed_score);
		score_val +=electron_density_weight*ed_score;
	}

	// RNA -- early exit, no need to compute fullatom stuff.
	if ( pose_flag() && rnaonly_scorefxn ) {
		pose_ns::Pose & pose( score_get_current_pose() );
		pose.set_0D_score( pose_ns::SCORE, score_val );
		store_rna_scores( pose );
		PROF_STOP( prof::SCOREFXN );
		return score_val;
	}

	if ( score_pose && fullatom && bbonly_scorefxn &&
			 ( pack_wts.hbond_bbwts_nonzero() ) ) {
		fast_backbone_hbE( *score_pose, hb_srbb_score, hb_lrbb_score );

		score_pose->set_0D_score( pose_ns::HB_SRBB, hb_srbb_score );
		score_pose->set_0D_score( pose_ns::HB_LRBB, hb_lrbb_score );
		score_val += pack_wts.Whb_srbb() * hb_srbb_score + pack_wts.Whb_lrbb() * hb_lrbb_score;
	}

	// new-style pose constraints for central
	if ( !fullatom && score_pose && score_pose->constraints_exist() ) {
		score_val += calc_pose_constraint_scores( *score_pose,
																							phipsi_cst_weight, omega_cst_weight, chi_cst_weight, kin_1D_cst_weight,
																							kin_3D_cst_weight, atompair_cst_weight, coord_cst_weight,
																							chainbreak_cst_weight );
	}

	//car loops
	score_val += get_loop_splicemsd() * splicemsd_weight;

	if ( evaluate_all_terms && score_pose )	store_centroid_scores( *score_pose);

	if ( !fullatom || ( score_pose && bbonly_scorefxn ) ) {
		///////////////////////////////////////////////////////////////////////////
		// NEW BEHAVIOR: if ( score_pose ) we will jump out here if
		//							 specifically requested not to evaluate fullatom terms
		//							 by setting of bbonly_scorefxn
		///////////////////////////////////////////////////////////////////////////
		score = score_val; // save total in global variable

		if ( score_pose ) {
			score_pose->set_0D_score( pose_ns::SCORE, score_val );
			// store other scores with a single call here
			store_centroid_scores( *score_pose );
		}

		PROF_STOP( prof::SCOREFXN );

		save_scores_for_graphics( score_val );

		return score_val;
	}
	//car ADDITIONAL FULLATOM TERMS

	//car must call fullatom_energy before rotamer_trials
	//car or if any of the packer energy terms are use
	//car here, assume that in fullatom mode, one of these is true
	fullatom_energy(res, res_variant, full_coord, total_residue, use_subset_energy);

	if ( try_rotamers ) {
		PROF_START( prof::ROTAMER_TRIALS );
		rotamer_trials();
		PROF_STOP ( prof::ROTAMER_TRIALS );
	}
	float cstE;
	sum_fullatom_energies(total_residue,fa_atr_score,fa_rep_score,fa_solv_score,
	 fa_ref_score,fa_pH_score,fa_dun_score,fa_prob1b_score,fa_pair_score,fa_plane_score,
	 fa_h2o_score,fa_h2o_hb_score,fa_h2o_solv_score,hb_srbb_score,hb_lrbb_score,
	 hb_sc_score,fa_intrares_score,fa_gb_elec_score,fa_elec_score, cstE,bond_angle_score);

	if( use_homolog_env_stats_in_farlx ){
		structure::BOUNDARY::evaluate_homolog_env( homolog_env_score );
		score_val += homolog_env_score;
	}
	if( use_homolog_pair_stats_in_farlx ){
		structure::BOUNDARY::evaluate_homolog_pair( homolog_pair_score );
		score_val += homolog_pair_score;
	}
	if( use_homolog_cendist_stats_in_farlx ) {
		misc_homolog_score( homolog_cendist_score );
		score_val += homolog_cendist_score;
	}

	score_val +=
		fa_atr_score * fa_atr_weight +
		fa_rep_score * fa_rep_weight +
		fa_dun_score * fa_dun_weight  +
		fa_pair_score * fa_pair_weight +
		fa_plane_score * fa_plane_weight +
		fa_solv_score * fa_solv_weight +
		fa_h2o_solv_score * fa_solv_weight -
		fa_ref_score * fa_ref_weight  +
		fa_pH_score * fa_pH_weight +
		fa_h2o_score * fa_h2o_weight +
		fa_h2o_hb_score * fa_h2o_weight  +
		fa_prob1b_score * fa_prob1b_weight +
		fa_intrares_score * fa_rep_weight +
		fa_gb_elec_score * fa_gb_elec_weight +
		bond_angle_score * bond_angle_weight;

    if ( get_simple_elec() )
      score_val += fa_elec_score * fa_elec_weight;

	// new-style pose constraints for full_atom
	// lin fill the cstenergy assay

	// Need to have these cst's initialized to zero if there are no constraints,
	// to keep score column the same length
	if (score_pose && atompair_cst_weight > 0.0)
		score_pose->set_0D_score( pose_ns::ATOMPAIR_CST, 0.0);
	if (score_pose && kin_1D_cst_weight > 0.0)
		score_pose->set_0D_score( pose_ns::KIN_1D_CST, 0.0);
	if (score_pose && kin_3D_cst_weight > 0.0)
		score_pose->set_0D_score( pose_ns::KIN_3D_CST, 0.0);

	if ( score_pose && score_pose->constraints_exist() ) {
		score_val += calc_pose_constraint_scores( *score_pose,
																							phipsi_cst_weight, omega_cst_weight, chi_cst_weight, kin_1D_cst_weight,
																							kin_3D_cst_weight, atompair_cst_weight, coord_cst_weight,
																							chainbreak_cst_weight );
	}

	score_val +=
		pack_wts.Whb_srbb() * hb_srbb_score + pack_wts.Whb_lrbb() * hb_lrbb_score +
		pack_wts.Whb_sc() * hb_sc_score; //JSS hbscore

	pc_score = cstE;		 //cstE has pc_weight already included
	score_val += pc_score;
	//	std::cout << "scorefxn total energy (score12) - 2b: " << score_val << std::endl;

	if ( std::abs(pc_weight) > 0.001 ) pc_score /= pc_weight;
	//bs disulfides x-tra fullatom contribution
	disulfides::BOUNDARY::disulf_eval_fa_scores(disulf_fa_score);
	score_val += disulf_fa_score;

	//car other fullatom terms not used by the packer
	//car evaluated only if non-zero weight or if evaluate_all_terms flag set

	///jjh Match-up between inverse rotamer library and loop
	//	if( dna_inv_rot_weight != 0.0 ) {
	//		score_val += get_dna_match_score() * dna_inv_rot_weight;
	//	}

	//chu fullatom-dependent docking specific scores
	if ( dock_scorefxn ) {
		float docking_score( 0.0 );
		docking_evaluate_fa_scores(docking_score);
		score_val += docking_score;
	}
	///jjh Get DNA motif functional group tether score
	if( motif_tether_weight != 0.0 ) {
		score_val += get_motif_tether_score() * motif_tether_weight;
	}

	//cj	approximate SASA calculations
	if ( evaluate_all_terms || ex_gsolt_weight != 0.0 || sasa_weight != 0.0 ){
		calc_aprox_sasa();
		score_val += ex_gsolt_weight * get_ex_gsolt();
		score_val += sasa_weight*get_ex_sasa_gsolt();
	}

	if ( evaluate_all_terms ) {
		calc_sasa_pack_score(total_residue,res,res_variant,full_coord);
	}

	score = score_val; // save total in global variable

	if ( score_pose ) {
		score_pose->set_0D_score( pose_ns::SCORE, score );
		store_fullatom_scores( *score_pose );
	}
	PROF_STOP( prof::SCOREFXN );

	save_scores_for_graphics( score_val );

	return score_val;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin score0
///
/// @brief
///car bumps only
///car INTENDED USE:	replacement of extended angles with fragments
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score0()
{
	using namespace scorefxns;
	using namespace scores;

	score_reset_weights();

	vdw_weight = 1.0;
	pc_weight = 1.0;

	pc_mode = cst_mode;

	score_apply_user_defined_reweights();

	float score0 = scorefxn();
	score0 += - vdw_score + static_cast< int >( vdw_score / 10.0f );
	mc_global_track::mc_score::score = score0; // save total in global variable

	return score0;
}


////////////////////////////////////////////////////////////////////////////////
/// @begin score1
///
/// @brief
///car bumps, env,pair,ss terms, constraints (low weight)
///car no terms to compact structure (cbeta, rg)
///car no rsigma	-- lower resolution strand pairing
///
///car INTENDED USE: secondary structure build-up in unfolded chains
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score1()
{
	using namespace scorefxns;

	score_reset_weights();

	vdw_weight = 1.0;
	env_weight = 1.0;
	pair_weight = 1.0;
	sheet_weight = 1.0;
	ss_weight = 0.3;
	hs_weight = 1.0;
	contact_prediction_weight = 1.0;
	pc_weight = 1.0;
	//			dipolar_weight = 1.0;

	pc_mode = cst_mode;
	ss_lowstrand = 1;
	ss_cutoff = 11;

	barcode_weight = 1.0; // like phipsi tether
	barcode_energy_weight = 0.0;
	taboo_weight = 1.0;

	score_apply_user_defined_reweights();

	electron_density_weight = 1.0;

	return scorefxn();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score2
///
/// @brief
///car vdw,env,pair,cb,sheet,ss,hs,pc,dipolar
///car tight ss terms, large weight on constraints
///
///car INTENDED USE: de novo folding, compacting score
///car alternate score2/score5 to compact structure, then relax
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score2()
{
	using namespace scorefxns;

	score_reset_weights();
	vdw_weight = 1.0;
	env_weight = 1.0;
	pair_weight = 1.0;
	cb_weight = 0.5;
	sheet_weight = 1.0;
	ss_weight = 1.0;
	hs_weight = 1.0;
	pc_weight = 1.0;
	contact_prediction_weight = 1.0;
	dipolar_weight = 1.0;

	disulf_cendist_weight = 1.0;
	disulf_bb_dih_weight = 0.0;
	disulf_cbdist_weight = 1.0;
	disulf_cacbcbca_weight = 0.0;

	pc_mode = cst_mode;
	ss_lowstrand = 1;
	ss_cutoff = 6;

	barcode_weight = 1.0; // like phipsi tether
	barcode_energy_weight = 0.5;
	taboo_weight = 1.0;

	dummy_model_weight = 1.0;
	saxs_model_weight = 1.0;
	electron_density_weight = 1.0;

	score_apply_user_defined_reweights();

	return scorefxn();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score3
///
/// @brief
///car all centroid terms
///car moderate resolution strand pairing (no hbonds, rsigma on)
///
///car INTENDED USE:	centroid refinement
///car								lowres atom radii
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score3()
{
	using namespace scorefxns;

	score_reset_weights();
	vdw_weight = 1.0;
	env_weight = 1.0;
	pair_weight = 1.0;
	cb_weight = 1.0;
	sheet_weight = 1.0;
	ss_weight = 1.0;
	hs_weight = 1.0;
	rsigma_weight = 1.0;
	rg_weight = 3.0;
	pc_weight = 1.0;
	contact_prediction_weight = 1.0;
	dipolar_weight = 1.0;

	splicemsd_weight = loop_weight;
	pc_mode = cst_mode;
	ss_lowstrand = 0;
	ss_cutoff = 6;

	disulf_cendist_weight = 2.5;
	disulf_bb_dih_weight = 2.5;
	disulf_cbdist_weight = 2.5;
	disulf_ca_minus_cen_weight = 2.5;

	barcode_weight = 1.0; // like phipsi tether
	barcode_energy_weight = 1.0;
	taboo_weight = 1.0;

	dummy_model_weight = 1.0;
	saxs_model_weight = 1.0;
	electron_density_weight = 1.0;

	score_apply_user_defined_reweights();

	return scorefxn();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score4
///
/// @brief
///car most centroid terms
///car no cbeta, rg
///car moderate resolution strand pairing (rsigma, no hbonds)
///
///car INTENDED USE:	final scoring of de novo folded structures
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score4()
{
	using namespace scorefxns;

	score_reset_weights();

	vdw_weight = 1.0;
	env_weight = 1.0;
	pair_weight = 1.0;
	sheet_weight = 1.0;
	ss_weight = 1.0;
	hs_weight = 1.0;
	rsigma_weight = 1.0;
	pc_weight = 1.0;
	contact_prediction_weight = 1.0;
	dipolar_weight = 1.0;

	ss_lowstrand = 0;
	ss_cutoff = 6;

	barcode_weight = 1.0; // like phipsi tether
	barcode_energy_weight = 1.0;
	taboo_weight = 1.0;

	dummy_model_weight = 1.0;
	electron_density_weight = 1.0;

	score_apply_user_defined_reweights();

	return scorefxn();
}


////////////////////////////////////////////////////////////////////////////////
/// @begin score5
///
/// @brief
///car loose strand pairing, loose constraints
///car no rg,rsigma
///
///car INTENDED USE: de novo folding
///car relax structure which is being compacted (see score2)
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score5()
{
	using namespace scorefxns;

	score_reset_weights();
	vdw_weight = 1.0;
	env_weight = 1.0;
	pair_weight = 1.0;
	cb_weight = 0.5;
	sheet_weight = 1.0;
	ss_weight = 1.0;
	hs_weight = 1.0;
	pc_weight = 0.2;
	contact_prediction_weight = 0.2;
	dipolar_weight = 0.05;

	pc_mode = cst_mode;
	ss_lowstrand = 1;
	ss_cutoff = 11;

	barcode_weight = 1.0; // like phipsi tether
	barcode_energy_weight = 0.5;
	taboo_weight = 1.0;

	dummy_model_weight = 1.0;
	saxs_model_weight = 1.0;
	electron_density_weight = 1.0;

	score_apply_user_defined_reweights();

	return scorefxn();
}
////////////////////////////////////////////////////////////////////////////////
/// @begin score6
///
/// @brief
///car all centroid terms
///car less compacting than score3 (rg downweighted)
///car variable vdw_weight
///car strand pairing:	both rsigma and hbonds
///
///car INTENDED USE:	centroid refinement
///car								switching to highres atom radii
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score6()
{
	using namespace scorefxns;
	using namespace param_pack;

	std::string protein_sstype;

	score_reset_weights();
	vdw_weight = lj_weight;
	env_weight = 1.0;
	pair_weight = 0.4;
	cb_weight = 1.5;
	sheet_weight = 0.0; // decrease low resolution ss terms and increase nl hb
	ss_weight = 0.3;
	hs_weight = 0.0;
	rsigma_weight = 0.0;
	rg_weight = 1.0;
	pack_wts.set_Whb_lrbb(1.3);

	protein_sstype = get_protein_sstype();
	if ( protein_sstype == "xx" ) {
		pack_wts.set_Whb_srbb(0.4);
	} else {
		if ( protein_sstype == "a" ) {
			pack_wts.set_Whb_srbb(0.7);
		} else {
			pack_wts.set_Whb_srbb(0.1);
		}
	}

	if (get_score_contact_fullatom()) contact_prediction_weight = 0.3;
	ramachandran_weight = 0.1;
	pc_weight = cst_weight;
	dipolar_weight = dpl_weight;
	splicemsd_weight = loop_weight;

	pc_mode = cst_mode;
	ss_lowstrand = 0;
	ss_cutoff = 6;

	disulf_cendist_weight = 0.6;
	disulf_bb_dih_weight = 1.2;
	disulf_cbdist_weight = 0.2;
	disulf_cacbcb_weight = 1.0;
	disulf_cacbcbca_weight = 1.0;

	taboo_weight = 1.0;
	barcode_weight = 1.0;

	score_apply_user_defined_reweights();

	return scorefxn();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score7
///
/// @brief
///car all centoid terms (no disulfides)
///car no compacting terms::	rg, cbeta
///car strand pairing:	both rsigma and hbonds
///car variable vdw_weight
///
///car INTENDED USE:	centroid refinement
///car								switching to highres atom radii
///car								structure compactness not an issue (maintained by
///car													(constraints or fixed template)
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score7()
{
	using namespace scorefxns;
	using namespace param_pack;

	std::string protein_sstype;

	score_reset_weights();
	vdw_weight = lj_weight;
	env_weight = 1.0;
	pair_weight = 0.4;
	sheet_weight = 0.0;
	cb_weight = 1.5;
	ss_weight = 0.3;
	hs_weight = 0.0;
	rsigma_weight = 0.0;
	pack_wts.set_Whb_lrbb(1.3);

	protein_sstype = get_protein_sstype();
	if ( protein_sstype == "xx" ) {
		pack_wts.set_Whb_srbb(0.4);
	} else {
		if ( protein_sstype == "a" ) {
			pack_wts.set_Whb_srbb(0.7);
		} else {
			pack_wts.set_Whb_srbb(0.1);
		}
	}

	if (get_score_contact_fullatom()) contact_prediction_weight = 0.3;
	ramachandran_weight = 0.1;
	pc_weight = cst_weight;
	dipolar_weight = dpl_weight;
	splicemsd_weight = loop_weight;

	pc_mode = cst_mode;
	ss_lowstrand = 0;
	ss_cutoff = 6;

	score_apply_user_defined_reweights();

	return scorefxn();
}
////////////////////////////////////////////////////////////////////////////////
/// @begin score8
///
/// @brief
///car INTENDED USE:	not in use
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score8()
{
	score_reset_weights();

	score_apply_user_defined_reweights();

	return scorefxn();
}
////////////////////////////////////////////////////////////////////////////////
/// @begin score9
///
/// @brief
///car mixed centroid/fullatom scoring function
///
///car INTENDED USE: not in use
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score9()
{
	using namespace scorefxns;
	using namespace param_pack;

	score_reset_weights();
	fa_scorefxn = true;

	vdw_weight = 1.0;
	env_weight = 1.0;
	pair_weight = 1.0;
	cb_weight = 1.0;
	sheet_weight = 1.0;
	ss_weight = 1.0;
	hs_weight = 1.0;
	rsigma_weight = 1.0;
	rg_weight = 3.0;
	pc_weight = 1.0;
	dipolar_weight = 1.0;
	if (get_score_contact_fullatom()) contact_prediction_weight = 1.0;
	ramachandran_weight = 0.1;

	pc_mode = cst_mode;
	ss_lowstrand = 1;
	ss_cutoff = 6;

	fa_atr_weight = lj_weight;
	fa_rep_weight = lj_weight*rep_reduce;
	fa_dun_weight = lj_weight;
	pack_wts.set_Whb_srbb(lj_weight);
	pack_wts.set_Whb_lrbb(lj_weight);

	score_apply_user_defined_reweights();
	return scorefxn();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score10
///
/// @brief
///car fullatom scoring function for jotter's fullatom relaxation protocol
///car no cbeta, vdw or rg
///
///car	some overcounting here:	 srbb,lrhb and rsigma all count main chain
///car	hydrogen bonds
///
///cj		updated score10 with new weights :: primarily influenced by bk.rep
///car INTENDED USE: not in use
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score10()
{
	using namespace param_pack;
	using namespace scorefxns;
	using namespace scores;

	score_reset_weights();
	fa_scorefxn = true;
	//	contribution
	env_weight		 =	2.0; //	 6.9%
	pair_weight		 =	2.0; //	 4.2%
	sheet_weight	 =	3.75; //	1.0%
	ss_weight			 =	1.0; //	 2.5%
	hs_weight			 = 15.0; //	 1.0%
	rsigma_weight	 =	3.0; //	 1.1%
	pc_weight			 =	cst_weight; //	n/c
	dipolar_weight =	dpl_weight; //	n/c
	if (get_score_contact_fullatom()) contact_prediction_weight = 1.0;

	pc_mode = cst_mode;
	ss_lowstrand = 0;
	ss_cutoff = 6;

	fa_atr_weight		 =	1.75; //	29.4%
	fa_rep_weight		 =	2.00 * rep_reduce; //	 46.8%
	fa_dun_weight		 =	1.0; //		1.6%
	fa_pair_weight	 = 25.0; //		2.2%
	pack_wts.set_Whb_srlrsc(0.250, 0.250, 0.125); // 2.6%, 2.6%, 0.4%

	ramachandran_weight = 0.1;

	float score10 = scorefxn();

	structure::functions::radius_gyration(rg, misc::total_residue); // evaluate but don't use

	score_apply_user_defined_reweights();

	return score10;
}



////////////////////////////////////////////////////////////////////////////////
/// @begin score11
///
/// @brief
///car INTENDED USE: not in use
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score11()
{
	using namespace scorefxns;

	score_reset_weights();
	fa_scorefxn = true;
	score_apply_user_defined_reweights();
	return scorefxn();
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score12
///
/// @brief
///bk fullatom scoring function for design
///car this is the same function as used by the packer except::
///car				 no rama score in packer
///car				 rep_weight not modified by rep_reduce in packer
///car				 includes constraints, chain_gaps if in use
///
///car INTENDED USE:	design, refinement
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
float
score12()
{
	using namespace param_pack;
	using namespace scorefxns;

	std::string protein_sstype;

	score_reset_weights();
	fa_scorefxn = true;

	splicemsd_weight = loop_weight;
	pc_weight = cst_weight;
	dipolar_weight = dpl_weight;
	ramachandran_weight = 0.2;
	if (get_score_contact_fullatom()) contact_prediction_weight = 1.0;

	// db 4-6-06	changed default long range hydrogen bonding weight to 1.0 for all sstypes.
	float hb_srbb_wt = 0.5;
	float hb_lrbb_wt = 1.0;
	if (get_input_lrhb_weight() > .01){
		hb_lrbb_wt=get_input_lrhb_weight();
	}

	if (get_input_srhb_weight() > .01){
		hb_srbb_wt=get_input_srhb_weight();
	}
	pack_wts.set_Whb_srlrsc(hb_srbb_wt, hb_lrbb_wt, 1.0);

	fa_atr_weight = 1.0;
	fa_rep_weight = 1.0 * rep_reduce;
	fa_dun_weight = 1.0;

	fa_pair_weight = 1.0;
	fa_solv_weight = 1.0;
	fa_gb_elec_weight = 1.0;
  fa_elec_weight = 1.0;
	fa_ref_weight = 1.0;
	if ( get_pH_packing_flag() ) fa_pH_weight = 1.0;
	fa_prob1b_weight = 0.5;
	fa_h2o_weight = 1.0;
	fa_plane_weight = 1.0; // plane score will be zero, though, unless you set Wplane_total = 1.0.

	disulf_cendist_weight = 5.0;
	disulf_bb_dih_weight = 3.0;
	disulf_cbdist_weight = 5.0;
	disulf_cacbcb_weight = 1.0;
	disulf_cacbcbca_weight = 3.0;

	barcode_weight = 1.0;
	barcode_energy_weight = 0.00001;
	taboo_weight = 1.0;

	if (score_get_vary_omega()){
		omega_weight=get_omega_weight();
	} else {
		omega_weight=0.0;
	}

	score_apply_user_defined_reweights();

	electron_density_weight = 1.0;

	return scorefxn();
}


/////////////////////////////////////////////////////////////////////////
// New full atom scorefxn
// This scorefxn has GBSA model in lieu of LK solvation model (fa_solv)
// The 'rama' term has been excluded
// The hb_lrbb_weight, hb_srbb_weight, hb_sc_weight has been assigned
// separately for the protein types a, b, ab and xx.
// These weights have been obtained from a statistical refitting procedure
// on a set of 54 proteins comprising 'a', 'b', 'ab' types.
// - Vatsan Raman
////////////////////////////////////////////////////////////////////////

float
score13()
{
	using namespace param_pack;
	using namespace scorefxns;
	std::string protein_sstype;

	score_reset_weights();
	fa_scorefxn = true;

	splicemsd_weight = loop_weight;
	pc_weight = cst_weight;
	dipolar_weight = dpl_weight;
	ramachandran_weight = 0.0;
	contact_prediction_weight = 1.0;

	float hb_lrbb_wt(0.0), hb_srbb_wt(0.0), hb_sc_wt(0.0);

	protein_sstype = get_protein_sstype();
	if ( protein_sstype == "a" ) {
		hb_srbb_wt = 0.4;
		hb_lrbb_wt = 0.1;
		hb_sc_wt =	 2.5;
	} else if ( protein_sstype == "b" ) {
		hb_srbb_wt = 0.1;
		hb_lrbb_wt = 1.1;
		hb_sc_wt =	 0.3;
	} else if ( protein_sstype == "ab" ) {
		hb_srbb_wt = 0.1;
		hb_lrbb_wt = 0.7;
		hb_sc_wt =	 0.7;
	} else if ( protein_sstype == "xx" ) {
		hb_srbb_wt = 0.1;
		hb_lrbb_wt = 0.7;
		hb_sc_wt =	 0.8;
	}
	pack_wts.set_Whb_srlrsc(hb_srbb_wt, hb_lrbb_wt, hb_sc_wt);

	fa_atr_weight = 1.0;
	fa_rep_weight = 1.0*rep_reduce;
	fa_dun_weight = 0.5;
	fa_solv_weight = 0.0;

	fa_pair_weight = 0.0;
	fa_gb_elec_weight = 1.3;
	fa_ref_weight = 1.0;
	if ( get_pH_packing_flag() ) fa_pH_weight = 1.0;
	fa_prob1b_weight = 2.0;
	fa_h2o_weight = 1.0;
	fa_plane_weight = 1.0; // plane score will be zero, though, unless you set Wplane_total = 1.0.

	sasa_weight = 0.05;

  fa_elec_weight = 1.0;

	disulf_cendist_weight = 5.0;
	disulf_bb_dih_weight = 3.0;
	disulf_cbdist_weight = 5.0;
	disulf_cacbcb_weight = 1.0;
	disulf_cacbcbca_weight = 3.0;

	score_apply_user_defined_reweights();

	return scorefxn();

}

/////////////////////////////////////////////////////////////////////////
// score14 is identical to score12 except that a surface area term is added in
// to model the cavity free energy.
/////////////////////////////////////////////////////////////////////////

float
score14()
{
	using namespace param_pack;
	using namespace scorefxns;

	std::string protein_sstype;

	score_reset_weights();
	fa_scorefxn = true;

	splicemsd_weight = loop_weight;
	pc_weight = cst_weight;
	dipolar_weight = dpl_weight;
	ramachandran_weight = 0.2;
	contact_prediction_weight = 1.0;

	float hb_lrbb_wt(0.0), hb_srbb_wt(0.0);
	protein_sstype = get_protein_sstype();
	if ( get_ss_independent_hb_wt()) {
		hb_srbb_wt = 0.3;
		hb_lrbb_wt = 1.0;
	} else if ( protein_sstype == "xx" ) {
		hb_srbb_wt = 0.5;
		hb_lrbb_wt = 1.0;
	} else if ( protein_sstype == "a" ) {
		hb_srbb_wt = 0.5;
		hb_lrbb_wt = 1.0;
	} else {
		hb_lrbb_wt = 2.0;
		hb_srbb_wt = 0.5;
	}

	// temporary for testing //
	if (get_input_lrhb_weight() > .01){
		hb_lrbb_wt=get_input_lrhb_weight();
	}

	if (get_input_srhb_weight() > .01){
		hb_srbb_wt=get_input_srhb_weight();
	}

	pack_wts.set_Whb_srlrsc(hb_srbb_wt, hb_lrbb_wt, 1.0);

	fa_atr_weight = 1.0;
	fa_rep_weight = 1.0 * rep_reduce;
	fa_dun_weight = 1.0;

	fa_pair_weight = 1.0;
	fa_solv_weight = 1.0;
	fa_gb_elec_weight = 1.0;
  fa_elec_weight = 1.0;
	fa_ref_weight = 1.0;
	if ( get_pH_packing_flag() ) fa_pH_weight = 1.0;
	fa_prob1b_weight = 0.5;
	fa_h2o_weight = 1.0;
	fa_plane_weight = 1.0; // plane score will be zero, though, unless you set Wplane_total = 1.0.

	disulf_cendist_weight = 5.0;
	disulf_bb_dih_weight = 3.0;
	disulf_cbdist_weight = 5.0;
	disulf_cacbcb_weight = 1.0;
	disulf_cacbcbca_weight = 3.0;

	barcode_weight = 1.0;
	taboo_weight = 1.0;

	if (score_get_vary_omega()){
		omega_weight=get_omega_weight();
	} else {
		omega_weight=0.0;
	}

	sasa_weight = 0.03;

	score_apply_user_defined_reweights();

	return scorefxn();
}


float
score99()
{
	using namespace scorefxns;

	score_reset_weights();
	vdw_weight = 1.0;
	rms_weight = 10.0;

	score_apply_user_defined_reweights();

	return scorefxn();
}

/////////////////////////////////////////////////////////////////////////////////
float
score_by_weight_map(
										const pose_ns::Score_weight_map & weight_map
										)
{
	using namespace scorefxns;
	using namespace pose_ns;

	score_set_weight_map_weights( weight_map );
	return scorefxn();
}

/////////////////////////////////////////////////////////////////////////////////
void
score_set_weight_map_weights(
														 const pose_ns::Score_weight_map & weight_map
														 )
{
	using namespace param_pack;
	using namespace scorefxns;
	using namespace pose_ns;

	score_reset_weights();

	// include handling of these things into the map:
	fa_scorefxn = false;
	bbonly_scorefxn = false;
	dock_scorefxn = false;
	domain_scorefxn = false;
	loop_scorefxn = false;

	// centroid terms:
	vdw_weight = weight_map.get_weight( VDW );
	env_weight = weight_map.get_weight( ENV );
	pair_weight = weight_map.get_weight( PAIR );
	cb_weight = weight_map.get_weight( CB );
	sheet_weight = weight_map.get_weight( SHEET );
	ss_weight = weight_map.get_weight( SSPAIR );
	hs_weight = weight_map.get_weight( HS );
	rsigma_weight = weight_map.get_weight( RSIGMA );
	ramachandran_weight = weight_map.get_weight( RAMACHANDRAN );
	rg_weight = weight_map.get_weight( RG );
	co_weight = weight_map.get_weight( CO );
	barcode_weight = weight_map.get_weight( BARCODE );
	barcode_energy_weight = weight_map.get_weight( BARCODE_ENERGY );
	contact_prediction_weight = weight_map.get_weight( CONTACT_MJ );

	// jumping chainbreak
	jmp_chainbreak_weight = weight_map.get_weight( CHAINBREAK );
	set_jmp_chainbreak_overlap( int ( weight_map.get_weight( CHAINBREAK_OVERLAP,
																													 0.0 ) ) );
	int size;
	if( weight_map.has_1D_weight( CUT_WEIGHT, size ) ) {
		if ( int( cut_weight.size1()) != size ) cut_weight.dimension( size );
		cut_weight = weight_map.get_1D_weight( CUT_WEIGHT );
		//chu
	}

	// pose-style constraints
	atompair_cst_weight = weight_map.get_weight( ATOMPAIR_CST ); // atompairs
	coord_cst_weight = weight_map.get_weight( COORD_CST ); // atompairs
	chainbreak_cst_weight = weight_map.get_weight( CHAINBREAK_CST ); // atompairs
	phipsi_cst_weight = weight_map.get_weight( PHIPSI_CST ); // torsions
	omega_cst_weight = weight_map.get_weight( OMEGA_CST );
	chi_cst_weight = weight_map.get_weight( CHI_CST );
	kin_1D_cst_weight = weight_map.get_weight( KIN_1D_CST );
	kin_3D_cst_weight = weight_map.get_weight( KIN_3D_CST );

	// symmetry
	symm_weight = weight_map.get_weight( SYMM );
	extra_weight = weight_map.get_weight( EXTRA );

	// backbone torsion tethers
	phipsi_weight = weight_map.get_weight( PHIPSI );
	omega_weight = weight_map.get_weight( OMEGA );

	// torsion tether? this would be most consistent with phipsi/omega
	// no one seems to care anymore.
	tether_weight = weight_map.get_weight( TETHER );

	dna_bs_weight = weight_map.get_weight( DNA_BS );
	dna_bp_weight = weight_map.get_weight( DNA_BP );

	rna_bs_weight = weight_map.get_weight( RNA_BS );
	rna_bp_w_weight = weight_map.get_weight( RNA_BP_W );
	rna_bp_h_weight = weight_map.get_weight( RNA_BP_H );
	rna_bp_s_weight = weight_map.get_weight( RNA_BP_S );
	rna_axis_weight = weight_map.get_weight( RNA_AXIS );
	rna_stagger_weight = weight_map.get_weight( RNA_STAGGER );
	rna_bulge_weight = weight_map.get_weight( RNA_BULGE );
	rna_nonbasebase_weight = weight_map.get_weight( RNA_NONBASEBASE );
	rna_o2star_weight = weight_map.get_weight( RNA_O2STAR );
	rna_phosphate_weight = weight_map.get_weight( RNA_PHOSPHATE );
	rna_contact_weight = weight_map.get_weight( RNA_CONTACT );
	rna_long_range_contact_weight = weight_map.get_weight( RNA_LONG_RANGE_CONTACT );
	rna_sasa_weight = weight_map.get_weight( RNA_SASA );

	ss_lowstrand = int ( weight_map.get_weight( SS_LOWSTRAND, 1 ) );
	ss_cutoff = int ( weight_map.get_weight( SS_CUTOFF, 6 ) );
	pc_mode = int ( weight_map.get_weight( PC_MODE, cst_mode ) );
	pc_weight = weight_map.get_weight( CST_SCORE );
	cst_weight = weight_map.get_weight( CST_SCORE );

	electron_density_weight = weight_map.get_weight( EDENSITY );

	// fullatom terms
	fa_atr_weight = weight_map.get_weight( FA_ATR );
	fa_rep_weight = weight_map.get_weight( FA_REP ) * rep_reduce;
	fa_solv_weight = weight_map.get_weight( FA_SOL );
	fa_pair_weight = weight_map.get_weight( FA_PAIR );
	fa_ref_weight = weight_map.get_weight( FA_REF );
	fa_prob1b_weight = weight_map.get_weight( FA_PROB );
	fa_dun_weight = weight_map.get_weight( FA_DUN );
	float const hb_srbb_wt = weight_map.get_weight( HB_SRBB );
	float const hb_lrbb_wt = weight_map.get_weight( HB_LRBB );
	float const hb_sc_wt = weight_map.get_weight( HB_SC );
	param_pack::pack_wts.set_Whb_srlrsc(hb_srbb_wt, hb_lrbb_wt, hb_sc_wt);

	fa_gb_elec_weight = weight_map.get_weight( GB );
  fa_elec_weight    = weight_map.get_weight( FA_ELEC );
	fa_h2o_weight = weight_map.get_weight( FA_H2O );
	fa_plane_weight = weight_map.get_weight( PLANE );
	sidechain_bond_angle_weight = weight_map.get_weight( SIDECHAIN_BOND_ANGLE );

	if ( std::abs( weight_map.get_weight( FA_SCOREFXN ) ) > 0.1 ) {
		fa_scorefxn = true;
	}

	// unideal bond terms
	bond_angle_weight = weight_map.get_weight( BOND_ANGLE );

	// this is used if we have a fullatom pose but only want to score
	// centroid/backbone terms such as bb hbonds. Ie we don't want
	// to call fullatom_energy...
	if ( std::abs( weight_map.get_weight( BBONLY_SCOREFXN ) ) > 0.1 ) {
		bbonly_scorefxn = true;
	}
	// Similar, useful flag for just RNA terms.
	if ( std::abs( weight_map.get_weight( RNAONLY_SCOREFXN ) ) > 0.1 ) {
		rnaonly_scorefxn = true;
	}

	//chu docking specific
	docking_env_weight = weight_map.get_weight( DOCK_ENV );
	docking_pair_weight = weight_map.get_weight( DOCK_PAIR );
	docking_contact_weight = weight_map.get_weight( DOCK_CONT );
	docking_contact_cap = weight_map.get_weight( DOCK_CONT_CAP );
	docking_vdw_weight = weight_map.get_weight( DOCK_VDW );
	docking_sc_weight = weight_map.get_weight( DOCK_SITE_CST );
	docking_fab_weight = weight_map.get_weight( DOCK_FAB );
	docking_fab_cap = weight_map.get_weight( DOCK_FAB_CAP );
	docking_warshel_elec_weight = weight_map.get_weight( DOCK_WSL_ELEC );

	//Monica Berrondo domain insertion specific
	domain_contact_weight = weight_map.get_weight( DOM_CONT );
	domain_contact_cap = weight_map.get_weight( DOM_CONT_CAP );
	domain_dc_weight = weight_map.get_weight( DOM_DIST_CST );
	domain_vdw_weight = weight_map.get_weight( DOM_VDW );

	loop_contact_weight = weight_map.get_weight( LOOP_CONTACT ); // aroop

	if ( std::abs( weight_map.get_weight( DOCK_SCOREFXN ) ) > 0.1 ) {
		dock_scorefxn = true;
	}

	if ( std::abs( weight_map.get_weight( DOM_SCOREFXN ) ) > 0.1 ) {
		domain_scorefxn = true;
	}

	if ( std::abs( weight_map.get_weight( LOOP_SCOREFXN ) ) > 0.1 ) {
		loop_scorefxn = true;
	}

	//dummy model for cryo-EM
	dummy_model_weight = weight_map.get_weight( DUMMY_MODEL );

	score_apply_user_defined_reweights();
}

///////////////////////////////////////////////////////////////////////////////
// copy the hard-coded weights in score_fxn into a weight_map
// for pose-specific stuff
//
void
setup_score_weight_map(
											 pose_ns::Score_weight_map & weight_map,
											 Scoring_Function score_fxn
											 )
{
	scorefxns::no_evaluation = true;
	score_fxn(); // fill the weights
	copy_current_score_weights_to_weight_map( weight_map );
}

///////////////////////////////////////////////////////////////////////////////
// this is still a pretty minimal set of weights
// limited to things that are in score_name.h and that I have
// tested with the pose stuff. Should be kept in sync with
// the routine, score_set_weight_map_weights.
// PB 2005-09-01

void
copy_current_score_weights_to_weight_map(
																				 pose_ns::Score_weight_map & weight_map
																				 )
{
	using namespace param_pack;
	using namespace scorefxns;
	using namespace pose_ns;

	weight_map.clear();

	// fullatom scorefxn?
	if ( fa_scorefxn ) weight_map.set_weight( FA_SCOREFXN, 1.0 );

	// fullatom pose but we only want centroid terms?
	if ( bbonly_scorefxn ) weight_map.set_weight( BBONLY_SCOREFXN, 1.0 ); // JSS this is circular with score_set_weight_map_weights above (fix?)
	if ( rnaonly_scorefxn ) weight_map.set_weight( RNAONLY_SCOREFXN, 1.0 );

	// centroid terms:
	weight_map.set_weight( VDW , vdw_weight );
	weight_map.set_weight( ENV , env_weight );
	weight_map.set_weight( PAIR , pair_weight );
	weight_map.set_weight( CB , cb_weight );
	weight_map.set_weight( SHEET , sheet_weight );
	weight_map.set_weight( SSPAIR , ss_weight );
	weight_map.set_weight( HS , hs_weight );
	weight_map.set_weight( RSIGMA , rsigma_weight );
	weight_map.set_weight( RAMACHANDRAN , ramachandran_weight );
	weight_map.set_weight( RG , rg_weight );
	weight_map.set_weight( CO , co_weight );
	weight_map.set_weight( BARCODE , barcode_weight );
	weight_map.set_weight( BARCODE_ENERGY , barcode_energy_weight );
	weight_map.set_weight( CONTACT_MJ, contact_prediction_weight );
	// jumping chainbreak, not set here
	// cut_weight, not set here //chu

	// pose-style constraints
	weight_map.set_weight( ATOMPAIR_CST , atompair_cst_weight ); // atompairs
	weight_map.set_weight( COORD_CST , coord_cst_weight ); // atompairs
	weight_map.set_weight( CHAINBREAK_CST , chainbreak_cst_weight ); // atompairs
	weight_map.set_weight( PHIPSI_CST , phipsi_cst_weight ); // torsions
	weight_map.set_weight( OMEGA_CST , omega_cst_weight );
	weight_map.set_weight( CHI_CST , chi_cst_weight );
	weight_map.set_weight( KIN_1D_CST , kin_1D_cst_weight );
	weight_map.set_weight( KIN_3D_CST , kin_3D_cst_weight );

	// symmetry
	weight_map.set_weight( SYMM , symm_weight );
	weight_map.set_weight( EXTRA , extra_weight );

	weight_map.set_weight( DNA_BS , dna_bs_weight );
	weight_map.set_weight( DNA_BP , dna_bp_weight );

	weight_map.set_weight( RNA_BS , rna_bs_weight );
	weight_map.set_weight( RNA_BP_W , rna_bp_w_weight );
	weight_map.set_weight( RNA_BP_H , rna_bp_h_weight );
	weight_map.set_weight( RNA_BP_S , rna_bp_s_weight );
	weight_map.set_weight( RNA_AXIS , rna_axis_weight );
	weight_map.set_weight( RNA_STAGGER , rna_stagger_weight );
	weight_map.set_weight( RNA_BULGE , rna_bulge_weight );
	weight_map.set_weight( RNA_NONBASEBASE , rna_nonbasebase_weight );
	weight_map.set_weight( RNA_O2STAR , rna_o2star_weight );
	weight_map.set_weight( RNA_PHOSPHATE , rna_phosphate_weight );
	weight_map.set_weight( RNA_CONTACT , rna_contact_weight );
	weight_map.set_weight( RNA_LONG_RANGE_CONTACT , rna_long_range_contact_weight );
	weight_map.set_weight( RNA_SASA , rna_sasa_weight );

	weight_map.set_weight( EDENSITY, electron_density_weight );
	// backbone torsion tethers, old-style
	weight_map.set_weight( PHIPSI , phipsi_weight );
	weight_map.set_weight( OMEGA , omega_weight );

	weight_map.set_weight( SS_LOWSTRAND, ss_lowstrand );
	weight_map.set_weight( SS_CUTOFF, ss_cutoff );
	weight_map.set_weight( PC_MODE, pc_mode );
	weight_map.set_weight( CST_SCORE, pc_weight );

	// fullatom terms
	weight_map.set_weight( FA_ATR , fa_atr_weight );
	if ( std::abs( rep_reduce ) > 0.001 ) {
		weight_map.set_weight( FA_REP, fa_rep_weight / rep_reduce );
	} else {
		std::cout << "WARNING: cant set FA_REP weight in weight_map " <<
			"because rep_reduce == 0.0. Setting weight to 1.0" << std::endl;
		weight_map.set_weight( FA_REP, 1.0 );
	}
	weight_map.set_weight( FA_SOL , fa_solv_weight );
	weight_map.set_weight( FA_PAIR , fa_pair_weight );
	weight_map.set_weight( FA_REF , fa_ref_weight );
	weight_map.set_weight( FA_PROB , fa_prob1b_weight );
	weight_map.set_weight( FA_DUN , fa_dun_weight );
	weight_map.set_weight( HB_SRBB , pack_wts.Whb_srbb() );
	weight_map.set_weight( HB_LRBB , pack_wts.Whb_lrbb() );
	weight_map.set_weight( HB_SC , pack_wts.Whb_sc() );
	weight_map.set_weight( GB, fa_gb_elec_weight );
  weight_map.set_weight( FA_ELEC, fa_elec_weight );
	weight_map.set_weight( FA_H2O, fa_h2o_weight );
	weight_map.set_weight( PLANE, fa_plane_weight );

	// unideal bond terms
	weight_map.set_weight( BOND_ANGLE, bond_angle_weight );
	weight_map.set_weight( SIDECHAIN_BOND_ANGLE, sidechain_bond_angle_weight );

	//chu docking specific
	if ( dock_scorefxn ) weight_map.set_weight( DOCK_SCOREFXN, 1.0 );
	weight_map.set_weight( DOCK_ENV, docking_env_weight );
	weight_map.set_weight( DOCK_PAIR, docking_pair_weight );
	weight_map.set_weight( DOCK_CONT, docking_contact_weight );
	weight_map.set_weight( DOCK_CONT_CAP, docking_contact_cap );
	weight_map.set_weight( DOCK_VDW, docking_vdw_weight );
	weight_map.set_weight( DOCK_SITE_CST, docking_sc_weight );
	weight_map.set_weight( DOCK_FAB, docking_fab_weight );
	weight_map.set_weight( DOCK_FAB_CAP, docking_fab_cap );
	weight_map.set_weight( DOCK_WSL_ELEC, docking_warshel_elec_weight );

  weight_map.set_weight( FA_ELEC, fa_elec_weight );

// Monica Berrondo domain insertion specific
	if ( domain_scorefxn ) weight_map.set_weight( DOM_SCOREFXN, 1.0 );
	weight_map.set_weight( DOM_CONT, domain_contact_weight );
	weight_map.set_weight( DOM_CONT_CAP, domain_contact_cap );
	weight_map.set_weight( DOM_DIST_CST, domain_dc_weight );
	weight_map.set_weight( DOM_VDW, domain_vdw_weight );

	if ( loop_scorefxn ) weight_map.set_weight ( LOOP_SCOREFXN, 1.0 );
	weight_map.set_weight( LOOP_CONTACT, loop_contact_weight );

	//dummy model for cryo-EM
	weight_map.set_weight( DUMMY_MODEL , dummy_model_weight );

}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
/// @begin score_reset_weights
///
/// @brief
///
/// @detailed
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_reset_weights()
{
	using namespace scorefxns;

	fa_scorefxn = false;
	bbonly_scorefxn = false;
	rnaonly_scorefxn = false;
	dock_scorefxn = false;

	vdw_weight = 0.0;
	env_weight = 0.0;
	pair_weight = 0.0;
	cb_weight = 0.0;
	sheet_weight = 0.0;
	ss_weight = 0.0;
	hs_weight = 0.0;
	rsigma_weight = 0.0;
	ramachandran_weight = 0.0;
	contact_prediction_weight = 0.0;
	rg_weight = 0.0;
	co_weight = 0.0;
	pc_weight = 0.0;
	dipolar_weight = 0.0;
	projection_weight = 0.0;
	splicemsd_weight = 0.0;
	atompair_cst_weight = 0.0; // PB
	coord_cst_weight = 0.0; // PB
	chainbreak_cst_weight = 0.0; // PB
	phipsi_cst_weight = 0.0; // PB
	omega_cst_weight = 0.0; // PB
	chi_cst_weight = 0.0; // PB

	pc_mode = cst_mode;
	ss_lowstrand = 1;
	ss_cutoff = 6;

	param_pack::pack_wts.set_Whb_srlrsc(0.0, 0.0, 0.0);

	fa_atr_weight = 0.0;
	fa_rep_weight = 0.0;
	fa_dun_weight = 0.0;
	fa_pair_weight = 0.0;
	fa_plane_weight = 0.0;
	fa_solv_weight = 0.0;
	fa_gb_elec_weight = 0.0;
  fa_elec_weight = 0.0;
	fa_ref_weight = 0.0;
	fa_pH_weight = 0.0;
	fa_prob1b_weight = 0.0;
	fa_h2o_weight	 =	0.0;
	sidechain_bond_angle_weight = 0.0;

	docking_vdw_weight = 0.0;
	docking_env_weight = 0.0;
	docking_pair_weight = 0.0;
	docking_contact_weight = 0.0;
	docking_contact_cap = -999.9;
	docking_sc_weight = 0.0;
	docking_fab_weight = 0.0;
	docking_fab_cap = -999.9;
	docking_warshel_elec_weight = 0.0;

	ex_gsolt_weight = 0.0;
	sasa_weight = 0.0;
	ex_ponpf_weight = 0.0;

	disulfide_distance_weight = 0.0;
	disulfide_csangles_weight = 0.0;
	disulfide_dihedral_weight = 0.0;
	disulfide_ca_dihedral_weight = 0.0;
	disulfide_cbs_dist_weight = 0.0;
	disulf_cendist_weight = 0.0;
	disulf_cbdist_weight = 0.0;
	disulf_bb_dih_weight = 0.0;
	disulf_ca_minus_cen_weight = 0.0;
	disulf_cacbcb_weight = 0.0;
	disulf_cacbcbca_weight = 0.0;
	disulf_Ncen_weight = 0.0;
	disulf_Ncb_weight = 0.0;
	disulf_Nfa_weight = 0.0;

	barcode_weight = 0.0;

	tether_weight = 0.0;
	phipsi_weight = 0.0;
	omega_weight = 0.0;

	bond_angle_weight = 0.0;

	symm_weight = 0.0;
	extra_weight = 0.0;
	jmp_chainbreak_weight = 0.0; // PB: 09/14/05

	dna_bs_weight = 0.0;
	dna_bp_weight = 0.0;

	rna_bs_weight = 0.0;
	rna_bp_w_weight = 0.0;
	rna_bp_h_weight = 0.0;
	rna_bp_s_weight = 0.0;
	rna_axis_weight = 0.0;
	rna_stagger_weight = 0.0;
	rna_bulge_weight = 0.0;
	rna_nonbasebase_weight = 0.0;
	rna_o2star_weight = 0.0;
	rna_phosphate_weight = 0.0;
	rna_contact_weight = 0.0;
	rna_long_range_contact_weight = 0.0;
	rna_sasa_weight = 0.0;

	if ( cut_weight.size1() > 0 ) cut_weight = 1.0; // chu
	rms_weight = 0.0;

	dummy_model_weight = 0.0;
	saxs_model_weight	 = 0.0;
}

//cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
//------------------------------------------------------------------------------
//		SCORE interface
//------------------------------------------------------------------------------
//cccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc

//------------------------------------------------------------------------------
//car	 functions score_set_XXX set weights/params that are passed to scorefxn
//car	 via scoreX. After setting weights via these methods, scoreX must be called
//car	 in order for these values to be passed to scorefxn.	If scorefxn is called
//car	 directly after setting these weights by method, the weights will NOT be
//car	 used by scorefxn. These parameters are referred to as external weights because
//car	 they are external to the function scorefxn.

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_lj_weight
///
/// @brief
///
/// @detailed
///
/// @param	weight_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_lj_weight( float weight_x )
{
	using namespace scorefxns;

	lj_weight = weight_x;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_lj_rep_weight
///
/// @brief
///
/// @detailed
///
/// @param	weight_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_lj_rep_weight( float weight_x )
{
	using namespace scorefxns;

	rep_reduce = weight_x;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_cst_weight
///
/// @brief
///
/// @detailed
///
/// @param	weight_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_cst_weight( float weight_x )
{
	using namespace scorefxns;

	cst_weight = weight_x;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_cst_mode
///
/// @brief
///
/// @detailed
///
/// @param	mode_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_cst_mode( int mode_x )
{
	using namespace scorefxns;

	cst_mode = mode_x;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_dpl_weight
///
/// @brief
///
/// @detailed
///
/// @param	weight_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_dpl_weight( float weight_x )
{
	using namespace scorefxns;

	dpl_weight = weight_x;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_loop_weight
///
/// @brief
///
/// @detailed
///
/// @param	weight_x - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///	 differs from other score_set_ functions by setting both
///	 the internal and external weights; required so that the loop
///	 term can be turned off in output_decoy
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_loop_weight( float weight_x )
{
	using namespace scorefxns;

	loop_weight = weight_x;
	splicemsd_weight = loop_weight;
}


void
score_set_motif_tether_weight( float weight_x )
{
	using namespace scorefxns;

	motif_tether_weight = weight_x;
}


//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//car	 functions scorefxn_set_XX directly set a weight used in scorefxn.
//car	 Calling these functions will have no effect if scoreX is in use
//car	 because the values set by method will be overwritten by scoreX; scorefxn
//car	 must be called directly (with no intervening calls to scoreX) for
//car	 values set by these methods to be in effect.	 As soon as scoreX
//car	 is called, these values for weights cease to be in effect.	 These
//car	 parameters are referred to as internal weights because they are unsed
//car	 internally within scorefxn.

////////////////////////////////////////////////////////////////////////////////
/// @begin scorefxn_set_tether_weight
///
/// @brief
///
/// @detailed
///
/// @param	weight - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
scorefxn_set_tether_weight( float weight )
{
	using namespace scorefxns;

	tether_weight = weight;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin scorefxn_set_torsion_weight
///
/// @brief
///
/// @detailed
///
/// @param	phipsi_wt - [in/out]? -
/// @param	omega_wt - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
scorefxn_set_torsion_weight(
														float phipsi_wt,
														float omega_wt
														)
{
	using namespace scorefxns;

	phipsi_weight = phipsi_wt;
	omega_weight = omega_wt;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin scorefxn_set_rama_weight
///
/// @brief
///
/// @detailed
///
/// @param	weight - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
scorefxn_set_rama_weight( float weight )
{
	using namespace scorefxns;

	ramachandran_weight = weight;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin scorefxn_set_bump_weight
///
/// @brief
///car relative weight of bumps for idealization
///
/// @detailed
///
/// @param	weight - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
scorefxn_set_bump_weight( float weight )
{
	using namespace scorefxns;

	if ( get_fullatom_flag() ) {
		fa_scorefxn = true;
		fa_atr_weight = weight;
		fa_rep_weight = weight;
		vdw_weight = 0.0;
	} else {
		fa_scorefxn = false;
		fa_atr_weight = 0.0;
		fa_rep_weight = 0.0;
		vdw_weight = weight*1.25; // compensate for weight in vdw_compute
	}
}

//------------------------------------------------------------------------------
// methods to set scorefxn flags/options
//	 These settings are effective for calls to either scorefxn or scoreX

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_try_rotamers
///
/// @brief
///car should score functions call rotamer trials?
///car this function should be called from main protocols
///
/// @detailed
///
/// @param	setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_try_rotamers( bool setting )
{
	using namespace scorefxns;

	try_rotamers_default = setting;
	try_rotamers = setting;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score_get_try_rotamers
///
/// @brief
///car should score functions call rotamer trials?
///car this function should be called from main protocols
///
/// @detailed
///
/// @return
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
bool
score_get_try_rotamers()
{
	using namespace scorefxns;

	return try_rotamers;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score_enable_rotamer_trials
///
/// @brief
///car enable/disable rotamer trials independent of how try_rotamers
///car was set by score_set_try_rotamers;
///car should be called by functions that need to ensure that
///car rotamer trials is off and then return to the user-defined setting
///
/// @detailed
///
/// @param	enable - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_enable_rotamer_trials( bool enable )
{
	using namespace scorefxns;

	if ( enable ) {
		try_rotamers = try_rotamers_default;
	} else {
		try_rotamers = false;
	}
}
////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_use_subset_energy
///
/// @brief
///
/// @detailed
///
/// @param	setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///car rotamer trials not allowed in subset ener
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_use_subset_energy( bool setting )
{
	using namespace scorefxns;

	use_subset_energy = setting;
	//do not use subset energies and rotamer_trials together!!
	//car (I wish I could recall exactly why...) 11/15/2004
	//Heres Brian Kuhlmans comments on why:
	//	Here is my guess.	 In general, subset energies was designed to be used
	// during minimization and rotamer_trials is not designed to work during
	// minimization.	I think more specifically, subset energies sets the energies
	// of some residues to zero.	Rotamer_trials uses these saved energies when
	// deciding whether to move a residue, and when calculating the energy of the
	// current rotamer (to avoid repeating a calculation that has just been
	// performed).	So rotamer_trials cant work properly if some things are set to
	// zero.	I guess this could be fixed by allowing rotamer trials to only work
	// on residues that were counted while in subset mode - but do we want rotamer
	// trials during minimization anyway?

	assert( ! use_subset_energy || ! score_get_try_rotamers() );
}
////////////////////////////////////////////////////////////////////////////
/// @begin score_set_evaluate_all_terms
///
/// @brief
///
/// @detailed
///
/// @param	setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_evaluate_all_terms( bool setting )
{
	using namespace scorefxns;

	evaluate_all_terms = setting;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_vary_omega
///
/// @brief
///car should score functions evaluate omega score?
///car this function should be called from main protocols
///
/// @detailed
///
/// @param	setting - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_vary_omega( bool setting )
{
	using namespace scorefxns;

	vary_omega = setting;

}

bool
score_get_vary_omega()
{
	using namespace scorefxns;

	return vary_omega;

}

//------------------------------------------------------------------------------
//	utility methods

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_new_pose
///
/// @brief
///
/// @detailed
///car notify scorefxn that a new structure is in the arrays and
///car internal info shouldn't be used
///car this allows a new position array to be scored, but the internal
///car array data is not updated
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_new_pose()
{
	maps_set_new_pose();

	if ( get_use_nblist() ) { //if using nblist, update now before scoring
		update_cendist(misc::total_residue, misc::centroid);
		update_nblist();
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin dump_scorefxn_weights
///
/// @brief
///
/// @detailed
///
/// @param	iunit - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
dump_scorefxn_weights( std::ostream & iunit )
{
	using namespace param_pack;
	using namespace scorefxns;

	iunit << "---------flags-----------" << std::endl;
	iunit << "eval all " << SS( evaluate_all_terms ) << std::endl;
	iunit << "no eval	 " << SS( no_evaluation ) << std::endl;
	iunit << "try rot	 " << SS( try_rotamers ) << std::endl;
	iunit << "trot dflt" << SS( try_rotamers_default ) << std::endl;
	iunit << "subset	 " << SS( use_subset_energy ) << std::endl;
	iunit << "fa_scfxn " << SS( fa_scorefxn ) << std::endl;
	iunit << "mc_presc " << SS( use_mc_prescore ) << std::endl;

	iunit << "------external wts-------" << std::endl;
	iunit << "lj			 " << SS( lj_weight ) << std::endl;
	iunit << "cst			 " << SS( cst_weight ) << std::endl;
	iunit << "dpl			 " << SS( dpl_weight ) << std::endl;
	iunit << "rep red	 " << SS( rep_reduce ) << std::endl;
	iunit << "cst mode " << SS( cst_mode ) << std::endl;

	iunit << "-----centroid wts--------" << std::endl;
	iunit << "vdw			 " << SS( vdw_weight ) << std::endl;
	iunit << "env			 " << SS( env_weight ) << std::endl;
	iunit << "pair		 " << SS( pair_weight ) << std::endl;
	iunit << "cb			 " << SS( cb_weight ) << std::endl;
	iunit << "sheet		 " << SS( sheet_weight ) << std::endl;
	iunit << "ss			 " << SS( ss_weight ) << std::endl;
	iunit << "hs			 " << SS( hs_weight ) << std::endl;
	iunit << "rsigma	 " << SS( rsigma_weight ) << std::endl;
	iunit << "hb_lrbb	 " << SS( pack_wts.Whb_lrbb() ) << std::endl;
	iunit << "hb_srbb	 " << SS( pack_wts.Whb_srbb() ) << std::endl;
	iunit << "rama		 " << SS( ramachandran_weight ) << std::endl;
	iunit << "rg			 " << SS( rg_weight ) << std::endl;
	iunit << "co			 " << SS( co_weight ) << std::endl;
	iunit << "pc			 " << SS( pc_weight ) << std::endl;
	iunit << "dipolar	 " << SS( dipolar_weight ) << std::endl;
	iunit << "pc mode	 " << SS( pc_mode ) << std::endl;
	iunit << "low strnd" << SS( ss_lowstrand ) << std::endl;
	iunit << "ss cutoff" << SS( ss_cutoff ) << std::endl;
	iunit << "loop		 " << SS( loop_weight ) << std::endl;

	if ( fa_scorefxn ) {

		iunit << "------fullatom wts-------" << std::endl;
		iunit << "atr			 " << SS( fa_atr_weight ) << std::endl;
		iunit << "rep			 " << SS( fa_rep_weight ) << std::endl;
		iunit << "dun			 " << SS( fa_dun_weight ) << std::endl;
		iunit << "pair		 " << SS( fa_pair_weight ) << std::endl;
		iunit << "plane		 " << SS( fa_plane_weight ) << std::endl;
		iunit << "solv		 " << SS( fa_solv_weight ) << std::endl;
		iunit << "ref			 " << SS( fa_ref_weight ) << std::endl;
		iunit << "pH			 " << SS( fa_pH_weight ) << std::endl;
		iunit << "gb_elec	 " << SS( fa_gb_elec_weight ) << std::endl;
		iunit << "prob1b	 " << SS( fa_prob1b_weight ) << std::endl;
		iunit << "h2o			 " << SS( fa_h2o_weight ) << std::endl;
		iunit << "hb_sc		 " << SS( pack_wts.Whb_sc() ) << std::endl;
		iunit << "gsolt		 " << SS( ex_gsolt_weight ) << std::endl;
		iunit << "ponpf		 " << SS( ex_ponpf_weight ) << std::endl;
    iunit << "elec     " << SS( fa_elec_weight ) << std::endl;
		iunit << "----unideal bond wts-----" << std::endl;
		iunit << "bond_angle " << SS( bond_angle_weight ) << std::endl;
	}

	if ( dock_scorefxn ) {

		iunit << "-------docking wts--------" << std::endl;
		iunit << "env			 " << SS( docking_env_weight ) << std::endl;
		iunit << "pair		 " << SS( docking_pair_weight ) << std::endl;
		iunit << "contact	 " << SS( docking_contact_weight ) << std::endl;
		iunit << "cntct cap" << SS( docking_contact_cap ) << std::endl;
		iunit << "vdw			 " << SS( docking_vdw_weight ) << std::endl;
		iunit << "sc			 " << SS( docking_sc_weight ) << std::endl;
		iunit << "fab			 " << SS( docking_fab_weight ) << std::endl;
		iunit << "fab cap	 " << SS( docking_fab_cap ) << std::endl;
		iunit << "warshel elec" << SS( docking_warshel_elec_weight ) << std::endl;
	}

	iunit << "---disulf cent weights---" << std::endl;
	iunit << "ss_cendist	" << SS( disulf_cendist_weight ) << std::endl;
	iunit << "ss_cbdist		" << SS( disulf_cbdist_weight ) << std::endl;
	iunit << "ss_bbdih		" << SS( disulf_bb_dih_weight ) << std::endl;
	iunit << "ss_camincen " << SS( disulf_ca_minus_cen_weight ) << std::endl;
	iunit << "ss_cacbcb		" << SS( disulf_cacbcb_weight ) << std::endl;
	iunit << "ss_cacbcbca " << SS( disulf_cacbcbca_weight ) << std::endl;

	iunit << "---tether weights---" << std::endl;
	iunit << "tether			" << SS( tether_weight ) << std::endl;
	iunit << "phipsi			" << SS( phipsi_weight ) << std::endl;
	iunit << "omega				" << SS( omega_weight ) << std::endl;

}

////////////////////////////////////////////////////////////////////////////////
/// @begin score_set_default_function
///
/// @brief
///
/// @detailed
///car set the default scoring function (by calling it once)
///car after calling this function, calling scorefxn() will
///car result in the default scoring function effectively
///car being used.
///
///car !!WARNING!! Once a different score function is called
///car			this default is no longer in effect!!!
///
///car mode-specific default behavior can be set here
///
///car fullatom is passed as an argument rather than retrieved from
///car the global fullatom flag (get_fullatom_flag) so that the
///car the default function can be set to a fullatom function even
///car if fullatom mode isn't yet activated (as happens in scoring
///car the native and starting structures in the initialize functions)
///
/// @param	fullatom - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
score_set_default_function( bool fullatom )
{
	using namespace scorefxns;

	//car local
	float score;

	no_evaluation = true;

	if ( !fullatom ) {
		if ( default_scorefxn == 0 ) {
			score = score0();
		} else if ( default_scorefxn == score_1 ) {
			score = score1();
		} else if ( default_scorefxn == score_2 ) {
			score = score2();
		} else if ( default_scorefxn == score_3 ) {
			score = score3();
		} else if ( default_scorefxn == score_4 ) {
			score = score4();
		} else if ( default_scorefxn == score_5 ) {
			score = score5();
		} else if ( default_scorefxn == score_6 ) {
			score = score6();
		} else if ( default_scorefxn == score_7 ) {
			score = score7();
		} else if ( default_scorefxn == score_8 ) {
			score = score8();
		} else if ( default_scorefxn == score_4d ) {
			score = score4d();
		} else if ( default_scorefxn == score_3L ) {
			score = score3L();
		} else if ( default_scorefxn == score_4L ) {
			score = score4L();
		} else if ( default_scorefxn == score_8di ) {
			score = score8di();
		} else if ( default_scorefxn == score_4Lc ) {
			score = score4Lc();
		} else {
			std::cout << "STOPPING:: invalid default_scorefxn: " <<
				default_scorefxn << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
	} else if ( fullatom ) {
		if ( default_fascorefxn == score_0 ) {
			score = score0();
		} else if ( default_fascorefxn == score_1 ) {
			score = score1();
		} else if ( default_fascorefxn == score_2 ) {
			score = score2();
		} else if ( default_fascorefxn == score_3 ) {
			score = score3();
		} else if ( default_fascorefxn == score_4 ) {
			score = score4();
		} else if ( default_fascorefxn == score_5 ) {
			score = score5();
		} else if ( default_fascorefxn == score_6 ) {
			score = score6();
		} else if ( default_fascorefxn == score_7 ) {
			score = score7();
		} else if ( default_fascorefxn == score_8 ) {
			score = score8();
		} else if ( default_fascorefxn == score_4d ) {
			score = score4d();
		} else if ( default_fascorefxn == score_3L ) {
			score = score3L();
		} else if ( default_fascorefxn == score_9 ) {
			score = score9();
		} else if ( default_fascorefxn == score_10 ) {
			score = score10();
		} else if ( default_fascorefxn == score_11 ) {
			score = score11();
		} else if ( default_fascorefxn == score_12 ) {
			score = score12();
		} else if ( default_fascorefxn == score_10d ) {
			score = score10d();
		} else if ( default_fascorefxn == score_9L ) {
			score = score9L();
		} else if ( default_fascorefxn == score_10L ) {
			score = score10L();
		} else if ( default_fascorefxn == score_11L ) {
			score = score11L();
		} else if ( default_fascorefxn == score_12L ) {
			score = score12L();
		} else if ( default_fascorefxn == score_13 ) {
			score = score13();
		} else if ( default_fascorefxn == score_14 ) {
			score = score14();
		} else {
			std::cout << "STOPPING:: invalid default_fascorefxn: " <<
				default_fascorefxn << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
	}
}

////////////////////////////////////////////////////////////////////////////
void
store_centroid_scores( pose_ns::Pose & pose )
{
	using namespace scorefxns;
	using namespace scores;
	using namespace pose_ns;

	pose.set_0D_score( ENV, env_score );
	pose.set_0D_score( PAIR, pair_score );
	pose.set_0D_score( VDW, vdw_score );
	pose.set_0D_score( HS, hs_score );
	pose.set_0D_score( SSPAIR, ss_score );
	pose.set_0D_score( SHEET, sheet_score );
	pose.set_0D_score( CB, cb_score );
	pose.set_0D_score( RSIGMA, rsigma_score );
	pose.set_0D_score( HB_SRBB, hb_srbb_score );
	pose.set_0D_score( HB_LRBB, hb_lrbb_score );
	pose.set_0D_score( RG, rg );
	pose.set_0D_score( CO, co );
	pose.set_0D_score( CONTACT_MJ, contact_prediction );
	pose.set_0D_score( RAMACHANDRAN, ramachandran_score );

	pose.set_0D_score( BARCODE, barscore );
	pose.set_0D_score( BARCODE_ENERGY, bar_energy_score );
	pose.set_0D_score( CST_SCORE, pc_score );
	if ( ramachandran_weight != 0.0 ) {
		pose.set_0D_score( RAMACHANDRAN, ramachandran_score );
	}

	// etc, add all other relevant scores from scorefxns

	if ( dock_scorefxn ) {
		pose.set_0D_score( DOCK_ENV, docking_env_score );
		pose.set_0D_score( DOCK_PAIR, docking_pair_score );
		pose.set_0D_score( DOCK_VDW, docking_vdw_score );
		pose.set_0D_score( DOCK_CONT, docking_contact_score );
		pose.set_0D_score( DOCK_SITE_CST, docking_site_constraint_score );
		pose.set_0D_score( DOCK_FAB, docking_fab_score );
	}

	if ( domain_scorefxn ) {
		pose.set_0D_score( DOM_CONT, domain_contact_score );
		pose.set_0D_score( DOM_DIST_CST, domain_dc_score );
	}
}

////////////////////////////////////////////////////////////////////////////
void
store_rna_scores( pose_ns::Pose & pose )
{
	using namespace scorefxns;
	using namespace scores;
	using namespace pose_ns;

	pose.set_0D_score( VDW, vdw_score );
	pose.set_0D_score( RG, rg );
	pose.set_0D_score( CONTACT_MJ, contact_prediction );
	pose.set_0D_score( pose_ns::RNA_BS, rna_bs_score );
	pose.set_0D_score( pose_ns::RNA_BP_W, rna_bp_w_score );
	pose.set_0D_score( pose_ns::RNA_BP_H, rna_bp_h_score );
	pose.set_0D_score( pose_ns::RNA_BP_S, rna_bp_s_score );
	pose.set_0D_score( pose_ns::RNA_AXIS, rna_axis_score );
	pose.set_0D_score( pose_ns::RNA_STAGGER, rna_stagger_score );
	pose.set_0D_score( pose_ns::RNA_BULGE, rna_bulge_score );
	pose.set_0D_score( pose_ns::RNA_NONBASEBASE, rna_nonbasebase_score );
	pose.set_0D_score( pose_ns::RNA_O2STAR, rna_o2star_score );
	pose.set_0D_score( pose_ns::RNA_PHOSPHATE, rna_phosphate_score );
	pose.set_0D_score( pose_ns::RNA_CONTACT, rna_contact_score );
	pose.set_0D_score( pose_ns::RNA_LONG_RANGE_CONTACT, rna_long_range_contact_score );
	pose.set_0D_score( pose_ns::RNA_SASA, rna_sasa_score );

	pose.set_0D_score( pose_ns::BARCODE_ENERGY, bar_energy_score );

}

////////////////////////////////////////////////////////////////////////////
void
store_fullatom_scores( pose_ns::Pose & pose )
{
	using namespace scorefxns;
	using namespace scores;
	using namespace pose_ns;
	if( files_paths::antibody_modeler || docking::dle_flag )
		pose.set_0D_score( VDW, vdw_score );
	pose.set_0D_score( FA_ATR, fa_atr_score );
	pose.set_0D_score( FA_REP, fa_rep_score );
	pose.set_0D_score( FA_SOL, fa_solv_score );
	pose.set_0D_score( FA_PAIR, fa_pair_score );
	pose.set_0D_score( FA_DUN, fa_dun_score );
	pose.set_0D_score( FA_PROB, fa_prob1b_score );
	pose.set_0D_score( FA_H2O, fa_h2o_score + fa_h2o_hb_score );
	pose.set_0D_score( HB_SRBB, hb_srbb_score );
	pose.set_0D_score( HB_LRBB, hb_lrbb_score );
	pose.set_0D_score( HB_SC, hb_sc_score );
	pose.set_0D_score( FA_INTRA, fa_intrares_score );
	pose.set_0D_score( RAMACHANDRAN, ramachandran_score );
	pose.set_0D_score( BARCODE, barscore );
	pose.set_0D_score( BARCODE_ENERGY, bar_energy_score );
	pose.set_0D_score( CST_SCORE, pc_score );
	pose.set_0D_score( GB, fa_gb_elec_score );
	if (bond_angle_weight) {
		pose.set_0D_score( BOND_ANGLE, bond_angle_score );
	}
	pose.set_0D_score( FA_REF, fa_ref_score );
	pose.set_0D_score( PLANE, fa_plane_score );
  pose.set_0D_score( FA_ELEC, fa_elec_score );
	// etc, add all other relevant scores from scorefxns

	if ( dock_scorefxn ) {
		pose.set_0D_score( DOCK_WSL_ELEC, docking_warshel_elec_score );
	}
}

Scoring_Function
score_function_from_string( bool fullatom, std::string const & fxn )
{
	using namespace scorefxns;

	Scoring_Function scorefxn(score12);

	if ( !fullatom ) {
		if ( fxn == "score0" ) {
			scorefxn = score0 ;
		} else if ( fxn == "score1" ) {
			scorefxn = score1 ;
		} else if ( fxn == "score2" ) {
			scorefxn = score2 ;
		} else if ( fxn == "score3" ) {
			scorefxn = score3 ;
		} else if ( fxn == "score4" ) {
			scorefxn = score4 ;
		} else if ( fxn == "score5" ) {
			scorefxn = score5 ;
		} else if ( fxn == "score6" ) {
			scorefxn = score6 ;
		} else if ( fxn == "score7" ) {
			scorefxn = score7 ;
		} else if ( fxn == "score8" ) {
			scorefxn = score8 ;
		} else if ( fxn == "score4d" ) {
			scorefxn = score4d ;
		} else if ( fxn == "score3L" ) {
			scorefxn = score3L ;
		} else if ( fxn == "score4L" ) {
			scorefxn = score4L ;
		} else if ( fxn == "score8di" ) {
			scorefxn = score8di ;
		} else if ( fxn == "score4Lc" ) {
			scorefxn = score4Lc ;
		} else {
			std::cout << "STOPPING:: invalid fxn: " <<
				fxn << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
	} else if ( fullatom ) {
		if ( fxn == "score0" ) {
			scorefxn = score0 ;
		} else if ( fxn == "score1" ) {
			scorefxn = score1 ;
		} else if ( fxn == "score2" ) {
			scorefxn = score2 ;
		} else if ( fxn == "score3" ) {
			scorefxn = score3 ;
		} else if ( fxn == "score4" ) {
			scorefxn = score4 ;
		} else if ( fxn == "score5" ) {
			scorefxn = score5 ;
		} else if ( fxn == "score6" ) {
			scorefxn = score6 ;
		} else if ( fxn == "score7" ) {
			scorefxn = score7 ;
		} else if ( fxn == "score8" ) {
			scorefxn = score8 ;
		} else if ( fxn == "score4d" ) {
			scorefxn = score4d ;
		} else if ( fxn == "score3L" ) {
			scorefxn = score3L ;
		} else if ( fxn == "score9" ) {
			scorefxn = score9 ;
		} else if ( fxn == "score10" ) {
			scorefxn = score10 ;
		} else if ( fxn == "score11" ) {
			scorefxn = score11 ;
		} else if ( fxn == "score12" ) {
			scorefxn = score12 ;
		} else if ( fxn == "score10d" ) {
			scorefxn = score10d ;
		} else if ( fxn == "score9L" ) {
			scorefxn = score9L ;
		} else if ( fxn == "score10L" ) {
			scorefxn = score10L ;
		} else if ( fxn == "score11L" ) {
			scorefxn = score11L ;
		} else if ( fxn == "score12L" ) {
			scorefxn = score12L ;
		} else if ( fxn == "score13" ) {
			scorefxn = score13 ;
		} else if ( fxn == "score14" ) {
			scorefxn = score14 ;
		} else {
			std::cout << "STOPPING:: invalid fxn: " <<
				fxn << std::endl;
			utility::exit( EXIT_FAILURE, __FILE__, __LINE__);
		}
	}
	return scorefxn;
}

bool
get_score_contact_fullatom()
{
	static bool init = {false};
	static bool score_contact_fullatom;

	if (!init) {
		score_contact_fullatom = truefalseoption("score_contact_fullatom");
		init = true;
	}

	return score_contact_fullatom;
}

bool
get_ssweight_for_homolog()
{
	static bool init = {false};
	static bool ssweight_for_homolog;

	if (!init) {
		ssweight_for_homolog = truefalseoption("ssweight_for_homolog");
		init = true;
	}

	return ssweight_for_homolog;
}


////////////////////////////////////////////////////////////////////////////
void
score_apply_user_defined_reweights() {
	using namespace scorefxns;
	using namespace param_pack;
	using namespace scorefxns::score_reweights;

	vdw_weight		*= vdw_reweight;
	env_weight		*= env_reweight;
	pair_weight		*= pair_reweight;
	cb_weight			*= cb_reweight;
	sheet_weight	*= sheet_reweight;
	ss_weight			*= ss_reweight;
	hs_weight			*= hs_reweight;
	rsigma_weight *= rsigma_reweight;
	rg_weight			*= rg_reweight;

	pc_weight			*= pc_reweight;

	jmp_chainbreak_weight *= chainbreak_reweight;

	fa_atr_weight		 *= fa_atr_reweight;
	fa_rep_weight		 *= fa_rep_reweight;
	fa_dun_weight		 *= fa_dun_reweight ;
	fa_pair_weight	 *= fa_pair_reweight;
	fa_plane_weight	 *= fa_plane_reweight;
	fa_solv_weight	 *= fa_solv_reweight;
	fa_ref_weight		 *= fa_ref_reweight ;
	fa_pH_weight		 *= fa_pH_reweight;
	fa_h2o_weight		 *= fa_h2o_reweight;
	fa_prob1b_weight *= fa_prob1b_reweight;
	fa_gb_elec_weight*= fa_gb_elec_reweight;

	pack_wts.set_Whb_srlrsc(pack_wts.Whb_srbb()*hb_srbb_reweight,
													pack_wts.Whb_lrbb()*hb_lrbb_reweight,
													pack_wts.Whb_sc() *hb_sc_reweight);

	electron_density_weight *= electron_density_reweight;
	dummy_model_weight *= dummy_model_reweight;
	saxs_model_weight	 *= saxs_model_reweight;

	barcode_weight	 *= barcode_reweight;
	barcode_energy_weight	 *= barcode_energy_reweight;

}

////////////////////////////////////////////////////////////////////////////
// Lin's feature to display score during minimization in gl_graphics
// and boinc_graphics. Modifications by rhiju to properly display
// rmsd in non-ligand modes.
void
save_scores_for_graphics(float const score_val ){

#ifndef GL_GRAPHICS
#ifndef BOINC_GRAPHICS
	return;
#endif
#endif

	if (!minimize_check_current_pose()) return;

	float rms_err (0.0);

	if( get_enable_ligaa_flag() ) {
		rms_err  = LG_rmsd( minimize_get_current_pose() );
	} else if (minimize_get_current_pose().native_pose_exists()) {
		//rms_err = calc_rms( minimize_get_current_pose() );
		//No, don't calculate MAXSUB!
		rms_err = CA_rmsd( minimize_get_current_pose().native_pose() ,
											 minimize_get_current_pose() );
	} else {
		// In some modes, e.g., pose_abinitio with sequence homologs
		// calc_rms() won't work. In these cases, send "append_trajectory"
		// a -1, signal to save whatever rms was evaluated last.
		rms_err = -1.0;
	}

#ifdef GL_GRAPHICS
	gl_graphics_save_scores( score_val, false );
	gl_graphics_append_trajectory(score_val, rms_err);
#endif
#ifdef BOINC_GRAPHICS
	append_trajectory(score_val, rms_err);
#endif

	// Oh this is silly: in non-GRAPHICS builds, do something with
	// score_val to avoid compiler warning.
	rms_err = score_val * 0.0; //dummy

}
