// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 15616 $
//  $Date: 2007-06-23 18:11:26 -0400 (Sat, 23 Jun 2007) $
//  $Author: rhiju $

#ifndef INCLUDED_score
#define INCLUDED_score


// Rosetta Headers
#include "pose_fwd.h"
#include "after_opts.h"

// C++ Headers
#include <iosfwd>
#include <string>


// Types
typedef  float (*Scoring_Function)();

// scorefxns Function Declarations


float
scorefxn();


float
score0();


float
score1();


float
score2();


float
score3();


float
score4();


float
score5();


float
score6();


float
score7();


float
score8();


float
score9();


float
score10();


float
score11();


float
score12();

float
score13();

float
score99();


// implement weight control by the Score_weight_map class:
float
score_by_weight_map(
  const pose_ns::Score_weight_map & weight_map
);


void
score_set_weight_map_weights(
  const pose_ns::Score_weight_map & weight_map
);


void
setup_score_weight_map(
	pose_ns::Score_weight_map & weight_map,
	Scoring_Function score_fxn
);


void
copy_current_score_weights_to_weight_map(
	pose_ns::Score_weight_map & weight_map
);


void
score_reset_weights();


void
score_set_lj_weight( float weight_x );


void
score_set_lj_rep_weight( float weight_x );


void
score_set_cst_weight( float weight_x );


void
score_set_cst_mode( int mode_x );


void
score_set_dpl_weight( float weight_x );


void
score_set_loop_weight( float weight_x );


//void
//score_set_dna_loop_match_weight( float weight_x );
//

void
score_set_motif_tether_weight( float weight_x );


void
scorefxn_set_tether_weight( float weight );


void
scorefxn_set_torsion_weight(
	float phipsi_wt,
	float omega_wt
);


void
scorefxn_set_rama_weight( float weight );


void
scorefxn_set_bump_weight( float weight );


void
score_set_try_rotamers( bool setting );


bool
score_get_try_rotamers();

void
score_set_vary_omega( bool setting );

bool
score_get_vary_omega();


void
score_enable_rotamer_trials( bool enable );


void
score_set_use_subset_energy( bool setting );


void
score_set_evaluate_all_terms( bool setting );


void
score_set_new_pose();


void
dump_scorefxn_weights( std::ostream & iunit );


void
score_set_default_function( bool fullatom );


void
store_centroid_scores( pose_ns::Pose & pose );

void
store_rna_scores( pose_ns::Pose & pose );

void
store_fullatom_scores( pose_ns::Pose & pose );

Scoring_Function
score_function_from_string(
		 bool fullatom,
		 std::string const & fxn
 );


float
get_vdw_reweight();

float
get_env_reweight();

float
get_pair_reweight();

float
get_cb_reweight();

float
get_sheet_reweight();

float
get_ss_reweight();

float
get_hs_reweight();

float
get_rsigma_reweight();

float
get_rg_reweight();

float
get_pc_reweight();

float
get_chainbreak_reweight();

bool
get_score_contact_fullatom();

bool
get_ssweight_for_homolog();

// SJF being called from fullatom_energy. Defined inline for performance.
inline
bool
get_simple_elec()
{
  static bool init = {false};
  static bool simple_elec;

  if (!init) {
    simple_elec = truefalseoption("simple_elec");
    init = true;
  }

  return simple_elec;
}


void
score_apply_user_defined_reweights();

void
save_scores_for_graphics( float const score_val );

#endif
