// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13219 $
//  $Date: 2007-03-02 10:03:59 -0500 (Fri, 02 Mar 2007) $
//  $Author: leaverfa $

#ifndef INCLUDED_sheet_filter
#define INCLUDED_sheet_filter


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray1Da.hh>
#include <ObjexxFCL/FArray2Da.hh>


namespace sheet_filter {

class SheetFilter {
	public: // Creation/Destruction
		SheetFilter(
			FArray2D_float const * position,
			FArray1D_char const * secstruct,
			int const * total_residue
		);
		SheetFilter();
		~SheetFilter();

	public: // methods
		bool
		compute_result(
			int & result
		);

		float
		get_handedness_score();

	private: // methods
		void
		ingo_diamers(
			int const & nres,
			FArray1Da_int strnm,
			int natm,
			FArray2D_float const & atmps,
			FArray1D_int & rnm,
			FArray1D_int & indC,
			FArray1D_int & indN,
			FArray2Da_float strdm,
			FArray1Da_int inddm
		);

		void
		ingo_find_dir(
			int shnm,
			int hm,
			int & nstr,
			FArray1Da_int slct,
			FArray1Da_int order,
			FArray1Da_int strlbl,
			FArray2Da_float strdr,
			// int & proper, // not used
			FArray1Da_int directions
		);

		void
		ingo_find_ord(
			int shnm,
			int hm,
			int & nstr,
			FArray1Da_int strlbl,
			FArray2Da_float dstrmin,
			float ngbhct,
			FArray1Da_int order,
			FArray1Da_int sequence,
			FArray1Da_int slct,
			int & rubbish
		);

		void
		ingo_hand(
			int const k,
			int const hm,
			FArray1Da_int stpppt,
			FArray1Da_int strtpt,
			int const str1,
			int const str2,
			FArray1Da_int order,
			FArray2Da_float strdr,
			int const nstr,
			int const nres,
			FArray1Da_int sequence,
			FArray1Da_int directions,
			FArray1Da_int scstr,
			FArray2Da_float lctn,
			bool const use_whole_helix,
			int & rubbish
		);

		void
		ingo_ident_sheets(
			int & nstr,
			FArray2Da_float dstrmin,
			float ngbhct,
			FArray2Da_int strprs,
			int & nsht,
			FArray1Da_int strsht,
			FArray1Da_int strlbl,
			int & rubbish
		);

		void
		ingo_lnl(
			int hm,
			FArray1Da_int order,
			int & nloc,
			int & nnloc
		);

		void
		ingo_locations(
			int const & nres,
			int natm,
			FArray1D_int & indCA,
			FArray2D_float const & atmps,
			FArray2Da_float lctn
		);

		void
		ingo_number_of_strands(
			int const & nres,
			FArray1Da_int scstr,
			int & nstr
		);

		void
		ingo_proper_sheets(
			int & nstr,
			int & nsht,
			float ngbhct,
			FArray2Da_float dstrmin,
			FArray2Da_float strdr,
			FArray1Da_int strsht,
			FArray1Da_int strlbl,
			int & rubbish,
			float & maxdist,
			float & mindotprodabs,
			FArray1Da_int strtpt,
			FArray1Da_int stpppt,
			FArray2Da_int locdsm,
			FArray2Da_float lctn,
			int const & nres
		);

		void
		ingo_sheet_stuff(
			int const & nres,
			FArray1Da_int scstr,
			int natm,
			FArray2D_float const &atmps,
			FArray1D_int & indN,
			FArray1D_int & indCA,
			FArray1D_int & indC,
			FArray1D_int & rnm,
			float ngbhct,
			int & nstr,
			int & nsht,
			float & maxdt,
			float & mindp,
			int & nloc,
			int & nnloc,
			int & rubbish
		);

		void
		ingo_start_stop(
			int const & nres,
			FArray1Da_int scstr,
			int & nstr,
			FArray1Da_int strnm,
			FArray1Da_int strtpt,
			FArray1Da_int stpppt
		);

		void
		ingo_strand_dirs(
			int const & nres,
			int & nstr,
			FArray1Da_int strtpt,
			FArray1Da_int stpppt,
			FArray2Da_float lctn,
			FArray2Da_float strdr
		);

		void
		ingo_strand_dists_min(
			int const & nres,
			int & nstr,
			FArray1Da_int inddm,
			FArray1Da_int strnm,
			FArray2Da_float strdm,
			FArray2Da_float dstrmin,
			FArray2Da_int locdsm
		);

		void
		ingo_clean_ss(
			int const & nres,
			FArray1Da_int scstr
		);

	private: // methods, data initializers
		static
		void
		c_atom_initializer(
			FArray1D_int & c_atom
		);

		static
		void
		ca_atom_initializer(
			FArray1D_int & ca_atom
		);

		static
		void
		n_atom_initializer(
			FArray1D_int & n_atom
		);

		static
		void
		binend_initializer(
			FArray1D_short & binend
		);

		static
		void
		binnumber_initializer(
			FArray1D_short & binnumber
		);

		static
		void
		binstart_initializer(
			FArray1D_short & binstart
		);

	private: // methods, setup
		void
		initialize();

	private: // mirrors, pointers
		FArray2D_float const * position_;
		FArray1D_char const * secstruct_;
		int const * total_residue_;

	private: // data, constants
		static int const max_nstr = 50; // max number of strands
		static short const maxatom = 167; // max atom types

		static FArray1D_int const c_atom;
		static FArray1D_int const ca_atom;
		static FArray1D_int const n_atom;

		static FArray1D_short const binend;
		static FArray1D_short const binnumber;
		static FArray1D_short const binstart;

	private: // data
		FArray1D_int res_num;
		FArray1D_int isN;
		FArray1D_int isCA;
		FArray1D_int isC;
		float handedness_score;
};

} // namespace structure


#endif
