// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 10595 $
//  $Date: 2006-10-07 20:04:10 -0400 (Sat, 07 Oct 2006) $
//  $Author: rhiju $


// Rosetta Headers
#include "smallmove.h"
#include "maps_ns.h"
#include "maps.h"
#include "misc.h"
#include "param.h"
#include "ramachandran.h"
#include "random_numbers.h"
#include "refold.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1Da.hh>

// C++ Headers
#include <algorithm>
#include <cmath>
#include <iostream>


// Namespaces
namespace small_move_param {
	float strand_max = { 5.0 }; // structure explodes if these params too big
	float other_max = { 6.0 };
	float helix_max = { 0.0 };
	float temp = { 0.50 }; // controls bias with with uphill moves accepted
}


////////////////////////////////////////////////////////////////////////////////
/// @begin small_moves_wob
///
/// @brief
///car multiple small moves
///car num_in = number of small moves to make  (max half of all residues)
///car moves can be made only be makde if the max for that ss-type is > 0
///
/// @detailed
///
/// keeps trying til it finds a move that is acceptable according
/// to the rama score.
/// maximum moves is half the number of possible movable residues
///
/// @param  num_in - [in/out]? -
/// @param  list - [in/out]? - list of positions moved
/// @param  num_out - [in/out]? - number moves actually made
/// @param  first - [in/out]? -
/// @param  last - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///db  makes +/- 10 degree perturbation at  residue(s) that is
///db  not embedded in a long secondary structural element. called from
///db  small_wobble_move.  I only tested it with num_in=1
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
small_moves_wob(
	int num_in,
	FArray1Da_int list, // list of positions moved
	int & num_out, // number moves actually made
	int & first,
	int & last
)
{
	using namespace misc;
	//	using namespace protein_maps;
	using namespace param;
	using namespace small_move_param;

	list.dimension( num_in );

//------------------------------------------------------------------------------// dont use protein_maps version directly, for pose compatibility
	FArray1D_bool allow_insert( MAX_RES()() );
	FArray1D_int insert_map( MAX_RES()() );
	int total_insert;

	retrieve_allow_insert(allow_insert,total_residue);
	retrieve_insertmap(insert_map,total_insert);

//car local
	int end;
	float phi_tmp,psi_tmp,old_rama_score,new_rama_score;
	float small_angle,big_angle;
	float boltz_factor,probability,crap;
	float tmp1,tmp2;
	int nhelix,nsheet,nn,dir;
	int nfail = 0;
//-------------------------------------------------------
	int nres = 0;
	num_out = 0;
	for ( int j = 1; j <= num_in; ++j ) {
	  list(j) = 0;
	}

	for ( int j = 1; j <= total_insert; ++j ) {
		int const k = insert_map(j);
		if ( secstruct(k) == 'L' && other_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'H' && helix_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'E' && strand_max > 0.0 ) ++nres;
	}
	int num = std::min(num_in,nres/2);

	if ( num < 1 ) {
		if ( nres > 1 ) {
			num = 1;
		} else {
			std::cout << "no movable positions in many_small_move" << std::endl;
			return;
		}
	}
	for ( int k = 1; k <= num; ++k ) {
L401:
		if( nfail > 1000){
			first = 1;
			last = 1;
			num_out = 0;
			return;
		}
		int const j = insert_map( static_cast< int >(ran3()*(total_insert-16))+8 );

		if ( ! allow_insert(j) ) goto L401; // fixed position, choose again

		if ( secstruct(j) == 'H' ) {
			if ( helix_max <= 0.0 ) goto L401; //! skip helix
			big_angle = helix_max;
		} else if ( secstruct(j) == 'E' ) {
			if ( strand_max <= 0.0 ) goto L401; // skip strand
			big_angle = strand_max;
		} else {
			if ( other_max <= 0.0 ) goto L401; // skip loop
			big_angle = other_max;
		}
		big_angle *= 10.0;
		small_angle = big_angle/2.0;

		int seg_num = identify_segment(j);
		refold_select_dir(seg_num,j,j,dir);
//		std::cout << "refold dir" << SS( j ) << SS( dir ) << std::endl;
		if ( dir == 1 ) {
			nhelix = 0;
			nsheet = 0;
			for ( nn = j+2; nn <= j+6; ++nn ) {
				if ( secstruct(nn) == 'E' ) ++nsheet;
				if ( secstruct(nn) == 'H' ) ++nhelix;
			}
			if ( nsheet == 5 || nhelix == 5 ) {
//				std::cout << "reject move" << SS( j ) << SS( nhelix ) <<
//				 SS( nsheet ) << SS( dir ) << std::endl;
				nfail++;
				goto L401;
			}
		} else {
			nhelix = 0;
			nsheet = 0;
			for ( nn = j-6; nn <= j-2; ++nn ) {
				if ( secstruct(nn) == 'E' ) ++nsheet;
				if ( secstruct(nn) == 'H' ) ++nhelix;
			}
			if ( nsheet == 5 || nhelix == 5 ) {
//				std::cout << "reject move" << SS( j ) << SS( nhelix ) <<
//				 SS( nsheet ) << SS( dir ) << std::endl;
				nfail++;
				goto L401;
			}
		}

//  next three lines skip ends of structure !!
//  fix a logic error here: the closer to the end, the higher the probability
//  to skip it; and when it is 1 or total_residue, the probability should be
//  zero; and the probability distribution should be symmetrical for two ends
//  residue:    N-   1   2   3   4   5   6
//  residue:    C-   t  t-1 t-2 t-3 t-4 t-5
//  prob to skip:    1  0.8 0.6 0.4 0.2 0.0
//  -- chu
//		end = total_residue-5;
//		if ( j < 5 && (static_cast< int >(ran3()*7)) <= j ) goto L401;
//		if ( j > end && (static_cast< int >(ran3()*6)+end) >= j ) goto L401;
		end = total_residue - 5;
		if ( j <= 5 && static_cast< int >(ran3()*5+1) >= j ) goto L401;
		if ( j > end && static_cast< int >(ran3()*5) + end <= j ) goto L401;

		for ( int kk = 1; kk <= num_out; ++kk ) {
			if ( j == list(kk) ) goto L401; // already moved
		}

		phi_tmp = phi(j) - small_angle + ran3()*big_angle;
		psi_tmp = psi(j) - small_angle + ran3()*big_angle;

		if ( phi_tmp > 180.0 ) { // this block keeps
			phi_tmp -= 360.0; // angles -180-180
		} else if ( phi_tmp < -180.0 ) {
			phi_tmp += 360.0;
		}
		if ( psi_tmp > 180.0 ) {
			psi_tmp -= 360.0;
		} else if ( psi_tmp < -180.0 ) {
			psi_tmp += 360.0;
		}

		eval_rama_score_residue(res(j),phi(j),psi(j),secstruct(j),old_rama_score,
		 tmp1,tmp2);
		eval_rama_score_residue(res(j),phi_tmp,psi_tmp,secstruct(j),new_rama_score,
		 tmp1,tmp2);
		if ( new_rama_score > old_rama_score ) {
			boltz_factor = ( old_rama_score - new_rama_score ) / temp;
			probability = std::exp( std::max( -40.0f, boltz_factor ) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap >= probability ) {nfail++; goto L401;}
		}
		phi(j) = phi_tmp;
		psi(j) = psi_tmp;
		name(j) = "-SW-";
		++num_out;
		list(num_out) = j;

	}

	first = list(1);
	last = list(1);
	for ( int j = 2; j <= num_out; ++j ) {
		first = std::min(first,list(j));
		last = std::max(last,list(j));
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin small_moves
///
/// @brief
///car multiple small moves
///car num_in = number of small moves to make  (max half of all residues)
///car moves can be made only be makde if the max for that ss-type is > 0
///
/// @detailed
/// keeps trying til it finds a move that is acceptable according
/// to the rama score.
/// maximum moves is half the number of possible movable residues
///
/// @param  num_in - [in/out]? -
/// @param  list - [in/out]? - list of positions moved
/// @param  num_out - [in/out]? - number moves actually made
/// @param  first - [in/out]? -
/// @param  last - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
small_moves(
	int num_in,
	FArray1Da_int list, // list of positions moved
	int & num_out, // number moves actually made
	int & first,
	int & last
)
{
	using namespace misc;
	//	using namespace protein_maps;
	using namespace small_move_param;
	using namespace param;

	list.dimension( num_in );

//car local
	int end,nres;
	float phi_tmp,psi_tmp,old_rama_score,new_rama_score;
	float small_angle,big_angle;
	float boltz_factor,probability,crap;
	float tmp1,tmp2;
//------------------------------------------------------------------------------// dont use protein_maps version directly, for pose compatibility
	FArray1D_bool allow_insert( MAX_RES()() );
	FArray1D_int insert_map( MAX_RES()() );
	int total_insert;

	retrieve_allow_insert(allow_insert,total_residue);
	retrieve_insertmap(insert_map,total_insert);

	nres = 0;
	num_out = 0;
	for ( int j = 1; j <= num_in; ++j ) {
		list(j) = 0;
	}

	for ( int j = 1; j <= total_insert; ++j ) {
		int k = insert_map(j);
		if ( secstruct(k) == 'L' && other_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'H' && helix_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'E' && strand_max > 0.0 ) ++nres;
	}
	int num = std::min(num_in,nres/2);

	if ( num < 1 ) {
		if ( nres > 1 ) {
			num = 1;
		} else {
			std::cout << "no movable positions in many_small_move" << std::endl;
			return;
		}
	}
	for ( int k = 1; k <= num; ++k ) {
L401:
		int j = insert_map(static_cast< int >(ran3()*(total_insert-1))+2);
		if ( !allow_insert(j) ) goto L401; // fixed position, choose again

		if ( secstruct(j) == 'H' ) {
			if ( helix_max <= 0.0 ) goto L401; //// skip helix
			big_angle = helix_max;
		} else if ( secstruct(j) == 'E' ) {
			if ( strand_max <= 0.0 ) goto L401; //// skip strand
			big_angle = strand_max;
		} else {
			if ( other_max <= 0.0 ) goto L401; //// skip loop
			big_angle = other_max;
		}
		small_angle = big_angle/2.0;

//  next three lines skip ends of structure !!
//  fix a logic error here: the closer to the end, the higher the probability
//  to skip it; and when it is 1 or total_residue, the probability should be
//  zero; and the probability distribution should be symmetrical for two ends
//  residue:    N-   1   2   3   4   5   6
//  residue:    C-   t  t-1 t-2 t-3 t-4 t-5
//  prob to skip:    1  0.8 0.6 0.4 0.2 0.0
//  -- chu
		end = total_residue - 5;
		if ( j <= 5 && static_cast< int >(ran3()*5+1) >= j ) goto L401;
		if ( j > end && static_cast< int >(ran3()*5) + end <= j ) goto L401;

		for ( int kk = 1; kk <= num_out; ++kk ) {
			if ( j == list(kk) ) goto L401; // already moved
		}

		phi_tmp = phi(j)-small_angle+ran3()*big_angle;
		psi_tmp = psi(j)-small_angle+ran3()*big_angle;

		if ( phi_tmp > 180.0 ) { // this block keeps
			phi_tmp -= 360.0; // angles -180-180
		}
		if ( psi_tmp > 180.0 ) {
			psi_tmp -= 360.0;
		}
		if ( phi_tmp < -180.0 ) {
			phi_tmp += 360.0;
		}
		if ( psi_tmp < -180.0 ) {
			psi_tmp += 360.0;
		}

		eval_rama_score_residue(res(j),phi(j),psi(j),secstruct(j),old_rama_score,
		 tmp1,tmp2);
		eval_rama_score_residue(res(j),phi_tmp,psi_tmp,secstruct(j),new_rama_score,
		 tmp1,tmp2);
//    std::cout << SS( j ) << SS( old_rama_score ) << SS( new_rama_score ) <<
//     SS( res(j) ) << SS( phi(j) ) << SS( phi_tmp ) << std::endl;
		if ( new_rama_score > old_rama_score ) {

			boltz_factor = (old_rama_score-new_rama_score)/temp;
			probability = std::exp(std::max(-40.0f,boltz_factor) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap >= probability ) goto L401;
		}

		phi(j) = phi_tmp;
		psi(j) = psi_tmp;
		name(j) = "-SM-";
		++num_out;
		list(num_out) = j;

	}

	first = list(1);
	last = list(1);
	for ( int j = 2; j <= num_out; ++j ) {
		first = std::min(first,list(j));
		last = std::max(last,list(j));
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin set_smallmove_size
///
/// @brief
///
/// @detailed
///
/// @param  helix - [in/out]? -
/// @param  strand - [in/out]? -
/// @param  other - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
set_smallmove_size(
	float helix,
	float strand,
	float other
)
{
//car regular moves: 0,5,6
//car min moves:  0,5,1.5

	using namespace small_move_param;

	helix_max = helix;
	strand_max = strand;
	other_max = other;
}

////////////////////////////////////////////////////////////////////////////////
/// @begin shear_moves
///
/// @brief
///car multiple small moves
///car num_in = number of small moves to make  (max half of all residues)
///car moves can be made only be makde if the max for that ss-type is > 0
///car num_out includes all residues moved, so has a max value of num_in*2
///
/// keeps trying til it finds a move that is acceptable according
/// to the rama score.
/// maximum moves is half the number of possible movable residues
///
/// @detailed
///
/// @param  num_in - [in/out]? -
/// @param  list - [in/out]? - list of positions moved
/// @param  num_out - [in/out]? - length of list
/// @param  first - [in/out]? -
/// @param  last - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
shear_moves(
	int num_in,
	FArray1Da_int list, // list of positions moved
	int & num_out, // length of list
	int & first,
	int & last
)
{
	using namespace misc;
	//	using namespace protein_maps;
	using namespace small_move_param;
	using namespace param;

	list.dimension( num_in*2 );

//car local
	int j,end,nres,num;
	float phi_tmp,psi_tmp,old_rama_score,new_rama_score;
	float small_angle,big_angle;
	float boltz_factor,probability,crap;
	int k,kk;
	float delta;
	float tmp1,tmp2;

// dont use protein_maps version directly, for pose compatibility
	FArray1D_bool allow_insert( MAX_RES()() );
	FArray1D_int insert_map( MAX_RES()() );
	int total_insert;

	retrieve_allow_insert(allow_insert,total_residue);
	retrieve_insertmap(insert_map,total_insert);


	nres = 0;
	num_out = 0;
	for ( j = 1; j <= num_in*2; ++j ) {
		list(j) = 0;
	}

	for ( j = 1; j <= total_insert; ++j ) {
		k = insert_map(j);
		if ( secstruct(k) == 'L' && other_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'H' && helix_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'E' && strand_max > 0.0 ) ++nres;
	}
	num = std::min(num_in,nres/2);

	if ( num < 1 ) {
		if ( nres > 1 ) {
			num = 1;
		} else {
			std::cout << "no movable positions in many_small_move" << std::endl;
			return;
		}
	}

	for ( k = 1; k <= num; ++k ) {
L401:
		j = insert_map(static_cast< int >(ran3()*(total_insert-1))+2);
		if ( !allow_insert(j) ) goto L401; // fixed position, choose again
		if ( !allow_insert(j-1) ) goto L401; // fixed position, choose again

//db  set maximum deviation to be twice that of smallmove since shears are less perturbing

		if ( secstruct(j) == 'H' ) {
			if ( helix_max <= 0.0 ) goto L401; //// skip helix
			big_angle = 2.0 * helix_max;
		} else if ( secstruct(j) == 'E' ) {
			if ( strand_max <= 0.0 ) goto L401; //// skip strand
			big_angle = 2.0 * strand_max;
		} else {
			if ( other_max <= 0.0 ) goto L401; //// skip loop
			big_angle = 2.0 * other_max;
		}
		small_angle = big_angle/2.0;

//  next three lines skip ends of structure !!
//  fix a logic error here: the closer to the end, the higher the probability
//  to skip it; and when it is 1 or total_residue, the probability should be
//  zero; and the probability distribution should be symmetrical for two ends
//  residue:    N-   1   2   3   4   5   6
//  residue:    C-   t  t-1 t-2 t-3 t-4 t-5
//  prob to skip:    1  0.8 0.6 0.4 0.2 0.0
//  -- chu
		end = total_residue - 5;
		if ( j <= 5 && static_cast< int >(ran3()*5+1) >= j ) goto L401;
		if ( j > end && static_cast< int >(ran3()*5) + end <= j ) goto L401;

		for ( kk = 1; kk <= num_out; kk += 2 ) {
			if ( j == list(kk) ) goto L401; // already moved, check first res of pair only
		}

		delta = small_angle-ran3()*big_angle;
		phi_tmp = phi(j)-delta;
		psi_tmp = psi(j-1)+delta;

		if ( phi_tmp > 180.0 ) { // this block keeps
			phi_tmp -= 360.0; // angles -180-180
		}
		if ( psi_tmp > 180.0 ) {
			psi_tmp -= 360.0;
		}
		if ( phi_tmp < -180.0 ) {
			phi_tmp += 360.0;
		}
		if ( psi_tmp < -180.0 ) {
			psi_tmp += 360.0;
		}

		eval_rama_score_residue(res(j),phi(j),psi(j),secstruct(j),old_rama_score,
		tmp1,tmp2);
		eval_rama_score_residue(res(j),phi_tmp,psi(j),secstruct(j),new_rama_score,
		tmp1,tmp2);
//    std::cout << SS( j ) << SS( old_rama_score ) << SS( new_rama_score ) <<
//     SS( res(j) ) << SS( phi(j) ) << SS( phi_tmp ) << std::endl;
		if ( new_rama_score > old_rama_score ) {

			boltz_factor = (old_rama_score-new_rama_score)/temp;
			probability = std::exp(std::max(-40.0f,boltz_factor) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap >= probability ) goto L401;
		}

		eval_rama_score_residue(res(j-1),phi(j-1),psi(j-1),secstruct(j-1),
		old_rama_score,tmp1,tmp2);
		eval_rama_score_residue(res(j-1),phi(j-1),psi_tmp,secstruct(j-1),
		new_rama_score,tmp1,tmp2);
		if ( new_rama_score > old_rama_score ) {

			boltz_factor = (old_rama_score-new_rama_score)/temp;
			probability = std::exp(std::max(-40.0f,boltz_factor) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap >= probability ) goto L401;
		}

		phi(j) = phi_tmp;
		psi(j-1) = psi_tmp;
		name(j) = "-SH-";
		name(j-1) = "-SH-";
		++num_out;
		list(num_out) = j;
		++num_out;
		list(num_out) = j-1;

	}

	first = list(1);
	last = list(1);
	for ( j = 2; j <= num_out; ++j ) {
		first = std::min(first,list(j));
		last = std::max(last,list(j));
	}

}

//////////////////////////////////////////////////////////////////////////////
/// @begin coupled_phipsi_moves
///
/// @brief
///BW These moves increase phi and decrease psi OF THE SAME RESIDUE
///BW They correspond to moving along the diagonals of the Ramachandran plot
///
/// @detailed
///
/// @param  num_in -[in/out]?
/// @param  list -[in/out]? - list of positions moved
/// @param  num_out -[in/out]?
/// @param  first -[in/out]?
/// @param  last -[in/out]?
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
coupled_phipsi_moves(
	int num_in,
	FArray1Da_int list, // list of positions moved
	int & num_out,
	int & first,
	int & last
)
{
	using namespace misc;
	using namespace protein_maps;
	using namespace small_move_param;

	list.dimension( num_in );

//car local
	int j,end,num,nres;
	float phi_tmp,psi_tmp,old_rama_score,new_rama_score;
	float small_angle,big_angle,delta;
	float boltz_factor,probability,crap;
	int k,kk;
	float tmp1,tmp2;
//------------------------------------------------------------------------------
	nres = 0;
	num_out = 0;
	for ( j = 1; j <= total_insert; ++j ) {
		k = insert_map(j);
		if ( secstruct(k) == 'L' && other_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'H' && helix_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'E' && strand_max > 0.0 ) ++nres;
	}
	num = std::min(num_in,nres/2);

//BW num = number of phi/psi pairs to change

	if ( num < 1 ) {
		if ( nres > 1 ) {
			num = 1;
		} else {
			list(1) = 0;
			std::cout << "no movable positions in coupled_phipsi_move" << std::endl;
			return;
		}
	}

//BW num = number of phi/psi pairs to change
	for ( k = 1; k <= num; ++k ) {
//ctsamod
L401:
		j = insert_map(static_cast< int >(ran3()*(total_insert))+1);
//ctsamod
		if ( !allow_insert(j) ) goto L401; // fixed position, choose again

		if ( secstruct(j) == 'H' ) {
			if ( helix_max <= 0.0 ) goto L401; //// skip helix
			big_angle = helix_max;
		} else if ( secstruct(j) == 'E' ) {
			if ( strand_max <= 0.0 ) goto L401; //// skip strand
			big_angle = strand_max;
		} else {
			if ( other_max <= 0.0 ) goto L401; //// skip loop
			big_angle = other_max;
		}
		small_angle = big_angle/2.0;

//  next three lines skip ends of structure !!
//  fix a logic error here: the closer to the end, the higher the probability
//  to skip it; and when it is 1 or total_residue, the probability should be
//  zero; and the probability distribution should be symmetrical for two ends
//  residue:    N-   1   2   3   4   5   6
//  residue:    C-   t  t-1 t-2 t-3 t-4 t-5
//  prob to skip:    1  0.8 0.6 0.4 0.2 0.0
//  -- chu
		end = total_residue - 5;
		if ( j <= 5 && static_cast< int >(ran3()*5+1) >= j ) goto L401;
		if ( j > end && static_cast< int >(ran3()*5) + end <= j ) goto L401;

		for ( kk = 1; kk < k; ++kk ) {
			if ( j == list(kk) ) goto L401; // already moved
		}


//BW Compensating changes in phi/psi OF THE SAME RESIDUE
//BW Contrasts with my "shear" moves, in which compensating
//BW changes are made in the phi of this residue and psi of the
//BW previous residue

		delta = small_angle-ran3()*big_angle;

		phi_tmp = phi(j)-delta;
		psi_tmp = psi(j)+delta;

		if ( phi_tmp > 180.0 ) { // this block keeps
			phi_tmp -= 360.0; // angles -180-180
		}
		if ( psi_tmp > 180.0 ) {
			psi_tmp -= 360.0;
		}
		if ( phi_tmp < -180.0 ) {
			phi_tmp += 360.0;
		}
		if ( psi_tmp < -180.0 ) {
			psi_tmp += 360.0;
		}

		eval_rama_score_residue(res(j),phi(j),psi(j),secstruct(j),old_rama_score,
		 tmp1,tmp2);
		eval_rama_score_residue(res(j),phi_tmp,psi_tmp,secstruct(j),new_rama_score,
		 tmp1,tmp2);
		if ( new_rama_score > old_rama_score ) {

			boltz_factor = (old_rama_score-new_rama_score)/temp;
			probability = std::exp(std::max(-40.0f,boltz_factor) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap >= probability ) goto L401;
		}

		phi(j) = phi_tmp;
		psi(j) = psi_tmp;
		name(j) = "-CP-";
		++num_out;
		list(num_out) = j;

	}

	first = list(1);
	last = list(1);
	for ( j = 2; j <= num_out; ++j ) {
		first = std::min(first,list(j));
		last = std::max(last,list(j));
	}
}

////////////////////////////////////////////////////////////////////////////////
/// @begin target_small_moves
///
/// @brief
///car num_in = number of small moves to make  (max half of all residues)
///car moves can be made only be makde if the max for that ss-type is > 0
///
/// @detailed
/// keeps trying til it finds a move that is acceptable according
/// to the rama score.
/// maximum moves is half the number of possible movable residues
///
/// @param  num_in - [in/out]? -
/// @param  list - [in/out]? - list of positions moved
/// @param  num_out - [in/out]? - number moves actually made
/// @param  first - [in/out]? -
/// @param  last - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
target_small_moves(
	std::vector< int > target_pos,// positions to move
	FArray1Da_int list, // list of positions moved
	int & num_out, // number moves actually made
	int & first,
	int & last
)
{
	using namespace misc;
	using namespace protein_maps;
	using namespace small_move_param;

	int num_in = target_pos.size();
	list.dimension( num_in );

//car local
	int end,nres;
	float phi_tmp,psi_tmp,old_rama_score,new_rama_score;
	float small_angle,big_angle;
	float boltz_factor,probability,crap;
	float tmp1,tmp2;
//------------------------------------------------------------------------------
	nres = 0;
	num_out = 0;
	for ( int j = 1; j <= num_in; ++j ) {
		list(j) = 0;
	}

	for ( int j = 1; j <= total_insert; ++j ) {
		int k = insert_map(j);
		if ( secstruct(k) == 'L' && other_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'H' && helix_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'E' && strand_max > 0.0 ) ++nres;
	}
	int num = std::min(num_in,nres/2);

	if ( num < 1 ) {
		if ( nres > 1 ) {
			num = 1;
		} else {
			std::cout << "no movable positions in many_small_move" << std::endl;
			return;
		}
	}

	for ( int k = 1; k <= num; ++k ) {
//		int j = insert_map(static_cast< int >(ran3()*(total_insert-1))+2);
		int j = target_pos.at( k-1 );
		if ( !allow_insert(j) ) continue; // fixed position, next

		if ( secstruct(j) == 'H' ) {
			if ( helix_max <= 0.0 ) continue; //// skip helix
			big_angle = helix_max;
		} else if ( secstruct(j) == 'E' ) {
			if ( strand_max <= 0.0 ) continue; //// skip strand
			big_angle = strand_max;
		} else {
			if ( other_max <= 0.0 ) continue; //// skip loop
			big_angle = other_max;
		}
		small_angle = big_angle/2.0;

		end = total_residue - 5;
		if ( j <= 5 && static_cast< int >(ran3()*5+1) >= j ) continue;
		if ( j > end && static_cast< int >(ran3()*5) + end <= j ) continue;

		int nfail = 0;
L401:
		++nfail;
		if (nfail >= 500 ) continue; // give up this position

		phi_tmp = phi(j)-small_angle+ran3()*big_angle;
		psi_tmp = psi(j)-small_angle+ran3()*big_angle;

		if ( phi_tmp > 180.0 ) { // this block keeps
			phi_tmp -= 360.0; // angles -180-180
		}
		if ( psi_tmp > 180.0 ) {
			psi_tmp -= 360.0;
		}
		if ( phi_tmp < -180.0 ) {
			phi_tmp += 360.0;
		}
		if ( psi_tmp < -180.0 ) {
			psi_tmp += 360.0;
		}

		eval_rama_score_residue(res(j),phi(j),psi(j),secstruct(j),old_rama_score,
			tmp1,tmp2);
		eval_rama_score_residue(res(j),phi_tmp,psi_tmp,secstruct(j),new_rama_score,
			tmp1,tmp2);
//   std::cout << SS( j ) << SS( old_rama_score ) << SS( new_rama_score ) <<
//    SS( res(j) ) << SS( phi(j) ) << SS( phi_tmp ) << std::endl;
		if ( new_rama_score > old_rama_score ) {

			boltz_factor = (old_rama_score-new_rama_score)/temp;
			probability = std::exp(std::max(-40.0f,boltz_factor) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap >= probability ) goto L401;
		}

		phi(j) = phi_tmp;
		psi(j) = psi_tmp;
		name(j) = "-TS-";
		++num_out;
		list(num_out) = j;

	}

	first = list(1);
	last = list(1);
	for ( int j = 2; j <= num_out; ++j ) {
		first = std::min(first,list(j));
		last = std::max(last,list(j));
	}

}

////////////////////////////////////////////////////////////////////////////////
/// @begin target_shear_moves
///
/// @brief
///car multiple small moves
///car num_in = number of small moves to make  (max half of all residues)
///car moves can be made only be makde if the max for that ss-type is > 0
///car num_out includes all residues moved, so has a max value of num_in*2
///
/// keeps trying til it finds a move that is acceptable according
/// to the rama score.
/// maximum moves is half the number of possible movable residues
///
/// @detailed
///
/// @param  num_in - [in/out]? -
/// @param  list - [in/out]? - list of positions moved
/// @param  num_out - [in/out]? - length of list
/// @param  first - [in/out]? -
/// @param  last - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
target_shear_moves(
	std::vector< int > target_pos, // target positions to move
	FArray1Da_int list, // list of positions moved
	int & num_out, // length of list
	int & first,
	int & last
)
{
	using namespace misc;
	using namespace protein_maps;
	using namespace small_move_param;

	int num_in = target_pos.size();
	list.dimension( num_in*2 );

//car local
	int j,end,nres,num;
	float phi_tmp,psi_tmp,old_rama_score,new_rama_score;
	float small_angle,big_angle;
	float boltz_factor,probability,crap;
	int k;
	float delta;
	float tmp1,tmp2;

	nres = 0;
	num_out = 0;
	for ( j = 1; j <= num_in*2; ++j ) {
		list(j) = 0;
	}

	for ( j = 1; j <= total_insert; ++j ) {
		k = insert_map(j);
		if ( secstruct(k) == 'L' && other_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'H' && helix_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'E' && strand_max > 0.0 ) ++nres;
	}
	num = std::min(num_in,nres/2);

	if ( num < 1 ) {
		if ( nres > 1 ) {
			num = 1;
		} else {
			std::cout << "no movable positions in many_small_move" << std::endl;
			return;
		}
	}

	for ( int k = 1; k <= num; ++k ) {
//		int j = insert_map(static_cast< int >(ran3()*(total_insert-1))+2);
		int j = target_pos.at( k-1 );

		if ( !allow_insert(j) ) continue; // fixed position, choose again
		if ( !allow_insert(j-1) ) continue; // fixed position, choose again


		if ( secstruct(j) == 'H' ) {
			if ( helix_max <= 0.0 ) continue; //// skip helix
			big_angle = 2.0 * helix_max;
		} else if ( secstruct(j) == 'E' ) {
			if ( strand_max <= 0.0 ) continue; //// skip strand
			big_angle = 2.0 * strand_max;
		} else {
			if ( other_max <= 0.0 ) continue; //// skip loop
			big_angle = 2.0 * other_max;
		}
		small_angle = big_angle/2.0;

		end = total_residue - 5;
		if ( j <= 5 && static_cast< int >(ran3()*5+1) >= j ) continue;
		if ( j > end && static_cast< int >(ran3()*5) + end <= j ) continue;


		int nfail = 0;
L401:
		++nfail;
		if (nfail >= 500 ) {
			continue; //give up this position
		}

		delta = small_angle-ran3()*big_angle;
		phi_tmp = phi(j)-delta;
		psi_tmp = psi(j-1)+delta;

		if ( phi_tmp > 180.0 ) { // this block keeps
			phi_tmp -= 360.0; // angles -180-180
		}
		if ( psi_tmp > 180.0 ) {
			psi_tmp -= 360.0;
		}
		if ( phi_tmp < -180.0 ) {
			phi_tmp += 360.0;
		}
		if ( psi_tmp < -180.0 ) {
			psi_tmp += 360.0;
		}

		eval_rama_score_residue(res(j),phi(j),psi(j),secstruct(j),old_rama_score,
			tmp1,tmp2);
		eval_rama_score_residue(res(j),phi_tmp,psi(j),secstruct(j),new_rama_score,
			tmp1,tmp2);
//    std::cout << SS( j ) << SS( old_rama_score ) << SS( new_rama_score ) <<
//     SS( res(j) ) << SS( phi(j) ) << SS( phi_tmp ) << std::endl;
		if ( new_rama_score > old_rama_score ) {

			boltz_factor = (old_rama_score-new_rama_score)/temp;
			probability = std::exp(std::max(-40.0f,boltz_factor) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap >= probability ) goto L401;
		}

		eval_rama_score_residue(res(j-1),phi(j-1),psi(j-1),secstruct(j-1),
			old_rama_score,tmp1,tmp2);
		eval_rama_score_residue(res(j-1),phi(j-1),psi_tmp,secstruct(j-1),
			new_rama_score,tmp1,tmp2);
		if ( new_rama_score > old_rama_score ) {
			boltz_factor = (old_rama_score-new_rama_score)/temp;
			probability = std::exp(std::max(-40.0f,boltz_factor) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap >= probability ) goto L401;
		}

		phi(j) = phi_tmp;
		psi(j-1) = psi_tmp;
		name(j) = "-TH-";
		name(j-1) = "-TH-";
		++num_out;
		list(num_out) = j;
		++num_out;
		list(num_out) = j-1;

	}
	first = list(1);
	last = list(1);
	for ( j = 2; j <= num_out; ++j ) {
		first = std::min(first,list(j));
		last = std::max(last,list(j));
	}

}
////////////////////////////////////////////////////////////////////////////////
/// @begin target_small_moves_wob
///
/// @brief
///bqian target_small_moves_wob
///bqian num_in = number of small moves to make  (max half of all residues)
///bqian moves can be made only be makde if the max for that ss-type is > 0
///
/// @detailed
///
/// keeps trying til it finds a move that is acceptable according
/// to the rama score.
/// maximum moves is half the number of possible movable residues
///
/// @param  num_in - [in/out]? -
/// @param  list - [in/out]? - list of positions moved
/// @param  num_out - [in/out]? - number moves actually made
/// @param  first - [in/out]? -
/// @param  last - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///db  makes +/- 10 degree perturbation at  residue(s) that is
///db  not embedded in a long secondary structural element. called from
///db  small_wobble_move.  I only tested it with num_in=1
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
target_small_moves_wob(
	std::vector< int > target_pos, // target positions to move
	FArray1Da_int list, // list of positions moved
	int & num_out, // number moves actually made
	int & first,
	int & last
)
{
	using namespace misc;
	using namespace protein_maps;
	using namespace small_move_param;

	int num_in = target_pos.size();
	list.dimension( num_in );

//car local
	int end;
	float phi_tmp,psi_tmp,old_rama_score,new_rama_score;
	float small_angle,big_angle;
	float boltz_factor,probability,crap;
	float tmp1,tmp2;
	int nhelix,nsheet,nn,dir;
//-------------------------------------------------------
	int nres = 0;
	num_out = 0;
	for ( int j = 1; j <= num_in; ++j ) {
	  list(j) = 0;
	}

	for ( int j = 1; j <= total_insert; ++j ) {
		int const k = insert_map(j);
		if ( secstruct(k) == 'L' && other_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'H' && helix_max > 0.0 ) ++nres;
		if ( secstruct(k) == 'E' && strand_max > 0.0 ) ++nres;
	}
	int num = std::min(num_in,nres/2);

	if ( num < 1 ) {
		if ( nres > 1 ) {
			num = 1;
		} else {
			std::cout << "no movable positions in many_small_move" << std::endl;
			return;
		}
	}
	for ( int k = 1; k <= num; ++k ) {
//		int const j = insert_map( static_cast< int >(ran3()*(total_insert-16))+8 );
		int j = target_pos.at( k-1 );

		if ( ! allow_insert(j) ) continue; // fixed position, choose again

		if ( secstruct(j) == 'H' ) {
			if ( helix_max <= 0.0 ) continue; //! skip helix
			big_angle = helix_max;
		} else if ( secstruct(j) == 'E' ) {
			if ( strand_max <= 0.0 ) continue; // skip strand
			big_angle = strand_max;
		} else {
			if ( other_max <= 0.0 ) continue; // skip loop
			big_angle = other_max;
		}
		big_angle *= 10.0;
		small_angle = big_angle/2.0;

		int seg_num = identify_segment(j);
		refold_select_dir(seg_num,j,j,dir);
//		std::cout << "refold dir" << SS( j ) << SS( dir ) << std::endl;
		if ( dir == 1 ) {
			nhelix = 0;
			nsheet = 0;
			for ( nn = j+2; nn <= j+6; ++nn ) {
				if ( secstruct(nn) == 'E' ) ++nsheet;
				if ( secstruct(nn) == 'H' ) ++nhelix;
			}
			if ( nsheet == 5 || nhelix == 5 ) {
//				std::cout << "reject move" << SS( j ) << SS( nhelix ) <<
//				 SS( nsheet ) << SS( dir ) << std::endl;
				continue;
			}
		} else {
			nhelix = 0;
			nsheet = 0;
			for ( nn = j-6; nn <= j-2; ++nn ) {
				if ( secstruct(nn) == 'E' ) ++nsheet;
				if ( secstruct(nn) == 'H' ) ++nhelix;
			}
			if ( nsheet == 5 || nhelix == 5 ) {
//				std::cout << "reject move" << SS( j ) << SS( nhelix ) <<
//				 SS( nsheet ) << SS( dir ) << std::endl;
				continue;
			}
		}

//  next three lines skip ends of structure !!
//  fix a logic error here: the closer to the end, the higher the probability
//  to skip it; and when it is 1 or total_residue, the probability should be
//  zero; and the probability distribution should be symmetrical for two ends
//  residue:    N-   1   2   3   4   5   6
//  residue:    C-   t  t-1 t-2 t-3 t-4 t-5
//  prob to skip:    1  0.8 0.6 0.4 0.2 0.0
//  -- chu
//		end = total_residue-5;
//		if ( j < 5 && (static_cast< int >(ran3()*7)) <= j ) goto L401;
//		if ( j > end && (static_cast< int >(ran3()*6)+end) >= j ) goto L401;
		end = total_residue - 5;
		if ( j <= 5 && static_cast< int >(ran3()*5+1) >= j ) continue;
		if ( j > end && static_cast< int >(ran3()*5) + end <= j ) continue;

		for ( int kk = 1; kk <= num_out; ++kk ) {
			if ( j == list(kk) ) continue; // already moved
		}

		int nfail = 0;
L401:
		++nfail;
		if (nfail >= 500 ) {
			continue; //give up this position
		}

		phi_tmp = phi(j) - small_angle + ran3()*big_angle;
		psi_tmp = psi(j) - small_angle + ran3()*big_angle;

		if ( phi_tmp > 180.0 ) { // this block keeps
			phi_tmp -= 360.0; // angles -180-180
		} else if ( phi_tmp < -180.0 ) {
			phi_tmp += 360.0;
		}
		if ( psi_tmp > 180.0 ) {
			psi_tmp -= 360.0;
		} else if ( psi_tmp < -180.0 ) {
			psi_tmp += 360.0;
		}

		eval_rama_score_residue(res(j),phi(j),psi(j),secstruct(j),old_rama_score,
		 tmp1,tmp2);
		eval_rama_score_residue(res(j),phi_tmp,psi_tmp,secstruct(j),new_rama_score,
		 tmp1,tmp2);
		if ( new_rama_score > old_rama_score ) {
			boltz_factor = ( old_rama_score - new_rama_score ) / temp;
			probability = std::exp( std::max( -40.0f, boltz_factor ) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap >= probability ) goto L401;
		}
		phi(j) = phi_tmp;
		psi(j) = psi_tmp;
		name(j) = "-TW-";
		++num_out;
		list(num_out) = j;

	}

	first = list(1);
	last = list(1);
	for ( int j = 2; j <= num_out; ++j ) {
		first = std::min(first,list(j));
		last = std::max(last,list(j));
	}

}
////////////////////////////////////////////////////////////////////////////////
/// @begin target_junction_moves
///
/// @brief
///car num_in = number of small moves to make  (max half of all residues)
///car moves can be made only be makde if the max for that ss-type is > 0
///
/// @detailed
/// try x number of time until find a move that is acceptable according
/// to the rama score.
///
/// @param  num_in - [in/out]? -
/// @param  list - [in/out]? - list of positions moved
/// @param  num_out - [in/out]? - number moves actually made
/// @param  first - [in/out]? -
/// @param  last - [in/out]? -
///
/// @global_read
///
/// @global_write
///
/// @remarks
///
/// @references
///
/// @authors
///
/// @last_modified
/////////////////////////////////////////////////////////////////////////////////
void
target_junction_moves (
 int junction_res
)
{
	using namespace misc;
	using namespace protein_maps;
	using namespace small_move_param;

//car local
//	int end,nres;
	float phi_tmp,psi_tmp,old_rama_score,new_rama_score;
	float const small_angle = { 2.0 };
	float const big_angle = { 180.0 };
	float boltz_factor,probability,crap;
	float tmp1,tmp2;
//------------------------------------------------------------------------------

	int num_tries = 0;
	bool accepted = false;

	while (num_tries < 100 && !accepted) {
		++num_tries;

		phi_tmp = phi(junction_res)-small_angle+ran3()*big_angle;
		psi_tmp = psi(junction_res)-small_angle+ran3()*big_angle;

		if ( phi_tmp > 180.0 ) { // this block keeps
			phi_tmp -= 360.0; // angles -180-180
		}
		if ( psi_tmp > 180.0 ) {
			psi_tmp -= 360.0;
		}
		if ( phi_tmp < -180.0 ) {
			phi_tmp += 360.0;
		}
		if ( psi_tmp < -180.0 ) {
			psi_tmp += 360.0;
		}

		eval_rama_score_residue(res(junction_res),phi(junction_res),psi(junction_res),secstruct(junction_res),old_rama_score,
			tmp1,tmp2);
		eval_rama_score_residue(res(junction_res),phi_tmp,psi_tmp,secstruct(junction_res),new_rama_score,
			tmp1,tmp2);
//   std::cout << SS( junction_res ) << SS( old_rama_score ) << SS( new_rama_score ) <<
//    SS( res(junction_res) ) << SS( phi(junction_res) ) << SS( phi_tmp ) << std::endl;
		if (new_rama_score <= old_rama_score ) {
			accepted = true;
		}else if ( new_rama_score > old_rama_score ) {
			boltz_factor = (old_rama_score-new_rama_score)/temp;
			probability = std::exp(std::max(-40.0f,boltz_factor) );
			crap = ran3(); // bug if  ran3 call in if statment
			if ( crap < probability ) accepted = true;
		}
		if (accepted) {
			phi(junction_res) = phi_tmp;
			psi(junction_res) = psi_tmp;
			name(junction_res) = "jxn-";
			//			std::cout<<"phi/psi "<<phi(junction_res)<<" "<<psi(junction_res)<<" after "<<num_tries<<" num_tries"<<std::endl;
		}
	}
}
