#ifndef INCLUDED_ObjexxFCL_ChunkExponent_HH
#define INCLUDED_ObjexxFCL_ChunkExponent_HH


// ChunkExponent: ChunkVector Exponent Wrapper for Function Disambiguation and Range Clipping
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <algorithm>
#include <cstddef>
#include <limits>


namespace ObjexxFCL {


/// @brief ChunkExponent: ChunkVector Exponent Wrapper for Function Disambiguation and Range Clipping
///
/// @remarks
///  The exponent is clipped to be less than the number of bits in its type so that 2^exponent can
///   be stored in that type
class ChunkExponent
{


public: // Types


	typedef  std::size_t  value_type;


public: // Creation


	/// @brief Constructor (Implicit): Clips Exponent to Valid Range
	inline
	ChunkExponent( value_type const exponent_a ) :
		exponent_( std::min( exponent_a, static_cast< value_type >( std::numeric_limits< value_type >::digits - 1 ) ) )
	{}


	/// @brief Destructor
	inline
	~ChunkExponent()
	{}


public: // Conversion


	/// @brief Exponent Value Conversion
	inline
	operator value_type() const
	{
		return exponent_;
	}


private: // Data


	/// @brief Exponent value
	value_type exponent_;


}; // ChunkExponent


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_ChunkExponent_HH
