#ifndef INCLUDED_ObjexxFCL_FArray1D_io_HH
#define INCLUDED_ObjexxFCL_FArray1D_io_HH


// FArray1D.io: Fortran-Compatible 1D Array Input/Output Functions
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// ObjexxFCL Headers
#include <ObjexxFCL/FArray1DB.hh>
#include <ObjexxFCL/TypeTraits.hh>

// C++ Standard Library Headers
#include <iomanip>
#include <ostream>


namespace ObjexxFCL {


/// @brief stream << FArray1DB
template< typename T >
std::ostream &
operator <<( std::ostream & stream, FArray1DB< T > const & a )
{
	// Types
	using std::setw;
	typedef  TypeTraits< T >  Traits;

	// Save current stream state and set persistent state
	std::ios_base::fmtflags const old_flags( stream.flags() );
	int const old_precision( stream.precision( Traits::precision() ) );
	stream << std::right << std::showpoint << std::uppercase;

	// Output array to stream
	int const w( Traits::width() );
	for ( int i = a.l(), e = a.u(); i < e; ++i ) {
		stream << setw( w ) << a( i ) << ' ';
	} stream << setw( w ) << a( a.u() );

	// Restore previous stream state
	stream.precision( old_precision );
	stream.flags( old_flags );

	return stream;
}


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray1D_io_HH
