#ifndef INCLUDED_ObjexxFCL_FArray2Da_FWD_HH
#define INCLUDED_ObjexxFCL_FArray2Da_FWD_HH


// FArray2Da Forward Declarations and Types Header
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>
#include <string>


namespace ObjexxFCL {


// Forward Declarations
template< typename > class FArray2Da;
class byte;
class ubyte;
class Fstring;


// Types
typedef  FArray2Da< bool >                FArray2Da_bool;
typedef  FArray2Da< byte >                FArray2Da_byte;
typedef  FArray2Da< ubyte >               FArray2Da_ubyte;
typedef  FArray2Da< short int >           FArray2Da_short;
typedef  FArray2Da< int >                 FArray2Da_int;
typedef  FArray2Da< long int >            FArray2Da_long;
typedef  FArray2Da< unsigned short int >  FArray2Da_ushort;
typedef  FArray2Da< unsigned int >        FArray2Da_uint;
typedef  FArray2Da< unsigned long int >   FArray2Da_ulong;
typedef  FArray2Da< std::size_t >         FArray2Da_size_t;
typedef  FArray2Da< std::size_t >         FArray2Da_size;
typedef  FArray2Da< float >               FArray2Da_float;
typedef  FArray2Da< double >              FArray2Da_double;
typedef  FArray2Da< long double >         FArray2Da_longdouble;
typedef  FArray2Da< char >                FArray2Da_char;
typedef  FArray2Da< unsigned char >       FArray2Da_uchar;
typedef  FArray2Da< signed char >         FArray2Da_schar;
typedef  FArray2Da< std::string >         FArray2Da_string;
typedef  FArray2Da< Fstring >             FArray2Da_Fstring;


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray2Da_FWD_HH
