#ifndef INCLUDED_ObjexxFCL_FArray4D_io_HH
#define INCLUDED_ObjexxFCL_FArray4D_io_HH


// FArray4D.io: Fortran-Compatible 4D Array Input/Output Functions
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// ObjexxFCL Headers
#include <ObjexxFCL/FArray4DB.hh>
#include <ObjexxFCL/TypeTraits.hh>

// C++ Standard Library Headers
#include <iomanip>
#include <ostream>


namespace ObjexxFCL {


/// @brief stream << FArray4DB
template< typename T >
std::ostream &
operator <<( std::ostream & stream, FArray4DB< T > const & a )
{
	// Types
	using std::setw;
	typedef  TypeTraits< T >  Traits;

	// Save current stream state and set persistent state
	std::ios_base::fmtflags const old_flags( stream.flags() );
	int const old_precision( stream.precision( Traits::precision() ) );
	stream << std::right << std::showpoint << std::uppercase;

	// Output array to stream
	int const w( Traits::width() );
	for ( int i1 = a.l1(), e1 = a.u1(); i1 <= e1; ++i1 ) {
		for ( int i2 = a.l2(), e2 = a.u2(); i2 <= e2; ++i2 ) {
			for ( int i3 = a.l3(), e3 = a.u3(); i3 <= e3; ++i3 ) {
				for ( int i4 = a.l4(), e4 = a.u4(); i4 < e4; ++i4 ) {
					stream << setw( w ) << a( i1, i2, i3, i4 ) << ' ';
				} stream << setw( w ) << a( i1, i2, i3, a.u4() ) << '\n';
			}
		}
	}

	// Restore previous stream state
	stream.precision( old_precision );
	stream.flags( old_flags );

	return stream;
}


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_FArray4D_io_HH
