// Time and Date Functions
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// ObjexxFCL Headers
#include <ObjexxFCL/Time_Date.hh>
#include <ObjexxFCL/FArray1D.hh>

// C++ Standard Library Headers
#include <cassert>
#include <ctime>


namespace ObjexxFCL {


/// @brief Current Time (G77/*NIX Compatible)
void
itime( FArray1D< int > & timearray )
{
	assert( timearray.I().contains( FArray1D< int >::IR( 1, 3 ) ) );
	std::time_t const current_time( std::time( NULL ) );
	std::tm const * const timeinfo( std::localtime( &current_time ) );
	timearray( 1 ) = timeinfo->tm_hour;
	timearray( 2 ) = timeinfo->tm_min;
	timearray( 3 ) = timeinfo->tm_sec;
}


/// @brief Current Date (G77/*NIX Compatible)
void
idate( FArray1D< int > & datearray )
{
	assert( datearray.I().contains( FArray1D< int >::IR( 1, 3 ) ) );
	std::time_t const current_time( std::time( NULL ) );
	std::tm const * const timeinfo( std::localtime( &current_time ) );
	datearray( 1 ) = timeinfo->tm_mday; // Day of month: 1,2,...
	datearray( 2 ) = timeinfo->tm_mon + 1; // Month of year: 1-12
	datearray( 3 ) = timeinfo->tm_year + 1900; // Year
}


/// @brief Current Date (Compaq Compatible: Not Y2K Compliant)
void
idate( int & month, int & day, int & year )
{
	std::time_t const current_time( std::time( NULL ) );
	std::tm const * const timeinfo( std::localtime( &current_time ) );
	month = timeinfo->tm_mon + 1; // Month of year: 1-12
	day = timeinfo->tm_mday; // Day of month: 1,2,...
	year = timeinfo->tm_year - ( timeinfo->tm_year / 100 ) * 100; // Year: 0-99 (2-digit)
}


} // namespace ObjexxFCL
