#ifndef INCLUDED_ObjexxFCL_array_iterator_HH
#define INCLUDED_ObjexxFCL_array_iterator_HH


// C Array Iterator Functions
//
// Project: Objexx Fortran Compatibility Library (ObjexxFCL)
//
// Version: 2.6.2
//
// Language: C++
//
// Copyright (c) 2007 Objexx Engineering, Inc. All Rights Reserved.
// Use of this source code or any derivative of it is restricted by license.
// Licensing is available from Objexx Engineering, Inc.:   http://objexx.com   Objexx@objexx.com


// C++ Standard Library Headers
#include <cstddef>


namespace ObjexxFCL {


/// @brief Begin Iterator for C Array
template < typename T, std::size_t N >
inline
T *
begin( T (&array)[N] )
{
	return array + 0;
}


/// @brief End Iterator for C Array
template < typename T, std::size_t N >
inline
T *
end( T (&array)[N] )
{
	return array + N;
}


} // namespace ObjexxFCL


#endif // INCLUDED_ObjexxFCL_array_iterator_HH
