// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   boost/boost_throw_exception.cc
/// @brief  Definition of boost::throw_exception
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @note   Link this in when boost is used and exception support is disabled


// Boost headers
#include <boost/throw_exception.hpp>


#ifdef BOOST_NO_EXCEPTIONS


namespace boost {


/// @brief Definition of boost::throw_exception needed with boost when exceptions are disabled
void
throw_exception( std::exception const & )
{}


} // namespace boost


#endif // BOOST_NO_EXCEPTIONS
