// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   numeric/constants.cc
/// @brief  Common numeric constants in varying precisions
/// @author Frank M. D'Ippolito (Objexx@objexx.com)
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @note   The 'constants' namespace and the namespaces within it
//          do not correspond to any package


// Package headers
#include <numeric/constants.hh>
#include <numeric/NumericTraits.hh>


namespace numeric {
namespace constants {


// float
namespace f {

	typedef  NumericTraits< Type >  Traits;

	Type const zero               = Traits::zero();
	Type const one                = Traits::one();
	Type const two                = Traits::two();
	Type const pi                 = Traits::pi();
	Type const pi_2               = Traits::pi_2();
	Type const pi_over_2          = Traits::pi_over_2();
	Type const pi_over_3          = Traits::pi_over_3();
	Type const pi_2_over_3        = Traits::pi_2_over_3();
	Type const pi_over_180        = Traits::pi_over_180();
	Type const degrees_to_radians = Traits::degrees_to_radians();
	Type const deg2rad            = Traits::deg2rad();
	Type const radians_to_degrees = Traits::radians_to_degrees();
	Type const rad2deg            = Traits::rad2deg();

} // namespace f


// double
namespace d {

	typedef  NumericTraits< Type >  Traits;

	Type const zero               = Traits::zero();
	Type const one                = Traits::one();
	Type const two                = Traits::two();
	Type const pi                 = Traits::pi();
	Type const pi_2               = Traits::pi_2();
	Type const pi_over_2          = Traits::pi_over_2();
	Type const pi_over_3          = Traits::pi_over_3();
	Type const pi_2_over_3        = Traits::pi_2_over_3();
	Type const pi_over_180        = Traits::pi_over_180();
	Type const degrees_to_radians = Traits::degrees_to_radians();
	Type const deg2rad            = Traits::deg2rad();
	Type const radians_to_degrees = Traits::radians_to_degrees();
	Type const rad2deg            = Traits::rad2deg();

} // namespace d


// long double
namespace ld {

	typedef  NumericTraits< Type >  Traits;

	Type const zero               = Traits::zero();
	Type const one                = Traits::one();
	Type const two                = Traits::two();
	Type const pi                 = Traits::pi();
	Type const pi_2               = Traits::pi_2();
	Type const pi_over_2          = Traits::pi_over_2();
	Type const pi_over_3          = Traits::pi_over_3();
	Type const pi_2_over_3        = Traits::pi_2_over_3();
	Type const pi_over_180        = Traits::pi_over_180();
	Type const degrees_to_radians = Traits::degrees_to_radians();
	Type const deg2rad            = Traits::deg2rad();
	Type const radians_to_degrees = Traits::radians_to_degrees();
	Type const rad2deg            = Traits::rad2deg();

} // namespace ld


} // namespace constants
} // namespace numeric
