// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   numeric/internal/RowsPointer.hh
/// @brief  Contiguous row-ordered 3x3 matrix pointer wrapper class
/// @author Frank M. D'Ippolito (Objexx@objexx.com)
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_numeric_internal_RowsPointer_HH
#define INCLUDED_numeric_internal_RowsPointer_HH


// Package headers
#include <numeric/xyzMatrix.fwd.hh>


namespace numeric {


template< typename T >
class RowsPointer
{


private: // Friends


	template< typename > friend class numeric::xyzMatrix;


public: // Creation


	/// @brief Contiguous row-ordered 3x3 xyzMatrix pointer constructor
	/// @warning No way to check that argument points to nine values
	inline
	explicit
	RowsPointer( T const * p_a ) :
		p_( p_a )
	{}


public: // Methods: conversion operators


	/// @brief Conversion to wrapped pointer
	inline
	operator T const *() const
	{
		return p_;
	}


private: // Fields


	/// @brief Pointer (non-owning) to contiguous row-ordered 3x3 matrix
	T const * p_;


}; // RowsPointer


} // namespace numeric


#endif // INCLUDED_numeric_internal_RowsPointer_HH
