// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/...
// (C) 199x-2005 University of Washington
// (C) 199x-2005 University of California Santa Cruz
// (C) 199x-2005 University of California San Francisco
// (C) 199x-2005 Johns Hopkins University
// (C) 199x-2005 University of North Carolina, Chapel Hill
// (C) 199x-2005 Vanderbilt University

/// @file   testing/unittest/TestFixture.hh
///
/// @brief  Unit test test fixture.
/// @author Ion Yannopoulos
/// @note   Currently there isn't much to these.


#ifndef INCLUDED_testing_unittest_TestFixture_HH
#define INCLUDED_testing_unittest_TestFixture_HH


// Project forward headers
//- #include <testing/unittest/TestFixture.fwd.hh>
 
 
// Project headers


// External library headers
#include <boost/test/unit_test_suite.hpp>


// Macros


/// @brief Define a fixture.
#define TEST_FIXTURE_BEGIN(CLASS) \
	struct CLASS                    \
    : public testing::unittest::TestFixture \
	{
/// @brief End a fixture definition.
#define TEST_FIXTURE_END          \
	};


/// @brief Define a fixture setup function
#define TEST_FIXTURE_SETUP_BEGIN(CLASS) \
  CLASS() : testing::unittest::TestFixture()
/// @brief End a fixture setup definition
#define TEST_FIXTURE_SETUP_END


/// @brief Define a fixture teardown function
#define TEST_FIXTURE_TEARDOWN_BEGIN(CLASS) \
  ~CLASS()
/// @brief End a fixture teardown definition
#define TEST_FIXTURE_TEARDOWN_END


/// @brief Construct a fixture (the constructor is the setup function)
///
/// When the fixture goes out of scope the destructor will teardown.
#define TEST_FIXTURE_USE(CLASS, OBJECT) \
	CLASS OBJECT;


/// @brief Call a fixture setup function
/// @note Prefer use of #TEST_FIXTURE_USE.
#define TEST_FIXTURE_SETUP_FUNCTION(FUNCTION, OBJECT) \
  FUNCTION(OBJECT);
/// @brief Call a fixture teardown function
#define TEST_FIXTURE_TEARDOWN_FUNCTION(FUNCTION, OBJECT) \
  FUNCTION(OBJECT);


/// @brief Call a fixture setup method
/// @note Prefer use of #TEST_FIXTURE_USE.
#define TEST_FIXTURE_SETUP_METHOD(OBJECT, METHOD) \
  OBJECT.METHOD();
/// @brief Call a fixture teardown method
#define TEST_FIXTURE_TEARDOWN_METHOD(OBJECT, METHOD) \
  OBJECT.METHOD();


namespace testing {
namespace unittest {

/// @brief Test fixtures
/// @note  This class exists as a hook, if text fixtures ever need anything else.
class TestFixture {};

/// @brief Fixture setup free functions
typedef void TestSetup(void *);

/// @brief Fixture teardown free functions
typedef void TestTeardown(void *);

} // namespace unittest
} // namespace testing


#endif // INCLUDED_testing_unittest_TestFixture_HH
