// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/...
// (C) 199x-2005 University of Washington
// (C) 199x-2005 University of California Santa Cruz
// (C) 199x-2005 University of California San Francisco
// (C) 199x-2005 Johns Hopkins University
// (C) 199x-2005 University of North Carolina, Chapel Hill
// (C) 199x-2005 Vanderbilt University

/// @file   testing/unittest/Tests.hh
///
/// @brief
/// @author


#ifndef INCLUDED_testing_unittest_Tests_HH
#define INCLUDED_testing_unittest_Tests_HH


// Testing forward headers
//- #include <testing/unittest/Tests.fwd.hh>


// Testing headers


// External library headers
#include <boost/test/test_tools.hpp>

// XXX: This has to be included to get the BOOST_*_CLOSE macros in
// XXX: test_tools.hpp to work.
// XXX: The Boost.Test header layout is something of a mess.
#include <boost/test/floating_point_comparison.hpp>


// C++ headers


// Operating system headers


// Forward declarations


// Macros


// --- TEST_NOTE_*


/// @brief The NOTE_* macros will generate a message, but not increase the
///   error count, or abort the test.
#define TEST_NOTE(predicate)    BOOST_WARN(predicate)
/// @brief A NOTE_* macro which prints a user-specified message in addition to
///   the failed predicate.
#define TEST_NOTE_MESSAGE(predicate, message) \
                                BOOST_WARN_MESSAGE(predicate, message)
/// @brief A NOTE_* macro which compares for value equality.  Note that this does
////  not necessarily mean indetical bits.
#define TEST_NOTE_EQUAL(first, second) \
                                BOOST_WARN_EQUAL(first, second)
/// @brief A NOTE_* macro which compares for equality, of bit representation,
///   rather than the value as interpreted.
#define TEST_NOTE_EQUAL_BITWISE(first, second) \
                                BOOST_WARN_BITWISE_EQUAL(first, second)
/// @brief A NOTE_* macro which compares values to see if they are within a
///   certain range of each other.  This is essential for floating point numbers.
#define TEST_NOTE_CLOSE(first, second, within) \
                                BOOST_WARN_CLOSE(first, second, within)
/// @brief A NOTE_* macro which compares two range of values, expressed as
///   iterators.
#define TEST_NOTE_EQUAL_RANGE(first_begin, first_end, second_begin, second_end) \
                                BOOST_WARN_EQUAL_COLLECTIONS(first_begin, first_end, \
                                                             second_begin, second_end)
/// @brief A NOTE_* macro which compares two complete STL containers
#define TEST_NOTE_EQUAL_COLLECTION(first, second) \
                              	BOOST_WARN_EQUAL_COLLECTIONS(first.begin(), first.end(), \
               										                           second.begin(), second.end())


/// @brief A NOTE_* macro which always fails.
#define TEST_WARN(message)      TEST_NOTE_MESSAGE(false, message)


// --- TEST_CHECK_*


/// @brief The CHECK_* macros will increase the error count, but not abort
///   the test.
#define TEST_CHECK(predicate)   BOOST_CHECK(predicate)
/// @brief A CHECK_* macro which prints a user-specified message in addition
///   to the failed predicate.
#define TEST_CHECK_MESSAGE(predicate, message) \
                                BOOST_CHECK_MESSAGE(predicate, message)
/// @brief A CHECK_* macro which compares for value equality.  Note that this
///   does not necessarily mean indetical bits.
#define TEST_CHECK_EQUAL(first, second) \
                                BOOST_CHECK_EQUAL(first, second)
/// @brief A CHECK_* macro which compares for equality, of bit representation,
///   rather than the value as interpreted.
#define TEST_CHECK_EQUAL_BITWISE(first, second) \
                                BOOST_CHECK_BITWISE_EQUAL(first, second)
/// @brief A CHECK_* macro which compares values to see if they are within a
///   certain range of each other.  This is essential for floating point numbers.
#define TEST_CHECK_CLOSE(first, second, within) \
                                BOOST_CHECK_CLOSE(first, second, within)
/// @brief A CHECK_* macro which compares two range of values, expressed as
///   iterators.
#define TEST_CHECK_EQUAL_RANGE(first_begin, first_end, second_begin, second_end) \
                                BOOST_CHECK_EQUAL_COLLECTIONS(first_begin, first_end, \
                                                              second_begin, second_end)
/// @brief A NOTE_* macro which compares two complete STL containers
#define TEST_CHECK_EQUAL_COLLECTION(first, second) \
                              	BOOST_CHECK_EQUAL_COLLECTIONS(first.begin(), first.end(), \
               										                           second.begin(), second.end())
/// @brief A CHECK_* macro which throws a user-defined exception on failure
/// @note TEST_CHECK_THROW has no equivalents for NOTE_* or REQUIRE_*.
#define TEST_CHECK_THROW(predicate, exception) \
                                BOOST_CHECK_THROW(predicate, exception)

/// @brief A CHECK_* macro which always fails
#define TEST_ERROR(message)     TEST_CHECK_MESSAGE(false, message)


// --- TEST_REQUIRE_*


/// @brief The REQUIRE_* macros will increase the error count, and also abort
///   the test.
#define TEST_REQUIRE(predicate) BOOST_CHECK(predicate)
/// @brief A REQUIRE__* macro which prints a user-specified message in addition
///   to the failed predicate.
#define TEST_REQUIRE_MESSAGE(predicate, message) \
                                BOOST_REQUIRE_MESSAGE(predicate, message)
/// @brief A REQUIRE_* macro which compares for value equality.  Note that this
///   does not necessarily mean indetical bits.
#define TEST_REQUIRE_EQUAL(first, second) \
                                BOOST_REQUIRE_EQUAL(first, second)
/// @brief A REQUIRE_* macro which compares for equality, of bit representation,
///   rather than the value as interpreted.
#define TEST_REQUIRE_EQUAL_BITWISE(first, second) \
                                BOOST_REQUIRE_BITWISE_EQUAL(first, second)
/// @brief A REQUIRE_* macro which compares values to see if they are within a
///   certain range of each other.  This is essential for floating point numbers.
#define TEST_REQUIRE_CLOSE(first, second, within) \
                                BOOST_REQUIRE_CLOSE(first, second, within)
/// @brief A REQUIRE_* macro which compares two range of values, expressed as
///   iterators.
#define TEST_REQUIRE_EQUAL_RANGE(first_begin, first_end, second_begin, second_end) \
                                BOOST_REQUIRE_EQUAL_COLLECTIONS(first_begin, first_end, \
                                                                second_begin, second_end)
/// @brief A NOTE_* macro which compares two complete STL containers
#define TEST_REQUIRE_EQUAL_COLLECTION(first, second) \
                              	BOOST_REQUIRE_EQUAL_COLLECTIONS(first.begin(), first.end(), \
               										                              second.begin(), second.end())
/// @brief A REQUIRE_* macro which always fails
#define TEST_FATAL(message)     TEST_REQUIRE_MESSAGE(false, message)


/// @brief A macro which simply prints a message.  It doesn't actually test
///   anything, and is used merely for diagnostics.
#define TEST_MESSAGE(message)   BOOST_MESSAGE(message)


/// @brief A stub for other test macros, IGNORE evaluates to true.
///   It can be used to mark a place which is not ready to test but will need
///   future checking.
#define TEST_IGNORE(predicate)  BOOST_IGNORE_CHECK(predicate)
/// @brief A stub for other test macros, IGNORE_MESSAGE evaluates to true.
///   It can be used to mark a place which is not ready to test but will need
///   future checking.
#define TEST_IGNORE_MESSAGE(predicate, message) \
                                BOOST_IGNORE_CHECK(predicate)



namespace testing {
namespace unittest {


} // namespace unittest
} // namespace testing


#endif // INCLUDED_testing_unittest_Tests_HH
