// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/io/ocstream.cc
/// @brief  Output channel stream wrapper base class,
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


// Unit header
#include <utility/io/ocstream.hh>

// C++ headers
#include <iostream>


namespace utility {
namespace io {
namespace oc { // Predefined ocstreams


/// @brief Wrapper around std::cout
ocstream cout( std::cout );

/// @brief Wrapper around std::cerr
ocstream cerr( std::cerr );

/// @brief Wrapper around std::clog
ocstream clog( std::clog );


} // namespace oc
} // namespace io
} // namespace utility
