// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/keys/KeyCount.hh
/// @brief  Key counter functor
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
///
/// @note   Useful for holding the number of keys in a namespace-scoped UserKey collection


#ifndef INCLUDED_utility_keys_KeyCount_HH
#define INCLUDED_utility_keys_KeyCount_HH


// Unit headers
#include <utility/keys/KeyCount.fwd.hh>

// C++ headers
#include <cassert>
#include <cstddef>


namespace utility {
namespace keys {


/// @brief Key counter functor
class KeyCount
{


public: // Types


	// STL/boost style
	typedef  std::size_t  size_type;

	// Project style
	typedef  std::size_t  Size;


public: // Creation


	/// @brief Count constructor
	inline
	explicit
	KeyCount( Size const count_a ) :
		count_( count_a )
	{}


	/// @brief Count + expected count constructor
	/// @note  Useful if a namespace constant is stored with the number of keys
	///        so that other namespace-scoped UserKeys can set contiguous indexes
	///        without global initialization order issues
	inline
	explicit
	KeyCount( Size const count_a, Size const expected_count ) :
		count_( count_a )
	{
		assert( count_ == expected_count );
		if ( this ); // Silly if to suppress unused variable warnings
	}


public: // Properties


	/// @brief Count
	inline
	Size
	operator ()() const
	{
		return count_;
	}


private: // Fields


	/// @brief Count of keys
	Size count_;


}; // KeyCount


} // namespace keys
} // namespace utility


#endif // INCLUDED_utility_keys_KeyCount_HH
