# This file is made available under the Rosetta Commons license.
# See http://www.rosettacommons.org/license
# (C) 199x-2007 University of Washington
# (C) 199x-2007 University of California Santa Cruz
# (C) 199x-2007 University of California San Francisco
# (C) 199x-2007 Johns Hopkins University
# (C) 199x-2007 University of North Carolina, Chapel Hill
# (C) 199x-2007 Vanderbilt University

## @file   utility/options/options.py
## @brief  Program options generation script that is run to generate the options
## @author Sergey Lyskov (Sergey.Lyskov@jhu.edu)

# Script for generating option.gen.cc.hh, keys/OptionKeys.hh.gen.hh, keys/OptionKeys.cc.gen.hh files
# Use 'python options.py -Wiki' to generate a Wiki table

import sys

import options_class, options_package
Options = options_package.Options


def main(args):
    if len(args) <= 1:  # no option give - just generating C++ files.
        options_class.writeToFile(Options, 'option.cc.gen.hh', options_class.Option.getOptionCC)
        options_class.writeToFile(Options, 'keys/OptionKeys.hh.gen.hh', options_class.Option.getOptionKeysHH)
        options_class.writeToFile(Options, 'keys/OptionKeys.cc.gen.hh', options_class.Option.getOptionKeysCC)
        print "Total %s options." % len(Options)
    elif args[1] == '-Wiki':
        print options_class.printWikiTable(Options)


if __name__ == "__main__":  main(sys.argv)
