# This file is made available under the Rosetta Commons license.
# See http://www.rosettacommons.org/license
# (C) 199x-2007 University of Washington
# (C) 199x-2007 University of California Santa Cruz
# (C) 199x-2007 University of California San Francisco
# (C) 199x-2007 Johns Hopkins University
# (C) 199x-2007 University of North Carolina, Chapel Hill
# (C) 199x-2007 Vanderbilt University

## @file   options/options/options_project.py
## @brief  Program options generation script: Project-specific options example
## @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


from options_class import Option, Option_Group

Options = Option_Group( '',
  Option_Group( 'run',
    Option( 'run', 'Boolean', desc='Run option group', legal='true', default='true' ),
    Option( 'benchmark', 'Boolean', desc='Run in benchmark mode' ),
    Option( 'verbosity', 'Integer', desc='Logging verbosity level', lower='0', upper='9', default='0' ),
  ),
  Option_Group( 'in',
    Option( 'in', 'Boolean', desc="Input option group", legal='true', default='true' ),
    Option( 'termini', 'Boolean', desc="Put full termini on input structures" ),
    Option_Group( 'path',
      Option( 'path', 'PathVector', desc="Paths to search for input files (checked after type-specific paths)", default="." ),
      Option( 'fragments', 'PathVector', desc="Fragment file input search paths" ),
      Option( 'pdb', 'PathVector', desc="PDB file input search paths" ),
      Option( 'database', 'PathVector', desc="Database file input search paths" ),
    ),
  ),
  Option_Group( 'out',
    Option( 'out', 'Boolean', desc="Ouput option group", legal='true', default='true' ),
    Option( 'overwrite', 'Boolean', desc="Ignore 'CHECKPOINT' file and the overwrite the PDB file(s)" ),
    Option_Group( 'path',
      Option( 'path', 'Path', desc="Default file output path", default="." ),
      Option( 'pdb', 'Path', desc="PDB file output path" ),
      Option( 'score', 'Path', desc="Score file output path" ),
      Option( 'movie', 'Path', desc="Movie file output path" ),
    ),
  ),
)