// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/pointer/access_ptr.fwd.hh
/// @brief  utility::pointer::access_ptr forward declarations
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_utility_pointer_access_ptr_FWD_HH
#define INCLUDED_utility_pointer_access_ptr_FWD_HH


// C++ headers
#include <cstddef>


namespace utility {
namespace pointer {


// Forward
template< typename T > class access_ptr;


// Types
typedef  access_ptr< bool >                access_ptr_bool;
typedef  access_ptr< short int >           access_ptr_short;
typedef  access_ptr< int >                 access_ptr_int;
typedef  access_ptr< long int >            access_ptr_long;
typedef  access_ptr< unsigned short int >  access_ptr_ushort;
typedef  access_ptr< unsigned int >        access_ptr_uint;
typedef  access_ptr< unsigned long int >   access_ptr_ulong;
typedef  access_ptr< std::size_t >         access_ptr_size_t;
typedef  access_ptr< float >               access_ptr_float;
typedef  access_ptr< double >              access_ptr_double;
typedef  access_ptr< long double >         access_ptr_longdouble;
typedef  access_ptr< char >                access_ptr_char;
typedef  access_ptr< unsigned char >       access_ptr_uchar;
typedef  access_ptr< signed char >         access_ptr_schar;


} // namespace pointer
} // namespace utility


#endif // INCLUDED_utility_pointer_access_ptr_FWD_HH
