// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/pointer/pointer.functions.hh
/// @brief  Pointer utility functions
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_utility_pointer_pointer_functions_HH
#define INCLUDED_utility_pointer_pointer_functions_HH


namespace utility {
namespace pointer {


///@brief  Delete a pointer and assign a new pointer
template< typename T >
inline
void
delete_and_assign( T * & p, T * n )
{
	delete p; p = n;
}


///@brief  Delete a pointer and assign and set it to zero
template< typename T >
inline
void
delete_and_zero( T * & p )
{
	delete p; p = 0;
}


///@brief  Delete a pointer to an array and assign a new pointer
template< typename T >
inline
void
delete_and_assign_array( T * & p, T * n )
{
	delete[] p; p = n;
}


///@brief  Delete a pointer to an array and set it to zero
template< typename T >
inline
void
delete_and_zero_array( T * & p )
{
	delete[] p; p = 0;
}


} // namespace pointer
} // namespace utility


#endif // INCLUDED_utility_pointer_pointer_functions_HH
