// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/vectorL_Selector.hh
/// @brief  vectorL lower index selectors
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)


#ifndef INCLUDED_utility_vectorL_Selector_HH
#define INCLUDED_utility_vectorL_Selector_HH


// Unit headers
#include <utility/vectorL.fwd.hh>

// C++ headers
#include <cstddef>


namespace utility {


/// @brief vectorL index type selector: Nonnegative lower index non-specialization
template< bool >
struct vectorL_IndexSelector
{
	typedef  std::size_t  index_type;
	typedef  std::size_t  Index;
};


/// @brief vectorL index type selector: Negative lower index specialization
template<>
struct vectorL_IndexSelector< false >
{
	typedef  ssize_t  index_type;
	typedef  ssize_t  Index;
};


/// @brief vectorL lower index zero selector: Nonzero lower index non-specialization
template< bool >
struct vectorL_ZeroSelector
{


	/// @brief ( i >= l )
	inline
	static
	bool
	ge( std::size_t const i, std::size_t const l )
	{
		return ( i >= l );
	}


	/// @brief ( i >= l ) and ( i - l ) is within ssize_t range
	inline
	static
	bool
	ge( ssize_t const i, ssize_t const l )
	{
		return ( ( i >= l ) && ( i - l >= 0 ) ); // Second clause catches range errors for the difference
	}


};


/// @brief vectorL lower index zero selector: Zero lower index specialization
template<>
struct vectorL_ZeroSelector< false >
{


	/// @brief ( i >= l )
	inline
	static
	bool
	ge( std::size_t const, std::size_t const )
	{
		return true; // Always true when l == 0
	}


};


} // namespace utility


#endif // INCLUDED_utility_vectorL_Selector_HH
