// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 9836 $
//  $Date: 2006-08-16 15:36:45 -0700 (Wed, 16 Aug 2006) $
//  $Author: pbradley $

#ifndef INCLUDED_symmetry_info
#define INCLUDED_symmetry_info


// Rosetta Headers
//#include "kin_stub.h"
//#include "pose_param.h"
//#include "SpaceGroup.h"

//#include <numeric/all.fwd.hh>
//#include <numeric/xyzVector.hh>
//#include <numeric/xyzMatrix.hh>
//#include <numeric/xyz.functions.hh>
//#include <numeric/xyzVector.io.hh>
//#include <numeric/xyzMatrix.io.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
//#include <ObjexxFCL/FArray1D.hh>
//#include <ObjexxFCL/FArray1Da.hh>
//#include <ObjexxFCL/FArray2Da.hh>

// C++ Headers
#include <iosfwd>
#include <string>
#include <vector>
#include <map>

namespace pose_ns {

	class Symmetry_info {
	public:

		inline
		int
		bb_follows( int const seqpos ) const;

		inline
		int
		chi_follows( int const seqpos ) const;

		inline
		int
		jump_follows( int const seqpos ) const;


		inline
		bool
		bb_independent( int const seqpos ) const
		{ return bb_follows(seqpos)==0;}

		inline
		bool
		chi_independent( int const seqpos ) const
		{ return chi_follows(seqpos)==0;}

		inline
		bool
		jump_independent( int const seqpos ) const
		{ return jump_follows(seqpos)==0;}


		// currently -- all bb-indep positions have the same number of clones
		// similarly for chi_clones
		inline
		int
		num_bb_clones() const;

		inline
		int
		num_chi_clones() const;


		// residues to exclude from total_residue
		inline
		int
		exclude_from_total_residue() const;

		inline
		void
		set_exclude_pseudo_from_total_residue( bool const setting ) {
			exclude_pseudo_from_total_residue = setting;
		}


		// clone list accessors
		inline
		std::vector< int > const &
		bb_clones( int const seqpos ) const;

		inline
		std::vector< int > const &
		chi_clones( int const seqpos ) const;

		inline
		std::vector< int > const &
		jump_clones( int const base_jump ) const;

		void
		add_bb_clone( int const base_pos, int const clone_pos );

		void
		add_chi_clone( int const base_pos, int const clone_pos );

		void
		add_jump_clone( int const base_jump, int const clone_jump );


		float
		deriv_scale_factor(
			int const seqpos,
			int const torsion
		) const;


		inline
		int npseudo() const { return npseudo_; }

		inline
		int & npseudo() { return npseudo_; }

		inline
		int nres_monomer() const { return chi_clones_.size(); }

		inline
		int nres_monomer_bb() const { return bb_clones_.size(); }

		inline
		int nres_monomer_chi() const { return chi_clones_.size(); }

		inline
		int N() const { return 1+num_chi_clones(); }

		inline
		int N_bb() const { return 1+num_bb_clones(); }

		inline
		int N_chi() const { return 1+num_chi_clones(); }

		inline
		std::string symm_type() const { return type_; }

		int
		num_indep_jump( int const num_jump ) const;

		int
		indep_jump( int const i, int const num_jump ) const;

		Symmetry_info(
			int const nres_monomer,
			int const njump_monomer, // # of jumps internal monomer
			int const N,
			std::string const & type
		);

		Symmetry_info(
    int const nres_monomer,
    int const njump_monomer,
    int const N,
    int score_monomer,
    std::string const & type
  );

		Symmetry_info():
		exclude_pseudo_from_total_residue( false ) {}

// 		void
// 		setup(
// 			int const npseudo,
// 			std::map< int, std::vector< int > > const & bclones,
// 			std::map< int, std::vector< int > > const & cclones,
// 			std::map< int, std::vector< int > > const & jclones
// 		);

		friend
		std::istream &
		operator >>( std::istream & is, Symmetry_info & s );

		friend
		std::ostream &
		operator <<( std::ostream & out, Symmetry_info const & s );


		friend
		bool
		operator== ( Symmetry_info const & a, Symmetry_info const & b );

		friend
		bool
		operator!= ( Symmetry_info const & a, Symmetry_info const & b );

	private:

		// fills num_indep_jump_ and indep_jump_
		// based on num_jump_ and jump_clones_
		//
		void
		setup_jump_maps(
			int const num_jump,
			int & num_indep_jumps,
			FArray1D_int & indep_jumps
		) const;

		void
		setup_clone_follows();


		// mapping from each primary jump to it's clones
		std::map< int, std::vector< int > >   bb_clones_;
		std::map< int, std::vector< int > >  chi_clones_;
		std::map< int, std::vector< int > > jump_clones_;
		// these are derived from the above lists:
		std::map< int, int >   bb_follows_;
		std::map< int, int >  chi_follows_;
		std::map< int, int > jump_follows_;
		int npseudo_;
		std::string type_;

		// hack for handling total_residue issues
		bool exclude_pseudo_from_total_residue;

		// silly! should make static class data
		std::vector< int > empty_list;

	};

	inline
	int
	Symmetry_info::num_bb_clones() const
	{
		// all these lists have the same size
		return bb_clones_.begin()->second.size();
	}


	inline
	int
	Symmetry_info::num_chi_clones() const
	{
		// all these lists have the same size
		return ( chi_clones_.size() ? chi_clones_.begin()->second.size() : 0 );
	}

	inline
	int
	Symmetry_info::bb_follows( int const seqpos ) const
	{
		std::map< int, int >::const_iterator it( bb_follows_.find( seqpos ) );
		return ( it == bb_follows_.end() ? 0 : it->second );
	}

	inline
	int
	Symmetry_info::chi_follows( int const seqpos ) const
	{
		std::map< int, int >::const_iterator it( chi_follows_.find( seqpos ) );
		return ( it == chi_follows_.end() ? 0 : it->second );
	}

	inline
	int
	Symmetry_info::jump_follows( int const seqpos ) const
	{
		std::map< int, int >::const_iterator it( jump_follows_.find( seqpos ) );
		return ( it == jump_follows_.end() ? 0 : it->second );
	}


	//////////////////////////////////
	// these are the const accessors
	//

	inline
	std::vector< int > const &
	Symmetry_info::bb_clones( int const seqpos ) const
	{
		std::map< int, std::vector< int > >::const_iterator it
			( bb_clones_.find( seqpos ) );
		if ( it == bb_clones_.end() ) {
			return empty_list;
		}
		return it->second;
	}

	inline
	std::vector< int > const &
	Symmetry_info::chi_clones( int const seqpos ) const
	{
		std::map< int, std::vector< int > >::const_iterator it
			( chi_clones_.find( seqpos ) );
		if ( it == chi_clones_.end() ) {
			return empty_list;
		}
		return it->second;
	}

	inline
	std::vector< int > const &
	Symmetry_info::jump_clones( int const base_jump ) const
	{
		std::map< int, std::vector< int > >::const_iterator it
			( jump_clones_.find( base_jump ) );
		if ( it == jump_clones_.end() ) {
			return empty_list;
		}
		return it->second;
	}


	inline
	int
	Symmetry_info::exclude_from_total_residue() const
	{
		if ( exclude_pseudo_from_total_residue ) {
			return npseudo_;
		} else {
			return 0;
		}
	}

}

#endif
