// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 13616 $
//  $Date: 2007-03-18 01:39:36 -0500 (Sun, 18 Mar 2007) $
//  $Author: stuartm $

#ifndef INCLUDED_taboo_search
#define INCLUDED_taboo_search


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// C++ Headers
#include <map>
#include <iosfwd>
#include <string>
#include <vector>


void
set_taboo_flag ( bool yesno);

void
set_taboo_active ( bool yesno );

void
initialize_taboo();

void
initialize_taboo_start();

void
initialize_taboo_decoy();

std::string
get_current_barcode();

std::string
get_best_barcode();

void
conclude_taboo_decoy();

void
reset_active_taboo_map();

void
set_active_aspiration_map( int tenure, int score, int bin_size );

bool
get_accum_taboo_flag();

void
taboo_new_move();

void
taboo_accept();

bool
check_barcode_validity( std::string const & barcode );

void
write_taboo_file( utility::io::orstream & taboo_out_stream, std::string const & tag );

std::string
barcode_vector(
	FArray1D_float const & phi,
	FArray1D_float const & psi,
	int start,
	int end
);

std::string
feature_barcode_vector(
	FArray1D_float const & phi,
	FArray1D_float const & psi
);


int
phipsi_bin( float angle );

std::string
map_to_string( std::map< std::string, int > const & intmap );

float
taboo_bonus();

std::string
get_taboo_list_file_name();

bool
taboo_list_file_exist();

//float taboo_c();

float
taboo_b();

float
taboo_influence();

bool
get_taboo_exist();

bool get_taboo_mode_exist();

int
get_taboo_mode ();

void
output_decoy_barcode( std::ostream & out );


////////////////////////////////////////////////////////////////////
//class definitions


class cTaboo
{

	//friend std::ostream & operator <<( std::ostream & out, cTaboo const & thisData) {
	//	out << "score = " << thisData.score << "; tenure = " << thisData.tenure;
	//}

	public:

		cTaboo();
		cTaboo( int score, int tenure, int id = 0 );

		~cTaboo();

		inline
		bool
		operator ==( cTaboo const & otherdata ) const
		{
			return (
			 tenure == otherdata.tenure &&
			 score == otherdata.score &&
			 id == otherdata.id );
		}

		inline
		bool
		operator !=( cTaboo const & otherdata ) const
		{
			return !(
			 tenure == otherdata.tenure &&
			 score == otherdata.score &&
			 id == otherdata.id );
		}

		//data:
		int tenure;
		int score;
		int id;

	private:
		void set_tenure( int i );

};


class cTrace{

	public:
		cTrace();

		~cTrace();

		void dump();

		void
		update(
			FArray1D_float const & thisphi,
			FArray1D_float const & thispsi,
			float thisscore = 0.0
		);

		void clear();

	//data
		std::vector< FArray1D_float > phi_trace;
		std::vector< FArray1D_float > psi_trace;
		std::vector< float > score_trace;

};


class cTabooMap{

	//friend std::ostream & operator <<( std::ostream & out, const cTabooMap & thisData );

	public:

		typedef  std::map< std::string, cTaboo >  Map;

	//cstors/dtor
		cTabooMap();

		~cTabooMap();

		//Objexx:SGM This should really be a binary non-member function
		bool
		operator ==( cTabooMap const & otherdata ) const
		{
			if ( taboo.size() != otherdata.taboo.size() ) return false;

			Map::const_iterator pos, otherpos;
			for ( pos = taboo.begin(); pos != taboo.end(); ++pos ) {
				otherpos = otherdata.taboo.find( pos->first );
				if ( otherpos == otherdata.taboo.end() ) { // Key not found
					return false;
				} else if ( pos->second != otherpos->second ) {
					return false;
				}
			}

			return ( aspiration == otherdata.aspiration );
		}

		void update( std::string const & barcode );

		void update ( int score, int tenure, std::string const & barcode );

		void update_from_file( std::string const & taboo_list_file );

		int score( std::string const & barcode );

		int get_id( std::string const & taboo_name );

		void remove_expired();

		void reduce_tenure();

		void retrieve_from_trace( int tenure, const cTrace & trace );

		void dump();

		void clear();  // clear out the taboo map


		//data
		Map taboo;
		bool aspiration; // determines if you want to favor this barcode or not
		float barcode_dist_thresh; //the distance threshhold for assigning barcode

};


namespace taboo_map_ns {

//-------------------------------
// taboo search params
//-------------------------------

extern bool taboo_mode_flag; //true if in taboo search mode
extern bool taboo_flag; //true if in taboo is active
extern int BB_BIN_WIDTH;
extern int TENURE;
extern cTabooMap taboo_map;
extern cTabooMap active_taboo_map;
extern cTabooMap imported_taboo_map;
extern cTabooMap trace_taboo_map;
extern cTabooMap tried_taboo_map;
extern cTrace search_trace;
extern cTrace aspiration_sites;
extern int taboo_mode;
extern std::string taboo_list_file;
extern bool increment_taboo_flag;
extern bool taboo_diagnosis;
extern bool taboo_penalize_trace;
extern bool taboo_penalize_tried;
extern std::string nat_code;
extern std::string taboo_header;
extern bool taboo_continuous;

}

float set_phipsi_range ( float const & phi );


#endif
