// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   numeric/xyzMatrix.test.hh
/// @brief  test suite for numeric::xyzMatrix
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


#ifndef INCLUDED_numeric_xyzMatrix_test_HH
#define INCLUDED_numeric_xyzMatrix_test_HH


// Testing headers
#include <testing/unittest/Tests.hh>
#include <testing/unittest/TestSuite.hh>
#include <testing/unittest/TestCase.hh>
#include <testing/unittest/TestFixture.hh>


namespace test {
namespace numeric {


// Declare test suites
TEST_SUITE( Tests_xyzMatrix )
TEST_SUITE( Tests_xyzMatrix_Construct )
TEST_SUITE( Tests_xyzMatrix_Assign )


// Declare test cases
TEST_CASE( test_xyzMatrix_ConstructIdentity )
TEST_CASE( test_xyzMatrix_ConstructFromVectors )
TEST_CASE( test_xyzMatrix_ConstructFromValues )
TEST_CASE( test_xyzMatrix_ConstructFromContiguous )
TEST_CASE( test_xyzMatrix_AssignFromSingleValue )
TEST_CASE( test_xyzMatrix_AssignFromContiguous )
TEST_CASE( test_xyzMatrix_AssignFromRowsCols )
TEST_CASE( test_xyzMatrix_Access )
TEST_CASE( test_xyzMatrix_CalculatedProperties )
TEST_CASE( test_xyzMatrix_Operations )
// TEST_CASE( test_xyzMatrix_Rotation )


} // namespace numeric
} // namespace test


#endif // INCLUDED_numeric_xyzMatrix_test_HH
