// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   numeric/xyzVector.test.hh
/// @brief  test suite for numeric::xyzVector
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


#ifndef INCLUDED_numeric_xyzVector_test_HH
#define INCLUDED_numeric_xyzVector_test_HH


// Testing headers
#include <testing/unittest/Tests.hh>
#include <testing/unittest/TestSuite.hh>
#include <testing/unittest/TestCase.hh>
#include <testing/unittest/TestFixture.hh>


namespace test {
namespace numeric {


// Declare test suites
TEST_SUITE(Tests_xyzVector)


// Declare test cases
TEST_CASE(test_xyzVector_ConstructFromSingleValue)
TEST_CASE(test_xyzVector_ConstructFrom1DArrayPointer)
TEST_CASE(test_xyzVector_ConstructFrom2DArrayPointer)
TEST_CASE(test_xyzVector_Length)
TEST_CASE(test_xyzVector_Accessors)
TEST_CASE(test_xyzVector_Relations)
TEST_CASE(test_xyzVector_BinaryOperations)


} // namespace numeric
} // namespace test


#endif // INCLUDED_numeric_xyzVector_test_HH
