// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/io/zipstream.test.cc
/// @brief  zipstream unit test suite
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


#include <utility/io/zipstream.test.hh>
//#include <utility/io/izstream.hh>
#include <utility/io/ocstream.hh>
#include <utility/io/ozstream.hh>

#include <iostream>


namespace test {
namespace utility {
namespace io {


// --- define helper functions in separate namespace
namespace zipstream_tests {

::utility::io::orstream &
output_( ::utility::io::orstream & os )
{
	os << "Test Line 1" << std::endl;
	os << "Test Line 2" << std::endl;
	return os;
}

}  // namespace zipstream_tests
using namespace zipstream_tests;


// --- set up the test suite
TEST_SUITE_BEGIN(Zipstream_Tests)

// for now, leave this test out -- it prints to cout and creates a local file
//	TEST_SUITE_USES_CASE(test_zipstream_general)

TEST_SUITE_END


// --- set up the individual test cases

/// @brief General tests
TEST_CASE_BEGIN(test_zipstream_general)
{
	// print test output to standard output stream (via our wrapper)
	output_( ::utility::io::oc::cout );

	// print test output to a zipped file
	::utility::io::ozstream mystream( "zipstream_test_output.gz" );
	output_( mystream );
}
TEST_CASE_END


} // namespace io
} // namespace utility
} // namespace test
