// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   utility/pointer/access_ptr.hh
/// @brief  Unit tests for utility::pointer::owning_ptr with multiple inheritance
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)
/// @author Kevin P. Hinshaw (KevinHinshaw@gmail.com)


// Headers
//#include <iostream> // Put this first to allow debug print-outs in project headers
#include <utility/pointer/owning_ptr_MI.test.hh>
#include <utility/pointer/owning_ptr.hh>
#include <utility/pointer/ReferenceCountMI.hh>
#include <utility/pointer/ReferenceCountMI_.hh>
#include <set>


namespace test {
namespace utility {
namespace pointer {


// --- set up some helper classes/functions for these tests
// --- (these go in a special namespace to be used from this file only!)
namespace owning_ptr_MI_test {

class Atom :
	virtual public ::utility::pointer::ReferenceCountMI
{
public:

	Atom()
	{
		++nAtoms;
	}

	virtual
	~Atom()
	{
		--nAtoms;
	}

	static int nAtoms; // For tracking destructions
};
int Atom::nAtoms = 0;


class Atom_ :
	public Atom,
	public ::utility::pointer::ReferenceCountMI_
{
public:

	Atom_( double const weight, double const charge ) :
		weight_( weight ),
		charge_( charge )
	{}

	virtual
	~Atom_()
	{}

	double weight_;
	double charge_;
};

} // namespace owning_ptr_MI_test

// The tests live in the test::utility::pointer namespace, but
// grant them access to our local namespace for classes/functions.

using namespace owning_ptr_MI_test;

// --- set up the test suite
TEST_SUITE_BEGIN(Owning_Ptr_MI_Tests)
	TEST_SUITE_USES_CASE(test_owning_ptr_MI_explicit)
TEST_SUITE_END

// --- set up the individual test cases

/// @brief Explicit owning pointer
TEST_CASE_BEGIN(test_owning_ptr_MI_explicit)
{
	typedef  ::utility::pointer::owning_ptr< Atom >  AtomP;
	Atom * Cp = new Atom_( 12.0, 0.0 ); // Raw heap pointer

	TEST_CHECK( Atom::nAtoms == 1 );
	TEST_CHECK( Cp->ref_count() == 0 );
	{
		AtomP C( Cp ); // First owning pointer has sole ownership
		TEST_CHECK( Cp->ref_count() == 1 );
		{
			AtomP C2( Cp ); // Second owning pointer shares ownership
			TEST_CHECK( Cp->ref_count() == 2 );
			{
				AtomP C3( C2 ); // Third owning pointer created from 2nd and shares ownership
				TEST_CHECK( Cp->ref_count() == 3 );
			}
		}
		TEST_CHECK( Cp->ref_count() == 1 );
	}
	// Atom should have been destructed
	TEST_CHECK( Atom::nAtoms == 0 );
}
TEST_CASE_END


} // namespace pointer
} // namespace utility
} // namespace test
