// Testing headers
#include <testing/unittest/unittest.hh>

// Test headers

#include <utility/BitSet.test.hh>
#include <utility/BitVector.test.hh>
#include <utility/vector0.test.hh>
#include <utility/vector1.test.hh>
#include <utility/vector1_bool.test.hh>
#include <utility/vectorL.test.hh>

#include <utility/factory/Factory.test.hh>

#include <utility/io/zipstream.test.hh>

#include <utility/keys/AutoKey.test.hh>
#include <utility/keys/ClassKeyMap.test.hh>
#include <utility/keys/ClassKeyVector.test.hh>
#include <utility/keys/Key4Tuple.test.hh>
#include <utility/keys/Key4Vector.test.hh>
#include <utility/keys/SmallKeyMap.test.hh>
#include <utility/keys/SmallKeyVector.test.hh>
#include <utility/keys/UserKey.test.hh>

#include <utility/pointer/access_ptr.test.hh>
#include <utility/pointer/owning_ptr.test.hh>
#include <utility/pointer/owning_ptr_MI.test.hh>


TEST_SUITE(All_Utility_Tests)

TEST_SUITE_BEGIN(All_Utility_Tests)
	TEST_SUITE_USES_SUITE(test::utility, BitSet_Tests)
	TEST_SUITE_USES_SUITE(test::utility, BitVector_Tests)
	TEST_SUITE_USES_SUITE(test::utility, Vector0_Tests)
	TEST_SUITE_USES_SUITE(test::utility, Vector1_Tests)
	TEST_SUITE_USES_SUITE(test::utility, Vector1_Bool_Tests)
	TEST_SUITE_USES_SUITE(test::utility, VectorL_Tests)

	TEST_SUITE_USES_SUITE(test::utility::factory, Factory_Tests)

	TEST_SUITE_USES_SUITE(test::utility::io, Zipstream_Tests)

	TEST_SUITE_USES_SUITE(test::utility::keys, AutoKey_Tests)
	TEST_SUITE_USES_SUITE(test::utility::keys, ClassKeyMap_Tests)
	TEST_SUITE_USES_SUITE(test::utility::keys, ClassKeyVector_Tests)
	TEST_SUITE_USES_SUITE(test::utility::keys, Key4Tuple_Tests)
	TEST_SUITE_USES_SUITE(test::utility::keys, Key4Vector_Tests)
	TEST_SUITE_USES_SUITE(test::utility::keys, SmallKeyMap_Tests)
	TEST_SUITE_USES_SUITE(test::utility::keys, SmallKeyVector_Tests)
	TEST_SUITE_USES_SUITE(test::utility::keys, UserKey_Tests)

	TEST_SUITE_USES_SUITE(test::utility::pointer, Access_Ptr_Tests)
	TEST_SUITE_USES_SUITE(test::utility::pointer, Owning_Ptr_Tests)
	TEST_SUITE_USES_SUITE(test::utility::pointer, Owning_Ptr_MI_Tests)

TEST_SUITE_END

TEST_MAIN(All_Utility_Tests)
