// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 6352 $
//  $Date: 2005-06-15 05:04:29 -0400 (Wed, 15 Jun 2005) $
//  $Author: mentzer $


// Rosetta Headers
#include "timer.h"

// C++ Headers
#include <cstdlib>
#include <ctime>
#include <iostream>
#include <map>
#include <string>


namespace timer {
	std::time_t start_time;
	std::clock_t start_clock;
	std::map< std::string, std::time_t > start_time_map;
}


void
start_timer()
{
  timer::start_time = time( NULL );
  timer::start_clock = clock();
}


void
start_timer( std::string const & tag )
{
  timer::start_time_map[tag] = time( NULL );
}


void
stop_timer( std::ostream & os )
{
  os << " clock-ticks: " << clock() - timer::start_clock
     << " seconds: " << time( NULL ) - timer::start_time << std::endl;
}


void
stop_timer( std::string const & tag, std::ostream & os )
{
  os << ' ' << tag << " seconds: " << time( NULL ) - timer::start_time_map[tag] << std::endl;
}


int
get_timer( std::string const & tag )
{
	return int( time( NULL ) - timer::start_time_map[tag] );
}
