// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 7630 $
//  $Date: 2006-03-10 12:37:52 -0500 (Fri, 10 Mar 2006) $
//  $Author: stuartm $

#ifndef INCLUDED_tree
#define INCLUDED_tree


// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// C++ Headers
#include <iosfwd>


// tree Function Declarations


int
num_edges( FArray2Da_int g );


void
add_edge(
	FArray2Da_int g,
	int const estart,
	int const estop,
	int const elabel
);


void
get_edge(
	FArray2Da_int g,
	int const i,
	int & estart,
	int & estop,
	int & elabel
);


void
get_unordered_edge(
	FArray2Da_int g,
	int const i,
	int & estart,
	int & estop,
	int & elabel
);


void
delete_edge(
	FArray2Da_int g,
	int const edge_num
);


void
show_graph( FArray2Da_int g );


void
output_graph(
	std::ostream & iunit, // input
	FArray2Da_int g
);


void
update_edge_label(
	FArray2Da_int g,
	int const edge_num,
	int const label
);


bool
graph_has_unordered_edge(
	FArray2Da_int g,
	int const edge_start,
	int const edge_stop
);


void
copy_tree(
	FArray2Da_int h, // input
	FArray2Da_int g
);


void
reorder_tree(
	FArray2Da_int g,
	int const start_vertex
);


void
split_tree(
	FArray2Da_int g,
	int & edge_num // INPUT / OUTPUT !!!!!!!!!!!!!!
);


void
modify_edge(
	FArray2Da_int g,
	int const edge_num, // input
	int const estart,
	int const estop,
	int const elabel
);


void
find_shortest_path(
	FArray2Da_int g,
	int const start_vertex,
	int const end_vertex,
	FArray2Da_int path // output
);


bool
same_tree(
	FArray2Da_int t1,
	FArray2Da_int t2
);


bool
is_vertex(
	FArray2Da_int tree,
	int const pos
);


#endif
