// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 20573 $
//  $Date: 2008-02-22 22:24:12 -0500 (Fri, 22 Feb 2008) $
//  $Author: johnk $

#ifndef INCLUDED_vall_data
#define INCLUDED_vall_data


// Rosetta Headers

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>
#include <ObjexxFCL/FArray1D.hh>

// C++ Headers
#include <cmath>
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <sstream>


namespace Vall {


class Vall_data {
private:
	static const int max_size = 848710; // vall.dat.pc60_2002-12-27_v01.2
	//static const int max_size = 52500; // 2001-02-02

	FArray1D_string pdb;
	FArray1D_char chain;
	FArray1D_int resseq;

	FArray1D_char sequence;
	FArray1D_char secstruct;

	FArray1D_float phi;
	FArray1D_float psi;
	FArray1D_float omega;

	int index;

public:
	Vall_data ():
		pdb       ( max_size ),
		chain     ( max_size ),
		resseq    ( max_size ),
		sequence  ( max_size ),
		secstruct ( max_size ),
		phi       ( max_size ),
		psi       ( max_size ),
		omega     ( max_size ),
		index(0)
	{}

	bool add_line( const char sq, const char ss,
								 const float ph, const float ps, const float om ) {
		if ( index >= max_size ) {
			std::cout << "Increase hard-coded max_size in vall_data.h" <<
				std::endl;
			return false;
		}
		++index;
		if ( index%100000 == 0 )
			std::cout << "Vall_data::add_line(...): index= " << index << std::endl;

		phi  (index) = ph;
		psi  (index) = ps;
		omega(index) = om;

		sequence (index) = sq;
		secstruct(index) = ss;
		return true;
	}

	bool add_line2( const char *pd, const char ch,
								  const int   rs,
									const char  sq, const char ss,
									const float ph, const float ps, const float om ) {
		if ( index >= max_size ) {
			std::cout << "Increase hard-coded max_size in vall_data.h" <<
				std::endl;
			return false;
		}
		++index;
		if ( index%100000 == 0 )
			std::cout << "Vall_data::add_line(...): index= " << index << std::endl;

		pdb  (index) = pd;
		chain(index) = ch;
		resseq(index) = rs;

		phi  (index) = ph;
		psi  (index) = ps;
		omega(index) = om;

		sequence (index) = sq;
		secstruct(index) = ss;
		return true;
	}

	const FArray1D_string & get_pdb    () const {return pdb;    }
	const FArray1D_char   & get_chain  () const {return chain;  }
	const FArray1D_int    & get_resseq () const {return resseq; }

	const FArray1D_char & get_sequence () const {return sequence; }
	const FArray1D_char & get_secstruct() const {return secstruct;}

	const FArray1D_float & get_phi  () const {return phi;}
	const FArray1D_float & get_psi  () const {return psi;}
	const FArray1D_float & get_omega() const {return omega;}

	int size() const { return index; }

};


} // namespace Vall


#endif
