// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 9595 $
//  $Date: 2006-08-08 19:20:23 -0400 (Tue, 08 Aug 2006) $
//  $Author: tex $


// Rosetta Headers
#include "void_ns.h"
#include "param.h"

// ObjexxFCL Headers
#include <ObjexxFCL/FArray1D.hh>
#include <ObjexxFCL/FArray2D.hh>
#include <ObjexxFCL/FArray3D.hh>

// Using
using namespace param;


namespace void_ns {


namespace probe_radii_common {

// number of probe radii:
int const n_pr_bin = { 2 };

// number of bins in database-derived offset info
int const max_sasa_offset_bins = { 50 };

// in case we want to add more probe_radii
int const pr_bin_14 = { 1 };
int const pr_bin_5 = { 2 };

void
probe_radii_initializer( FArray1D_float & probe_radii )
{
	int i = 0;
	probe_radii( ++i ) = 1.4;
	probe_radii( ++i ) = 0.5;
}

FArray1D_float probe_radii( n_pr_bin, probe_radii_initializer );
 // must be in decreasing order b/c of min_rsq logic

}

namespace void_common {
	FArray2D_float rsd_sasa( n_pr_bin, MAX_RES() );
	FArray3D_float atom_sasa( n_pr_bin, MAX_ATOM(), MAX_RES() );
//KMa phospho_ser 2006-01
	FArray3D_float sasa_offset( 3, max_sasa_offset_bins, param::MAX_AA_PLUS() );
	FArray1D_float rsd_sasa_pack_score( MAX_RES() );
	float avg_sasa_pack_score(999.0);
//KMa phospho_ser 2006-01
	FArray3D_float sasaprob_cdf( param::MAX_AA_PLUS(), 10, 75 );
	FArray1D_float rsd_sasaprob( MAX_RES() );
	float avg_sasaprob = 0.0;

	FArray3D_float rsq_min( MAX_ATOMTYPES(), MAX_ATOMTYPES(), n_pr_bin );
}

namespace dot_sphere_info{
	//globals for sasa_pack in sim_anneal
	float const probe_radius_small = { 0.5 };
	float const probe_radius_large = { 1.4 };
}

} // namespace void_ns
