// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//  CVS information:
//  $Revision: 14003 $
//  $Date: 2007-04-06 14:24:40 -0400 (Fri, 06 Apr 2007) $
//  $Author: snoeyink $

#ifndef INCLUDED_water
#define INCLUDED_water

#include "water_ns.h"
#include "hbonds_ns.h" // for HBDerivType

// ObjexxFCL Headers
#include <ObjexxFCL/ObjexxFCL.hh>

// Utility Headers
#include <utility/io/all.fwd.hh>

// Numeric Headers
#include <numeric/all.fwd.hh>
//#include <numeric/xyzVector.hh>
//#include <numeric/xyz.functions.hh>

// C++ Headers
#include <vector>
#include <string>
#include <iosfwd>


// water Function Declarations

bool
water_exists();


void
create_sidechain_h2o_variants( int aa );


void
create_backbone_h2o_variants( int aa );


void
create_dna_h2o_variants( int na );


void
create_dna_water_combinations(
	int na,
	int nav,
	std::vector< std::vector< water::IC_Info > >::iterator this_pos,
	std::vector< std::vector< water::IC_Info > >::iterator end_pos,
	std::vector< water::IC_Info > accum_waters
);

bool
clashing_waters_found(
	int na,
	int nav
);

void
add_water_to_variant(
	std::string const & name,
	int & aa,
	int & var,
	int ta1,
	int ta2,
	int ta3,
	int ha, // heavy atom water is connected to
	float & dis, // distance between water and attached heavy atom
	bool fixed, // if true, water doesn't rotate around heavy atom
	float dihedral,
	bool rot_fixed, // if true, water doesn't rotate around heavy atom
	float & rot_ang // for rotable water, what is the dihedral
);



void
add_exact_water_to_variant(
	std::string const & name,
	int const aa,
	int const var,
	int const ta1,
	int const ta2,
	int const ta3,
	int const ha, // heavy atom water is connected to
	float const twx,
	float const twy,
	float const twz
);


void
place_water_by_superimpose(
	int const aa,
	int const var,
	float const twx,
	float const twy,
	float const twz,
	FArray1Da_float xyz_h2o // output the  co-ordinates of water
);


void
place_water_by_internal_coords(
	FArray1Da_float ref1,
	FArray1Da_float ref2,
	FArray1Da_float ref3,
	float length,
	float angle,
	float torsion,
	FArray1Da_float xyz_h2o // output the  co-ordinates of water
);


void
read_pdb_water(
	utility::io::irstream & iunit, // stream of file
	FArray1Da_int aan_in,
	FArray3Da_float xyz_in,
	int & nres_in
);


void
make_pdb_water( utility::io::orstream & iunit );


void
is_buried_water(
	FArray1Da_int aan,
	int nres,
	FArray3Da_float xyz,
	FArray1Da_float coordh2o,
	int & h2o_neighbors,
	bool & is_buried
);


void
count_native_water_neighbors(
	FArray1Da_int aan_in,
	int nres_in,
	FArray3Da_float xyz_in,
	int N_h2oatm, // # of water in the list
	FArray2Da_float coordw, // postion of water in the water list
	FArray1Da_int neighbors
);


void
count_explicit_water_neighbors(
	FArray1DB_int const & aan_in,
	FArray1DB_int const & aav_in,
	int nres_in,
	FArray3DB_float const & xyz_in,
	FArray2DB_int & neighbors
);


void
water_rotamer_check(
	int aa,
	int aav,
	FArray2Da_float coord,
	FArray3Da_float xyz,
	FArray1Da_int aan,
	FArray1Da_int aa_variant,
	int nres,
	FArray1Da_int h2o_nb, // water neighbors
	bool & is_exposed,
	float & h2o_intra_repE,
	float & h2o_intra_hbE
);


void
get_h2oE(
	int const aa1,
	int const aa2,
	int const aav1,
	int const aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	int const res1,
	int const res2,
	float & h2oE,
	float & h2ohbE
);


void
get_sc_bb_h2oE(
	int const & aasc,
	int const & aavsc,
	int const & aabb,
	int const & aavbb,
	FArray2Da_float coordsc,
	FArray2Da_float coordbb,
	int const & ressc,
	int const & resbb,
	float & h2oE,
	float & h2ohbE
);


void
get_sc_hetero_h2oE(
	int const aasc,
	int const aavsc,
	FArray2Da_float coordsc,
	float & h2oE
);


void
get_sc_hetero_h2oEhb(
	int const aasc,
	int const aavsc,
	FArray2Da_float rotcoord,
	float & h2ohb_E
);


void
get_sc_sc_h2oE(
	int const & aa1,
	int const & aav1,
	FArray2Da_float coord1,
	int const & aa2,
	int const & aav2,
	FArray2Da_float coord2,
	int const & res1,
	int const & res2,
	float & h2oE,
	float & h2ohbE
);


void
get_sc_sc_h2oE_1way(
	int const aa1,
	int const aav1,
	FArray2DB_float const & coord1,
	int const aa2,
	int const aav2,
	FArray2DB_float const & coord2,
	int const res1,
	int const res2,
	float & h2oE,
	float & h2ohbE
);


float
get_sc_atm_h2oE(
	int const seqpos,
	int const atomno
);


void
get_sc_atm_h2oE_1way(
	int const aa1,
	int const aav1,
	FArray2Da_float coord1,
	int const aa2,
	int const aav2,
	int const atm2,
	FArray2Da_float coord2,
	int const res1,
	float & h2ohbE
);


void
find_h2ohb_template_atom(
	int type1,
	FArray1Da_float coord1,
	int atm2,
	int aa2,
	int aav2,
	int type2,
	FArray2Da_float coord2,
	int & atm2a,
	int & type2a,
	float & best_ang
);


void
h2o_hbenergy(
	int type1, // atom type of bridging water
	FArray1Da_float coord1,
	int nb1, // neighbor number of water
	int type2, // the other atom that water contacts with
	FArray1Da_float coord2,
	int type0, // the atom that water is attached to
	FArray1Da_float coord0,
	int type2a,
	FArray1Da_float coord2a,
	int type0a,
	FArray1Da_float coord0a,
	float & energy,
	bool & bonus
);


void
fast_pairenergy_h2o(
	int type1,
	FArray1Da_float coord1,
	int type2,
	FArray1Da_float coord2,
	float & energy
);


void
fast_pairenergy_hetero_h2ohb(
	int atm1,
	int aa1,
	int aav1,
	int atm1_type,
	FArray2Da_float coord1,
	int atm2,
	int aa2,
	int aav2,
	int atm2_type,
	FArray2Da_float coord2,
	int N_h2oatm, // # of water in the list
	FArray2Da_float coordw, // postion of water in the water list
	float & h2ohbE // energy of water-mediated hydrogen bond
);


void
fast_pairenergy_attached_h2o(
	int atom1,
	int atom2,
	int aa1,
	int aa2,
	int aav1,
	int aav2,
	FArray2Da_float coord1,
	FArray2Da_float coord2,
	float & h2oE,
	float & h2ohbE
);


void
fill_h2ototalE_arrays(
	FArray1DB_int const & aan,
	FArray1DB_int const & aav, // aa variant
	FArray3DB_float const & xyz,
	int const nres,
	FArray2DB_bool const & neighborlist,
  hbonds::HBDerivType const deriv_type = hbonds::hbderiv_NONE
);


void
fill_h2oE_array(
	int res1,
	int res2,
	float energy1,
	float energy2
);


void
get_buried_h2ohb_weight(
	int h2o_nb,
	float & environ_weight
);


void
set_weights_for_packer();


void
set_weights_for_score();


void
revise_Wdun_Wrep_to_packer();


void
set_water_rotamer_for_packer( std::string const & mode );


void
set_water_rotamer_for_score();


void
set_use_W_int_repack( bool truefalse );


void
set_use_W_int_score( bool truefalse );


void
set_use_simple_bonus_for_h2ohb( bool truefalse );


void
set_use_angle_check_for_h2ohb( bool truefalse );


void
set_use_W_h2o_hb_env_dep( bool truefalse );


void
compute_atom_h2o_hb_deriv(
	int const atomno,
	int const seqpos,
	float const weight,
	numeric::xyzVector_float & F1,
	numeric::xyzVector_float & F2
);


#endif
